<?php



class pageMan {
        
        private
        $_count   = null,
        $_page    = null,
        $_tmpPage = 1,
        $_items   = 10,
        $_pages   = null,
        $_start   = null;
        
        /**
         * pageMan::setCount()
         * Регистрация общего количества записей.
         * @param mixed $count
         * @return object
         */
        public function setCount($count) {
            
            if (is_numeric($count) and 0 < $count) {
                
                $this->_count = (int)$count;
            }
            else {
                
                trigger_error('Value must be integer', E_USER_ERROR);
            }
            
            return $this;
        }
        
        /**
         * pageMan::setPage()
         * Регистрация текущей страницы.
         * @param mixed $page
         * @return object
         */
        public function setPage($page) {
            
            if (is_numeric($page) and 0 < $page) {
                
                $this->_tmpPage = (int)$page;
            }
            
            return $this;
        }
        
        /**
         * pageMan::setItems()
         * Регистрация количества записей на страницу.
         * @param mixed $items
         * @return object
         */
        public function setItems($items) {
            
            if (is_numeric($items)) {
                
                if (0 < $items) {
                    
                    $this->_items = (int)$items;
                }
                else if ($this->_count) {
                    
                    $this->_items = $this->_count;
                }
            }
            
            return $this;
        }
        
        /**
         * pageMan::getPages()
         * Расчет общего кол-ва страниц.
         * @return float
         */
        public function getPages() {
            
            if (null === $this->_count) {
                
                trigger_error('Not enough data', E_USER_ERROR);
            }
            
            if (null === $this->_pages) {
                
                $this->_pages = ceil($this->_count / $this->_items);
            }
            
            return $this->_pages;
        }
        
        /**
         * pageMan::_corrPage()
         * Коррекция текущей страницы.
         * @return integer
         */
        private function _corrPage() {
            
            if (null === $this->_page) {
                
                $this->_page = min($this->_tmpPage, $this->getPages());
            }
            
            return $this->_page;
        }
        
        /**
         * pageMan::getPage()
         * Получение номера корректной текущей страницы.
         * @return integer
         */
        public function getPage() {
            
            return $this->_corrPage();
        }
        
        /**
         * pageMan::_setStart()
         * Расчет начальной точки отсчета показа записей в вашем цикле.
         * @return integer
         */
        private function _setStart() {
            
            if (null === $this->_start) {
                
                $this->_start = ($this->_corrPage() - 1) * $this->_items;
            }
            
            return $this->_start;
        }
        
        /**
         * pageMan::getArray()
         * Расчет конечной точки отсчета показа записей в цикле для массива данных.
         * @return array
         */
        public function getArray() {
            
            if (null === $this->_count) {
                
                trigger_error('Not enough data', E_USER_ERROR);
            }
            
            return array(
            'start' => $this->_setStart(),
            'stop'  => min(($this->_start + $this->_items), $this->_count));
        }
        
        /**
         * pageMan::getTable()
         * Расчет конечной точки отсчета показа записей в цикле для данных в таблице (DB).
         * @return array
         */
        public function getTable() {
            
            return array(
            'start' => $this->_setStart(),
            'stop'  => $this->_items);
        }
        
        /**
         * pageMan::getPageRange()
         * Получение ближайшего отрезка номеров страниц для создания навигации вида: (10 11 [12] 13 14).
         * @return array
         */
        public function getPageRange($range=null) {
            
            $range = (is_numeric($range) and 0 < $range) ? (int)$range : 4;
            
            $prev = $this->getPage() - $range;
            $next = $this->_page     + $range;

            $start = $this->getPages() < $next ? $this->_pages - $next + $prev : $prev;
            $stop  =                 1 > $prev ? $next - $prev + 1             : $next;
            
            $start -= $this->_pages <= $stop ? 1 : 0;
            $stop  += 1 >= $start ? 1 : 0;
            
            $start = 1 < $start ? $start : 1;
            $stop  = $this->_pages > $stop ? $stop : $this->_pages;
            
            $array = range($start, $stop);
            
            if (1 < $start) {
                
                array_unshift($array, 1);
            }
            
            if ($this->_pages > $stop) {
                
                $array[] = $this->_pages;
            }
            
            return $array;
        }
    }

$pg = new pageMan();

$pg->setCount($_GET['count'])->setPage($_GET['page']);

//echo '<pre>';
//print_r($pg->getPageRange(3));
//echo '</pre>';

$links = $pg->getPageRange(2);

define('NOW_PAGE', $pg->getPage());
define('LAST_PAGE', $pg->getPages());
?>

<style type="text/css">
a { text-decoration: none; }
</style>
<?php foreach ($links as $page):?>
<?php if (NOW_PAGE == $page):?>
<span style="background-color: #000; color: #fff; padding: 2px 3px 2px 3px;"><?php echo $page;?></span>
<?php else:?>
<span style="border: 1px dotted #000; padding: 1px 2px 1px 2px;"><a href="?page=<?php echo $page;?>&amp;count=<?php echo $_GET['count'];?>"><?php echo $page;?></a></span>
<?php endif; endforeach;?>