var db, audio;

var setting = new function () {
    this.reload     = localStorage['reload']   ? localStorage['reload']   : 0.5; // заполняю обект данными о настройках
    this.volume     = localStorage['volume']   ? localStorage['volume']   : 0.5;
    this.autohide   = localStorage['autoHide'] ? localStorage['autoHide'] : 0.5;
    this.timezone   = localStorage['timezone'] ? localStorage['timezone'] : 3;
    this.nick       = localStorage['nick'];
    this.sound      = 'trololo.wav';
    this.setReload  = function (o) {
        this.reload            = localStorage['reload']    = o.value; // Если изменилось сохраняем
        localStorage['setting'] = localStorage['portPopup'] = '1'; // Включаем порт
    };
    this.setHide = function (o) {
        this.autohide          = localStorage['autoHide']  = o.value; // автозакрытия здесь порт не нужен
    };
    this.setVolume = function (o) {
        this.volume            = localStorage['volume']    = audio.volume = o.value;
        localStorage['setting'] = localStorage['portPopup'] = '1'; // Дале тоже самое
        audio.play();
    };
    this.setNick = function (o) {
        this.nick              = localStorage['nick']      = o.value;
        localStorage['setting'] = localStorage['portPopup'] = '1';
    };
    this.setTimezone = function (o) {
        this.timezone          = localStorage['timezone']      = o.value;
        viewForum(); // Обновляем дом
    };
    this.setInput = function () { // Заполняем дом настройками
        o = $('#window-topic-set');
        o.find('#reload').attr('value', setting.reload);
        o.find('#hide').attr('value', setting.autohide);
        o.find('#volume').attr('value', setting.volume);
        o.find('#nick').attr('value', setting.nick);
        o.find('select option[value="' + this.timezone + '"]').prop('selected', true);
    };
};


var pop = new function () {
    this.viewSet  = false; // Показаны настройки или нет
    this.clickSet = true;  // Чтобы небыло глюков при многоразовом нажатии определяет выполняется анимация открытия или закрытия настроек
    this.reload   = false; // Хуй его знает Что это
    this.autoHide = false; // Id таймаута на автозакрытия
    this.frameOn  = false; // Включен ли фрейм. Для определения как закрывать попу
    this.open     = function () { 
        if (this.toggle) {
            return false;
        } else {
            this.toggle = true;
        }
        // Далее раскрываем анимацией попу
        $('#window-topic').slideDown(250, function () {
            $('#window-topic div.blockform').animate({width: '400px'}, 250, function () {
                $('#window-topic-main').css({display: 'inline'});
                $('#forum').slideDown(250);
            });
        });
        $('body').bind("mouseleave", function () { // Авто закрытие
            if (setting.autohide !== '0') {
                pop.autoHide = setTimeout(function () {
                    pop.close();
                }, setting.autohide * 1000);
            }
        }).bind('mouseenter', function () {
            clearTimeout(pop.autoHide); // если мыш зашла обратно снимаем задачу на закрытие
        });
    };
    this.close = function () {
        if (this.frameOn) {
            window.close();
            return;
        }
        this.toggleSet(1);
        $('#forum:first').slideUp(250, function () {
            $('#window-topic-main, div.window-close').hide();
            $('#window-topic div.blockform').animate({width: '55px'}, 250, function () {
                $('body').slideUp(250, function () {
                    window.close();
                });
            });
        });
    };
    this.toggleSet = function (a) {
        if (this.clickSet) {
            this.clickSet = false;
        } else {
            return false;
        }
        var setObject = $('#window-topic-set');
        if (this.viewSet || a) {
            setObject.slideUp(500, function () {
                pop.clickSet = true;
                pop.viewSet = false;
            });
        } else {
            setting.setInput();
            setObject.slideDown(500, function () {
                pop.clickSet = true;
                pop.viewSet = true;
            });
        }
    };
    this.frame = function (a) {
        this.frameOn = true;

        $('#window-topic').slideToggle(500, function () {
            clearTimeout(pop.autoHide); // если мышь зашла обратно, снимаем задачу на закрытие просто будет сворачиватся и разварачиватся ест вероятность ухода мышы и сработает авнозакрытие
            $('body').animate({width: '800px', height: '500px'}, 800);
            $(this).html('<iframe id="frame" style="position: relative" src="' + a + '" width="99%" height="100%" onload="frameOnload()" /></iframe>');
        });
    };
};


var reload = new function() {
    this.active = function () {
        $('#window-topic div.window-reload:first').removeClass('window-reload-off').addClass('window-reload-on');
    };
    this.off    = function () {
        $('#window-topic div.window-reload:first').removeClass('window-reload-on').addClass('window-reload-off');
    };
};


$(document).ready(function () {
    audio = new Audio(setting.sound);
    audio.volume = setting.volume;

    db = getForum(); // Выгружаю с базы данные форума.

    pop.open();
    viewForum(); // Вывод с базы на страницу
    setTimeout(connect, 1000); // Обновляем через минуту
    $('#window-topic tr').each(function (clickForum) {    // Цепляем к ссылка обработчики
        $(this).find("a[href^='http']").click(function (e) { // Открываем в фрейме
            e.preventDefault();
            pop.frame($(this).attr('href'));
        })
        .dblclick(function (e) { // Открываем в новой вкладке
            window.open($(this).attr('href'));
        });
    });

    localStorage['blink']     = '1'; // отключаем мигалку
    localStorage['portPopup'] = '1'; // Включаем порт
});


function viewForum () { // Не буду срать здесь все понятно заполняется дом
    var dom;

    for (var i = 3; i <= 7; i++) {
        dom = $('#window-topic tbody tr:eq(' + (i-3) + ')');

        dom.find('td.tcr a').attr('href', (db[i]['last_post_id'] ? 'http:wapinet.ru/forum/viewtopic.php?pid=' +
            db[i]['last_post_id'] + '#' +
            db[i]['last_post_id'] : 'http:wapinet.ru/forum/viewforum.php?id=' + i))
                .text(db[i]['subject'] ? db[i]['subject'] : 'Нет данных');

        dom.find('td.tcr span.byuser').text((db[i]['last_post_time'] ? parseDate(((intval(db[i]['last_post_time']) - 7200) + (setting.timezone * 3600)) * 1000) : '') + 
            ' ' + (db[i]['last_poster'] ? db[i]['last_poster'] : 'Обновите данные'));

        if (!db[i]['icon']) {
            dom.removeClass('inew').find('div.icon').removeClass('inew');
        } else {
            dom.addClass('inew').find('div.icon').addClass('inew');
            localStorage['forum[' + i + '][icon]'] = ''; // Сохраняем как просмотренное
        }
    }
}


function frameOnload() {
    $('#window-topic').slideDown(500);
}