var db, idTimeout, forum, audio;


/*
    функция перевода времени
*/ 
function parseDate (i) {
    var myDate = new Date;
    var a = new Date(i + 86400000); // для сравнение с сегоднешней датой
    i = new Date(i);
    var str = "";

    if (i.getDate() == myDate.getDate() && i.getMonth() == myDate.getMonth()) {
        str = "\u0421\u0435\u0433\u043e\u0434\u043d\u044f"; // сегодня
    }
    if (a.getDate() == myDate.getDate() && a.getMonth() == myDate.getMonth()) {
        str = "\u0412\u0447\u0435\u0440\u0430"; // Вчера
    } else {
        // Или показать дату
        str = i.getFullYear()
            + "." +
            (i.getMonth() + 1 > 9 ? i.getMonth() + 1 : "0" + (i.getMonth()+1)) // формат 06 месяца
            + "." +
            (i.getDate() > 9 ? i.getDate() : "0" + i.getDate()); // Аналогично
    }
    return str + " " + (i.getHours() > 9 ? i.getHours() : "0" + i.getHours()) + ":" + (i.getMinutes() > 9 ? i.getMinutes() : "0" + i.getMinutes());
}


function intval (mixed_var, base) {
    // http://kevin.vanzonneveld.net
    // +   original by: Kevin van Zonneveld (http://kevin.vanzonneveld.net)
    // +   improved by: stensi
    // +   bugfixed by: Kevin van Zonneveld (http://kevin.vanzonneveld.net)
    // +   input by: Matteo
    // +   bugfixed by: Brett Zamir (http://brett-zamir.me)
    // +   bugfixed by: Rafał Kukawski (http://kukawski.pl)
    // *     example 1: intval('Kevin van Zonneveld');
    // *     returns 1: 0
    // *     example 2: intval(4.2);
    // *     returns 2: 4
    // *     example 3: intval(42, 8);
    // *     returns 3: 42
    // *     example 4: intval('09');
    // *     returns 4: 9
    // *     example 5: intval('1e', 16);
    // *     returns 5: 30
    var tmp, type = typeof(mixed_var);

    if (type === 'boolean') {
        return +mixed_var;
    } else if (type === 'string') {
        tmp = parseInt(mixed_var, base || 10);
        return (isNaN(tmp) || !isFinite(tmp)) ? 0 : tmp;
    } else if (type === 'number' && isFinite(mixed_var)) {
        return mixed_var | 0;
    } else {
        return 0;
    }
}


function getForum() {
    var data = [];

    for (var i = 3; i <= 7; i++) {
        data[i] = {
           'last_post_time' : localStorage['forum[' + i + '][last_post_time]'],
           'last_post_id'   : localStorage['forum[' + i + '][last_post_id]'],
           'last_poster'    : localStorage['forum[' + i + '][last_poster]'],
           'subject'        : localStorage['forum[' + i + '][subject]'],
           'icon'           : localStorage['forum[' + i + '][icon]']
        };
    }
    return data;
}


function saveForum() {
    for (var i = 3; i <= 7; i++) {
        localStorage['forum[' + i + '][last_post_time]'] = db[i]['last_post_time'];
        localStorage['forum[' + i + '][last_post_id]']   = db[i]['last_post_id'];
        localStorage['forum[' + i + '][last_poster]']    = db[i]['last_poster'];
        localStorage['forum[' + i + '][subject]']        = db[i]['subject'];
        localStorage['forum[' + i + '][icon]']           = db[i]['icon'];
    }
}


var setting = new function () {
    this.reload     = localStorage['reload']   ? localStorage['reload']   : 0.5;
    this.volume     = localStorage['volume']   ? localStorage['volume']   : 0.5;
    this.autohide   = localStorage['autoHide'] ? localStorage['autoHide'] : 0.5;
    this.nick       = localStorage['nick'];
    this.sound      = 'trololo.wav';
};


var audio = new Audio(setting.sound);
audio.volume = setting.volume;


function connect(a) {
    if (!a) {
        reload.active();
    } else {
        db = getForum();
    }

    clearTimeout(idTimeout);
    $.getJSON('http://wapinet.ru/forum/ajax.server.php?informer', {}, function (arr) {
        if (!a) {
            reload.off();
        }
        if (arr.status == true) {
            var status = {'play': 0};

            for (var i = 3; i <= 7; i++) {
                db[i]['last_post_id']   = arr.forum[i]['last_post_id'];
                db[i]['last_poster']    = arr.forum[i]['last_poster'];
                db[i]['subject']        = arr.forum[i]['subject'];

                if (arr.forum[i]['last_poster'] == setting.nick) {
                    db[i]['icon']   = '';
                } else if (intval(db[i]['last_post_time']) < arr.forum[i]['last_post_time']) {
                    db[i]['icon']   = 1;
                    status['play']  = 1;
                }
                db[i]['last_post_time'] = arr.forum[i]['last_post_time'];
            }
            if (status['play'] == 1) {
                 audio.play();
                 if (a) {
                    blink.start();
                 }
            }
            saveForum();
            db = getForum();
            if (!a) {
                viewForum(1);
            }
        }
        if (a && (setting.reload * 10)) {
            idTimeout = setTimeout('connect(1)', (setting.reload * 60000));
        }
    }).error(function () {
        if (a && (setting.reload * 10)) {
            idTimeout = setTimeout('connect(1)', (setting.reload * 60000));
        }
    });
}