<?php
/**
 * IF
 *
 * @author     ByVlad <byvlad@i.ua>
 * @framework  Imperial Framework
 * @category   Pagination
 * @copyright  2011
 */

class Pages {
	function __construct($total, $limit, $str, $view_q = TRUE) {
		$this -> total = $total;
		$this -> limit = $limit;
		$this -> str = $str;
		$this -> view_q = $view_q;
		$this -> page = (!isset($_GET['page']) or !is_numeric($_GET['page']) or $_GET['page'] == 0) ? 1 : (int)$_GET['page'];
		$this -> pages = ceil($this -> total / $this -> limit);

		if($this -> page > $this -> pages)
			$this -> page = $this -> pages;
	}

	function sql() {
		if(isset($_GET['end']))
			$this -> page = $this -> pages;
  		return $this -> page * $this -> limit - $this -> limit;
	}

	function run() {
		echo ($this -> page > 1) ? '<a href="' . $this -> str . ($this -> page - 1) . '">&lt;- Назад</a>' : '&lt;- Назад';
     	echo ' | ';
     	echo ($this -> page < $this -> pages) ? '<a href="' . $this -> str . ($this -> page + 1) . '">Далее -&gt;</a>' : 'Далее -&gt;';
     	if($this -> total > $this -> limit) {

        	echo '<br /><br />Страницы: ';
        	if($this -> page != 1) {
        		echo '<a href="' . $this -> str . '1">1</a> ';
        		if($this -> page == 3)
        			echo '<a href="' . $this -> str . '2">2</a> ';
        		if($this -> page > 4)
        			echo ' ... ';
        	}

  			if($this -> page-2 > 0 and $this -> page-2 != 1)
        		echo '<a href="' . $this -> str . ($this -> page - 2) . '">' . ($this -> page - 2) . '</a>';

    		echo ($this -> page-2 > 0 and $this -> page-2 != 1) ? ' <a href="' . $this -> str . ($this -> page - 1) . '">' . ($this -> page - 1) . '</a>' : ' [<strong>' . $this -> page . '</strong>]';

  			if(($this -> page + 1) <= $this -> pages) {
  				if(!in_array($this -> page, array(1, 2, 3)))
  					echo ' [<strong>' . $this -> page . '</strong>]';
  				if(($this -> page + 1) <= $this -> pages)
  					echo ' <a href="' . $this -> str . ($this -> page + 1) . '">' . ($this -> page + 1) . '</a>';
  			}


  			if(($this -> page + 2) < $this -> pages)
  				echo ' <a href="' . $this -> str . ($this -> page + 2) . '">' . ($this -> page + 2) . '</a>';

  			if($this -> pages >= 3) {
  				if($this -> page != $this -> pages) {
  					if(!in_array($this->page, array($this->pages - 1, $this->pages - 2, $this->pages - 3)))
  						echo ' ...';
  					echo ' <a href="' . $this -> str . ($this -> pages) . '">' . ($this -> pages) . '</a>';
  				} else {
                    if($this -> pages!=3 AND $this -> page!=3)
  					echo ' <strong>[' . $this -> pages . ']</strong></a>';
  				}
  	 		}
  	 		$num = ($this -> page != $this -> pages) ? ($this -> page + 1) : 1;
            if($this -> view_q)
          echo '<form action="' . $this -> str . '.html" method="get">
      	 		<div>
      	 		Страница:
      	 		<input type="text" name="page" value="' . $num . '" size="2" />
      	 		<input type="submit" value="&gt;&gt;" />
      	 		</div></form>';
  	 	}
  	}
}
?>