<?php

echo '<html>';
echo '<head><style type="text/css">';
echo '* { font: 12px Verdana; line-height: 20px; }';
echo 'div.items { overflow: hidden; margin-bottom: 30px; width: 500px; }';
echo 'div.items h1 { float: left; width: 200px; font-weight: bold; }';
echo 'div.items h2 { float: left; width: 300px; }';
echo '</style></head>';
echo '<body>';

if($mp3file = trim($_GET['mp3file'])) {

	if(!file_exists('./mp3/'.$mp3file)) {
		echo '<script type="text/javascript">window.location = \'?\';</script>';
		exit;
	}

	$showmp3file = $mp3file;
	$mp3file = './mp3/'.$mp3file;

} else {

	echo 'Please select a mp3 file to operate:<br />';
	echo '&nbsp;&nbsp;<a href="?mp3file=cbr.mp3">mp3/cbr.mp3</a><br />';
	echo '&nbsp;&nbsp;<a href="?mp3file=vbr.mp3">mp3/vbr.mp3</a><br /><br />';
	echo '* Please put two mp3 file (cbr.mp3 for CBR MP3, vbr.mp3 for VBR.mp3) into the directory \'mp3\'';

	echo '</body>';
	echo '</html>';
	exit;

}

require './class.mp3.php';
$mp3 = new mp3;

$acts = array('info', 'nicety', 'frames', 'set', 'cut');
$act = !empty($_GET['act']) && in_array($_GET['act'], $acts) ? $act : '';

if($act == 'info' || $act == 'nicety') {

	if($data = $mp3->get_mp3($mp3file, $act == 'info' ? false : true)) {

		if($data['Data']) {

			echo '<div class="items">';

			echo '<h1>File size</h1><h2>'.round($data['Data']['Filesize'] / 1024, 2).' Kb</h2>';
			echo '<h1>MPEG Version</h1><h2>'.$data['Data']['MPEGVer'].'</h2>';
			echo '<h1>MPEG Layer</h1><h2>'.$data['Data']['Layer'].'</h2>';
			echo '<h1>Bitrate (Ave)</h1><h2>'.$data['Data']['Bitrate'].' kbps</h2>';
			echo '<h1>Sampling Frequency</h1><h2>'.$data['Data']['Sampling_frequency'].' Hz</h2>';
			echo '<h1>Mode</h1><h2>'.$data['Data']['Mode'].'</h2>';
			echo '<h1>Mode Extension</h1><h2>Intensity Stereo: '.($data['Data']['Mode_extension']['Intensity_Stereo'] ? 'On' : 'Off').', MS Stereo: '.($data['Data']['Mode_extension']['MS_Stereo'] ? 'On' : 'Off').'</h2>';
			echo '<h1>Copyright</h1><h2>'.$data['Data']['Copyright'].'</h2>';
			echo '<h1>Original</h1><h2>'.$data['Data']['Original'].'</h2>';
			echo '<h1>Type</h1><h2>'.$data['Data']['Type'].'</h2>';
			echo '<h1>Length</h1><h2>'.$data['Data']['Length'].' second(s)</h2>';
			echo '<h1>Time</h1><h2>'.$data['Data']['Time'].'</h2>';
			echo '<h1>Frame total</h1><h2>'.$data['Data']['Frametotal'].'</h2>';

			if($data['Data']['Bitrate_max']) {
				echo '<h1></h1><h2></h2>';
				echo '<h1>Bitrate Max</h1><h2>'.$data['Data']['Bitrate_max'].' kbps</h2>';
				echo '<h1>Bitrate Min</h1><h2>'.$data['Data']['Bitrate_min'].' kbps</h2>';
			}

			echo '</div>';

		}

		if($data['ID3v2']) {

			echo '<div class="items">';
			echo '<h1>ID3v2: Version</h1><h2>'.$data['ID3v2']['Version'].'</h2>';
			echo '<h1>ID3v2: Revision</h1><h2>'.$data['ID3v2']['Revision'].'</h2>';
			echo '<h1>ID3v2: Flag</h1><h2>Unsynchronisation: '.($data['ID3v2']['Flag']['Unsynchronisation'] ? 'On' : 'Off').', Extra: '.($data['ID3v2']['Flag']['Extra'] ? 'On' : 'Off').', Test: '.($data['ID3v2']['Flag']['Test'] ? 'On' : 'Off').'</h2>';
			echo '<h1>ID3v2: Size</h1><h2>'.$data['ID3v2']['Size'].'</h2>';
			echo '</div>';

			foreach($data['ID3v2']['Frames'] as $frameid => $frames) {

				foreach($frames as $frameindex => $frame) {

					echo '<div class="items">';
					echo '<h1>ID3v2: FrameID</h1><h2>'.$frame['FrameID'].'</h2>';
					echo '<h1>ID3v2: Description</h1><h2>'.$frame['Description'].'</h2>';
					echo '<h1>ID3v2: Flag: Tag_protect</h1><h2>'.($frame['Flag']['Tag_protect'] ? 'On' : 'Off').'</h2>';
					echo '<h1>ID3v2: Flag: File_protect</h1><h2>'.($frame['Flag']['File_protect'] ? 'On' : 'Off').'</h2>';
					echo '<h1>ID3v2: Flag: Readonly</h1><h2>'.($frame['Flag']['Readonly'] ? 'On' : 'Off').'</h2>';
					echo '<h1>ID3v2: Flag: Compressed</h1><h2>'.($frame['Flag']['Compressed'] ? 'On' : 'Off').'</h2>';
					echo '<h1>ID3v2: Flag: Encrypt</h1><h2>'.($frame['Flag']['Encrypt'] ? 'On' : 'Off').'</h2>';
					echo '<h1>ID3v2: Flag: Group</h1><h2>'.($frame['Flag']['Group'] ? 'On' : 'Off').'</h2>';
					echo '<h1>ID3v2: Size</h1><h2>'.$frame['Size'].'</h2>';
					echo '<h1>ID3v2: Charset</h1><h2>'.$frame['Charset'].'</h2>';
					echo '<h1>ID3v2: Data</h1><h2>'.$frame['Data'].'</h2>';
					echo $frame['Language'] ? '<h1>ID3v2: Language</h1><h2>'.$frame['Language'].'</h2>' : '';
					echo '</div>';

				}

			}

		}

		if($data['ID3v1']) {

			echo '<div class="items">';

			foreach($data['ID3v1'] as $tagname => $tagvalue) {
				echo "<h1>ID3v1:  $tagname</h1><h2>$tagvalue</h2>";
			}

			echo '</div>';

		}

	} else {
		echo 'Error';
	}

} elseif ($act == 'frames') {

	$data = $mp3->get_mp3($mp3file, true);

	if($data['Frames']) {

		echo '<div class="items">';

		foreach($data['Frames'] as $index => $position) {
			echo "<h1>Frame $index</h1><h2>$position</h2>";
		}

		echo '</div>';

	} else {
		echo 'Error';
	}

} elseif ($act == 'set') {

	$output = 'test.mp3';
	$id3v1 = array('Test Title', 'Test Artist', 'Test Album', 'Year', 'Test Comment', 0, 1, 12);

	$id3v2 = array
		(
		'unsynchronisation' => true,
		'extra' => true,
		'test' => true,
		'frames' => array
			(
			'TIT2' => array
				(
				'tagprotect' => 0,
				'fileprotect' => 0,
				'readonly' => 0,
				'compressed' => 0,
				'encrypt' => 0,
				'group' => 0,
				'language' => 0,
				'data' => 'Test Title'
				),
			'COMM' => array
				(
				'data' => "eng\x00Test Comment"
				)
			)
		);

	if($mp3->set_mp3($mp3file, $output, $id3v1, $id3v2)) {
		echo '<a href="'.$output.'">Click here to download result file.</a>';
	} else {
		echo 'Error';
	}

} elseif ($act == 'cut') {

	$startframe = intval($_GET['startframe']);
	$endframe = intval($_GET['endframe']);
	$output = trim($_GET['output']);

	if($endframe) {

		if($mp3->cut_mp3($mp3file, $output, $startframe, $endframe)) {
			echo '<a href="'.$output.'">Click here to download result file.</a>';
		} else {
			echo 'Error';
		}

	} else {

		$data = $mp3->get_mp3($mp3file, true);

		if($data['Frames']) {

			echo '<form method="get">';
			echo '<input type="hidden" name="mp3file" value="'.$showmp3file.'" />';
			echo '<input type="hidden" name="act" value="cut" />';
			echo '<div class="items">';
			echo '<h1>Frame Start:</h1><h2><input type="text" size="10" value="0" name="startframe" /></h2>';
			echo '<h1>Frame End:</h1><h2><input type="text" size="10" value="'.(count($data['Frames']) - 1).'" name="endframe" /></h2>';
			echo '<h1>Output:</h1><h2><input type="text" size="30" value="output.mp3" name="output" /></h2>';
			echo '<h1></h1><h2></h2>';
			echo '<h1><button type="submit"> Cut now </button></h1>';
			echo '</div>';
			echo '</form>';

		} else {
			echo 'Error';
		}

	}

} else {

	echo '<a href="?mp3file='.$showmp3file.'&act=info">Get information</a><br />';
	echo '<a href="?mp3file='.$showmp3file.'&act=nicety">Get information (nicety)</a><br />';
	echo '<a href="?mp3file='.$showmp3file.'&act=frames">Get frames index</a><br />';
	echo '<a href="?mp3file='.$showmp3file.'&act=set">Set tags</a><br />';
	echo '<a href="?mp3file='.$showmp3file.'&act=cut">Cut the file</a>';

}

echo '</body>';
echo '</html>';

?>