<?php
class Compress {
  var $mode;
  var $level;
  function Compress($level=6){
    $this->level=$level;
    if(isset($_SERVER['HTTP_ACCEPT_ENCODING'])){
      $enc =& $_SERVER['HTTP_ACCEPT_ENCODING'];
    }else{
      $enc =& $_SERVER['HTTP_TE'];
    }
    if(!$level){
      $this->mode='off';
    }elseif(strpos($enc, 'deflate')!==false){
      $this->mode='deflate';
    }elseif(strpos($enc, 'gzip')!==false){
      $this->mode='gzip';
    }else{
      $this->mode='off';
    }
   ob_start(array(&$this,'out'));
   register_shutdown_function('ob_end_flush');
  }
  /* // функция для извращенцев:
  function percent(){
    $buffer=ob_get_contents();
    $csize=strlen($this->out($buffer));
    return 100-round(100/(strlen($buffer)/$csize),1);
  }
  */
  function out($output){
    switch($this->mode){
      case 'deflate':
        header('Content-Encoding: deflate');
        return gzdeflate($output,$this->level);
      break;
      case 'gzip':
        header('Content-Encoding: gzip');
        return gzencode($output,$this->level);
      break;
      default:
        return $output;
      break;
    }
  }
}

function perf(){
 static $start=0;
 list($usec,$sec)=explode(' ',microtime());
 if($start) return round((float)$usec+(float)$sec-$start,4);
 else $start=((float)$usec+(float)$sec);
}

function fname($str){
  if($str{0}=='-'){
    $str=substr($str,1);
    $repl=array(
     'A'=>'А','a'=>'а','B'=>'Б','b'=>'б',
     'V'=>'В','v'=>'в','G'=>'Г','g'=>'г',
     'D'=>'Д','d'=>'д','E'=>'Е','e'=>'е',
     'yo'=>'ё','Yo'=>'Ё','Zh'=>'Ж','zh'=>'ж',
     'Z'=>'З','z'=>'з','I'=>'И','i'=>'и',
     'J'=>'Й','j'=>'й','K'=>'К','k'=>'к',
     'L'=>'Л','l'=>'л','M'=>'М','m'=>'м',
     'N'=>'Н','n'=>'н','O'=>'О','o'=>'о',
     'P'=>'П','p'=>'п','R'=>'Р','r'=>'р',
     'S'=>'С','s'=>'с','T'=>'Т','t'=>'т',
     'U'=>'У','u'=>'у','F'=>'Ф','f'=>'ф',
     'H'=>'Х','h'=>'х','C'=>'Ц','c'=>'ц',
     'Ch'=>'Ч','ch'=>'ч','Sh'=>'Ш','sh'=>'ш',
     'Sch'=>'Щ','sch'=>'щ',"''"=>'ъ',"'"=>'ь',
     'Y'=>'Ы','y'=>'ы','Ye'=>'Э','ye'=>'э',
     'Yu'=>'Ю','yu'=>'ю','Ya'=>'Я','ya'=>'я',
     '_'=>' ');
  }else $repl=array('_'=>' ');
  $str=strtr($str,$repl);
  return $str;
}

function &getvar($idx){
 if(!isset($_GET[$idx])) $_GET[$idx]=null;
 return $_GET[$idx];
}

?>
