<?php
// Укороченный только для чтения и модифицированный вариант класса MP3_id (by DreamDragon)
class MP3_Id {
    var $file = false;
    var $id3v1 = false;
    var $id3v11 = false;
    var $name = '';
    var $artists = '';
    var $album = '';
    var $year = '';
    var $comment = '';
    var $track = 0;
    var $studied = false;
    var $mpeg_ver = 0;
    var $layer = 0;
    var $bitrate = 0;
    var $crc = false;
    var $frequency = 0;
    var $encoding_type = 0;
    var $samples_per_frame = 0;
    var $samples = 0;
    var $musicsize = -1;
    var $frames = 0;
    var $quality = 0;
    var $padding = false;
    var $private = false;
    var $mode = '';
    var $copyright = false;
    var $original = false;
    var $emphasis = '';
    var $filesize = -1;
    var $frameoffset = -1;
    var $lengthh = false;
    var $length = false;
    var $lengths = false;

    function MP3_Id($study = false){
        $this->study=$study;
    }

    function _utf8($string){
        if(!preg_match('/^.{1}/us',$string)){
         if(function_exists('mb_substr')){
          return mb_convert_encoding($string,'UTF-8','Windows-1251');
         }elseif(function_exists('iconv')){
          return iconv('Windows-1251','UTF-8',$string);
         };
        };
        return $string;
    }

    function read($file=''){
        if(!empty($file)) $this->file = $file;
        if($this->study) $this->_readframe();
	    if (! ($f = @fopen($this->file, 'rb')) ) {
	        return false;
	    }
	    if (fseek($f, -128, SEEK_END) == -1) {
	        return false;
	    }
	    $r = fread($f, 128);
	    fclose($f);

	    $id3tag = $this->_decode_v1($r);
	    if($id3tag){
	        $this->id3v1 = true;

	        $tmp = explode(Chr(0), $id3tag['NAME']);
	        $this->name = $this->_utf8($tmp[0]);

	        $tmp = explode(Chr(0), $id3tag['ARTISTS']);
	        $this->artists = $this->_utf8($tmp[0]);

	        $tmp = explode(Chr(0), $id3tag['ALBUM']);
	        $this->album = $this->_utf8($tmp[0]);

	        $tmp = explode(Chr(0), $id3tag['YEAR']);
	        $this->year = $tmp[0];

	        $tmp = explode(Chr(0), $id3tag['COMMENT']);
	        $this->comment = $this->_utf8($tmp[0]);

	        if(isset($id3tag['TRACK'])){
	         $this->id3v11 = true;
	         $this->track = $id3tag['TRACK'];
	        };

	    }else{
	        return $id3tag;
	    };
    }

    function _decode_v1($rawtag){
        if($rawtag[125] == Chr(0) and $rawtag[126] != Chr(0)){
         $format = 'a3TAG/a30NAME/a30ARTISTS/a30ALBUM/a4YEAR/a28COMMENT/x1/C1TRACK/C1GENRENO';
        }else{
         $format = 'a3TAG/a30NAME/a30ARTISTS/a30ALBUM/a4YEAR/a30COMMENT/C1GENRENO';
        };

        $id3tag = unpack($format, $rawtag);
        if ($id3tag['TAG'] != 'TAG'){
         return false;
        }
        return $id3tag;
    }

    function _readframe(){
        $this->studied = true;
        $file = $this->file;

        if(! ($f = fopen($file, 'rb')) ){
         return false;
        }

        $this->filesize = filesize($file);

        do {
            while(fread($f,1) != Chr(255)){
             if(feof($f)){
                return false;
             }
            }
            fseek($f, ftell($f) - 1);

            $frameoffset = ftell($f);

            $r = fread($f, 4);
            $bits = sprintf("%'08b%'08b%'08b%'08b", ord($r{0}), ord($r{1}), ord($r{2}), ord($r{3}));
        } while(!$bits[8] && !$bits[9] && !$bits[10]);

        $this->frameoffset = $frameoffset;

        if($bits[11] == 0){
         if(($bits[24] == 1) && ($bits[25] == 1)){
            $vbroffset = 9;
         }else{
            $vbroffset = 17;
         };
        }elseif($bits[12] == 0){
         if(($bits[24] == 1) && ($bits[25] == 1)){
            $vbroffset = 9;
         }else{
            $vbroffset = 17;
         };
        }else{
         if(($bits[24] == 1) && ($bits[25] == 1)){
            $vbroffset = 17;
         }else{
            $vbroffset = 32;
         };
        };

        fseek($f, ftell($f) + $vbroffset);
        $r = fread($f, 4);

        switch ($r) {
            case 'Xing': $this->encoding_type = 'VBR';
            case 'Info':
             $r = fread($f, 4);
             $vbrbits = sprintf("%'08b", ord($r{3}));

             if($vbrbits[7] == 1){
                $r = fread($f, 4);
                $this->frames = unpack('N', $r);
                $this->frames = $this->frames[1];
             };

             if($vbrbits[6] == 1){
                $r = fread($f, 4);
                $this->musicsize = unpack('N', $r);
                $this->musicsize = $this->musicsize[1];
             };

             if($vbrbits[5] == 1){
                fseek($f, ftell($f) + 100);
             };

             if($vbrbits[4] == 1){
                $r = fread($f, 4);
                $this->quality = unpack('N', $r);
                $this->quality = $this->quality[1];
             };

             break;

            case 'VBRI':
            default:
             if($vbroffset != 32){
                fseek($f, ftell($f) + 32 - $vbroffset);
                $r = fread($f, 4);

                if($r != 'VBRI'){
                    $this->encoding_type = 'CBR';
                    break;
                }
             }else{
                $this->encoding_type = 'CBR';
                break;
             };

             $this->encoding_type = 'VBR';

             fseek($f, ftell($f) + 2);
             fseek($f, ftell($f) + 2);

             $r = fread($f, 2);
             $this->quality = unpack('n', $r);
             $this->quality = $this->quality[1];

             $r = fread($f, 4);
             $this->musicsize = unpack('N', $r);
             $this->musicsize = $this->musicsize[1];

             $r = fread($f, 4);
             $this->frames = unpack('N', $r);
             $this->frames = $this->frames[1];
        }

        fclose($f);

        if($bits[11] == 0){
         $this->mpeg_ver = "2.5";
         $bitrates = array(
            '1' => array(0, 32, 48, 56, 64, 80, 96, 112, 128, 144, 160, 176, 192, 224, 256, 0),
            '2' => array(0,  8, 16, 24, 32, 40, 48,  56,  64,  80,  96, 112, 128, 144, 160, 0),
            '3' => array(0,  8, 16, 24, 32, 40, 48,  56,  64,  80,  96, 112, 128, 144, 160, 0),
                 );
        }elseif($bits[12] == 0){
         $this->mpeg_ver = "2";
         $bitrates = array(
            '1' => array(0, 32, 48, 56, 64, 80, 96, 112, 128, 144, 160, 176, 192, 224, 256, 0),
            '2' => array(0,  8, 16, 24, 32, 40, 48,  56,  64,  80,  96, 112, 128, 144, 160, 0),
            '3' => array(0,  8, 16, 24, 32, 40, 48,  56,  64,  80,  96, 112, 128, 144, 160, 0),
                 );
        }else{
         $this->mpeg_ver = "1";
         $bitrates = array(
            '1' => array(0, 32, 64, 96, 128, 160, 192, 224, 256, 288, 320, 352, 384, 416, 448, 0),
            '2' => array(0, 32, 48, 56,  64,  80,  96, 112, 128, 160, 192, 224, 256, 320, 384, 0),
            '3' => array(0, 32, 40, 48,  56,  64,  80,  96, 112, 128, 160, 192, 224, 256, 320, 0),
                 );
        };

        $layer = array(
         array(0,3),
         array(2,1),
              );
        $this->layer = $layer[$bits[13]][$bits[14]];

        if($bits[15] == 0){
         $this->crc = true;
        };

        $bitrate = 0;
        if($bits[16] == 1) $bitrate += 8;
        if($bits[17] == 1) $bitrate += 4;
        if($bits[18] == 1) $bitrate += 2;
        if($bits[19] == 1) $bitrate += 1;
        $this->bitrate = $bitrates[$this->layer][$bitrate];

        $frequency = array(
         '1' => array(
            '0' => array(44100, 48000),
            '1' => array(32000, 0),
                ),
         '2' => array(
            '0' => array(22050, 24000),
            '1' => array(16000, 0),
                ),
         '2.5' => array(
            '0' => array(11025, 12000),
            '1' => array(8000, 0),
                  ),
          );
        $this->frequency = $frequency[$this->mpeg_ver][$bits[20]][$bits[21]];

        $this->padding = $bits[22];
        $this->private = $bits[23];

        $mode = array(
         array('Stereo', 'Joint Stereo'),
         array('Dual Channel', 'Mono'),
             );
        $this->mode = $mode[$bits[24]][$bits[25]];

        $this->copyright = $bits[28];
        $this->original = $bits[29];

        $emphasis = array(
         array('none', '50/15ms'),
         array('', 'CCITT j.17'),
             );
        $this->emphasis = $emphasis[$bits[30]][$bits[31]];

        $samplesperframe = array(
         '1' => array(
            '1' => 384,
            '2' => 1152,
            '3' => 1152
         ),
         '2' => array(
            '1' => 384,
            '2' => 1152,
            '3' => 576
         ),
         '2.5' => array(
            '1' => 384,
            '2' => 1152,
            '3' => 576
         ),
        );
        $this->samples_per_frame = $samplesperframe[$this->mpeg_ver][$this->layer];

        if($this->encoding_type != 'VBR'){
         if($this->bitrate == 0){
            $s = -1;
         }else{
            $s = ((8*filesize($this->file))/1000) / $this->bitrate;
         };
         $this->length = sprintf('%02d:%02d',floor($s/60),floor($s-(floor($s/60)*60)));
         $this->lengthh = sprintf('%02d:%02d:%02d',floor($s/3600),floor($s/60),floor($s-(floor($s/60)*60)));
         $this->lengths = (int)$s;

         $this->samples = ceil($this->lengths * $this->frequency);
         if(0 != $this->samples_per_frame){
            $this->frames = ceil($this->samples / $this->samples_per_frame);
         }else{
            $this->frames = 0;
         };
         $this->musicsize = ceil($this->lengths * $this->bitrate * 1000 / 8);
        }else{
         $this->samples = $this->samples_per_frame * $this->frames;
         $s = $this->samples / $this->frequency;

         $this->length = sprintf('%02d:%02d',floor($s/60),floor($s-(floor($s/60)*60)));
         $this->lengthh = sprintf('%02d:%02d:%02d',floor($s/3600),floor($s/60),floor($s-(floor($s/60)*60)));
         $this->lengths = (int)$s;

         $this->bitrate = (int)(($this->musicsize / $s) * 8 / 1000);
        };
    }
}

//  -   -   -   -   -   -   -   -

require('require.php');
require('header.php');
require('config.php');
$gzip = &new compress($CFG['gzip']);
$path=&getvar('f');
echo('<?xml version="1.0" encoding="utf-8"?>
<!DOCTYPE html PUBLIC "-//WAPFORUM//DTD XHTML Mobile 1.0//EN" "http://www.wapforum.org/DTD/xhtml-mobile10.dtd">
<html xmlns="http://www.w3.org/1999/xhtml" xml:lang="ru"><head>
<link rel="stylesheet" type="text/css" href="style/style.css" />
<title>');
$title=fname(basename($path));
print($title.'</title></head><body><div style="text-align: center">
');
if(strpos($path,'..')!==false || $path{0}=='/') die('Дocтуп зaпpeщён.</div></body></html>');
if(!file_exists('../'.$path)) die('Oшибкa. Taкoгo фaйлa нeт</div></body></html>');
$mp3 = &new MP3_id(true);
$mp3->read('../'.$path);
function show($name,$str){
  if($str) return('<div class="a">'.$name.':</div>'.$str); else return null;
}
if($mp3->id3v1){
  echo(
   show('Haзвaниe',$mp3->name).
   show('Иcпoлнитeль',$mp3->artists).
   show('Aльбoм',$mp3->album).
   show('Гoд',$mp3->year).
   show('Тpeк',$mp3->track).
   show('Koммeнтapий',$mp3->comment)
  );
};
if($mp3->studied){
  echo(
   show('Битpeйт',$mp3->bitrate.'kbps').
   show('Чacтoтa',$mp3->frequency.'Hz').
   show('Koдиpoвaниe',$mp3->encoding_type).
   show('Peжим',$mp3->mode).
   show('Bpeмя',$mp3->length)
  );
};
echo('<div class="a">Paзмep:</div>'.round(filesize('../'.$path)/1024,1).'kb<br /><br />
[<a href="../'.$path.'">Cкaчaть</a>]</div><div><hr />
[<a href="../?d='.dirname($path).'">K фaйлaм</a>]<br />
[<a href="/">На главную</a>]</div></body></html>');
?>