<?php
// модификация dunzip2 by DreamDragon
class zip {
  var $zipfile;
  var $filelist = Array();
  var $total = 0;
  var $endOfCentral = Array();
  var $fh;
  var $zipSignature = "\x50\x4b\x03\x04"; // local file header signature
  var $dirSignature = "\x50\x4b\x01\x02"; // central dir header signature
  var $dirSignatureE= "\x50\x4b\x05\x06"; // end of central dir signature

  function zip($zipfile){
    $this->zipfile = $zipfile;
  }

  function getlist($stopOnFile=false){
    if(sizeof($this->filelist)){
     return $this->filelist;
   }
   $this->fh = fopen($this->zipfile, 'r');
   if(!$this->fh){
     echo('Failed to load file.');
     return false;
   }
   if(!$this->_loadFileListByEOF($this->fh, $stopOnFile)){
     echo('ZIP File is corrupted or empty');
     return false;
   }
   return $this->filelist;
  }

  function getzipinfo($detail=false){
    return $detail ? $this->endOfCentral[$detail] : $this->endOfCentral;
  }

  function unzip($i){
    if(!$this->filelist){
      $this->getlist($i);
    }
    if(isset($this->filelist[$i])){
      $fdetails = &$this->filelist[$i];
    }else{
      echo('File is not compressed in the zip.');
      return false;
    }
    if(substr($fdetails['file_name'], -1) == '/'){
      echo('Trying to unzip a folder name "<b>'.$fdetails['file_name'].'</b>.');
      return false;
    }
    if(!$fdetails['uncompressed']){
      return '';
    }
    fseek($this->fh, $fdetails['start_offset']);
    $ret = $this->uncompress(fread($this->fh, $fdetails['compressed']), $fdetails['compr_method'], $fdetails['uncompressed']);
    return $ret;
  }

  function close(){
    if($this->fh) fclose($this->fh);
  }

  function uncompress($content, $mode, $size){
    switch($mode){
     case 0:
      // Not compressed
      return $content;
     case 1:
      echo('Shrunk mode is not supported... yet?');
      return false;
     case 2:
     case 3:
     case 4:
     case 5:
      echo('Compression factor '.($mode-1).' is not supported... yet?');
     return false;
     case 6:
      echo('Implode is not supported... yet?');
     return false;
     case 7:
      echo('Tokenizing compression algorithm is not supported... yet?');
      return false;
     case 8:
      // Deflate
      if(!extension_loaded('zlib')){
        echo('Error: Zlib is not loaded');
        return false;
      }
     return gzinflate($content, $size);
     case 9:
      echo('Enhanced Deflating is not supported... yet?');
     return false;
     case 10:
      echo('PKWARE Date Compression Library Impoloding is not supported... yet?');
      return false;
     case 12:
      // Bzip2
      if(!extension_loaded('bzip2')){
       echo('Error: BZip2 not loaded');
       return false;
      }
      return bzdecompress($content);
     case 18:
      echo('IBM TERSE is not supported... yet?');
      return false;
     default:
      echo('Unknown uncompress method: '.$mode);
      return false;
    }
  }

  function _loadFileListByEOF(&$fh, $stopOnFile=false){
    // Check if there's a valid Central Dir signature.
    // Let's consider a file comment smaller than 1024 characters...
    // Actually, it length can be 65536.. But we're not going to support it.
    for($x = 0; $x < 1024; $x++){
      fseek($fh, -22-$x, SEEK_END);
      if(fread($fh, 4) == $this->dirSignatureE){
       // If found EOF Central Dir
        $eodir['disk_number_this']   = unpack('v', fread($fh, 2)); // number of this disk
        $eodir['disk_number']        = unpack('v', fread($fh, 2)); // number of the disk with the start of the central directory
        $eodir['total_entries_this'] = unpack('v', fread($fh, 2)); // total number of entries in the central dir on this disk
        $eodir['total_entries']      = unpack('v', fread($fh, 2)); // total number of entries in
        $eodir['size_of_cd']         = unpack('V', fread($fh, 4)); // size of the central directory
        $eodir['offset_start_cd']    = unpack('V', fread($fh, 4)); // offset of start of central directory with respect to the starting disk number
        $zipFileCommentLenght        = unpack('v', fread($fh, 2)); // zipfile comment length
        $eodir['zipfile_comment']    = $zipFileCommentLenght[1] ? fread($fh, $zipFileCommentLenght[1]) : ''; // zipfile comment
        $this->endOfCentral = Array(
                    'disk_number_this'=>$eodir['disk_number_this'][1],
                    'disk_number'=>$eodir['disk_number'][1],
                    'total_entries_this'=>$eodir['total_entries_this'][1],
                    'total_entries'=>$eodir['total_entries'][1],
                    'size_of_cd'=>$eodir['size_of_cd'][1],
                    'offset_start_cd'=>$eodir['offset_start_cd'][1],
                    'zipfile_comment'=>$eodir['zipfile_comment']
                                    );
        $this->total=$this->endOfCentral['total_entries_this'];
        // Then, load file list
        fseek($fh, $this->endOfCentral['offset_start_cd']);
        $signature = fread($fh, 4);
        $i=0;
        while($signature == $this->dirSignature){
          $dir['version_madeby']      = unpack('v', fread($fh, 2)); // version made by
          $dir['version_needed']      = unpack('v', fread($fh, 2)); // version needed to extract
          fseek($fh, 2,SEEK_CUR);
          $dir['compr_method']  = unpack('v', fread($fh, 2)); // compression method
          $dir['lastmod_time']        = unpack('v', fread($fh, 2)); // last mod file time
          $dir['lastmod_date']        = unpack('v', fread($fh, 2)); // last mod file date
          fseek($fh,4,SEEK_CUR);
          $dir['compressed']     = unpack('V', fread($fh, 4)); // compressed size
          $dir['uncompressed']   = unpack('V', fread($fh, 4)); // uncompressed size
          $fileLength             = unpack('v', fread($fh, 2)); // filename length
          $extraFieldLength           = unpack('v', fread($fh, 2)); // extra field length
          $fileCommentLength          = unpack('v', fread($fh, 2)); // file comment length
          fseek($fh,8,SEEK_CUR);
          $dir['relative_offset']     = unpack('V', fread($fh, 4)); // relative offset of local header
          $dir['file_name']           = fread($fh, $fileLength[1]); // filename
          fseek($fh,$extraFieldLength[1]+$fileCommentLength[1],SEEK_CUR);
          $dir['start_offset']=$dir['relative_offset'][1]+$fileLength[1]+$extraFieldLength[1]+$fileCommentLength[1]+30;
          // Convert the date and time, from MS-DOS format to UNIX Timestamp
          $BINlastmod_date = str_pad(decbin($dir['lastmod_date'][1]), 16, '0', STR_PAD_LEFT);
          $BINlastmod_time = str_pad(decbin($dir['lastmod_time'][1]), 16, '0', STR_PAD_LEFT);
          $lastmod_dateY = bindec(substr($BINlastmod_date,  0, 7))+1980;
          $lastmod_dateM = bindec(substr($BINlastmod_date,  7, 4));
          $lastmod_dateD = bindec(substr($BINlastmod_date, 11, 5));
          $lastmod_timeH = bindec(substr($BINlastmod_time,   0, 5));
          $lastmod_timeM = bindec(substr($BINlastmod_time,   5, 6));
          $lastmod_timeS = bindec(substr($BINlastmod_time,  11, 5));

          $this->filelist[$dir['file_name']] = Array(
                         'version_madeby'=>$dir['version_madeby'][1],
                         'version_needed'=>$dir['version_needed'][1],
                         'compr_method'=>$dir['compr_method'][1],
                         'lastmod_datetime'  =>mktime($lastmod_timeH, $lastmod_timeM, $lastmod_timeS, $lastmod_dateM, $lastmod_dateD, $lastmod_dateY),
                         'compressed'=>$dir['compressed'][1],
                         'uncompressed'=>$dir['uncompressed'][1],
                         'relative_offset'=>$dir['relative_offset'][1],
                         'file_name'=>$dir['file_name'],
                         'start_offset'=>$dir['start_offset']
                       );
          if($stopOnFile==$dir['file_name']) break;
          $signature = fread($fh, 4);
        }
        return true;
      }
    }
    return false;
  }
}

//  -   -   -   -   -   -   -   -

require('require.php');
require('config.php');
$gzip = &new compress($CFG['gzip']);
$f=&getvar('f');
$path='../'.$f.'.jar';
if(isset($_GET['jad'])){
  $zip = &new zip($path);
  $zip->getlist();
header('Content-Type: text/vnd.sun.j2me.app-descriptor');
header('Content-Disposition: attachment; filename="'.basename($path).'.jad"');
  $repl='MIDlet-Jar-Size: '.filesize($path)."\n".
  'MIDlet-Jar-URL: http://'.$_SERVER['HTTP_HOST'].dirname(dirname($_SERVER['PHP_SELF'])).'/'.$f."\n";
  print preg_replace('!MIDlet-Jar-URL: [\S]+[\s]!i',$repl,$zip->unzip('META-INF/MANIFEST.MF'));
  exit;
}
include('header.php');
$title=fname(basename($f));
echo('<?xml version="1.0" encoding="utf-8"?>
<!DOCTYPE html PUBLIC "-//WAPFORUM//DTD XHTML Mobile 1.0//EN" "http://www.wapforum.org/DTD/xhtml-mobile10.dtd">
<html xmlns="http://www.w3.org/1999/xhtml" xml:lang="ru"><head>
<link rel="stylesheet" type="text/css" href="style/style.css" />
<title>'.$title.'</title></head><body><div>
<div class="a" style="text-align: center"><img src="style/jar.gif" alt="" /> <b>'.$title.'</b></div>
');
if(!file_exists($path)) die('Oшибкa. Taкoгo фaйлa нeт</div></body></html>');
$about=dirname($path).'/_'.basename($f).'.txt';
if(file_exists($about)) readfile($about);
echo("<hr />\n");
if($CFG['unzip']) print('[<a href="java.php?f='.$f.'&amp;jad">Cкaчaть JAD</a>]<br />');
echo('
[<a href="'.$path.'">Cкaчaть JAR<small> ('.round(filesize($path)/1024,1).' kb)</small></a>]<hr />
[<a href="../?d='.dirname($f).'">K фaйлaм</a>]<br />
[<a href="/">На главную</a>]</div></body></html>');
?>