<?php
error_reporting(0);

class Spamer{

	/**
	 * @author Gemorroj
	 * @copyright 2009.05.30 20:10
	 * @version PHP 5
	 * @link http://wapinet.ru
	 */


	/**
	 * @var array
	 * Массив пользователей
	 * $users['spamed'] - уже были проспамлены
	 * $users['not_spamed'] - еще не были проспамлены
	 */
	public $users = array();
	/**
	 * @var array
	 * Массив заголовков
	 */
	public $headers = array();
	/**
	 * @var int
	 * Таймаут соединения с сервером
	 */
	public $timeout;
	/**
	 * @var string
	 * Прокси
	 */
	public $proxy;
	/**
	 * @var string
	 * Файл с правами на запись и чтение
	 */
	public $file;
	/**
	 * @var string
	 * Ответ удаленного сервера
	 */
	 public $response;


	/**
	 * @param $referer (string) - реферер
	 * @param $cookie (string) - кукисы
	 * @param $proxy (string)- прокси
	 * @param $timeout (int)- таймаут соединения с сервером
	 * @param $file (string)- файл с правами на запись и чтение
	 * @return void
	 */
	public function __construct($proxy = '', $timeout = 10, $file = 'db.dat'){

		$this->proxy = $proxy;
		$this->timeout = $timeout;
		$this->file = $file;

		if(!is_file($this->file)){
			touch($this->file);
		}
		chmod($this->file, 0666);

		$this->headers['Accept'] = 'text/html, application/xml;q=0.9, application/xhtml+xml, image/png, image/jpeg, image/gif, image/x-xbitmap, */*;q=0.1';
		$this->headers['Accept-Charset'] = 'iso-8859-1, utf-8, utf-16, *;q=0.1';
		$this->headers['Accept-Language'] = 'ru-RU,ru;q=0.9,en;q=0.8';
		$this->headers['Connection'] = 'close';
	}


	/**
	 * @param $header (string) - добавление произвольного заголовка
	 * @return array - возвращает массив заголовков
	 */
	public function send_header($header = ''){
		$h = explode(':', $header);

		$key = ucwords(trim($h[0]));
		unset($h[0]);

		$value = trim(implode(':', $h));
		
		if($this->headers[$key]){
			$this->headers[$key] = $this->headers[$key] . ';' . $value;
		}
		else{
			$this->headers[$key] = $value;
		}

		return $this->headers;
	}


	/**
	 * @param $url (string) - URL на который отправляется запрос
	 * @param $authorise (string) - данные передаваемые через POST для авторизации (логин, пароль)
	 * @param $regexp (string) - регулярное выражение для выдирания идентификатора сессии
	 * @param $match (int) - нужный элемент выходного массива после использования регекспа
	 * @param $header (bool) - нужно ли получать заголовки ответа
	 * @param $nobody (bool) - нужно ли получать тело страницы
	 * @return string - результат регулярного выражения или ответ сервера
	 */
	public function authorise($url, $authorise, $regexp = '', $match = 0, $header = true, $nobody = false){
		$get = $this->get($url, $authorise, $header, $nobody);

		if($regexp){
			preg_match($regexp, $get, $array);
			return trim($array[$match]);
		}
		else{
			return $get;
		}
	}


	/**
	 * @param $url1 (string) - URL на который отправляется первый запрос (не работает, если заранее указано количество страниц)
	 * @param $regexp (string) - регулярное выражение для выдирания общего количества страниц (не работает, если заранее указано количество страниц)
	 * @param $match (int) - нужный элемент выходного массива после использования регекспа (не работает, если заранее указано количество страниц)
	 * @param $url2 (string) - URL на который отправляются запросы 
	 * @param $regexp_user (string) - регулярное выражение для выдирания имен пользователей
	 * @param $match_user (int) - нужный элемент выходного массива после использования регекспа
	 * @param $regexp_id (string) - регулярное выражение для выдирания ID пользователей
	 * @param $match_id (int) - нужный элемент выходного массива после использования регекспа
	 * @param $pg (int) - количество страниц (не обязательный)
	 * @param $step (int) - шаг между страницами
	 * @return array - массив пользователей в онлайне. Ключ - ID, значение - ник
	 */
	public function online($url1 = '', $regexp = '', $match = 0, $url2, $regexp_user, $match_user, $regexp_id, $match_id, $pg = 0, $step = 1){
		$array = array();

		if($pg){
			$array[$match] = $pg;
		}
		else{
			$get = $this->get($url1, '', false, false);
			preg_match($regexp, $get, $array);
		}

		for($i = 0; $i < $array[$match]; $i++){
			$get = $this->get($url2 . ($i * $step), '', false, false);

			preg_match_all($regexp_user, $get, $array_user);
			preg_match_all($regexp_id, $get, $array_id);

			//$a = sizeof($array_user[$match_user]);
			$a = sizeof($array_id[$match_id]);

			for($ii = 0; $ii < $a; $ii++){
				$this->users[trim($array_id[$match_id][$ii])] = trim($array_user[$match_user][$ii]);
			}

		}

		return $this->users;
	}


	/**
	 * @param $spamed (bool) - проспамлены ли уже эти пользователи
	 * @param $users (array) - массив пользователей, которых нужно сохранить
	 * @return int - успешно ли записаны данные
	 */
	public function save_users($spamed = false, $users = array()){

		$array = array();

		if(!$users){
			$users = $this->users;
		}

		$data = $this->get_users();
		if($spamed){
			$array['spamed'] = $users + $data['spamed'];
			$array['not_spamed'] = array_diff($data['not_spamed'], $users);
		}
		else{
			$array['not_spamed'] = $users + $data['not_spamed'];
			$array['spamed'] = array_diff($data['spamed'], $users);
		}

		return file_put_contents($this->file, serialize($array));
	}


	/**
	 * @param void
	 * @return array - массив сохраненных пользователей
	 * $array['spamed'] - уже были проспамлены
	 * $array['not spamed'] - еще не были проспамлены
	 */
	public function get_users(){

		$data = unserialize(file_get_contents($this->file));

		if(!$data['spamed']){
			$data['spamed'] = array();
		}
		if(!$data['not_spamed']){
			$data['not_spamed'] = array();
		}

		return $data;
	}


	/**
	 * @param $url (string) - URL на который отправляется запрос
	 * @param $post (string) - POST запрос
	 * @param $header (bool) - выдавать ли в ответе заголовки
	 * @param $nobody (bool) - выдавать ли в ответе тело страницы
	 * @return string - страница полученная с удаленного серверав результате нашего запроса
	 */
	public function get($url, $post = '', $header = true, $nobody = false){
		
		$h = array();
		foreach($this->headers as $key => $val){
			$h[] = $key . ': ' . $val;
		}
		
		$curl = curl_init();
		curl_setopt($curl, CURLOPT_URL, $url);
		curl_setopt($curl, CURLOPT_HTTPHEADER, $h);
		curl_setopt($curl, CURLOPT_RETURNTRANSFER, true);
		curl_setopt($curl, CURLOPT_FOLLOWLOCATION, true);
		curl_setopt($curl, CURLOPT_AUTOREFERER, false);
		curl_setopt($curl, CURLOPT_TIMEOUT, $this->timeout);
		curl_setopt($curl, CURLOPT_HEADER, $header);
  		curl_setopt($curl, CURLOPT_SSL_VERIFYPEER, false);
    	curl_setopt($curl, CURLOPT_SSL_VERIFYHOST, false);
		curl_setopt($curl, CURLOPT_NOBODY, $nobody);
		curl_setopt($curl, CURLOPT_VERBOSE, false);

		if($post){
			curl_setopt($curl, CURLOPT_POST, true);
			curl_setopt($curl, CURLOPT_POSTFIELDS, $post);
		}

		if($this->proxy){
			curl_setopt($curl, CURLOPT_PROXY, $this->proxy);
			curl_setopt($curl, CURLOPT_PROXYTYPE, CURLPROXY_HTTP);
		}

		$get = curl_exec($curl);
		curl_close($curl);

		return $this->response = (string)$get;
	}


	/**
	 * @param $url (string) - URL на который отправляется запрос
	 * @param $post (string) - POST запрос
	 * @param $regexp (string) - регулярное выражение для поиска совпадения текста в случае удачного запроса
	 * @param $header (bool) - нужно ли получать заголовки ответа
	 * @param $nobody (bool) - нужно ли получать тело страницы
	 * @return mixed - 1/0 в случае регулярного выражения, полученная страница в случае его отсутствия
	 */
	public function spam($url, $post = '', $regexp = '', $header = false, $nobody = false){
		$get = $this->get($url, $post, $header, $nobody);

		if($regexp){
			return preg_match($regexp, $get);
		}

		return $get;
	}


	/**
	 * @param void
	 * @return int - успешно ли обновлена БД
	 */
	public function clean(){
		return file_put_contents($this->file, serialize(array('spamed' => array(), 'not_spamed' => array())));
	}
	
	
	/**
	 * @param void
	 * @return int записаны ли данные в БД
	 */
	public function all_spamed(){
		$data = $this->get_users();
		return file_put_contents($this->file, serialize(array('spamed' => $data['spamed'] + $data['not_spamed'], 'not_spamed' => array())));
	}


	/**
	 * @param void
	 * @return int записаны ли данные в БД
	 */
	public function all_not_spamed(){
		$data = $this->get_users();
		return file_put_contents($this->file, serialize(array('spamed' => array(), 'not_spamed' => $data['spamed'] + $data['not_spamed'])));
	}


	/**
	 * @param void
	 * @return string куки, которые пытается записать удаленный сервер
	 */
	public function get_cookies(){
		$h = explode("\r\n\r\n", $this->response);
		preg_match_all('/\nSet\-Cookie:\s*?(.+);.*/iU', $h[0], $cookies);
		return implode(';', $cookies[1]);
	}
}
?>