<?php
/***************************************************************************
 *                              weblog_rss.php
 *                           --------------------
 *   begin                : Monday, September 5, 2004
 *   copyright            : (C) 2005 Hyperion
 *   
 *   $Id: weblog_rss.php,v 1.0.0 2004/09/05, 13:17:43 Hyperion Exp $
 *
 ***************************************************************************/

/***************************************************************************
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 ***************************************************************************/

define('IN_PHPBB', true);
$phpbb_root_path = './';
include($phpbb_root_path . 'extension.inc');
include($phpbb_root_path . 'common.' . $phpEx);
include($phpbb_root_path . 'includes/bbcode.' . $phpEx);
include($phpbb_root_path . 'includes/weblogs_common.'.$phpEx);
include($phpbb_root_path . 'includes/functions_weblog.'.$phpEx);

if( isset($HTTP_GET_VARS[POST_WEBLOG_URL]) || isset($HTTP_POST_VARS[POST_WEBLOG_URL]) )
{
	$weblog_id = ( isset($HTTP_GET_VARS[POST_WEBLOG_URL]) ) ? intval($HTTP_GET_VARS[POST_WEBLOG_URL]) : intval($HTTP_POST_VARS[POST_WEBLOG_URL]);
	$weblog_id = intval($weblog_id);
}

$userdata = session_pagestart($user_ip, PAGE_INDEX);
init_userprefs($userdata);

if( !empty($weblog_id) )
{
	$sql = "SELECT w.*, u.user_id
		FROM " . WEBLOGS_TABLE . " w, " . USERS_TABLE . " u
		WHERE w.weblog_id = $weblog_id
			AND u.user_weblog = w.weblog_id";
	if( !$result = $db->sql_query($sql) )
	{
		message_die(GENERAL_ERROR, "Couldn't obtain weblogs information.", "", __LINE__, __FILE__, $sql);
	}

	if( !($weblog_data = $db->sql_fetchrow($result)) )
	{
		message_die(GENERAL_MESSAGE, $lang['Weblog_not_exist']);
	}

	if ( $weblog_data['deleted'] )
	{
		message_die(GENERAL_ERROR, sprintf($lang['Weblog_deactivated'], $weblog_data['weblog_name']));
	}

	$sql = "SELECT * FROM " . WEBLOG_CONTRIBUTORS_TABLE . " WHERE weblog_id = $weblog_id AND user_id = " . $userdata['user_id'];
	if ( !($result = $db->sql_query($sql)) )
	{
		message_die(GENERAL_ERROR, 'Error querying to find user weblog information', '', __LINE__, __FILE__, $sql);
	}
	
	$contributor = FALSE;
	if ( $row = $db->sql_fetchrow($result) || $userdata['user_level'] == ADMIN )
	{
		$contributor = TRUE;
	}

	$auth_level = get_auth_level ( $weblog_data, $contributor );

	if ( $weblog_data['weblog_auth'] > $auth_level )
	{
		message_die(GENERAL_ERROR, $lang['Weblog_noaccess']);
	}

	$sql = "SELECT * FROM " . USERS_TABLE . "
			WHERE user_weblog = " . $weblog_data['weblog_id'];
	if( !$result = $db->sql_query($sql) )
	{
		message_die(GENERAL_ERROR, "Couldn't get weblog owner information.", "", __LINE__, __FILE__, $sql);
	}

	$owner_data = array();
	if ( $row = $db->sql_fetchrow($result) )
	{
		$owner_data = $row;
	}

	$sql = "SELECT * FROM " . WEBLOG_ENTRIES_TABLE . "
		WHERE weblog_id = " . $weblog_data['weblog_id'] . "
			AND entry_access <= $auth_level
			AND entry_time <= " . time() . "
		ORDER BY entry_time DESC
		LIMIT " . $weblog_data['entries_perpage'];
	if(!($result = $db->sql_query($sql)))
	{
		message_die(GENERAL_ERROR, 'Could not query weblog entry information', '', __LINE__, __FILE__, $sql);
	}

	$entry_data = array();
	while ( $row = $db->sql_fetchrow($result) )
	{
		$entry_data[] = $row;
	}
}

$server_name = trim($board_config['server_name']);
$server_protocol = ( $board_config['cookie_secure'] ) ? 'https://' : 'http://';
$server_port = ( $board_config['server_port'] <> 80 ) ? ':' . trim($board_config['server_port']) . '/' : '';
$script_name = preg_replace('/^\/?(.*?)\/?$/', '\1', trim($board_config['script_path']));

$basedir = $server_protocol . $server_name .  $server_port . '/' .  $script_name . '/';

$smilies_path = $board_config['smilies_path'];
$smilies_url = $basedir . $smilies_path;
$smilies_path = preg_replace("/\//", "\/", $smilies_path);


header ('Expires: ' . gmdate('D, d M Y H:i:s', time()) . ' GMT');
header ('Last-Modified: ' . gmdate('D, d M Y H:i:s') . ' GMT');
header ('Content-Type: text/xml');

echo ("<?xml version=\"1.0\" encoding=\"utf8\" ?>\n");
echo ("  <rss version=\"2.0\">\n");
echo ("	<channel>\n");
if ( $weblog_id )
{
	echo ("	  <title>" . $weblog_data['weblog_name'] . "</title>\n");
	echo ("	  <link>" . $basedir . "weblog.$phpEx?" . POST_WEBLOG_URL . "=$weblog_id" . "</link>\n");
}
else
{
	echo ("	  <title>" . $lang['Latest_weblogs_feed'] . "</title>\n");
	echo ("	  <link>" . $basedir . "weblogs.$phpEx</link>\n");
}
echo ("	  <webMaster>" . $board_config['board_email'] . "</webMaster>\n");
echo ("	  <lastBuildDate>" . gmdate('D, d M Y H:i:s', time()) . " GMT</lastBuildDate>\n");
echo ("	  <generator>The Blog Mod " . WEBLOGS_MOD_VERSION . " by Hyperion</generator>\n");

if ( $weblog_id )
{

$sql = "SELECT *
	FROM " . WEBLOG_MOODS_TABLE . "
	ORDER BY mood_text";
if( !$result = $db->sql_query($sql) )
{
	message_die(GENERAL_ERROR, "Couldn't obtain mood data from database", "", __LINE__, __FILE__, $sql);
}
$mood_data = $db->sql_fetchrowset($result);

$sql = "SELECT *
	FROM " . WEBLOG_ACTIONS_TABLE . "
	ORDER BY action_text";
if( !$result = $db->sql_query($sql) )
{
	message_die(GENERAL_ERROR, "Couldn't obtain action data from database", "", __LINE__, __FILE__, $sql);
}
$action_data = $db->sql_fetchrowset($result);


for ($i = 0; $i < count($entry_data); $i++)
{
	$entry_data[$i]['entry_text'] = htmlspecialchars($entry_data[$i]['entry_text']);
	if ( $entry_data[$i]['enable_bbcode'] )
	{
		$entry_data[$i]['entry_text'] = bbencode_second_pass($entry_data[$i]['entry_text'], $entry_data[$i]['bbcode_uid']);
	}

	if ( $entry_data[$i]['enable_smilies'] )
	{
		$entry_data[$i]['entry_text'] = smilies_pass($entry_data[$i]['entry_text']);
	}

	$entry_data[$i]['entry_text'] = make_clickable($entry_data[$i]['entry_text']);

	if ( !$weblog_config['censor_weblog'] )
	{
		$orig_word = array();
		$replacement_word = array();
		obtain_word_list($orig_word, $replacement_word);

		/*if (count($orig_word))
		{
			$entry_data[$i]['entry_subject'] = preg_replace($orig_word, $replacement_word, $entry_data[$i]['entry_subject']);
			$entry_data[$i]['entry_text'] = preg_replace($orig_word, $replacement_word, $entry_data[$i]['entry_text']);
		}*/
	}

	$entry_data[$i]['entry_text'] = nl2br($entry_data[$i]['entry_text']);

	$mood = array();
	$mood = find_mood($entry_data[$i]['entry_mood']);

	if ( $mood >= 0 )
	{ 
		$mood = '<strong>[</strong>&nbsp;' . sprintf($lang['Mood:'], '<img src="' . $basedir . 'images/weblog/' . $mood['mood_url'] . '" alt="' . $mood['mood_text'] . '" style="vertical-align: middle" border="0" />', $mood['mood_text']) . '&nbsp;<strong>]</strong><br />';
	}
	else
	{
		$mood = '';
	}

	$currently = array();
	$currently = find_action($entry_data[$i]['entry_currently']);

	if ( $currently > 0 )
	{
		$action = '<strong>[</strong>&nbsp;' . sprintf($lang['Currently:'], '<img src="' . $basedir . 'images/weblog/' . $currently['action_url'] . '" alt="' . $currently['action_text'] . ' ' . $entry_data[$i]['currently_text'] . '" style="vertical-align: middle" border="0" />',  $currently['action_text'] . ' ' . $entry_data[$i]['currently_text']) . '&nbsp;<strong>]</strong><br />'; 
	}
	else if ( $entry_data[$i]['currently_text'] && $currently == -2 )
	{
		$action = '<strong>[</strong>' . sprintf($lang['Currently:'], '', $entry_data[$i]['currently_text']) . '&nbsp;<strong>]</strong><br />';
	}
	else
	{
		$action = '';
	}
        $entry_data[$i]['entry_text'] = preg_replace('/img src ?= ?"images/', 'img src="' . $basedir . 'images', $entry_data[$i]['entry_text']);

	$entry_data[$i]['entry_text'] = $mood . $action . $entry_data[$i]['entry_text'];

	$entry_data[$i]['entry_text'] = trim ($entry_data[$i]['entry_text']);

	$entry_data[$i]['entry_text'] = cut_message ( $entry_data[$i]['entry_text'], $entry_data[$i]['entry_id'] );

	$entry_author = $owner_data['username'] . ' ';
	if ( ($owner_data['user_viewemail']) || $userdata['user_level'] == ADMIN )
	{
		$entry_author .= $owner_data['user_email'];
	}

	$entry_link = $basedir . "weblog_entry.$phpEx?" . POST_ENTRY_URL . "=" . $entry_data[$i]['entry_id'];

	$entry_time = $entry_data[$i]['entry_time'];
	echo ("	  <item>\n");
	echo ("	    <title>" . $entry_data[$i]['entry_subject'] . "</title>\n");
	echo ("	    <link>" . $entry_link . "</link>\n");
	echo ("	    <description>" . htmlspecialchars($entry_data[$i]['entry_text']) . "</description>\n");
	echo ("	    <author>" . $entry_author . "</author>\n");
	echo ("	    <pubDate>" . gmdate('D, d M Y H:i:s', $entry_data[$i]['entry_time']) . " GMT</pubDate>\n");
	echo ("	  </item>\n");
}

}
else
{
		//
	// Friends
	//
	$sql = "SELECT * FROM " . WEBLOG_FRIENDS_TABLE . " WHERE friend_id = " . $userdata['user_id'];
	if ( !($result = $db->sql_query($sql)) )
	{
		message_die(GENERAL_ERROR, 'Error querying to find user weblog friends information', '', __LINE__, __FILE__, $sql);
	}

	$friends_data = array();
	while ( $row = $db->sql_fetchrow($result) )
	{
		$friends_data[] = $row;
	}

	//
	// Blocked Users
	//
	$sql = "SELECT * FROM " . WEBLOG_BLOCKED_TABLE . " WHERE blocked_id = " . $userdata['user_id'];
	if ( !($result = $db->sql_query($sql)) )
	{
		message_die(GENERAL_ERROR, 'Error querying to find user weblog blocked information', '', __LINE__, __FILE__, $sql);
	}

	$blocked_data = array();
	while ( $row = $db->sql_fetchrow($result) )
	{
		$blocked_data[] = $row;
	}

	//
	// Fetch Contributor data
	//
	$sql = "SELECT * FROM " . WEBLOG_CONTRIBUTORS_TABLE . " WHERE user_id = " . $userdata['user_id'];
	if ( !($result = $db->sql_query($sql)) )
	{
		message_die(GENERAL_ERROR, 'Error querying to find user weblog information', '', __LINE__, __FILE__, $sql);
	}

	$contributor_data = array();
	while ( $row = $db->sql_fetchrow($result) )
	{
		$contributor_data[] = $row;
	}

	//
	// Get Weblog Data from Weblogs with at least one valid entry
	//
	$sql = "SELECT w.*, u.*, e.entry_id, e.entry_subject, e.entry_access, e.entry_mood, e.entry_currently, e.entry_time, e.bbcode_uid, e.entry_text
		FROM " . USERS_TABLE . " u, " . WEBLOGS_TABLE . " w
			LEFT JOIN " . WEBLOG_ENTRIES_TABLE . " e
				ON e.weblog_id = w.weblog_id
				AND e.entry_time <= " . time() . "
			WHERE w.weblog_id = u.user_weblog			
			ORDER BY e.entry_time DESC LIMIT 0,10";
	if ( !($result = $db->sql_query($sql)) )
	{
		message_die(GENERAL_ERROR, 'Could not query weblogs information', '', __LINE__, __FILE__, $sql);
	}

	//
	// Build a new array, discarding weblogs with outdated entries or entries that cannot be viewed.
	//
	$weblog_data = array();
	while( $row = $db->sql_fetchrow($result) )
	{
		if ( !search_array( $row['weblog_id'], $weblog_data ) )
		{
			$contributor = FALSE;
			for ( $i = 0; $i < count($contributor_data); $i++)
			{
				if ( $contributor_data[$i]['weblog_id'] == $row['weblog_id'] )
				{
					$contributor = TRUE;
					break;
				}
			}
			$auth_level = get_auth_level( $row, $contributor, $friends_data, $blocked_data );

			if ( $auth_level >= $row['weblog_auth'] && $auth_level >= $row['entry_access'] )
			{
				$weblog_data[] = $row;
			}
		}
	}

	for ($i = 0; $i < count($weblog_data); $i++)
	{
		$weblog_link = $basedir . "weblog.$phpEx?" . POST_WEBLOG_URL . "=" . $weblog_data[$i]['weblog_id'];

		echo ("	  <item>\n");
		echo ("	    <title>" . $weblog_data[$i]['weblog_name'] . "</title>\n");
		echo ("	    <link>" . $weblog_link . "</link>\n");
		echo ("	    <description>" . htmlspecialchars($weblog_data[$i]['weblog_desc']) . "</description>\n");
		echo ("	    <author>" . $weblog_data[$i]['username'] . "</author>\n");
		echo ("	    <pubDate>" . gmdate('D, d M Y H:i:s', $weblog_data[$i]['entry_time']) . " GMT</pubDate>\n");
		echo ("	  </item>\n");
	}
}

echo ("	</channel>\n");
echo ("  </rss>\n");
?>