<?php
/***************************************************************************
 *                               viewforum.php
 *                            -------------------
 *     (C) apwa.ru
 *      
 *       Anv@r.all   2010
 ***************************************************************************/


define('IN_PHPBB', true);
$phpbb_root_path = './';
include($phpbb_root_path . 'extension.inc');
include($phpbb_root_path . 'common.'.$phpEx);

if ( isset($HTTP_GET_VARS[POST_FORUM_URL]) || isset($HTTP_POST_VARS[POST_FORUM_URL]) )
{
	$forum_id = ( isset($HTTP_GET_VARS[POST_FORUM_URL]) ) ? intval($HTTP_GET_VARS[POST_FORUM_URL]) : intval($HTTP_POST_VARS[POST_FORUM_URL]);
}
else if ( isset($HTTP_GET_VARS['forum']))
{
	$forum_id = intval($HTTP_GET_VARS['forum']);
}
else
{
	$forum_id = '';
}

if ( isset($HTTP_GET_VARS['mark']) || isset($HTTP_POST_VARS['mark']) )
{
	$mark_read = (isset($HTTP_POST_VARS['mark'])) ? $HTTP_POST_VARS['mark'] : $HTTP_GET_VARS['mark'];
}
else
{
	$mark_read = '';
}

if ( !empty($forum_id) )
{
	$sql = "SELECT *
		FROM " . FORUMS_TABLE . "
		WHERE forum_id = $forum_id 
		OR attached_forum_id =$forum_id
		ORDER BY attached_forum_id ASC";		
	if ( !($result = $db->sql_query($sql)) )
	{
		message_die(GENERAL_ERROR, 'Could not obtain forums information', '', __LINE__, __FILE__, $sql);
	}
}
else
{
	message_die(GENERAL_MESSAGE, 'Forum_not_exist');
}

if ( !($forum_row = $db->sql_fetchrow($result)) )
{
	message_die(GENERAL_MESSAGE, 'Forum_not_exist');
}

$attachments = '';
if ($db->sql_numrows ($result) > 1)
{
	$attachments = TRUE;
}

$userdata = session_pagestart($user_ip, $forum_id);
init_userprefs($userdata);

if ( isset($HTTP_POST_VARS['start1']) )
{
    $start1 = intval($HTTP_POST_VARS['start1']);
    $start = (($start1 - 1) * $board_config['topics_per_page']);
} 
else 
{
    $start = ( isset($HTTP_GET_VARS['start']) ) ? intval($HTTP_GET_VARS['start']) : 0;
    $start = ($start < 0) ? 0 : $start;
}

$is_auth = array();
$is_auth = auth(AUTH_ALL, $forum_id, $userdata, $forum_row);

if ( !$is_auth['auth_read'] || !$is_auth['auth_view'] )
{
	if ( !$userdata['session_logged_in'] )
	{
		$redirect = POST_FORUM_URL . "=$forum_id" . ( ( isset($start) ) ? "&start=$start" : '' );
		redirect(append_sid("login.$phpEx?redirect=viewforum.$phpEx&$redirect", true));
	}
	$message = ( !$is_auth['auth_view'] ) ? $lang['Forum_not_exist'] : sprintf($lang['Sorry_auth_read'], $is_auth['auth_read_type']);

	message_die(GENERAL_MESSAGE, $message);
}

if ( $mark_read == 'topics' )
{
	if ( $userdata['session_logged_in'] )
	{
		$sql = "SELECT MAX(post_time) AS last_post 
			FROM " . POSTS_TABLE . " 
			WHERE forum_id = $forum_id";
		if ( !($result = $db->sql_query($sql)) )
		{
			message_die(GENERAL_ERROR, 'Could not obtain forums information', '', __LINE__, __FILE__, $sql);
		}

		if ( $row = $db->sql_fetchrow($result) )
		{
			$tracking_forums = ( isset($HTTP_COOKIE_VARS[$board_config['cookie_name'] . '_f']) ) ? unserialize($HTTP_COOKIE_VARS[$board_config['cookie_name'] . '_f']) : array();
			$tracking_topics = ( isset($HTTP_COOKIE_VARS[$board_config['cookie_name'] . '_t']) ) ? unserialize($HTTP_COOKIE_VARS[$board_config['cookie_name'] . '_t']) : array();              			
	                if ( ( count($tracking_forums) + count($tracking_topics) ) >= 150 && empty($tracking_forums[$forum_id]) )
		        {
			        asort($tracking_forums);
			        unset($tracking_forums[key($tracking_forums)]);
		        }

		        if ( $row['last_post'] > $userdata['user_lastvisit'] )
		        {
				$tracking_forums[$forum_id] = time();
				setcookie($board_config['cookie_name'] . '_f', serialize($tracking_forums), 0, $board_config['cookie_path'], $board_config['cookie_domain'], $board_config['cookie_secure']);
		        }
	        }

		$template->assign_vars(array(
			'META' => '<meta http-equiv="refresh" content="3;url=' . append_sid("viewforum.$phpEx?" . POST_FORUM_URL . "=$forum_id") . '">')
		);
	}

	$message = $lang['Topics_marked_read'] . '<br />' . sprintf($lang['Click_return_forum'], '<a href="' . append_sid("viewforum.$phpEx?" . POST_FORUM_URL . "=$forum_id") . '">', '</a> ');
	message_die(GENERAL_MESSAGE, $message);
}

$tracking_topics = ( isset($HTTP_COOKIE_VARS[$board_config['cookie_name'] . '_t']) ) ? unserialize($HTTP_COOKIE_VARS[$board_config['cookie_name'] . '_t']) : '';
$tracking_forums = ( isset($HTTP_COOKIE_VARS[$board_config['cookie_name'] . '_f']) ) ? unserialize($HTTP_COOKIE_VARS[$board_config['cookie_name'] . '_f']) : '';

if ($forum_row[attached_forum_id]>0)
{
	$parent_lookup = $forum_row[attached_forum_id];
}

if ($attachments)
{
	if ( $userdata['session_logged_in'] )
	{
		$sql = "SELECT t.forum_id, t.topic_id, p.post_time
			FROM " . TOPICS_TABLE . " t, " . POSTS_TABLE . " p
			WHERE p.post_id = t.topic_last_post_id
			AND p.post_time > " . $userdata['user_lastvisit'] . "
			AND t.topic_moved_id = 0";
		if ( !($result = $db->sql_query($sql)) )
		{
			message_die(GENERAL_ERROR, 'Could not query new topic information', '', __LINE__, __FILE__, $sql);
		}

		$new_topic_data = array();
		while( $topic_data = $db->sql_fetchrow($result) )
		{
			$new_topic_data[$topic_data['forum_id']][$topic_data['topic_id']] = $topic_data['post_time'];
		}
	}

	$sql2 = "SELECT f.*, p.post_time, p.post_username, u.username, u.user_id, t.topic_id, t.topic_title
		 FROM ((( " . FORUMS_TABLE . " f
		 LEFT JOIN " . POSTS_TABLE . " p ON p.post_id = f.forum_last_post_id )
		 LEFT JOIN " . USERS_TABLE . " u ON u.user_id = p.poster_id )
		 LEFT JOIN " . TOPICS_TABLE . " t ON t.topic_last_post_id = f.forum_last_post_id)
		 WHERE attached_forum_id = " . $forum_id . "
		 GROUP by f.forum_id ORDER BY f.forum_order";

	$result2 = $db->sql_query ($sql2);
	if (!$result2 )
	{
		message_die ('Could not gather attached forum info', __LINE__, __FILE__, $sql2);
	}

	if ($db->sql_numrows ($result2) != 0)
	{
		while( $row = $db->sql_fetchrow($result2) )
		{
			$forum_data[] = $row;
		}
		$is_auth_ary = auth(AUTH_VIEW, AUTH_LIST_ALL, $userdata, $forum_data);
		$x=0;
		foreach ($forum_data as $row2 => $value)
		{
			if ($is_auth_ary[$value['forum_id']]['auth_view'])
			{
				$x++;
				if ($x==1)
				{
					$template->assign_block_vars ('switch_attached_list',array( 
					        'L_ATTACHED_FORUM' => $lang['Attached_forums'],
						'L_ATTACHED_TOPICS' => $lang['Topics'],
						'L_ATTACHED_POSTS' => $lang['Replies'],
						'L_LAST_POST' => $lang['Last_Post'])
					);

				}
				$attach_forum_link = append_sid('viewforum.php?f=' . $value['forum_id']);
				$attach_forum_name = $value['forum_name'];
				$attach_forum_desc = $value['forum_desc'];
				$attach_forum_topics = $value['forum_topics'];
				$attach_forum_posts = $value['forum_posts'];
				$last_post_id = $value['forum_last_post_id'];

   				if ( $value['forum_status'] == FORUM_LOCKED )
				{
					$folder_image = "images/locked.gif"; 
				}
				else
				{
					$unread_topics = false;
					if ( $userdata['session_logged_in'] )
					{
						$unread_topics=check_unread($value['forum_id']);
					}						
					$folder_image = ( $unread_topics ) ? "images/new.gif" : "images/nonew.gif";						
				}

				if ( $value['forum_last_post_id'] )
				{

					if (strlen($value['topic_title'])>=25)
					{
						$value['topic_title'] = substr($value['topic_title'],0,25). "...";
					}						
					$last_post_time = create_date($board_config['default_dateformat'], $value['post_time'], $board_config['board_timezone']);
					$last_post = '[' . $last_post_time . ']';															
					$last_post .= ( $value['user_id'] == ANONYMOUS ) ? ( ($value['post_username'] != '' ) ? $value['post_username'] . ' ' : $lang['Guest'] . ' ' ) : '' . $value['username'] . ' <a href="' . append_sid("viewtopic.$phpEx?"  . POST_POST_URL . '=' . $value['forum_last_post_id']) . '#' . $value['forum_last_post_id'] . '">'.$lang['View_latest_post'] . '</a>';											        						
				}
				else
				{
					$last_post = $lang['No_Posts'];
				}

				 $template->assign_block_vars ('switch_attached_list.switch_attached_present', array(
						'FORUM_FOLDER_IMG' => $folder_image,						
						'FORUM_NAME' => $attach_forum_name,
						'U_VIEWFORUM' => $attach_forum_link,
						'FORUM_DESC' => $attach_forum_desc,
						'TOPICS' => $attach_forum_topics,
						'POSTS' => $attach_forum_posts,
						'LAST_POST_ID' => $last_post)
				);
			}
		}

	}
     $db->sql_freeresult ($result2);
}
if ( $is_auth['auth_mod'] && $board_config['prune_enable'] )
{
	if ( $forum_row['prune_next'] < time() && $forum_row['prune_enable'] )
	{
		include($phpbb_root_path . 'includes/prune.'.$phpEx);
		require($phpbb_root_path . 'includes/functions_admin.'.$phpEx);
		auto_prune($forum_id);
	}
}

$sql = "SELECT f.*
	FROM (( " . FORUMS_TABLE . " f
	LEFT JOIN " . POSTS_TABLE . " p ON p.post_id = f.forum_last_post_id )
	LEFT JOIN " . USERS_TABLE . " u ON u.user_id = p.poster_id )
	ORDER BY f.cat_id, f.forum_order";
if ( !($result = $db->sql_query($sql)) )
{
	message_die(GENERAL_ERROR, 'Could not query forums information', '', __LINE__, __FILE__, $sql);
}

$forum_data = array();
while( $row = $db->sql_fetchrow($result) )
{
	$forum_data[] = $row;
}
$db->sql_freeresult($result);

$jumpbox = '<form name="jumpbox" action="' . append_sid("viewforum.$phpEx?" . POST_FORUM_URL ."=$forum_id") . '" method="get">';
$jumpbox .= '<select name="f">';
for ($i = 0; $i < count($forum_data); $i++)
{
	$jumpbox .= '<option value="' . $forum_data[$i]['forum_id'] . '"';
	$jumpbox .= ($forum_id ==$forum_data[$i]['forum_id']) ? ' selected="selected"' : '';
	$jumpbox .= '>' . $forum_data[$i]['forum_name'] . '</option>';
}
$jumpbox .= '</select>';
$jumpbox .= '<input type="submit" class="liteoption" value="' . $lang['Go'] . '"/>';
$jumpbox .= '<input type="hidden" name="sid" value="' . $userdata['session_id'] . '"/>';
$jumpbox .= '</form>';
	
$sql = "SELECT u.user_id, u.username 
	FROM " . AUTH_ACCESS_TABLE . " aa, " . USER_GROUP_TABLE . " ug, " . GROUPS_TABLE . " g, " . USERS_TABLE . " u
	WHERE aa.forum_id = $forum_id 
	AND aa.auth_mod = " . TRUE . " 
	AND g.group_single_user = 1
	AND ug.group_id = aa.group_id 
	AND g.group_id = aa.group_id 
	AND u.user_id = ug.user_id 
	GROUP BY u.user_id, u.username  
	ORDER BY u.user_id";
if ( !($result = $db->sql_query($sql)) )
{
	message_die(GENERAL_ERROR, 'Could not query forum moderator information', '', __LINE__, __FILE__, $sql);
}

$moderators = array();

while( $row = $db->sql_fetchrow($result) )
{
    $moderators[] = '<a href="' . append_sid("profile.$phpEx?mode=viewprofile&amp;" . POST_USERS_URL . "=" . $row['user_id']) . '">' . $row['username'] . '</a>';
}

$sql = "SELECT g.group_id, g.group_name 
	FROM " . AUTH_ACCESS_TABLE . " aa, " . USER_GROUP_TABLE . " ug, " . GROUPS_TABLE . " g 
	WHERE aa.forum_id = $forum_id
	AND aa.auth_mod = " . TRUE . " 
	AND g.group_single_user = 0
	AND g.group_type <> ". GROUP_HIDDEN ."
	AND ug.group_id = aa.group_id 
	AND g.group_id = aa.group_id 
	GROUP BY g.group_id, g.group_name  
	ORDER BY g.group_id";
if ( !($result = $db->sql_query($sql)) )
{
	message_die(GENERAL_ERROR, 'Could not query forum moderator information', '', __LINE__, __FILE__, $sql);
}

while( $row = $db->sql_fetchrow($result) )
{
    $moderators[] = '<a href="' . append_sid("groupcp.$phpEx?" . POST_GROUPS_URL . "=" . $row['group_id']) . '">' . $row['group_name'] . '</a>';
}

$l_moderators = ( count($moderators) == 1 ) ? $lang['Moderator'] : $lang['Moderators'];
$forum_moderators = ( count($moderators) ) ? implode(', ', $moderators) : $lang['None'];
unset($moderators);

$previous_days = array(0, 1, 7, 14, 30, 90, 180, 364);
$previous_days_text = array($lang['All_Topics'], $lang['1_Day'], $lang['7_Days'], $lang['2_Weeks'], $lang['1_Month'], $lang['3_Months'], $lang['6_Months'], $lang['1_Year']);

if ( !empty($HTTP_POST_VARS['topicdays']) || !empty($HTTP_GET_VARS['topicdays']) )
{
	$topic_days = ( !empty($HTTP_POST_VARS['topicdays']) ) ? intval($HTTP_POST_VARS['topicdays']) : intval($HTTP_GET_VARS['topicdays']);
	$min_topic_time = time() - ($topic_days * 86400);

	$sql = "SELECT COUNT(t.topic_id) AS forum_topics 
		FROM " . TOPICS_TABLE . " t, " . POSTS_TABLE . " p 
		WHERE t.forum_id = $forum_id 
		AND p.post_id = t.topic_last_post_id
		AND p.post_time >= $min_topic_time"; 
	if ( !($result = $db->sql_query($sql)) )
	{
		message_die(GENERAL_ERROR, 'Could not obtain limited topics count information', '', __LINE__, __FILE__, $sql);
	}
	$row = $db->sql_fetchrow($result);

	$topics_count = ( $row['forum_topics'] ) ? $row['forum_topics'] : 1;
	$limit_topics_time = "AND p.post_time >= $min_topic_time";

	if ( !empty($HTTP_POST_VARS['topicdays']) )
	{
		$start = 0;
	}
}
else
{        
	$topics_count = ( $forum_row['forum_topics'] ) ? $forum_row['forum_topics'] : 1;

	$limit_topics_time = '';
	$topic_days = 0;
}

$select_topic_days = '<select name="topicdays">';
for($i = 0; $i < count($previous_days); $i++)
{
	$selected = ($topic_days == $previous_days[$i]) ? ' selected="selected"' : '';
	$select_topic_days .= '<option value="' . $previous_days[$i] . '"' . $selected . '>' . $previous_days_text[$i] . '</option>';
}
$select_topic_days .= '</select>';

$sql = "SELECT t.*, u.username, u.user_id, u2.username as user2, u2.user_id as id2, p.post_time, p.post_username
	FROM " . TOPICS_TABLE . " t, " . USERS_TABLE . " u, " . POSTS_TABLE . " p, " . USERS_TABLE . " u2
	WHERE t.forum_id = $forum_id 
	AND t.topic_poster = u.user_id
	AND p.post_id = t.topic_last_post_id
	AND p.poster_id = u2.user_id
	AND t.topic_type = " . POST_ANNOUNCE . " 
	ORDER BY t.topic_last_post_id DESC ";
if ( !($result = $db->sql_query($sql)) )
{
   message_die(GENERAL_ERROR, 'Could not obtain topic information', '', __LINE__, __FILE__, $sql);
}

$topic_rowset = array();
$total_announcements = 0;
while( $row = $db->sql_fetchrow($result) )
{
	$topic_rowset[] = $row;
	$total_announcements++;
}

$db->sql_freeresult($result);

$sql = "SELECT t.*, u.username, u.user_id, u2.username as user2, u2.user_id as id2, p.post_username, p2.post_username AS post_username2, p2.post_time 
	FROM " . TOPICS_TABLE . " t, " . USERS_TABLE . " u, " . POSTS_TABLE . " p, " . POSTS_TABLE . " p2, " . USERS_TABLE . " u2
	WHERE t.forum_id = $forum_id
	AND t.topic_poster = u.user_id
	AND p.post_id = t.topic_first_post_id
	AND p2.post_id = t.topic_last_post_id
	AND u2.user_id = p2.poster_id 
	AND t.topic_type <> " . POST_ANNOUNCE . " 
	$limit_topics_time
	ORDER BY t.topic_type DESC, t.topic_last_post_id DESC 
	LIMIT $start, ".$board_config['topics_per_page'];
if ( !($result = $db->sql_query($sql)) )
{
   message_die(GENERAL_ERROR, 'Could not obtain topic information', '', __LINE__, __FILE__, $sql);
}

$total_topics = 0;
while( $row = $db->sql_fetchrow($result) )
{
	$topic_rowset[] = $row;
	$total_topics++;
}

$db->sql_freeresult($result);

$total_topics += $total_announcements;

$orig_word = array();
$replacement_word = array();
obtain_word_list($orig_word, $replacement_word);

$template->assign_vars(array(
	'U_POST_NEW_TOPIC' => append_sid("posting.$phpEx?mode=newtopic&amp;" . POST_FORUM_URL . "=$forum_id"))
);

if ( $is_auth['auth_mod'] )
{
	$moder = sprintf($lang['Rules_moderate'], "<a href=\"modcp.$phpEx?" . POST_FORUM_URL . "=$forum_id&amp;start=" . $start . "&amp;sid=" . $userdata['session_id'] . '" class="buttom">', '</a><br/>');
}

define('SHOW_ONLINE', true);
$page_title = $forum_row['forum_name'];
include($phpbb_root_path . 'includes/page_header.'.$phpEx);

$template->set_filenames(array(
	'body' => 'viewforum_body.tpl')
);

$template->assign_vars(array(
	'FORUM_ID' => $forum_id,
	'L_TOPICS' => $lang['Topics'],
	'L_POSTS' => $lang['Posts'],
	'L_AUTHOR' => $lang['Author'],
	'L_VIEWS' => $lang['Views'],
	'L_LAST_POST' => $lang['Last_Post'],
	'L_POST_NEW_TOPIC' => ( $forum_row['forum_status'] == FORUM_LOCKED ) ? $lang['Forum_locked'] : $lang['Post_new_topic'],
	'ANNOUNCE' => $lang['Post_Announcement'],
	'STICKY' => $lang['Post_Sticky'],
	'NORMAL' => $lang['Post_Normal'],
	'RSS' => '<a href="rss.'.$phpEx.'?f=' . $forum_id . '">Форум в RSS</a>',
	'FORUM_NAME' => $forum_row['forum_name'],
	'JUMPBOX' => $jumpbox,
	'MODERATORS' => $forum_moderators,
	'MODER' => $moder,
	'U_VIEW_FORUM' => append_sid("viewforum.$phpEx?" . POST_FORUM_URL ."=$forum_id"))
);

if( $total_topics )
{
	for($i = 0; $i < $total_topics; $i++)
	{
		$topic_id = $topic_rowset[$i]['topic_id'];
		$topic_title = ( count($orig_word) ) ? str_replace($orig_word, $replacement_word, $topic_rowset[$i]['topic_title']) : $topic_rowset[$i]['topic_title'];
		$replies = $topic_rowset[$i]['topic_replies'];
		$topic_type = $topic_rowset[$i]['topic_type'];
		
		if( $topic_type == POST_ANNOUNCE )
		{
			$topic_type = $lang['Topic_Announcement'] . '';			
		}
		else if( $topic_type == POST_STICKY )
		{
			$topic_type = $lang['Topic_Sticky'] . '';			
		}
		else
		{
			$topic_type = '';	
		}

		if( $topic_rowset[$i]['topic_vote'] )
		{
			$topic_type .= $lang['Topic_Poll'];
		}
		
		if( $topic_rowset[$i]['topic_status'] == TOPIC_MOVED )
		{
			$topic_type = $lang['Topic_Moved'];
			$topic_id = $topic_rowset[$i]['topic_moved_id'];
		}
		else
		{
			if( $userdata['session_logged_in'] )
			{
				if( $topic_rowset[$i]['post_time'] > $userdata['user_lastvisit'] ) 
				{
					if( !empty($tracking_topics) || !empty($tracking_forums) || isset($HTTP_COOKIE_VARS[$board_config['cookie_name'] . '_f_all']) )
					{
						$unread_topics = true;

						if( !empty($tracking_topics[$topic_id]) )
						{
							if( $tracking_topics[$topic_id] >= $topic_rowset[$i]['post_time'] )
							{
								$unread_topics = false;
							}
						}

						if( !empty($tracking_forums[$forum_id]) )
						{
							if( $tracking_forums[$forum_id] >= $topic_rowset[$i]['post_time'] )
							{
								$unread_topics = false;
							}
						}

						if( isset($HTTP_COOKIE_VARS[$board_config['cookie_name'] . '_f_all']) )
						{
							if( $HTTP_COOKIE_VARS[$board_config['cookie_name'] . '_f_all'] >= $topic_rowset[$i]['post_time'] )
							{
								$unread_topics = false;
							}
						}

						if( $unread_topics )
						{
							$folder_alt = $lang['New_posts'];
						}
						else
						{
							$folder_alt = ( $topic_rowset[$i]['topic_status'] == TOPIC_LOCKED && !$topic_rowset[$i]['topic_type'] ) ? $lang['Topic_locked1'] : '';
						}
					}
					else
					{
						$folder_alt = ( $topic_rowset[$i]['topic_status'] == TOPIC_LOCKED && !$topic_rowset[$i]['topic_type'] ) ? '<b>' . $lang['Topic_locked1'] . '</b>' : $lang['New_posts'];
					}
				}
				else 
				{
				        $folder_alt = ( $topic_rowset[$i]['topic_status'] == TOPIC_LOCKED && !$topic_rowset[$i]['topic_type'] ) ? $lang['Topic_locked1'] : '';
				}
			}
			else
			{
				$folder_alt = ( $topic_rowset[$i]['topic_status'] == TOPIC_LOCKED && !$topic_rowset[$i]['topic_type'] ) ? $lang['Topic_locked1'] : '';
			}
		}
		if( ( $replies + 1 ) > $board_config['posts_per_page'] )
		{
			$total_pages = ceil( ( $replies + 1 ) / $board_config['posts_per_page'] );
			$goto_page = '[';

			$times = 1;
			for($j = 0; $j < $replies + 1; $j += $board_config['posts_per_page'])
			{
				$goto_page .= '<a href="' . append_sid("viewtopic.$phpEx?" . POST_TOPIC_URL . "=" . $topic_id . "&amp;start=$j") . '">' . $times . '</a>';
				if( $times == 1 && $total_pages > 4 )
				{
					$goto_page .= '...';
					$times = $total_pages - 3;
					$j += ( $total_pages - 4 ) * $board_config['posts_per_page'];
				}
				else if ( $times < $total_pages )
				{
					$goto_page .= ', ';
				}
				$times++;
			}
			$goto_page .= ']';
		}
		else
		{
			$goto_page = '';
		}
		
		$topic_author = ( $topic_rowset[$i]['user_id'] != ANONYMOUS ) ? '<a href="' . append_sid("profile.$phpEx?mode=viewprofile&amp;" . POST_USERS_URL . '=' . $topic_rowset[$i]['user_id']) . '">' : '';
		$topic_author .= ( $topic_rowset[$i]['user_id'] != ANONYMOUS ) ? $topic_rowset[$i]['username'] : ( ( $topic_rowset[$i]['post_username'] != '' ) ? $topic_rowset[$i]['post_username'] : $lang['Guest'] );
		$topic_author .= ( $topic_rowset[$i]['user_id'] != ANONYMOUS ) ? '</a>' : '';
               
		$view_topic_url = append_sid("viewtopic.$phpEx?" . POST_TOPIC_URL . "=$topic_id");
		$first_post_time = create_date($board_config['default_dateformat'], $topic_rowset[$i]['topic_time'], $board_config['board_timezone']);

		$last_post_time = create_date($board_config['default_dateformat'], $topic_rowset[$i]['post_time'], $board_config['board_timezone']);
		$last_post_author = ( $topic_rowset[$i]['id2'] == ANONYMOUS ) ? ( ($topic_rowset[$i]['post_username2'] != '' ) ? $topic_rowset[$i]['post_username2'] . ' ' : $lang['Guest'] . ' ' ) :  $topic_rowset[$i]['user2']  ;
		$last_post_url = '<a href="' . append_sid("viewtopic.$phpEx?"  . POST_POST_URL . '=' . $topic_rowset[$i]['topic_last_post_id']) . '#' . $topic_rowset[$i]['topic_last_post_id'] . '" class="cattitle">' . $lang['View_latest_post'] . '</a>';
                
                $views = $topic_rowset[$i]['topic_views'];                
                if( $topic_rowset[$i]['topic_type'] == POST_ANNOUNCE || $topic_rowset[$i]['topic_type'] == POST_STICKY )
                {
                         $row_class = 'row1';
                }
                else
                {         
                         $row_class = ( !($i % 2) ) ? 'row_easy' : 'row_hard';
		}
		
		$template->assign_block_vars('topicrow', array(		        
			'REPLIES' => $replies,
			'ROW_CLASS' => $row_class,
			'GOTO_PAGE' => $goto_page,
			'TOPIC_ATTACHMENT_IMG' => topic_attachment_image($topic_rowset[$i]['topic_attachment']),
		        'TOPIC_AUTHOR' => $topic_author,	
			'TOPIC_TITLE' => $topic_title,			
			'TOPIC_TYPE' => $topic_type,
			'REPLIES' => $replies,
			'VIEWS' => $views,
			'FIRST_POST_TIME' => $first_post_time,
		        'LAST_POST_TIME' => $last_post_time, 	
			'LAST_POST_AUTHOR' => $last_post_author, 
			'LAST_POST_IMG' => $last_post_url, 
			'L_TOPIC_FOLDER_ALT' => $folder_alt, 
			'U_VIEW_TOPIC' => $view_topic_url)
		);
	}
	      
	$topics_count -= $total_announcements;

	$template->assign_vars(array(
		'PAGINATION' => generate_pagination("viewforum.$phpEx?" . POST_FORUM_URL . "=$forum_id&amp;topicdays=$topic_days", $topics_count, $board_config['topics_per_page'], $start),		
		'PAGE_NUMBER' => sprintf($lang['Page_of'], ( floor( $start / $board_config['topics_per_page'] ) + 1 ), ceil( $topics_count / $board_config['topics_per_page'] )))	        
	);
}
else
{	
	$no_topics_msg = ( $forum_row['forum_status'] == FORUM_LOCKED ) ? $lang['Forum_locked'] : $lang['No_topics_post_one'];
	$template->assign_vars(array(		
		'L_NO_TOPICS' => $no_topics_msg)
	);

	$template->assign_block_vars('switch_no_topics', array() );

}

$template->pparse('body');

include($phpbb_root_path . 'includes/page_tail.'.$phpEx);

?>