<?php
/***************************************************************************
 *                                entries.php
 *                            -------------------
 *    Anv@r.all, 2010
 *    (C) apwa.ru
 *
 ***************************************************************************/
$sape_block = true;

// standard hack prevent
define('IN_PHPBB', true);
$phpbb_root_path = './';
include($phpbb_root_path . 'extension.inc');
include($phpbb_root_path . 'common.'.$phpEx);
include($phpbb_root_path . 'includes/bbcode.'.$phpEx);
include($phpbb_root_path . 'includes/weblogs_common.'.$phpEx);
include($phpbb_root_path . 'includes/functions_weblog.'.$phpEx);

if ( isset($HTTP_GET_VARS['start']) || isset($HTTP_POST_VARS['start']) )
{
	$start = (isset($HTTP_POST_VARS['start'])) ? intval($HTTP_POST_VARS['start']) : intval($HTTP_GET_VARS['start']);
	$start = abs($start);
}
else
{
	$start = 0;
}

if ( isset($HTTP_GET_VARS['sort']) || isset($HTTP_POST_VARS['sort']) )
{
	$sort = (isset($HTTP_POST_VARS['sort'])) ? intval($HTTP_POST_VARS['sort']) : intval($HTTP_GET_VARS['sort']);
}
else
{
	$sort = $weblog_config['main_sorttype'];
}

if ( isset($HTTP_GET_VARS['order']) || isset($HTTP_POST_VARS['order']) )
{
	$order = (isset($HTTP_POST_VARS['order'])) ? $HTTP_POST_VARS['order'] : $HTTP_GET_VARS['order'];
	$order = ( $order == 'asc' || $order == 'desc' ) ? $order : 'desc';
}
else
{
	$order = $weblog_config['main_sortorder'];
}
if ( isset($HTTP_GET_VARS['count']) || isset($HTTP_POST_VARS['count']) )
{
	$w_count = (isset($HTTP_POST_VARS['count'])) ? intval($HTTP_POST_VARS['count']) : intval($HTTP_GET_VARS['count']);
}
else
{
	$w_count = $weblog_config['latest_entry_max']/*$weblog_config['main_blogsperpage']*/;
}

if ( $w_count < 1 )
{
	$w_count = 1;
}

$pagination = '&';
$pagination_replies = '&';
$total_entry_items = 1;
$total_reply_items = 1;

$userdata = session_pagestart($user_ip, PAGE_INDEX);
init_userprefs($userdata);

$sql = "SELECT *
	FROM " . WEBLOG_MOODS_TABLE . "
	ORDER BY mood_text";
if( !$result = $db->sql_query($sql) )
{
	message_die(GENERAL_ERROR, "Couldn't obtain mood data from database", "", __LINE__, __FILE__, $sql);
}
$mood_data = $db->sql_fetchrowset($result);

$sql = "SELECT *
	FROM " . WEBLOG_ACTIONS_TABLE . "
	ORDER BY action_text";
if( !$result = $db->sql_query($sql) )
{
	message_die(GENERAL_ERROR, "Couldn't obtain action data from database", "", __LINE__, __FILE__, $sql);
}
$action_data = $db->sql_fetchrowset($result);

$sql = "SELECT * FROM " . WEBLOG_CONTRIBUTORS_TABLE . " 
        WHERE user_id = " . $userdata['user_id'];
if ( !($result = $db->sql_query($sql)) )
{
	message_die(GENERAL_ERROR, 'Error querying to find user weblog information', '', __LINE__, __FILE__, $sql);
}

$contributor = FALSE;
if ( $row = $db->sql_fetchrow($result) || $userdata['user_level'] == ADMIN )
{
	$contributor = TRUE;
}

$auth_level = get_auth_level ( $weblog_data, $friends_data, $blocked_data, $weblog_data['user_id'], $contributor );

if ( $weblog_data['weblog_auth'] > $auth_level )
{
	message_die(GENERAL_ERROR, $lang['Weblog_noaccess']);
}

switch ( $sort )
{
	case SORT_NEWEST_ENTRIES:    $sort = 'e.entry_time'; break;
	case SORT_WEBLOG_NAME:       $sort = 'e.entry_subject'; break;
	case SORT_NUM_ENTRIES:       $sort = 'e.entry_replies'; break;
	case SORT_WEBLOG_VIEWS:	     $sort = 'e.entry_views'; break;
	case SORT_WEBLOG_OWNER_NAME: $sort = 'u.username'; break;
	default:                     $sort = 'e.entry_time'; break;
}

if ( $weblog_config['show_latest_entries'] )
{
	$sql = "SELECT w.weblog_id, w.weblog_name, e.entry_id, e.entry_access, e.entry_subject, e.entry_time, e.entry_views, e.entry_poster_id, e.entry_text, e.bbcode_uid, e.entry_mood, e.entry_currently, e.entry_replies, u.user_id, u.username, u.user_avatar, u.user_avatar_type, u.user_allowavatar
		FROM " . WEBLOGS_TABLE . " w, " . WEBLOG_ENTRIES_TABLE . " e, " . USERS_TABLE . " u
		WHERE w.weblog_id = e.weblog_id
		AND e.entry_access <= $auth_level		
		AND e.entry_poster_id = u.user_id
		ORDER BY $sort $order 
		LIMIT $start, " . $w_count;
	if (!$result = $db->sql_query($sql))
	{
		message_die(GENERAL_ERROR, 'Could not query blog information', '', __LINE__, __FILE__, $sql);
	}

	$blog_row = array();
	while ($row = $db->sql_fetchrow($result))
	{
		$blog_row[] = $row;
	}
	$db->sql_freeresult($result);
}

$num_weblogs = array(1, 2, 3, 4, 5, 10, 20, 30, 40, 50, 100);

$select_num_weblogs = '<select name="count">';
for($i = 0; $i < count($num_weblogs); $i++)
{
	$selected = ( $w_count == $num_weblogs[$i] ) ? ' selected="selected"' : '';
	$select_num_weblogs .= '<option value="' . $num_weblogs[$i] . '"' . $selected . '>' . $num_weblogs[$i] . '</option>';
}
$select_num_weblogs .= '</select>';

$sort_method = array(SORT_NEWEST_ENTRIES, SORT_WEBLOG_NAME, SORT_NUM_ENTRIES, SORT_WEBLOG_VIEWS, SORT_WEBLOG_OWNER_NAME);
$sort_method_text = array($lang['Sort_newest_entries'], $lang['Sort_weblog_name'], $lang['Sort_num_entries'], $lang['Sort_weblog_views'], $lang['Sort_Username']);

$select_sort = '<select name="sort">';
for($i = 0; $i < count($sort_method); $i++)
{
	$selected = ( $sort == $sort_method[$i] ) ? ' selected="selected"' : '';
	$select_sort .= '<option value="' . $sort_method[$i] . '"' . $selected . '>' . $sort_method_text[$i] . '</option>';
}
$select_sort .= '</select>';

$sort_order = array('desc', 'asc');
$sort_order_text = array($lang['Sort_Descending'], $lang['Sort_Ascending']);

$select_asc_desc = '<select name="order">';
for($i = 0; $i < count($sort_order); $i++)
{
	$selected = ( strtolower($order) == $sort_order[$i] ) ? ' selected="selected"' : '';
	$select_asc_desc .= '<option value="' . $sort_order[$i] . '"' . $selected . '>' . $sort_order_text[$i] . '</option>';
}
$select_asc_desc .= '</select>';

$page_title = 'Последние записи и комментарии';
include($phpbb_root_path . 'includes/page_header.'.$phpEx);


$template->set_filenames(array(
        'body' => 'blog/index_entries_body.tpl')
);

switch ( $sort )
{
	case 'e.entry_time':	$sort = SORT_NEWEST_ENTRIES; break;
	case 'e.entry_subject': $sort = SORT_WEBLOG_NAME; break;
	case 'e.entry_replies':	$sort = SORT_NUM_ENTRIES; break;
	case 'e.entry_views':	$sort = SORT_WEBLOG_VIEWS; break;
	case 'u.username':	$sort = SORT_WEBLOG_OWNER_NAME; break;
	default: 		$sort = SORT_NEWEST_ENTRIES; break;
}

$template->assign_vars(array(
	'L_SORT' => $lang['Sort'],
	'L_GO' => $lang['Go'],	
	'L_NO_ACCESS' => $lang['Weblog_noaccess'],	
	'L_WEBLOGS_PER_PAGE' => $lang['Weblogs_perpage'],
	'L_SORT' => $lang['Sort'],
	'L_GO' => $lang['Go'],	
	'L_ENTRY' => $lang['Entry'],
	'L_REPLY' => $lang['Reply'],
	'L_WEBLOG' => $lang['Weblog'],
	'L_WEBLOGS' => $lang['Weblog_Index'],
	'L_OWNER' => $lang['Weblog_Owner'],
	'L_AUTHOR' => $lang['Author'],
	'L_VIEWS'=> $lang['Views'],
	'L_REPLIES' => $lang['Replies'],
	'L_LAST_ENTRY' => $lang['Last_entry'],
	'L_LATEST_MOOD' => $lang['Latest_mood'],
	'L_WEBLOG_DESCRIPTION' => $lang['Weblog_description'],
	'L_LAST_SEEN' => $lang['Last_seen'], 
	'L_MARK_ALL_ENTRIES' => $lang['Mark_all_entries'],
	'L_MARK_ALL_REPLIES' => $lang['Mark_all_replies'],   			
        'U_WEBLOG_RSS' => append_sid ("weblog_rss.$phpEx"),				
	'L_RSS' => $lang['RSS'],
	'S_NUM_WEBLOGS' => $select_num_weblogs,
	'S_SORT_METHOD' => $select_sort,
	'S_SORT_ORDER' => $select_asc_desc,
	'S_SORT_ACTION' => append_sid("entries.$phpEx"),	
	'S_NEWS_COLSPAN' => $colspan,
	'S_NO_BLOCKS' => $weblog_config['no_blocks_text'])
);

if ( $userdata['session_logged_in'] )
{
	$sql = "SELECT w.*, u.*
		FROM " . WEBLOGS_TABLE . " w, " . USERS_TABLE . " u
		WHERE w.weblog_id = u.user_weblog
			AND u.user_id = " . $userdata['user_id'];
	if ( !($result = $db->sql_query($sql)) )
	{
		message_die(GENERAL_ERROR, 'Could not query user weblog information', '', __LINE__, __FILE__, $sql);
	}

	$user_weblog_data = array();
	if ( $row = $db->sql_fetchrow($result) )
	{
	     $user_weblog_data = $row; 	             					
	     $weblog_id = $user_weblog_data['weblog_id'];   
	      
             avatar_img($gb_rows[$i]['user_avatar_type'], $gb_rows[$i]['user_allowavatar'], $gb_rows[$i]['user_avatar'], $avatar_img, $avatar_mini);
       		      
	     $sql = "SELECT * FROM " . WEBLOG_ENTRIES_TABLE . "
		     WHERE weblog_id = " . $userdata['user_weblog'] . " 
		     ORDER BY entry_time DESC LIMIT 1";
	     if ( !($result = $db->sql_query($sql)) )
	     {
		    message_die(GENERAL_ERROR, 'Could not query user weblog information', '', __LINE__, __FILE__, $sql);
	     }

	     if ( $row = $db->sql_fetchrow($result) )
	     {
		  $last_entry_data = $row;

		  $mood = array();
		  $mood = find_mood($last_entry_data['entry_mood']);

		  if ( $mood >= 0 )
		  {
			$mood = sprintf($lang['Mood:'], '<img src="images/weblog/' . $mood['mood_url'] . '" alt="' . $mood_data['mood_text'] . '"/>', $mood['mood_text']);
		  }
		  else
		  {
			$mood = $lang['None'];
		  }

		  // Currently Icons
		  $currently = array();
		  $currently = find_action($last_entry_data['entry_currently']);

		  if ( $currently > 0 )
		  {
			$action = sprintf($lang['Currently:'], '<img src="images/weblog/' . $currently['action_url'] . '" alt="' . $currently['action_text'] . ' ' . strip_tags(htmlspecialchars($last_entry_data['currently_text'])) . '" />',  $currently['action_text'] . ' ' . strip_tags(htmlspecialchars($last_entry_data['currently_text'])));
		  }
		  else if ( $last_entry_data['currently_text'] && $currently == -2 )
		  {
			$action = sprintf($lang['Currently:'], '', strip_tags(htmlspecialchars($last_entry_data['currently_text'])));
		  }
		  else
		  {
			$action = $lang['None'];
		  }

		   $entry_id = $last_entry_data['entry_id'];
		   $last_entry_time = create_date($board_config['default_dateformat'], $last_entry_data['entry_time'], $board_config['board_timezone']);
		   $last_entry_time .= '&nbsp;<a href="' . append_sid("weblog_entry.$phpEx?" . POST_ENTRY_URL . "=$entry_id") . '">»</a>';
		   $last_entry = $last_entry_time;
	     }
	     else
	     {
		   $last_entry = $lang['No_entries'];
		   $action = $lang['None'];
		   $mood = $lang['None'];
	     }
	
	     $template->assign_block_vars('user_blog', array(
		      'WEBLOG_NAME' => $lang['Your_weblog'],
		      'AVATAR_IMG' => $avatar_img,		
		      'WEBLOG_OWNER' => $user_weblog_data['username'],
		      'WEBLOG_DESCRIPTION' => $user_weblog_data['weblog_desc'],
		      'U_VIEW_WEBLOG' => append_sid ("weblog.$phpEx?" . POST_WEBLOG_URL . "=" . $user_weblog_data['weblog_id']),
		      'NO_BLOG_CREATE' => sprintf($lang['No_weblog_create'], '<a href="' . append_sid("weblog_config.$phpEx") . '" class="mainmenu">', '</a>'),
	              'LAST_ENTRY' => $last_entry,
	              'LATEST_MOOD' => $mood,
		      'LAST_SEEN' => $action )
	     );
	}
	else
	{
		if ( !$userdata['session_logged_in'] )
		{
			$lang_create = $lang['No_weblog_guests'];
		}
		else if ( !$userdata['user_allowweblog'] )
		{
			$lang_create = $lang['Weblog_banned'];
		}
		else
		{
			$lang_create = $lang['No_weblog_create'];
		}

		$template->assign_block_vars('user_no_blog', array(
			'L_NO_WEBLOG_CREATE' => sprintf($lang['No_weblog_create'], '<a href="' . append_sid("weblog_config.$phpEx") . '" class="genmed">', '</a>'))
		);						
	} 	        
	
}
else
{
		if ( !$userdata['session_logged_in'] )
		{
			$lang_create = $lang['No_weblog_guests'];
		}
		else if ( !$userdata['user_allowweblog'] )
		{
			$lang_create = $lang['Weblog_banned'];
		}
		else
		{
			$lang_create = $lang['No_weblog_create'];
		}

		$template->assign_block_vars('user_no_blog', array(
			'L_NO_WEBLOG_CREATE' => sprintf($lang_create, '<a href="' . append_sid("weblog_config.$phpEx") . '" class="genmed">', '</a>'))
		);	
}

$weblog_data = fetch_visible_weblogs('e.entry_replies', 'DESC');

if ( $userdata['session_logged_in'] )
{
	$sql = "SELECT weblog_id, entry_id, entry_time 
		FROM " . WEBLOG_ENTRIES_TABLE . "
		WHERE entry_time > " . $userdata['user_lastvisit']; 
	if ( !($result = $db->sql_query($sql)) )
	{
		message_die(GENERAL_ERROR, 'Could not query new entry information', '', __LINE__, __FILE__, $sql);
	}
	
	while( $entry_data = $db->sql_fetchrow($result) )
	{
		$new_entry_data[$entry_data['weblog_id']][$entry_data['entry_id']] = $entry_data['entry_time'];
	}
	$db->sql_freeresult($result);
}

for ($i = 0; $i < count($weblog_data) && $i < $weblog_config['main_blogsperpage']; $i++)
{	
	$last_entry = '';
	$mood = '';
	$action = '';
	$weblog_id = $weblog_data[$i]['weblog_id'];
	
        avatar_img($weblog_data[$i]['user_avatar_type'], $weblog_data[$i]['user_allowavatar'], $weblog_data[$i]['user_avatar'], $avatar_img, $avatar_mini);
        
	if ( $weblog_data[$i]['entry_text'] )
	{
		$last_entry_data = $weblog_data[$i];

		$mood = array();
		$mood = find_mood($last_entry_data['entry_mood']);

		if ( $mood >= 0 )
		{ 
			$mood = sprintf($lang['Mood:'], '<img src="images/weblog/' . $mood['mood_url'] . '" alt="' . $mood_data['mood_text'] . '" style="vertical-align: middle" border="0" />', $mood['mood_text']);
		}
		else
		{
			$mood = $lang['None'];
		}

		// Currently Icons
		$currently = array();
		$currently = find_action($last_entry_data['entry_currently']);

		if ( $currently > 0 )
		{
			$action = sprintf($lang['Currently:'], '<img src="images/weblog/' . $currently['action_url'] . '" alt="' . $currently['action_text'] . ' ' . strip_tags(htmlspecialchars($last_entry_data['currently_text'])) . '" style="vertical-align: middle" border="0" />',  $currently['action_text'] . ' ' . strip_tags(htmlspecialchars($last_entry_data['currently_text'])));
		}
		else if ( $last_entry_data['currently_text'] && $currently == -2 )
		{
			$action = sprintf($lang['Currently:'], '', strip_tags(htmlspecialchars($last_entry_data['currently_text'])));
		}
		else
		{
			$action = $lang['None'];
		}

		$unread_entries = false;
		if ( $userdata['session_logged_in'] )
		{
			if ( !empty($new_entry_data[$weblog_id]) )
			{
				$weblog_last_post_time = 0;

				while( list($check_entry_id, $check_post_time) = @each($new_entry_data[$weblog_id]) )
				{
					if ( empty($tracking_entries[$check_entry_id]) )
					{
						$unread_entries = true;
						$weblog_last_post_time = max($check_post_time, $weblog_last_post_time);
					}
					else
					{
						if ( $tracking_entries[$check_entry_id] < $check_post_time )
						{
							$unread_entries = true;
							$weblog_last_post_time = max($check_post_time, $weblog_last_post_time);
						}
					}
				}

				if ( !empty($tracking_weblogs[$weblog_id]) )
				{
					if ( $tracking_weblogs[$weblog_id] > $weblog_last_post_time )
					{
						$unread_entries = false;
					}
				}

				if ( isset($HTTP_COOKIE_VARS[$board_config['cookie_name'] . '_w_all']) )
				{
					if ( $HTTP_COOKIE_VARS[$board_config['cookie_name'] . '_w_all'] > $weblog_last_post_time )
					{
						$unread_entries = false;
					}
				}
			}
		}

		$entry_id = $last_entry_data['entry_id'];

		$newest_post_img = '';
		if ( $unread_entries )
		{
			$newest_post_img = '<a href="' . append_sid("weblog_entry.$phpEx?" . POST_ENTRY_URL . "=$entry_id") . '">»</a> ';
		}
		else
		{
			$newest_post_img = '<a href="' . append_sid("weblog_entry.$phpEx?" . POST_ENTRY_URL . "=$entry_id") . '">»</a> ';
		}
		

		$last_entry_time = create_date($board_config['default_dateformat'], $last_entry_data['entry_time'], $board_config['board_timezone']);

		$last_entry_time .= '&nbsp;' . $newest_post_img;

		$last_entry = $last_entry_time;
	}
	else
	{
		$mood = $lang['None'];
		$action = $lang['None'];
		$last_entry = $lang['No_entries'];
	}
	
	$row_class = ( !($i % 2) ) ? 'row_hard' : 'row_easy';

	$template->assign_block_vars('blogrow', array(
		'ID' => 'weblog' . $i,
		'ROW_CLASS' => $row_class,					
		'RECENT_POST_CLASS' => $row_class,
		'WEBLOG_NAME' => strip_tags($weblog_data[$i]['weblog_name']),
		'AVATAR_IMG' => $avatar_img,
		'WEBLOG_OWNER' => $weblog_data[$i]['username'],
		'WEBLOG_DESCRIPTION' => $weblog_data[$i]['weblog_desc'],
		'USERNAME' => $weblog_data[$i]['username'],
		'U_VIEW_WEBLOG' => append_sid ("weblog.$phpEx?" . POST_WEBLOG_URL . "=" . $weblog_data[$i]['weblog_id']),		
		'LAST_ENTRY' => $last_entry,
		'LATEST_MOOD' => $mood,
		'LAST_SEEN' => $action)
	);	
}

if ( $weblog_config['show_latest_entries'] )
{	
	$template->assign_block_vars('switch_show', array());
	for ($i = 0; $i < count($blog_row) && $i < $w_count + $start; $i++)
	{		
		$entry_id = $blog_row[$i]['entry_id'];
		
                avatar_img($blog_row[$i]['user_avatar_type'], $blog_row[$i]['user_allowavatar'], $blog_row[$i]['user_avatar'], $avatar_img, $avatar_mini);
        
		if ( $blog_row[$i]['entry_text'] )
		{
			$last_entry_data = $blog_row[$i];                      
			// Mood
			$mood = array();
			$mood = find_mood($last_entry_data['entry_mood']);

			if ( $mood >= 0 )
			{
				$mood = sprintf($lang['Mood:'], '<img src="images/weblog/' . $mood['mood_url'] . '" alt=""/>', $mood['mood_text']);
			}
			else
			{
				$mood = '';
			}

			// Currently Icons
			$currently = array();
			$currently = find_action($last_entry_data['entry_currently']);

			if ( $currently > 0 )
			{
				$action = sprintf($lang['Currently:'], '<img src="images/weblog/' . $currently['action_url'] . '" alt=""/>',  $currently['action_text']);
			}
			else
			{
				$action = '';
			}
		}
		$entry_text = $blog_row[$i]['entry_text'];
		$entry_text = preg_replace('#(<)([\/]?.*?)(>)#is', "&lt;\\2&gt;", $entry_text);
		if( strlen($entry_text) > 600 )
	        {
	 	         $entry_text = substr($entry_text, 0, 600-strlen(strrchr(substr($entry_text, 0, 600), ' '))) . '...';
	        }		
		if ( $board_config['allow_bbcode'] )
		{
			 $entry_text = ( $blog_row[$i]['bbcode_uid'] ) ? bbencode_second_pass($entry_text, $blog_row[$i]['bbcode_uid']) : preg_replace('/\:[0-9a-z\:]+\]/si', ']', $entry_text);
		}
		$entry_text = make_clickable($entry_text);                             
                if ( $board_config['allow_smilies'] )
		{
			 $entry_text = smilies_pass($entry_text);
		}			
	        $entry_text = str_replace("\n", "\n<br />\n", $entry_text);
		$entry_poster = '<a href="' . append_sid("profile.$phpEx?mode=viewprofile&amp;" . "u" . "=" . $blog_row[$i]['user_id']) . '">' . $blog_row[$i]['username'] . '</a>';
	        if ( $weblog_config['show_action'] )
		{
			$colspan = 2;
		}
		else
		{
			$colspan = 1;
		}
		
		$row_class = ( !($i % 2) ) ? 'row_easy' : 'row_hard';		
		$template->assign_block_vars('switch_show.entry_row', array(		
			'ROW_CLASS' => $row_class,			
			'U_LATEST_ENTRY' => append_sid("weblog_entry.$phpEx?" . 'e' . '=' . $blog_row[$i]['entry_id']),
			'U_VIEW_WEBLOG' => append_sid ("weblog.$phpEx?" . POST_WEBLOG_URL . "=" . $blog_row[$i]['weblog_id']),
			'WEBLOG_NAME' => strip_tags($blog_row[$i]['weblog_name']),
			'LATEST_MOOD' => $mood,
			'LATEST_ACTION' => ( $weblog_config['show_action'] ) ? $action : '',
			'L_LATEST_ENTRIES' => strip_tags(htmlspecialchars($blog_row[$i]['entry_subject'])),
			'L_ENTRY_TEXT' => $entry_text,
			'L_ENTRY_REPLIES' => $blog_row[$i]['entry_replies'],
			'L_VIEWS' => $blog_row[$i]['entry_views'],
			'AVATAR_IMG' => $avatar_img,
			'S_POSTER' => $entry_poster,
			'S_POSTTIME' => create_date($board_config['default_dateformat'], $blog_row[$i]['entry_time'], $board_config['board_timezone']))
		);

                if ( $weblog_config['show_latest_replies'] )
                {
	                 $sql = "SELECT r.reply_id, r.entry_id, r.poster_id, r.post_time, r.post_username, r.reply_text, r.bbcode_uid, r.enable_bbcode, r.enable_smilies, u.user_id, u.username, u.user_avatar, u.user_avatar_type, u.user_allowavatar, u.user_weblog
	                         FROM " . WEBLOG_REPLIES_TABLE . " r, " . USERS_TABLE . " u 
	                         WHERE r.entry_id = " . $entry_id . "
	                         AND r.poster_id = u.user_id
	                         ORDER BY r.reply_id DESC LIMIT " . $weblog_config['latest_reply_max'];
                         if (!$result = $db->sql_query($sql))
                         {
	                         message_die(GENERAL_ERROR, 'Could not query blog information', '', __LINE__, __FILE__, $sql);
                         }
                         $replies = $db->sql_numrows($result);
                         $replies_row = array();
                         while ($row = $db->sql_fetchrow($result))
                         {
	                         $replies_row[] = $row;
                         }
                         $db->sql_freeresult($result);
	                
	                 for ($j = 0; $j < $replies; $j++)
	                 {	                 	
                                 avatar_img($replies_row[$j]['user_avatar_type'], $replies_row[$j]['user_allowavatar'], $replies_row[$j]['user_avatar'], $avatar_img, $avatar_mini);     
	                         if ( $board_config['allow_bbcode'] )
		                 {
			                 if ( $replies_row[$j]['enable_bbcode'] )
			                 {
				                  $replies_row[$j]['reply_text'] = ( $replies_row[$j]['bbcode_uid'] ) ? bbencode_second_pass($replies_row[$j]['reply_text'], $replies_row[$j]['bbcode_uid']) : preg_replace('/\:[0-9a-z\:]+\]/si', ']', $replies_row[$j]['reply_text']);
			                 }
		                 }
		                $replies_row[$j]['reply_text'] = make_clickable($replies_row[$j]['reply_text']);
                                
                                 if ( $board_config['allow_smilies'] )
		                 {
			                 if ( $replies_row[$j]['enable_smilies'] )
			                 {
				                  $replies_row[$j]['reply_text'] = smilies_pass($replies_row[$j]['reply_text']);
			                 }
		                 }

		                 if ( $replies_row[$j]['poster_id'] == '-1' && $replies_row[$j]['post_username'] != '' )
		                 {
			                 $poster = $replies_row[$j]['post_username'];
		                 }
		                 else
		                 {
			                 $poster = '<a href="' . append_sid("profile.$phpEx?mode=viewprofile&amp;" . "u" . "=" . $replies_row[$j]['user_id']) . '">' . $replies_row[$j]['username'] . '</a>';
		                 }

		                 $replies_replies = $replies_row[$j]['entry_replies'];

		                 $row_class = ( !($j % 2) ) ? 'row_easy' : 'row_hard';
                
		                 $template->assign_block_vars('switch_show.entry_row.reply_row', array(					
			                'ROW_CLASS' => $row_class,
			                'L_REPLY_TEXT' => ( $weblog_config['show_comments'] ) ? $replies_row[$j]['reply_text'] : '',
			                'AVATAR_IMG' => $avatar_img,
			                'S_POSTER' => $poster,			                
			                'S_REPLYTIME' => create_date($board_config['default_dateformat'], $replies_row[$j]['post_time'], $board_config['board_timezone']))
		                 );
		
	                 }
	                $template->assign_vars(array(
	                       	'L_LASTPOST' => '<b>' . $lang['Last_reply'] . '</b>')
	                );        	
                }
        }

	$sql = "SELECT count(*) AS total
		FROM " . WEBLOG_ENTRIES_TABLE . "
		WHERE entry_access <= $auth_level";

	if ( !($result = $db->sql_query($sql)) )
	{
	   message_die(GENERAL_ERROR, 'Error getting total entries', '', __LINE__, __FILE__, $sql);
	}

	if ( $total = $db->sql_fetchrow($result) )
	{
	     $total_entry_items = $total['total'];
	     $pagination = generate_pagination("entries.php?count=$w_count&amp;sort=$sort&amp;order=$order", $total_entry_items, $w_count, $start);
	}
	$template->assign_vars(array(
	       'PAGINATION' => $pagination,
	       'PAGE_NUMBER' => sprintf($lang['Page_of'], ( floor( $start / $weblog_config['latest_entry_max'] ) + 1 ), ceil( $total_entry_items / $weblog_config['latest_entry_max'] )))
        );
}

if ( !$weblog_config['show_latest_entries'] && !$weblog_config['show_latest_replies'] )
{
	$template->assign_block_vars('switch_no_blocks', array());
}

$template->pparse('body');


// Include the page footer
include($phpbb_root_path . 'includes/page_tail.'.$phpEx);

?>