<?php
/***************************************************************************
 *                          admin_weblog_config.php
 *                       -----------------------------
 *   begin                : Monday, September 5, 2004
 *   copyright            : (C) 2005 Hyperion
 *   
 *   $Id: module_weblog_config.php,v 1.0.0 2011/06/01
 *
 ***************************************************************************/

define('IN_PHPBB', 1);

if( !empty($setmodules) )
{
	$file = basename(__FILE__);
	$module['Modules']['Последние дневники'] = "$file";
	return;
}

//
// Let's set the root dir for phpBB
//
$phpbb_root_path = "./../";
require($phpbb_root_path . 'extension.inc');
require('./pagestart.' . $phpEx);
include($phpbb_root_path . 'includes/functions_selects.'.$phpEx);
include($phpbb_root_path . 'includes/weblogs_common.'.$phpEx);
include($phpbb_root_path . 'language/lang_' . $use_lang . '/lang_weblog_admin.' . $phpEx);

//
// Pull all config data
//
$sql = "SELECT *
	FROM " . WEBLOG_CONFIG_TABLE;
if(!$result = $db->sql_query($sql))
{
	message_die(CRITICAL_ERROR, "Could not query config information in admin_weblog__news_config", "", __LINE__, __FILE__, $sql);
}
else
{
	while( $row = $db->sql_fetchrow($result) )
	{
		$config_name = $row['config_name'];
		$config_value = $row['config_value'];
		$default_config[$config_name] = isset($HTTP_POST_VARS['submit']) ? str_replace("'", "\'", $config_value) : $config_value;

		$new[$config_name] = ( isset($HTTP_POST_VARS[$config_name]) ) ? $HTTP_POST_VARS[$config_name] : $default_config[$config_name];

		if ($config_name == 'cookie_name')
		{
			$cookie_name = str_replace('.', '_', $new['cookie_name']);
		}

		if( isset($HTTP_POST_VARS['submit']) )
		{
			$sql = "UPDATE " . WEBLOG_CONFIG_TABLE . " SET
				config_value = '" . str_replace("\'", "''", $new[$config_name]) . "'
				WHERE config_name = '$config_name'";
			if( !$db->sql_query($sql) )
			{
				message_die(GENERAL_ERROR, "Failed to update weblog news configuration for $config_name", "", __LINE__, __FILE__, $sql);
			}
		}
	}

	if( isset($HTTP_POST_VARS['submit']) )
	{
		$message = $lang['Weblog_news_config_updated'] . "<br/>" . sprintf($lang['Click_return_weblog_news_config'], "<a href=\"" . append_sid("module_weblog_news_config.$phpEx") . "\">", "</a>") . "<br /><br />" . sprintf($lang['Click_return_admin_index'], "<a href=\"" . append_sid("index.$phpEx?pane=module") . "\">", "</a>");

		message_die(GENERAL_MESSAGE, $message);
	}
}

$template->set_filenames(array(
	"body" => "admin/weblog_news_config_body.tpl")
);

$show_latest_entries_yes = ( $new['show_latest_entries'] ) ? ' checked="checked"' : '';
$show_latest_entries_no = ( !$new['show_latest_entries'] ) ? ' checked="checked"' : '';

$show_latest_replies_yes = ( $new['show_latest_replies'] ) ? ' checked="checked"' : '';
$show_latest_replies_no = ( !$new['show_latest_replies'] ) ? ' checked="checked"' : '';

$show_comments_yes = ( $new['show_comments'] ) ? ' checked="checked"' : '';
$show_comments_no = ( !$new['show_comments'] ) ? ' checked="checked"' : '';

$show_action_yes = ( $new['show_action'] ) ? ' checked="checked"' : '';
$show_action_no = ( !$new['show_action'] ) ? ' checked="checked"' : '';

// Escape quotes
$weblog_config['no_blocks_text'] = str_replace('"', '&quot;', $weblog_config['no_blocks_text']);

$template->assign_vars(array(
	'S_CONFIG_ACTION' => append_sid("module_weblog_news_config.$phpEx"),

	'L_YES' => $lang['Yes'],
	'L_NO' => $lang['No'],
	'L_SUBMIT' => $lang['Submit'],
	'L_RESET' => $lang['Reset'],

	'L_LATEST_ENTRY_MAX' => $lang['Latest_entry_max'],
	'L_LATEST_REPLY_MAX' => $lang['Latest_entry_max'],
	'L_SHOW_LATEST_ENTRIES' => $lang['Show_latest_entries'],
	'L_SHOW_LATEST_REPLIES' => $lang['Show_latest_replies'],
	'L_GENERAL_SETTINGS' => $lang['General_settings'],
	'L_WEBLOG_NEWS' => $lang['Weblog_news'],
	'L_WEBLOG_NEWS_CONFIG' => $lang['Weblog_news_config'],
	'L_WEBLOG_NEWS_CONFIG_EXPLAIN' => $lang['Weblog_news_config_explain'],
	'L_ENTRY_NEWS' => $lang['Entry_news'],
	'L_REPLY_NEWS' => $lang['Reply_news'],
	'L_HOT_LEVEL' => $lang['Hot_level'],
	'L_NO_BLOCKS' => $lang['No_blocks'],
	'L_SHOW_COMMENTS' => $lang['Show_comments'],
	'L_SHOW_ACTION' => $lang['Show_action'],
	'LATEST_ENTRY_MAX' => $weblog_config['latest_entry_max'],
	'LATEST_REPLY_MAX' => $weblog_config['latest_reply_max'],
	'HOT_LEVEL' => $weblog_config['hot_level'],
	'NO_BLOCKS_TEXT' => $weblog_config['no_blocks_text'],

	'S_SHOW_LATEST_ENTRIES_YES' => $show_latest_entries_yes,
	'S_SHOW_LATEST_ENTRIES_NO' => $show_latest_entries_no,
	'S_SHOW_LATEST_REPLIES_YES' => $show_latest_replies_yes,
	'S_SHOW_LATEST_REPLIES_NO' => $show_latest_replies_no,
	'S_SHOW_COMMENTS_YES' => $show_comments_yes,
	'S_SHOW_COMMENTS_NO' => $show_comments_no,
	'S_SHOW_ACTION_YES' => $show_action_yes,
	'S_SHOW_ACTION_NO' => $show_action_no
	)
);

$template->pparse("body");

include('./page_footer_admin.'.$phpEx);

?>