<?php
/***************************************************************************
 *                          admin_weblog_config.php
 *                       -----------------------------
 *   begin                : Monday, September 5, 2004
 *   copyright            : (C) 2005 Hyperion
 *   
 *   $Id: admin_weblog_config.php,v 1.0.0 2004/09/05, 13:17:43 Hyperion Exp $
 *
 ***************************************************************************/

/***************************************************************************
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 ***************************************************************************/

define('IN_PHPBB', 1);

if( !empty($setmodules) )
{
	$file = basename(__FILE__);
	$module['Modules']['Настройки дневников'] = "$file";
	return;
}

//
// Let's set the root dir for phpBB
//
$phpbb_root_path = "./../";
require($phpbb_root_path . 'extension.inc');
require('./pagestart.' . $phpEx);
include($phpbb_root_path . 'includes/functions_selects.'.$phpEx);
include($phpbb_root_path . 'includes/weblogs_common.'.$phpEx);
include($phpbb_root_path . 'includes/functions_weblog.'.$phpEx);
include($phpbb_root_path . 'language/lang_' . $use_lang . '/lang_weblog_admin.' . $phpEx);

//
// Pull all config data
//
$sql = "SELECT *
	FROM " . WEBLOG_CONFIG_TABLE;
if(!$result = $db->sql_query($sql))
{
	message_die(CRITICAL_ERROR, "Could not query config information in admin_weblog_config", "", __LINE__, __FILE__, $sql);
}
else
{
	while( $row = $db->sql_fetchrow($result) )
	{
		$config_name = $row['config_name'];
		$config_value = $row['config_value'];
		$default_config[$config_name] = isset($HTTP_POST_VARS['submit']) ? str_replace("'", "\'", $config_value) : $config_value;
		
		$new[$config_name] = ( isset($HTTP_POST_VARS[$config_name]) ) ? $HTTP_POST_VARS[$config_name] : $default_config[$config_name];

		if ($config_name == 'cookie_name')
		{
			$cookie_name = str_replace('.', '_', $new['cookie_name']);
		}

		if( isset($HTTP_POST_VARS['submit']) )
		{
			$sql = "UPDATE " . WEBLOG_CONFIG_TABLE . " SET
				config_value = '" . str_replace("\'", "''", $new[$config_name]) . "'
				WHERE config_name = '$config_name'";
			if( !$db->sql_query($sql) )
			{
				message_die(GENERAL_ERROR, "Failed to update weblog configuration for $config_name", "", __LINE__, __FILE__, $sql);
			}
		}
	}

	if( isset($HTTP_POST_VARS['submit']) )
	{
		$message = $lang['Weblog_config_updated'] . "<br /><br />" . sprintf($lang['Click_return_weblog_config'], "<a href=\"" . append_sid("module_weblog_config.$phpEx") . "\">", "</a>") . "<br /><br />" . sprintf($lang['Click_return_admin_index'], "<a href=\"" . append_sid("index.$phpEx?pane=module") . "\">", "</a>");

		message_die(GENERAL_MESSAGE, $message);
	}
}

$template->set_filenames(array(
	"body" => "admin/weblog_config_body.tpl")
);

$enable_mod_yes = ( $new['enable_mod'] ) ? ' checked="checked"' : '';
$enable_mod_no = ( !$new['enable_mod'] ) ? ' checked="checked"' : '';

$condense_index_yes = ( $new['condense_index'] ) ? ' checked="checked"' : '';
$condense_index_no = ( !$new['condense_index'] ) ? ' checked="checked"' : '';

$censor_weblogs_yes = ( $new['censor_weblog'] ) ? ' checked="checked"' : '';
$censor_weblogs_no = ( !$new['censor_weblog'] ) ? ' checked="checked"' : '';

$require_auth_yes = ( $new['require_auth'] ) ? ' checked="checked"' : '';
$require_auth_no = ( !$new['require_auth'] ) ? ' checked="checked"' : '';

$index_list_by_username_yes = ( $new['index_list_by_username'] ) ? ' checked="checked"' : '';
$index_list_by_username_no = ( !$new['index_list_by_username'] ) ? ' checked="checked"' : '';

$pic_uploading_enabled_yes = ( $new['pic_upload_enabled'] ) ? ' checked="checked"' : '';
$pic_uploading_enabled_no = ( !$new['pic_upload_enabled'] ) ? ' checked="checked"' : '';

$use_default_faceplates_yes = ( $new['use_default_faceplates'] ) ? ' checked="checked"' : '';
$use_default_faceplates_no = ( !$new['use_default_faceplates'] ) ? ' checked="checked"' : '';

$num_weblogs = array(1, 2, 3, 4, 5, 10, 20, 30, 40, 50, 100);
$select_num_weblogs = '<select name="main_blogsperpage">';
for($i = 0; $i < count($num_weblogs); $i++)
{
	$selected = ( $num_weblogs[$i] == $new['main_blogsperpage'] ) ? ' selected="selected"' : '';
	$select_num_weblogs .= '<option value="' . $num_weblogs[$i] . '"' . $selected . '>' . $num_weblogs[$i] . '</option>';
}
$select_num_weblogs .= '</select>';

$sort_method = array(SORT_NEWEST_ENTRIES, SORT_WEBLOG_NAME, SORT_NUM_ENTRIES, SORT_WEBLOG_START_DATE, SORT_WEBLOG_VIEWS);
$sort_method_text = array($lang['Sort_newest_entries'], $lang['Sort_weblog_name'], $lang['Sort_num_entries'], $lang['Sort_weblog_start_date'], $lang['Sort_weblog_views']);

$select_sort = '<select name="main_sorttype">';
for($i = 0; $i < count($sort_method); $i++)
{
	$selected = ( $sort_method[$i] == $new['main_sorttype'] ) ? ' selected="selected"' : '';
	$select_sort .= '<option value="' . $sort_method[$i] . '"' . $selected . '>' . $sort_method_text[$i] . '</option>';
}
$select_sort .= '</select>';

$sort_order = array('desc', 'asc');
$sort_order_text = array($lang['Sort_Descending'], $lang['Sort_Ascending']);

$select_asc_desc = '<select name="main_sortorder">';
for($i = 0; $i < count($sort_order); $i++)
{
	$selected = ($sort_order[$i] == $new['main_sortorder'] ) ? ' selected="selected"' : '';
	$select_asc_desc .= '<option value="' . $sort_order[$i] . '"' . $selected . '>' . $sort_order_text[$i] . '</option>';
}
$select_asc_desc .= '</select>';

$select_auth = make_weblog_auth_select ( $new['default_auth'], 'default_auth' );
$select_reply_auth = make_weblog_auth_select ( $new['default_reply_auth'], 'default_reply_auth' );

//
// Escape any quotes in the site description for proper display in the text
// box on the admin page 
//
$template->assign_vars(array(
	'S_CONFIG_ACTION' => append_sid("module_weblog_config.$phpEx"),

	'L_YES' => $lang['Yes'],
	'L_NO' => $lang['No'],
	'L_SUBMIT' => $lang['Submit'],
	'L_RESET' => $lang['Reset'],

	'L_CONFIGURATION_TITLE' => $lang['Weblog_configuration'],
	'L_CONFIGURATION_EXPLAIN' => $lang['Weblog_configuration_explain'],
	'L_GENERAL_SETTINGS' => $lang['General_settings'],
	'L_ENABLE_BLOG_MOD' => $lang['Enable_blog_mod'],
	'L_INDEX_BLOGS_PER_PAGE' => $lang['Index_weblogs_per_page'],
	'L_CONDENSE_INDEX' => $lang['Condense_index'],
	'L_CONDENSE_INDEX_EXPLAIN' => $lang['Condense_index_explain'],
	'L_CENSOR_WEBLOGS' => $lang['Censor_weblogs'],
	'L_CENSOR_WEBLOGS_EXPLAIN' => $lang['Censor_weblogs_explain'],
	'L_REQUIRE_AUTH' => $lang['Require_authentication'],
	'L_REQUIRE_AUTH_EXPLAIN' => $lang['Require_authentication_explain'],
	'L_DEFAULT_SETTINGS' => $lang['Default_settings'],
	'L_DEFAULT_WEBLOG_NAME' => $lang['Default_weblog_name'],
	'L_DEFAULT_WEBLOG_NAME_EXPLAIN' => $lang['Default_weblog_name_explain'],
	'L_DEFAULT_WEBLOG_DESC' => $lang['Default_weblog_desc'],
	'L_INDEX_SORT_TYPE' => $lang['Index_sort_type'],
	'L_INDEX_SORT_ORDER' => $lang['Index_sort_order'],
	'L_WEBLOG_AUTH_DEFAULT' => $lang['Default_accessibility'],
	'L_WEBLOG_REPLY_AUTH_DEFAULT' => $lang['Default_reply_auth'],
	'L_ENTRIES_PER_PAGE' => $lang['Default_entries_per_page'],
	'L_POST_REPLY_TEXT' => $lang['Default_post_reply_text'],
	'L_REPLIES_TEXT' => $lang['Default_replies_text'],
	'L_INDEX_LIST_BY_USERNAME' => $lang['Index_list_by_username'],
	'L_BY_WEBLOG_NAME' => $lang['By_weblog_name'],
	'L_BY_OWNER_NAME' => $lang['By_owner_name'],
	'L_SHOUTBOX_FLOOD_DELAY' => $lang['Shoutbox_flood_delay'],
	'L_PICTURE_UPLOADING' => $lang['Picture_uploading'],
	'L_PICTURE_UPLOAD_ENABLED' => $lang['Picture_uploading_enabled'],
	'L_MAXIMUM_PIC_SIZE' => $lang['Maximum_pic_size'],
	'L_MAX_PIC_WIDTH' => $lang['Maximum_pic_width'],
	'L_MAX_PIC_HEIGHT' => $lang['Maximum_pic_height'],
	'L_USE_DEFAULT_FACEPLATES' => $lang['Use_default_faceplates'],
	'L_USE_DEFAULT_FACEPLATES_EXPLAIN' => $lang['Use_default_faceplates_explain'],
	'SHOUTBOX_FLOOD_DELAY' => intval($new['shoutbox_flood_delay']),
	'BLOGS_PER_PAGE_SELECT' => $select_num_weblogs,
	'INDEX_SORT_TYPE_SELECT' => $select_sort,
	'INDEX_SORT_ORDER_SELECT' => $select_asc_desc,
	'WEBLOG_AUTH_SELECT' => $select_auth,
	'WEBLOG_REPLY_AUTH_SELECT' => $select_reply_auth,
	'DEFAULT_WEBLOG_NAME' => $weblog_config['default_name'],
	'DEFAULT_WEBLOG_DESC' => $weblog_config['default_desc'],
	'ENTRIES_PER_PAGE' => $weblog_config['default_entries_perpage'],
	'POST_REPLY_TEXT' => $weblog_config['default_post_reply_text'],
	'REPLIES_TEXT' => $weblog_config['default_replies_text'],
	'MAX_PIC_SIZE' => $weblog_config['max_pic_size'],
	'MAX_PIC_HEIGHT' => $weblog_config['max_pic_height'],
	'MAX_PIC_WIDTH' => $weblog_config['max_pic_width'],

	'S_USE_DEFAULT_FACEPLATES_YES' => $use_default_faceplates_yes,
	'S_USE_DEFAULT_FACEPLATES_NO' => $use_default_faceplates_no,
	'S_PIC_UPLOAD_ENABLED_YES' => $pic_uploading_enabled_yes,
	'S_PIC_UPLOAD_ENABLED_NO' => $pic_uploading_enabled_no,
	'S_ENABLE_BLOG_MOD_YES' => $enable_mod_yes,
	'S_ENABLE_BLOG_MOD_NO' => $enable_mod_no,
	'S_CONDENSE_INDEX_YES' => $condense_index_yes,
	'S_CONDENSE_INDEX_NO' => $condense_index_no,
	'S_CENSOR_WEBLOGS_YES' => $censor_weblogs_yes,
	'S_CENSOR_WEBLOGS_NO' => $censor_weblogs_no,
	'S_INDEX_LIST_BY_USERNAME_YES' => $index_list_by_username_yes,
	'S_INDEX_LIST_BY_USERNAME_NO' => $index_list_by_username_no,
	'S_REQUIRE_AUTH_YES' => $require_auth_yes,
	'S_REQUIRE_AUTH_NO' => $require_auth_no)
);

$template->pparse("body");

include('./page_footer_admin.'.$phpEx);

?>