<?php
/***************************************************************************
 *                           ©  KaspeR
 *                            -------------------
 ***************************************************************************/
 
define('IN_PHPBB', 1);

$points_config['points_name'] = isset($points_config['points_name']) ? $points_config['points_name'] : 'Points';

//
// First we do the setmodules stuff for the admin cp.
//
if( !empty($setmodules) )
{
	$filename = basename(__FILE__);
	$module['Points_sys_settings']['Points_forums'] = $filename;
	return;
}

//
// Load default header
//
$phpbb_root_path = './../';
require($phpbb_root_path . 'extension.inc');
require('./pagestart.' . $phpEx);

    
if ( isset($HTTP_POST_VARS['submit']) )
{
	$forum_id = ( isset($HTTP_POST_VARS['forum_id']) ) ? $HTTP_POST_VARS['forum_id'] : array();
	$points_disabled = ( isset($HTTP_POST_VARS['points_disabled']) ) ? $HTTP_POST_VARS['points_disabled'] : array();

	for($i = 0; $i < count($forum_id); $i++)
	{
		$f_id = $forum_id[$i];
		$sql = 'UPDATE '. FORUMS_TABLE . '
			SET points_disabled = '. intval($points_disabled[$f_id]) . '
			WHERE forum_id = ' . $f_id;
		if (!$db->sql_query($sql))
		{ 
			message_die(GENERAL_ERROR, 'Couldn\'t update forum table.', __LINE__, __FILE__);
		}
	}

	$message = $lang['Points_updated'] . '<br /><br />' . sprintf($lang['Click_return_points'], "<a href=\"" . append_sid("module_points.$phpEx") . "\">", '</a>') . '<br /><br />' . sprintf($lang['Click_return_admin_index'], "<a href=\"" . append_sid("index.$phpEx?pane=module") . "\">", '</a>');
	message_die(GENERAL_MESSAGE, $message);
}

$template->set_filenames(array(
	'body' => 'admin/admin_points_forums_body.tpl')
);
  
$template->assign_vars(array(
        'L_TITLE' => $lang['Points_forums'],
	'L_TEXT' => sprintf($lang['Points_forums_explain'], $points_config['points_name']),
        'L_FORUM' => $lang['Forum_name'],
	'L_POINTS_DISABLED' => sprintf($lang['Points_disabled'], $points_config['points_name']),
	'L_SUBMIT' => $lang['Submit'],
	'L_MARK_ALL' => $lang['Mark_all'],
	'L_UNMARK_ALL' => $lang['Unmark_all'],

	'S_ACTION' => append_sid("module_points_forums.$phpEx"))
);

$sql = "SELECT f.forum_name, f.forum_id, f.points_disabled
	FROM ". FORUMS_TABLE ." f, " . CATEGORIES_TABLE . " c
	WHERE c.cat_id = f.cat_id
	ORDER BY c.cat_order ASC, f.forum_order ASC";
	if ( !($result = $db->sql_query($sql)) )
	{
		message_die(GENERAL_ERROR, 'Could not query forum information', '', __LINE__, __FILE__, $sql);
	}
	$forums = $db->sql_fetchrowset($result); 
	$nums = $db->sql_numrows($result);
  	$db->sql_freeresult($result);

	for ($i = 0; $i < $nums; $i++) 
	{
		if ( $forums[$i]['points_disabled'] )
		{
			$points_disabled = 'checked="checked"';
		}
    	else
	    {
			$points_disabled = '';
	    }
                  
		$forum_url = append_sid("forum_forums.$phpEx?mode=editforum&amp;" . POST_FORUM_URL . '=' . $forums[$i]['forum_id']);
		$forum = '<a href="'. $forum_url .'">'. $forums[$i]['forum_name'] .'</a>';

		$row_color = ( !($i % 2) ) ? $theme['td_color1'] : $theme['td_color2'];
		$row_class = ( !($i % 2) ) ? $theme['td_class1'] : $theme['td_class2'];
     
		$template->assign_block_vars('points_overview',array(
			'ROW_COLOR' => '#' . $row_color, 
			'ROW_CLASS' => $row_class,
			'FORUM' => $forum,
			'FORUM_ID' => $forums[$i]['forum_id'],
          
			'S_POINTS_DISABLED' => $points_disabled)
		);      					
	}

$template->pparse("body");

include('./page_footer_admin.'.$phpEx);

?>