<?php
/***************************************************************************
 *                               weblogs.php
 *                            -----------------
 *   Anv@r.all 2010
 *  (C) apwa.ru
 *
 ***************************************************************************/


define('IN_PHPBB', true);
$phpbb_root_path = './';
include($phpbb_root_path . 'extension.inc');
include($phpbb_root_path . 'common.'.$phpEx);
include($phpbb_root_path . 'includes/weblogs_common.'.$phpEx);
include($phpbb_root_path . 'includes/functions_weblog.'.$phpEx);


$userdata = session_pagestart($user_ip, PAGE_INDEX);
init_userprefs($userdata);

if ( isset($HTTP_GET_VARS['count']) || isset($HTTP_POST_VARS['count']) )
{
	$w_count = (isset($HTTP_POST_VARS['count'])) ? intval($HTTP_POST_VARS['count']) : intval($HTTP_GET_VARS['count']);
}
else
{
	$w_count = $weblog_config['main_blogsperpage'];
}

if ( $w_count < 1 )
{
	$w_count = 1;
}

if ( isset($HTTP_GET_VARS['start']) || isset($HTTP_POST_VARS['start']) )
{
	$start = (isset($HTTP_POST_VARS['start'])) ? intval($HTTP_POST_VARS['start']) : intval($HTTP_GET_VARS['start']);
	$start = abs($start);
}
else
{
	$start = 0;
}

if ( isset($HTTP_GET_VARS['sort']) || isset($HTTP_POST_VARS['sort']) )
{
	$sort = (isset($HTTP_POST_VARS['sort'])) ? intval($HTTP_POST_VARS['sort']) : intval($HTTP_GET_VARS['sort']);
}
else
{
	$sort = $weblog_config['main_sorttype'];
}

if ( isset($HTTP_GET_VARS['order']) || isset($HTTP_POST_VARS['order']) )
{
	$order = (isset($HTTP_POST_VARS['order'])) ? $HTTP_POST_VARS['order'] : $HTTP_GET_VARS['order'];
	$order = ( $order == 'asc' || $order == 'desc' ) ? $order : 'desc';
}
else
{
	$order = $weblog_config['main_sortorder'];
}

$page_title = $lang['Weblogs'];
include($phpbb_root_path . 'includes/page_header.'.$phpEx);

$tracking_entries = ( isset($HTTP_COOKIE_VARS[$board_config['cookie_name'] . '_e']) ) ? unserialize($HTTP_COOKIE_VARS[$board_config['cookie_name'] . "_e"]) : array();
$tracking_weblogs = ( isset($HTTP_COOKIE_VARS[$board_config['cookie_name'] . '_w']) ) ? unserialize($HTTP_COOKIE_VARS[$board_config['cookie_name'] . "_w"]) : array();

$sql = "SELECT *
	FROM " . WEBLOG_MOODS_TABLE . "
	ORDER BY mood_text";
if( !$result = $db->sql_query($sql) )
{
	message_die(GENERAL_ERROR, "Couldn't obtain mood data from database", "", __LINE__, __FILE__, $sql);
}
$mood_data = $db->sql_fetchrowset($result);

$sql = "SELECT *
	FROM " . WEBLOG_ACTIONS_TABLE . "
	ORDER BY action_text";
if( !$result = $db->sql_query($sql) )
{
	message_die(GENERAL_ERROR, "Couldn't obtain action data from database", "", __LINE__, __FILE__, $sql);
}
$action_data = $db->sql_fetchrowset($result);


if ( $userdata['session_logged_in'] )
{
	$sql = "SELECT w.*, u.*
		FROM " . WEBLOGS_TABLE . " w, " . USERS_TABLE . " u
		WHERE w.weblog_id = u.user_weblog
			AND u.user_id = " . $userdata['user_id'];
	if ( !($result = $db->sql_query($sql)) )
	{
		message_die(GENERAL_ERROR, 'Could not query user weblog information', '', __LINE__, __FILE__, $sql);
	}

	$user_weblog_data = array();
	if ( $row = $db->sql_fetchrow($result) )
	{
	     $user_weblog_data = $row; 	             					
	     $weblog_id = $user_weblog_data['weblog_id'];
	    
	     avatar_img($userdata['user_avatar_type'], $userdata['user_allowavatar'], $userdata['user_avatar'], $avatar_img, $avatar_mini);

             $sql = "SELECT * FROM " . WEBLOG_ENTRIES_TABLE . "
		     WHERE weblog_id = " . $userdata['user_weblog'] . " 
		     ORDER BY entry_time DESC LIMIT 1";
	     if ( !($result = $db->sql_query($sql)) )
	     {
		    message_die(GENERAL_ERROR, 'Could not query user weblog information', '', __LINE__, __FILE__, $sql);
	     }

	     if ( $row = $db->sql_fetchrow($result) )
	     {
		  $last_entry_data = $row;

		  $mood = array();
		  $mood = find_mood($last_entry_data['entry_mood']);

		  if ( $mood >= 0 )
		  {
			$mood = sprintf($lang['Mood:'], '<img src="images/weblog/' . $mood['mood_url'] . '" alt="' . $mood_data['mood_text'] . '"/>', $mood['mood_text']);
		  }
		  else
		  {
			$mood = $lang['None'];
		  }

		  // Currently Icons
		  $currently = array();
		  $currently = find_action($last_entry_data['entry_currently']);

		  if ( $currently > 0 )
		  {
			$action = sprintf($lang['Currently:'], '<img src="images/weblog/' . $currently['action_url'] . '" alt="' . $currently['action_text'] . ' ' . strip_tags(htmlspecialchars($last_entry_data['currently_text'])) . '" />',  $currently['action_text'] . ' ' . strip_tags(htmlspecialchars($last_entry_data['currently_text'])));
		  }
		  else if ( $last_entry_data['currently_text'] && $currently == -2 )
		  {
			$action = sprintf($lang['Currently:'], '', strip_tags(htmlspecialchars($last_entry_data['currently_text'])));
		  }
		  else
		  {
			$action = $lang['None'];
		  }

		   $entry_id = $last_entry_data['entry_id'];
		   $last_entry_time = create_date($board_config['default_dateformat'], $last_entry_data['entry_time'], $board_config['board_timezone']);
		   $last_entry_time .= '&nbsp;<a href="' . append_sid("weblog_entry.$phpEx?" . POST_ENTRY_URL . "=$entry_id") . '">»</a>';
		   $last_entry = $last_entry_time;
	     }
	     else
	     {
		   $last_entry = $lang['No_entries'];
		   $action = $lang['None'];
		   $mood = $lang['None'];
	     }
	
	     $template->assign_block_vars('user_blog', array(
		      'ID' => 'user',		      
		      'WEBLOG_NAME' => $lang['Your_weblog'],
		      'AVATAR_IMG' => $avatar_img,		
		      'WEBLOG_OWNER' => $user_weblog_data['username'],
		      'WEBLOG_DESCRIPTION' => $user_weblog_data['weblog_desc'],
		      'U_VIEW_WEBLOG' => append_sid ("weblog.$phpEx?" . POST_WEBLOG_URL . "=" . $user_weblog_data['weblog_id']),
		      'NO_BLOG_CREATE' => sprintf($lang['No_weblog_create'], '<a href="' . append_sid("weblog_config.$phpEx") . '" class="mainmenu">', '</a>'),
	              'LAST_ENTRY' => $last_entry,
	              'LATEST_MOOD' => $mood,
		      'LAST_SEEN' => $action )
	     );
	}
	else
	{
		if ( !$userdata['session_logged_in'] )
		{
			$lang_create = $lang['No_weblog_guests'];
		}
		else if ( !$userdata['user_allowweblog'] )
		{
			$lang_create = $lang['Weblog_banned'];
		}
		else
		{
			$lang_create = $lang['No_weblog_create'];
		}

		$template->assign_block_vars('user_no_blog', array(
			'L_NO_WEBLOG_CREATE' => sprintf($lang['No_weblog_create'], '<a href="' . append_sid("weblog_config.$phpEx") . '" class="genmed">', '</a>'))
		);						
	} 	        
	
}
else
{
		if ( !$userdata['session_logged_in'] )
		{
			$lang_create = $lang['No_weblog_guests'];
		}
		else if ( !$userdata['user_allowweblog'] )
		{
			$lang_create = $lang['Weblog_banned'];
		}
		else
		{
			$lang_create = $lang['No_weblog_create'];
		}

		$template->assign_block_vars('user_no_blog', array(
			'L_NO_WEBLOG_CREATE' => sprintf($lang_create, '<a href="' . append_sid("weblog_config.$phpEx") . '" class="genmed">', '</a>'))
		);	
}

$num_weblogs = array(1, 2, 3, 4, 5, 10, 20, 30, 40, 50, 100);

$select_num_weblogs = '<select name="count">';
for($i = 0; $i < count($num_weblogs); $i++)
{
	$selected = ( $w_count == $num_weblogs[$i] ) ? ' selected="selected"' : '';
	$select_num_weblogs .= '<option value="' . $num_weblogs[$i] . '"' . $selected . '>' . $num_weblogs[$i] . '</option>';
}
$select_num_weblogs .= '</select>';

$sort_method = array(SORT_NEWEST_ENTRIES, SORT_WEBLOG_NAME, SORT_NUM_ENTRIES, SORT_WEBLOG_START_DATE, SORT_WEBLOG_VIEWS);
$sort_method_text = array($lang['Sort_newest_entries'], $lang['Sort_weblog_name'], $lang['Sort_num_entries'], $lang['Sort_weblog_start_date'], $lang['Sort_weblog_views']);

$select_sort = '<select name="sort">';
for($i = 0; $i < count($sort_method); $i++)
{
	$selected = ( $sort == $sort_method[$i] ) ? ' selected="selected"' : '';
	$select_sort .= '<option value="' . $sort_method[$i] . '"' . $selected . '>' . $sort_method_text[$i] . '</option>';
}
$select_sort .= '</select>';

$sort_order = array('desc', 'asc');
$sort_order_text = array($lang['Sort_Descending'], $lang['Sort_Ascending']);

$select_asc_desc = '<select name="order">';
for($i = 0; $i < count($sort_order); $i++)
{
	$selected = ( strtolower($order) == $sort_order[$i] ) ? ' selected="selected"' : '';
	$select_asc_desc .= '<option value="' . $sort_order[$i] . '"' . $selected . '>' . $sort_order_text[$i] . '</option>';
}
$select_asc_desc .= '</select>';

//
// BEGIN
//

switch ( $sort )
{
	case SORT_NEWEST_ENTRIES: 	$sort = 'e.entry_time'; break;
	case SORT_WEBLOG_NAME: 		$sort = 'w.weblog_name'; break;
	case SORT_NUM_ENTRIES: 		$sort = 'w.weblog_entries'; break;
	case SORT_WEBLOG_START_DATE:	$sort = 'w.weblog_create_date'; break;
	case SORT_WEBLOG_VIEWS:		$sort = 'w.weblog_views'; break;
	case SORT_WEBLOG_OWNER_NAME:	$sort = 'u.username'; break;
	default: 			$sort = 'e.entry_time'; break;
}

$weblog_data = fetch_visible_weblogs($sort, $order);

$total_weblogs = count($weblog_data);
if ( $total_weblogs == 0 )
{
	message_die(GENERAL_MESSAGE, $lang['No_weblogs']);
}

$template->set_filenames(array(
		'body' => 'blog/index_blogs_body.tpl')
	);

// Switch back to numeric values.
switch ( $sort )
{
	case 'e.entry_time':		$sort = SORT_NEWEST_ENTRIES; break;
	case 'w.weblog_name': 		$sort = SORT_WEBLOG_NAME; break;
	case 'w.weblog_entries':	$sort = SORT_NUM_ENTRIES; break;
	case 'w.weblog_create_date':	$sort = SORT_WEBLOG_START_DATE; break;
	case 'w.weblog_views':		$sort = SORT_WEBLOG_VIEWS; break;
	case 'u.username':		$sort = SORT_WEBLOG_OWNER_NAME; break;
	default: 			$sort = SORT_NEWEST_ENTRIES; break;
}

$template->assign_vars(array(
	'S_NUM_WEBLOGS' => $select_num_weblogs,
	'S_SORT_METHOD' => $select_sort,
	'S_SORT_ORDER' => $select_asc_desc,
	'S_SORT_ACTION' => append_sid("weblogs.$phpEx"),
	'L_NO_ACCESS' => $lang['Weblog_noaccess'],
	'L_WEBLOGS_PER_PAGE' => $lang['Weblogs_perpage'],
	'L_SORT' => $lang['Sort'],
	'L_GO' => $lang['Go'],
	'L_WEBLOG' => $lang['Weblog'],
	'L_WEBLOG_DESCRIPTION' => $lang['Weblog_description'],
	'L_OWNER' => $lang['Weblog_Owner'],
	'L_LAST_ENTRY' => $lang['Last_entry'],
	'L_LATEST_MOOD' => $lang['Latest_mood'],
	'L_LAST_SEEN' => $lang['Last_seen'],
	'L_ENTRIES' => $lang['Weblogs_news'],
	'L_RSS' => $lang['RSS'],     	
	'L_WEBLOG_DESCRIPTION' => $lang['Weblog_description'],	
	'PAGE_NUMBER' => sprintf($lang['Page_of'], ( floor( $start / $w_count ) + 1 ), ceil( count($weblog_data) / $w_count )),
	'PAGINATION' => generate_pagination("weblogs.$phpEx?count=$w_count&amp;sort=$sort&amp;order=$order", count($weblog_data), $w_count, $start))
);

if ( $userdata['session_logged_in'] )
{
	$sql = "SELECT weblog_id, entry_id, entry_time 
		FROM " . WEBLOG_ENTRIES_TABLE . "
		WHERE entry_time > " . $userdata['user_lastvisit']; 
	if ( !($result = $db->sql_query($sql)) )
	{
		message_die(GENERAL_ERROR, 'Could not query new entry information', '', __LINE__, __FILE__, $sql);
	}
	
	while( $entry_data = $db->sql_fetchrow($result) )
	{
		$new_entry_data[$entry_data['weblog_id']][$entry_data['entry_id']] = $entry_data['entry_time'];
	}
	$db->sql_freeresult($result);
}

for ($i = $start; $i < $total_weblogs && $i < $w_count + $start; $i++)
{	
	$last_entry = '';
	$mood = '';
	$action = '';
	$weblog_id = $weblog_data[$i]['weblog_id'];
        avatar_img($weblog_data[$i]['user_avatar_type'], $weblog_data[$i]['user_allowavatar'], $weblog_data[$i]['user_avatar'], $avatar_img, $avatar_mini);       

	if ( $weblog_data[$i]['entry_text'] )
	{
		$last_entry_data = $weblog_data[$i];

		$mood = array();
		$mood = find_mood($last_entry_data['entry_mood']);

		if ( $mood >= 0 )
		{ 
			$mood = sprintf($lang['Mood:'], '<img src="images/weblog/' . $mood['mood_url'] . '" alt="' . $mood_data['mood_text'] . '" style="vertical-align: middle" border="0" />', $mood['mood_text']);
		}
		else
		{
			$mood = $lang['None'];
		}

		// Currently Icons
		$currently = array();
		$currently = find_action($last_entry_data['entry_currently']);

		if ( $currently > 0 )
		{
			$action = sprintf($lang['Currently:'], '<img src="images/weblog/' . $currently['action_url'] . '" alt="' . $currently['action_text'] . ' ' . strip_tags(htmlspecialchars($last_entry_data['currently_text'])) . '" style="vertical-align: middle" border="0" />',  $currently['action_text'] . ' ' . strip_tags(htmlspecialchars($last_entry_data['currently_text'])));
		}
		else if ( $last_entry_data['currently_text'] && $currently == -2 )
		{
			$action = sprintf($lang['Currently:'], '', strip_tags(htmlspecialchars($last_entry_data['currently_text'])));
		}
		else
		{
			$action = $lang['None'];
		}

		$unread_entries = false;
		if ( $userdata['session_logged_in'] )
		{
			if ( !empty($new_entry_data[$weblog_id]) )
			{
				$weblog_last_post_time = 0;

				while( list($check_entry_id, $check_post_time) = @each($new_entry_data[$weblog_id]) )
				{
					if ( empty($tracking_entries[$check_entry_id]) )
					{
						$unread_entries = true;
						$weblog_last_post_time = max($check_post_time, $weblog_last_post_time);
					}
					else
					{
						if ( $tracking_entries[$check_entry_id] < $check_post_time )
						{
							$unread_entries = true;
							$weblog_last_post_time = max($check_post_time, $weblog_last_post_time);
						}
					}
				}

				if ( !empty($tracking_weblogs[$weblog_id]) )
				{
					if ( $tracking_weblogs[$weblog_id] > $weblog_last_post_time )
					{
						$unread_entries = false;
					}
				}

				if ( isset($HTTP_COOKIE_VARS[$board_config['cookie_name'] . '_w_all']) )
				{
					if ( $HTTP_COOKIE_VARS[$board_config['cookie_name'] . '_w_all'] > $weblog_last_post_time )
					{
						$unread_entries = false;
					}
				}
			}
		}

		$entry_id = $last_entry_data['entry_id'];

		$newest_post_img = '';
		if ( $unread_entries )
		{
			$newest_post_img = '<a href="' . append_sid("weblog_entry.$phpEx?" . POST_ENTRY_URL . "=$entry_id") . '">+»</a> ';
		}
		else
		{
			$newest_post_img = '<a href="' . append_sid("weblog_entry.$phpEx?" . POST_ENTRY_URL . "=$entry_id") . '">»</a> ';
		}
		

		$last_entry_time = create_date($board_config['default_dateformat'], $last_entry_data['entry_time'], $board_config['board_timezone']);

		$last_entry_time .= '&nbsp;' . $newest_post_img;

		$last_entry = $last_entry_time;
	}
	else
	{
		$mood = $lang['None'];
		$action = $lang['None'];
		$last_entry = $lang['No_entries'];
	}
	
	$row_class = ( !($i % 2) ) ? 'row_hard' : 'row_easy';

	$template->assign_block_vars('blogrow', array(
		'ID' => 'weblog' . $i,
		'ROW_CLASS' => $row_class,					
		'RECENT_POST_CLASS' => $row_class,
		'WEBLOG_NAME' => strip_tags($weblog_data[$i]['weblog_name']),
		'AVATAR_IMG' => $avatar_img,
		'WEBLOG_OWNER' => $weblog_data[$i]['username'],
		'WEBLOG_DESCRIPTION' => $weblog_data[$i]['weblog_desc'],
		'USERNAME' => $weblog_data[$i]['username'],
		'U_VIEW_WEBLOG' => append_sid ("weblog.$phpEx?" . POST_WEBLOG_URL . "=" . $weblog_data[$i]['weblog_id']),		
		'LAST_ENTRY' => $last_entry,
		'LATEST_MOOD' => $mood,
		'LAST_SEEN' => $action)
	);	
}

$template->pparse('body');

include($phpbb_root_path . 'includes/page_tail.'.$phpEx);

?>