<?php
/***************************************************************************
 *                            weblog_posting.php
 *                         ------------------------
 *   Anv@r.all 2010
 *   (C) apwa.ru
 *
 ***************************************************************************/


define('IN_PHPBB', true);
$phpbb_root_path = './';
include($phpbb_root_path . 'extension.inc');
include($phpbb_root_path . 'common.'.$phpEx);
include($phpbb_root_path . 'includes/bbcode.'.$phpEx);
include($phpbb_root_path . 'includes/functions_post.'.$phpEx);
include($phpbb_root_path . 'includes/weblogs_common.'.$phpEx);
include($phpbb_root_path . 'includes/functions_weblog.'.$phpEx);

if ( isset($HTTP_POST_VARS[POST_REPLY_URL]) || isset($HTTP_GET_VARS[POST_REPLY_URL]) )
{
	$reply_id = ( isset($HTTP_POST_VARS[POST_REPLY_URL]) ) ? $HTTP_POST_VARS[POST_REPLY_URL] : $HTTP_GET_VARS[POST_REPLY_URL];
	$reply_id = intval($reply_id);
}
else
{
	$reply_id = 0;
}

if ( isset($HTTP_POST_VARS[POST_ENTRY_URL]) || isset($HTTP_GET_VARS[POST_ENTRY_URL]) )
{
	$entry_id = ( isset($HTTP_POST_VARS[POST_ENTRY_URL]) ) ? $HTTP_POST_VARS[POST_ENTRY_URL] : $HTTP_GET_VARS[POST_ENTRY_URL];
	$entry_id = intval($entry_id);
}
else
{
	$entry_id = 0;
}

if ( isset($HTTP_POST_VARS[POST_WEBLOG_URL]) || isset($HTTP_GET_VARS[POST_WEBLOG_URL]) )
{
	$weblog_id = ( isset($HTTP_POST_VARS[POST_WEBLOG_URL]) ) ? $HTTP_POST_VARS[POST_WEBLOG_URL] : $HTTP_GET_VARS[POST_WEBLOG_URL];
	$weblog_id = intval($weblog_id);
}
else
{
	$weblog_id = 0;
}

if ( isset($HTTP_GET_VARS['popup']) || isset($HTTP_POST_VARS['popup']))
{
	$popup = ( isset($HTTP_GET_VARS['popup']) ) ? intval($HTTP_GET_VARS['popup']) : intval($HTTP_POST_VARS['popup']);
}

if ( isset($HTTP_POST_VARS['mode']) || isset($HTTP_GET_VARS['mode']) )
{
	$mode = ( isset($HTTP_POST_VARS['mode']) ) ? $HTTP_POST_VARS['mode'] : $HTTP_GET_VARS['mode'];
}
else
{
	$mode = '';
}

$confirm = ( $HTTP_POST_VARS['confirm'] ) ? TRUE : 0;

//
// Text based parameters
//
$params = array('username' => 'username', 'subject' => 'subject');
while( list($var, $param) = @each($params) )
{
	if ( !empty($HTTP_POST_VARS[$param]) )
	{
		$$var = trim($HTTP_POST_VARS[$param]);
	}
	else
	{
		$$var = '';
	}
}

//
// Integer parameters
//
$mood = -1;
$params = array('entry_access' => 'entry_access', 'mood' => 'mood', 'action' => 'action', 'year' => 'year', 'month' => 'month', 'day' => 'day');
while( list($var, $param) = @each($params) )
{
	if ( !empty($HTTP_POST_VARS[$param]) )
	{
		$$var = intval($HTTP_POST_VARS[$param]);
	}
	else if ( $var != 'mood' )
	{
		$$var = 0;
	}
}

//
// Parameters with only on or off
//
$params = array('memorable' => 'memorable', 'disable_replies' => 'disable_replies', 'disable_html' => 'disable_html', 'disable_bbcode' => 'disable_bbcode', 'disable_smilies' => 'disable_smilies', 'attach_sig' => 'attach_sig');
while( list($var, $param) = @each($params) )
{
	if ( !empty($HTTP_POST_VARS[$param]) )
	{
		$$var = ( !empty($HTTP_POST_VARS[$param]) ) ? 1 : 0;
	}
	else
	{
		$$var = 0;
	}
}

//
// Start session management
//
$userdata = session_pagestart($user_ip, PAGE_POSTING);
init_userprefs($userdata);
//
// End session management
//

$hidden_form_fields = '';

if ( $reply_id )
{
	$reply_data = '';
	$sql = "SELECT * FROM " . WEBLOG_REPLIES_TABLE . " WHERE reply_id = $reply_id";
	if ( !($result = $db->sql_query($sql)) )
	{
		message_die(GENERAL_ERROR, 'Error getting reply information', '', __LINE__, __FILE__, $sql);
	}

	$reply_data = array();
	if ( $row = $db->sql_fetchrow($result) )
	{
		$reply_data = $row;
	}
	else
	{
		message_die(GENERAL_ERROR, $lang['Reply_not_exist']);
	}

	// Also get the entry data
	$sql = "SELECT * FROM " . WEBLOG_ENTRIES_TABLE . " WHERE entry_id = " . $reply_data['entry_id'];
	if ( !($result = $db->sql_query($sql)) )
	{
		message_die(GENERAL_ERROR, 'Error getting reply information', '', __LINE__, __FILE__, $sql);
	}

	$entry_data = array();
	if ( $row = $db->sql_fetchrow($result) )
	{
		$entry_data = $row;
	}
	else
	{
		message_die(GENERAL_ERROR, $lang['Entry_not_exist']);
	}

	$sql = "SELECT w.*, u.user_id FROM " . WEBLOGS_TABLE . " w, " . USERS_TABLE . " u
			WHERE w.weblog_id = " . $entry_data['weblog_id'] . "
				AND w.weblog_id = u.user_weblog";
	if ( !($result = $db->sql_query($sql)) )
	{
		message_die(GENERAL_ERROR, 'Error retrieving the reply\'s weblog', '', __LINE__, __FILE__, $sql);
	}

	$weblog_data = array();
	if ( $row = $db->sql_fetchrow($result) )
	{
		$weblog_data = $row;
	}
	else
	{
		// If a reply doesn't belong to a weblog or an entry, it doesn't exist.
		message_die(GENERAL_ERROR, $lang['Weblog_not_exist']);
	}

	$entry_id = $reply_data['entry_id'];
	$weblog_id = $weblog_data['weblog_id'];
}
else if ( $entry_id )
{
	$entry_data = '';
	$sql = "SELECT * FROM " . WEBLOG_ENTRIES_TABLE . " WHERE entry_id = $entry_id";
	if ( !($result = $db->sql_query($sql)) )
	{
		message_die(GENERAL_ERROR, 'Error getting entry information', '', __LINE__, __FILE__, $sql);
	}

	if ( $row = $db->sql_fetchrow($result) )
	{
		$entry_data = $row;
	}
	else
	{
		message_die(GENERAL_ERROR, $lang['Entry_not_exist']);
	}

	$sql = "SELECT w.*, u.user_id FROM " . WEBLOGS_TABLE . " w, " . USERS_TABLE . " u
			WHERE w.weblog_id = " . $entry_data['weblog_id'] . "
				AND w.weblog_id = u.user_weblog";
	if ( !($result = $db->sql_query($sql)) )
	{
		message_die(GENERAL_ERROR, 'Error retrieving the entry\'s weblog', '', __LINE__, __FILE__, $sql);
	}

	if ( $row = $db->sql_fetchrow($result) )
	{
		$weblog_data = $row;
	}
	else
	{
		// If an entry does not belong to a weblog, it doesn't exist
		message_die(GENERAL_ERROR, $lang['Weblog_not_exist']);
	}
	$weblog_id = $weblog_data['weblog_id'];

}
else if ( $weblog_id )
{
	$weblog_data = '';
	$sql = "SELECT w.*, u.* FROM " . WEBLOGS_TABLE . " w, " . USERS_TABLE . " u WHERE w.weblog_id = $weblog_id AND u.user_weblog = w.weblog_id";
	if ( !($result = $db->sql_query($sql)) )
	{
		message_die(GENERAL_ERROR, 'Error getting weblog information', '', __LINE__, __FILE__, $sql);
	}

	if ( $row = $db->sql_fetchrow($result) )
	{
		$weblog_data = $row;
	}
	else
	{
		message_die(GENERAL_ERROR, $lang['Weblog_not_exist']);
	}
}

//
// Was cancel pressed? If so then redirect to the appropriate
// page, no point in continuing with any further checks
//
if ( isset($HTTP_POST_VARS['cancel']) )
{
	if ( $tb_id )
	{
		$redirect = "weblog_entry.$phpEx?" . POST_ENTRY_URL . "=$entry_id&amp;tb=1";
		$post_append = "#$post_id";
	}
	else if ( $entry_id )
	{
		$redirect = "weblog_entry.$phpEx?" . POST_ENTRY_URL . "=$entry_id";
		$post_append = '';
	}
	else if ( $weblog_id )
	{
		$redirect = "weblog.$phpEx?" . POST_WEBLOG_URL . "=$weblog_id";
		$post_append = '';
	}
	else
	{
		$redirect = "weblogs.$phpEx";
		$post_append = '';
	}

	redirect(append_sid($redirect, true) . $post_append);
}

if ( $weblog_data['deleted'] )
{
	message_die(GENERAL_ERROR, sprintf($lang['Weblog_deactivated'], $weblog_data['weblog_name']));
}

//
// Fetch Contributor data
//
$sql = "SELECT * FROM " . WEBLOG_CONTRIBUTORS_TABLE . " WHERE weblog_id = $weblog_id AND user_id = " . $userdata['user_id'];
if ( !($result = $db->sql_query($sql)) )
{
	message_die(GENERAL_ERROR, 'Error querying to find user weblog information', '', __LINE__, __FILE__, $sql);
}

$contributor = FALSE;
if ( $row = $db->sql_fetchrow($result) || $userdata['user_level'] == ADMIN )
{
	$contributor = TRUE;
}

$auth_level = get_auth_level($weblog_data, $contributor);

if ( !$board_config['allow_html'] )
{
	$disable_html = 1;
}


if ( !$board_config['allow_bbcode'] )
{
	$disable_bbcode = 1;
}

if ( !$board_config['allow_smilies'] )
{
	$disable_smilies = 1;
}

if ( $disable_html )
{
	$html_on = 0;
}
else
{
	$html_on = 1;
}

if ( $disable_bbcode )
{
	$bbcode_on = 0;
}
else
{
	$bbcode_on = 1;
	$bbcode_uid = make_bbcode_uid();
}

if ( $disable_smilies )
{
	$smilies_on = 0;
}
else
{
	$smilies_on = 1;
}

//
// Handle Submissions (excluding image uploads)
//
if ( isset($HTTP_POST_VARS['submit']) )
{
	if ( !$userdata['user_allowweblog'] )
	{
		message_die(GENERAL_ERROR, $lang['Owner_banned']);
	}
	
        $target_date = time();
	// Always going to be a message that needs to be taken care of
	$message = ( isset($HTTP_POST_VARS['message']) ) ? $HTTP_POST_VARS['message'] : '';
	$error_msg = '';

	if ( empty($subject) && ($mode == 'newentry' || $mode == 'editentry') )
	{
		$error_msg .= (!empty($error_msg)) ? '<br />' . $lang['Subject_empty'] : $lang['Subject_empty'];
	}

        // ADD ON category by willow
        $category_id = ( isset($HTTP_POST_VARS['category_id']) ) ? intval($HTTP_POST_VARS['category_id']) : '0';

	if ( empty($message) )
	{
		if ( $mode == 'newentry' || $mode == 'editentry' )
		{
			$error_msg .= (!empty($error_msg)) ? '<br />' . $lang['Entry_empty'] : $lang['Entry_empty'];
		}
		else
		{
			$error_msg .= (!empty($error_msg)) ? '<br />' . $lang['Reply_empty'] : $lang['Reply_empty'];
		}

	}
	else
	{
		$message = prepare_message($message, $html_on, $bbcode_on, $smilies_on, $bbcode_uid);
	}

	// Check username
	if (!empty($username))
	{
		$username = trim(strip_tags($username));

		if (!$userdata['session_logged_in'])
		{
			include($phpbb_root_path . 'includes/functions_validate.'.$phpEx);

			$result = validate_username($username);
			if ($result['error'])
			{
				$error_msg .= (!empty($error_msg)) ? '<br />' . $result['error_msg'] : $result['error_msg'];
			}
		}
		else
		{
			$username = '';
		}
	}

	if ( !empty($error_msg) )
	{
		message_die (GENERAL_ERROR, $error_msg . '<br />' . $lang['Try_again']);
	}

	if ( $mode == 'newentry' || $mode == 'editentry' )
	{
		
		$maximum = 0;

		// First, get the maximum entry id
		$sql = "SELECT MAX(entry_id) AS maximum FROM " . WEBLOG_ENTRIES_TABLE;
		if ( !($result = $db->sql_query($sql)) )
		{
			message_die(GENERAL_ERROR, 'Could not query maximum entry id in database', '', __LINE__, __FILE__, $sql);
		}

		if ( $row = $db->sql_fetchrow($result) )
		{
			$maximum = $row['maximum'];
		}

		$maximum++;

		$tb_excerpt = ( isset($HTTP_POST_VARS['tb_excerpt']) ) ? stripslashes(strip_tags($HTTP_POST_VARS['tb_excerpt'])) : '';
		$tb_urls = ( isset($HTTP_POST_VARS['tb_urls']) ) ? stripslashes($HTTP_POST_VARS['tb_urls']) : '';

		$tb_result = '';

		if ( $mode == 'newentry' )
		{
			if ( $weblog_data['weblog_id'] != $userdata['user_weblog'] && $userdata['user_level'] != ADMIN && !$contributor )
			{
				message_die (GENERAL_ERROR, $lang['No_add_entries']);
			}

			$sql = "INSERT INTO " . WEBLOG_ENTRIES_TABLE . " (entry_id, weblog_id, entry_access, entry_subject, entry_text, bbcode_uid, entry_mood, entry_currently, entry_time, enable_bbcode, enable_smilies, memorable, no_replies, entry_last_post_userid, entry_poster_id, category_id)
					VALUES ($maximum, $weblog_id, $entry_access, '" . str_replace("\'", "''", $subject) . "', '" . str_replace("\'", "''", $message) . "', '$bbcode_uid', $mood, $action, $target_date, $bbcode_on, $smilies_on, $memorable, $disable_replies, " . $userdata['user_id'] . ", " . $userdata['user_id'] . ", '" . $category_id . "')";
			if ( !($result = $db->sql_query($sql)) )
			{
				message_die(GENERAL_ERROR, 'Could not insert entry into database', '', __LINE__, __FILE__, $sql);
			}
			// Sobytie
			add_sobytie($maximum, 'weblog', '', '', '', $userdata['user_id'], $userdata['username'], $subject, $message, $target_date);                        
	                // Sobytie

			$sql = "UPDATE " . WEBLOGS_TABLE . "
				SET weblog_entries = weblog_entries + 1
				WHERE weblog_id = $weblog_id";
			if( !$result = $db->sql_query($sql) )
			{
				message_die(GENERAL_ERROR, "Couldn't update weblog entries information.", "", __LINE__, __FILE__, $sql);
			}

			// Set a cookie for this entry
			$tracking_entries = ( !empty($HTTP_COOKIE_VARS[$board_config['cookie_name'] . '_e']) ) ? unserialize($HTTP_COOKIE_VARS[$board_config['cookie_name'] . '_e']) : array();
			$tracking_weblogs = ( !empty($HTTP_COOKIE_VARS[$board_config['cookie_name'] . '_w']) ) ? unserialize($HTTP_COOKIE_VARS[$board_config['cookie_name'] . '_w']) : array();

			if ( count($tracking_entries) + count($tracking_weblogs) == 100 && empty($tracking_entries[$maximum]) )
			{
				asort($tracking_entries);
				unset($tracking_entries[key($tracking_entries)]);
			}

			$tracking_entries[$maximum] = time();

			setcookie($board_config['cookie_name'] . '_e', serialize($tracking_entries), 0, $board_config['cookie_path'], $board_config['cookie_domain'], $board_config['cookie_secure']);
			
			// Finish Up
			$template->assign_vars(array(
				'META' => '<meta http-equiv="refresh" content="3;url=' . append_sid("weblog_entry.$phpEx?" . POST_ENTRY_URL . "=$maximum") . '">')
			);

			message_die(GENERAL_MESSAGE, $lang['Entry_submitted'] . $tb_result . '<br />' . sprintf($lang['Click_return_entry'], '<a href="' . append_sid("weblog_entry.$phpEx?" . POST_ENTRY_URL . "=$maximum") . '">', '</a>') . '<br />' . sprintf($lang['Click_return_weblog'], '<a href="' . append_sid("weblog.$phpEx?" . POST_WEBLOG_URL . "=" . $weblog_data['weblog_id']) . '">', '</a>', $weblog_data['weblog_name']));
		}
		else if ( $mode == 'editentry' )
		{
			if ( $weblog_data['weblog_id'] != $userdata['user_weblog'] && $userdata['user_level'] != ADMIN && !$contributor )
			{
				message_die(GENERAL_ERROR, $lang['No_edit_entries']);
			}

			$sql = "UPDATE " . WEBLOG_ENTRIES_TABLE . " SET entry_access = $entry_access, entry_subject = '" . str_replace("\'", "''", $subject) . "', entry_text = '" . str_replace("\'", "''", $message) . "', bbcode_uid = '$bbcode_uid', entry_mood = $mood, entry_currently = $action, category_id = '" . $category_id . "', enable_bbcode = $bbcode_on, enable_smilies = $smilies_on, memorable = $memorable, no_replies = $disable_replies WHERE entry_id = $entry_id";
			if ( !($result = $db->sql_query($sql)) )
			{
				message_die(GENERAL_ERROR, 'Could not update entry in database', '', __LINE__, __FILE__, $sql);
			}

			$template->assign_vars(array(
				'META' => '<meta http-equiv="refresh" content="3;url=' . append_sid("weblog_entry.$phpEx?" . POST_ENTRY_URL . "=$entry_id") . '">')
			);

			message_die (GENERAL_MESSAGE, $lang['Entry_updated'] . $tb_result . '<br />' . sprintf($lang['Click_return_entry'], '<a href="' . append_sid("weblog_entry.$phpEx?" . POST_ENTRY_URL . "=$entry_id") . '">', '</a>') . '<br />' . sprintf($lang['Click_return_weblog'], '<a href="' . append_sid("weblog.$phpEx?" . POST_WEBLOG_URL . "=" . $weblog_data['weblog_id']) . '">', '</a>', $weblog_data['weblog_name']));
		}
	}
	else if ( $mode == 'editreply' || $mode == 'reply' )
	{
		if ( $mode == 'editreply' )
		{
			// If the user isn't the original poster or a contributor or the weblog owner...
			if ( $reply_data['poster_id'] != $userdata['user_id'] && !$contributor && $weblog_data['weblog_id'] != $userdata['user_id'] && $userdata['session_logged_in'] )
			{
				message_die (GENERAL_ERROR, $lang['No_edit_replies']);
			}

			$sql = "UPDATE " . WEBLOG_REPLIES_TABLE . " SET post_subject = '" . str_replace("\'", "''", $subject) . "', reply_text = '" . str_replace("\'", "''", $message) . "', bbcode_uid = '$bbcode_uid', enable_bbcode = $bbcode_on, enable_smilies = $smilies_on, post_username = '" . str_replace("\'", "''", $username) . "' WHERE reply_id = $reply_id";
			if ( !($result = $db->sql_query($sql)) )
			{
				message_die(GENERAL_ERROR, 'Could not update reply in database', '', __LINE__, __FILE__, $sql);
			}

			$template->assign_vars(array(
				'META' => '<meta http-equiv="refresh" content="3;url=' . append_sid("weblog_entry.$phpEx?" . POST_ENTRY_URL . "=$entry_id") . '">')
			);

			message_die (GENERAL_MESSAGE, $lang['Reply_updated'] . '<br />' . sprintf($lang['Click_return_entry'], '<a href="' . append_sid("weblog_entry.$phpEx?" . POST_ENTRY_URL . "=$entry_id") . '">', '</a>') . '<br />' . sprintf($lang['Click_return_weblog'], '<a href="' . append_sid("weblog.$phpEx?" . POST_WEBLOG_URL . "=" . $weblog_data['weblog_id']) . '">', '</a>', $weblog_data['weblog_name']));
		}
		else if ( $mode == 'reply' )
		{
			if ( $weblog_data['replies_auth'] > $auth_level || $entry_data['no_replies'] )
			{
				message_die(GENERAL_ERROR, $lang['Reply_no_auth']);
			}
			// Get max reply id
			$sql = "SELECT MAX(reply_id) AS maximum FROM " . WEBLOG_REPLIES_TABLE;
			if ( !($result = $db->sql_query($sql)) )
			{
				message_die(GENERAL_ERROR, 'Could not query maximum reply id in database', '', __LINE__, __FILE__, $sql);
			}

			$maximum = 0;
			if ( $row = $db->sql_fetchrow($result) )
			{
				$maximum = $row['maximum'];
			}

			$maximum++;

			$sql = "INSERT INTO " . WEBLOG_REPLIES_TABLE . " (reply_id, entry_id, poster_id, post_time, post_username, enable_bbcode, enable_smilies, enable_sig, reply_text, bbcode_uid)
					VALUES ($maximum, $entry_id, " . $userdata['user_id'] . ", " . time() . ", '" . str_replace("\'", "''", $username) . "', $bbcode_on, $smilies_on, $attach_sig, '" . str_replace("\'", "''", $message) . "', '$bbcode_uid')";
			if ( !($result = $db->sql_query($sql)) )
			{
				message_die(GENERAL_ERROR, 'Could not insert reply into database', '', __LINE__, __FILE__, $sql);
			}
                        // Sobytie
                        add_sobytie($entry_id, 'weblog_comment', '', '', '', $userdata['user_id'], $userdata['username'], $entry_id, $message, time());
	                // Sobytie
	                
			// Also update the weblog entries' data
			$sql = "UPDATE " . WEBLOG_ENTRIES_TABLE . "
				SET entry_replies = entry_replies + 1, entry_last_post_id = $maximum, entry_last_post_userid = " . $userdata['user_id'] . "
				WHERE entry_id = $entry_id";
			if( !$result = $db->sql_query($sql) )
			{
				message_die(GENERAL_ERROR, "Couldn't update entry information.", "", __LINE__, __FILE__, $sql);
			}

			// Set a cookie for this reply
			$tracking_entries = ( !empty($HTTP_COOKIE_VARS[$board_config['cookie_name'] . '_e']) ) ? unserialize($HTTP_COOKIE_VARS[$board_config['cookie_name'] . '_e']) : array();
			$tracking_weblogs = ( !empty($HTTP_COOKIE_VARS[$board_config['cookie_name'] . '_w']) ) ? unserialize($HTTP_COOKIE_VARS[$board_config['cookie_name'] . '_w']) : array();

			if ( count($tracking_entries) + count($tracking_weblogs) == 100 && empty($tracking_entries[$entry_id]) )
			{
				asort($tracking_entries);
				unset($tracking_entries[key($tracking_entries)]);
			}

			$tracking_entries[$entry_id] = time();

			setcookie($board_config['cookie_name'] . '_e', serialize($tracking_entries), 0, $board_config['cookie_path'], $board_config['cookie_domain'], $board_config['cookie_secure']);

			if ( $popup )
			{
				//
				// Include page header
				//
				include($phpbb_root_path . 'includes/page_header.'.$phpEx);

				$template->assign_vars(array(
					'MESSAGE_TITLE' => $lang['Information'],
					'MESSAGE_TEXT' => $lang['Reply_submitted'] . '<br /><a href="javascript:window.close();">' . $lang['Close_window'] . '</a>')
				);

				$template->set_filenames(array(
					'body' => 'message_body.tpl')
				);

				$template->pparse('body');

				// Script will exit here
				include($phpbb_root_path . 'includes/page_tail.'.$phpEx);
			}

			$template->assign_vars(array(
				'META' => '<meta http-equiv="refresh" content="3;url=' . append_sid("weblog_entry.$phpEx?" . POST_ENTRY_URL . "=$entry_id") . '">')
			);

			message_die (GENERAL_MESSAGE, $lang['Reply_submitted'] . '<br />' . sprintf($lang['Click_return_entry'], '<a href="' . append_sid("weblog_entry.$phpEx?" . POST_ENTRY_URL . "=" . $entry_id) . '">', '</a>') . '<br /><br />' . sprintf($lang['Click_return_weblog'], '<a href="' . append_sid("weblog.$phpEx?" . POST_WEBLOG_URL . "=" . $weblog_data['weblog_id']) . '">', '</a>', $weblog_data['weblog_name']));
		}
	}

	message_die(GENERAL_ERROR, $lang['No_mode_specified']);
}
//
// Handle all other requests (e.g. deleting replies or entries, editing an entry/reply needs to replace variables)
//
if ( $mode == 'editentry' )
{
	if ( $weblog_data['weblog_id'] != $userdata['user_weblog'] && !$contributor )
	{
		message_die (GENERAL_ERROR, $lang['No_edit_entries']);
	}

	$message = $entry_data['entry_text'];

	$message = preg_replace('/\:(([a-z0-9]:)?)' . $entry_data['bbcode_uid'] . '/s', '', $message);
	$message = str_replace('<', '&lt;', $message);
	$message = str_replace('>', '&gt;', $message);
	$message = str_replace('<br />', "\n", $message);

	$subject = $entry_data['entry_subject'];
	$mood = $entry_data['entry_mood'];
	$action = $entry_data['entry_currently'];
	
	$category_id = $entry_data['category_id'];
	
	$entry_access = $entry_data['entry_access'];
	$memorable = $entry_data['memorable'];
	$disable_replies = $entry_data['no_replies'];
	$bbcode_on = $entry_data['enable_bbcode'];
	$smilies_on = $entry_data['enable_smilies'];
	$title = $lang['Edit_entry'];
	$template->assign_block_vars('switch_post_entry', array());
}
else if ( $mode == 'editreply' )
{
	if ( $weblog_data['replies_auth'] > $auth_level )
	{
		message_die(GENERAL_ERROR, $lang['Reply_no_auth']);
	}

	$message = $reply_data['reply_text'];
	$subject = $reply_data['post_subject'];
	$bbcode_on = $reply_data['enable_bbcode'];
	$smilies_on = $reply_data['enable_smilies'];
	$attach_sig = $reply_data['enable_sig'];

	$message = preg_replace('/\:(([a-z0-9]:)?)' . $reply_data['bbcode_uid'] . '/s', '', $message);
	$message = str_replace('<', '&lt;', $message);
	$message = str_replace('>', '&gt;', $message);
	$message = str_replace('<br />', "\n", $message);

	// Everything else okay
	$template->assign_vars(array(
		'S_POST_ACTION' => ( $popup ) ? append_sid("weblog_posting.$phpEx?mode=newentry&amp;" . POST_WEBLOG_URL . "=$weblog_id&amp;popup=1") : append_sid("weblog_posting.$phpEx?mode=newentry&amp;" . POST_WEBLOG_URL . "=$weblog_id"))
	);

	$title = $lang['Edit_reply'];

	$template->assign_block_vars('switch_post_reply', array());
}
else if ( $mode == 'delete' )
{
	if ( $weblog_data['weblog_id'] == $userdata['user_weblog'] || $userdata['user_level'] == ADMIN )
	{
		if ( $confirm )
		{
			if ( $reply_id )
			{
				// Delete the reply
				$sql = "DELETE FROM " . WEBLOG_REPLIES_TABLE . " WHERE reply_id = $reply_id";
				if ( !($result = $db->sql_query($sql)) )
				{
					message_die(GENERAL_ERROR, 'Could not delete reply.', '', __LINE__, __FILE__, $sql);
				}

				// Also find and set the new last reply id
				$sql = "SELECT * FROM " . WEBLOG_REPLIES_TABLE . " WHERE entry_id = " . $entry_data['entry_id'] . " ORDER BY post_time DESC LIMIT 1";
				if( !$result = $db->sql_query($sql) )
				{
					message_die(GENERAL_ERROR, "Couldn't query entry replies information.", "", __LINE__, __FILE__, $sql);
				}

				if ( $row = $db->sql_fetchrow($result) )
				{
					$last_reply_id = $row['reply_id'];
				}
				else
				{
					$last_reply_id = 0;
				}

				// Successful, so decrement the replies count and set the new last reply id
				$sql = "UPDATE " . WEBLOG_ENTRIES_TABLE . "
					SET entry_replies = entry_replies - 1, entry_last_post_id = $last_reply_id
					WHERE entry_id = " . $entry_data['entry_id'];
				if( !$result = $db->sql_query($sql) )
				{
					message_die(GENERAL_ERROR, "Couldn't update weblog views information.", "", __LINE__, __FILE__, $sql);
				}

				$template->assign_vars(array(
					'META' => '<meta http-equiv="refresh" content="3;url=' . append_sid("weblog_entry.$phpEx?" . POST_ENTRY_URL . "=$entry_id") . '">')
				);

				message_die (GENERAL_MESSAGE, $lang['Reply_deleted'] . '<br />' . sprintf($lang['Click_return_entry'], '<a href="' . append_sid("weblog_entry.$phpEx?" . POST_ENTRY_URL . "=" . $entry_data['entry_id']) . '">', '</a>') . '<br /><br />' . sprintf($lang['Click_return_weblog'], '<a href="' . append_sid("weblog.$phpEx?" . POST_WEBLOG_URL . "=" . $weblog_data['weblog_id']) . '">', '</a>', $weblog_data['weblog_name']));
			}
			else if ( $entry_id )
			{
				$sql = "DELETE FROM " . WEBLOG_ENTRIES_TABLE . " WHERE entry_id = $entry_id";	
				if ( !($result = $db->sql_query($sql)) )
				{
					message_die(GENERAL_ERROR, 'Could not delete entry.', '', __LINE__, __FILE__, $sql);
				}

				// Also find and set the new last reply id
				$sql = "SELECT * FROM " . WEBLOG_ENTRIES_TABLE . " WHERE weblog_id = " . $weblog_data['weblog_id'] . " ORDER BY entry_time DESC LIMIT 1";
				if( !$result = $db->sql_query($sql) )
				{
					message_die(GENERAL_ERROR, "Couldn't query entries information.", "", __LINE__, __FILE__, $sql);
				}

				$last_entry_id = 0;
				if ( $row = $db->sql_fetchrow($result) )
				{
					$last_entry_id = $row['entry_id'];
				}

				// Successful, so decrement the entries count
				$sql = "UPDATE " . WEBLOGS_TABLE . "
					SET weblog_entries = weblog_entries - 1
					WHERE weblog_id = " . $weblog_data['weblog_id'];
				if( !$result = $db->sql_query($sql) )
				{
					message_die(GENERAL_ERROR, "Couldn't update weblog views information.", "", __LINE__, __FILE__, $sql);
				}

				$template->assign_vars(array(
					'META' => '<meta http-equiv="refresh" content="3;url=' . append_sid("weblog.$phpEx?" . POST_WEBLOG_URL . "=$weblog_id") . '">')
				);

				message_die (GENERAL_MESSAGE, $lang['Entry_deleted'] . '<br />' . sprintf($lang['Click_return_weblog'], '<a href="' . append_sid("weblog.$phpEx?" . POST_WEBLOG_URL . "=" . $weblog_data['weblog_id']) . '">', '</a>', $weblog_data['weblog_name']));
			}
			else
			{
				message_die(GENERAL_MESSAGE, $lang['Delete_not_specified']);
			}
		}
		else
		{
			$hidden_fields = '<input type="hidden" name="sid" value="' . $userdata['session_id'] . '" /><input type="hidden" name="mode" value="' . $mode . '" />';

			if ( $reply_id )
			{
				$hidden_fields .= '<input type="hidden" name="' . POST_REPLY_URL . '" value="' . $reply_id . '" />';
				$lang_confirm_delete = $lang['Confirm_delete_reply'];
			}
			else if ( $entry_id )
			{
				$hidden_fields .= '<input type="hidden" name="' . POST_ENTRY_URL . '" value="' . $entry_id . '" />';
				$lang_confirm_delete = $lang['Confirm_delete_entry'];
			}

			//
			// Include page header
			//
			include($phpbb_root_path . 'includes/page_header.'.$phpEx);
			
			//
			// Set template files
			//
			$template->set_filenames(array(
				'body' => 'confirm_body.tpl')
			);

			$template->assign_vars(array(
				'MESSAGE_TITLE' => $lang['Confirm'],
				'MESSAGE_TEXT' => $lang_confirm_delete,

				'L_YES' => $lang['Yes'],
				'L_NO' => $lang['No'],

				'S_CONFIRM_ACTION' => append_sid("weblog_posting.$phpEx"),
				'S_HIDDEN_FIELDS' => $hidden_fields)
			);

			$template->pparse('body');

			$template->assign_vars(array(
				'L_POWERED_BY' => sprintf($lang['Weblog_powered_by'], WEBLOGS_MOD_VERSION))
			);

			include($phpbb_root_path . 'includes/page_tail.'.$phpEx);

		}
	}
	else
	{
		message_die (GENERAL_ERROR, $lang['Delete_not_authed']);
	}
}
else if ( $mode == 'newentry' )
{
	if ( $weblog_data['weblog_id'] != $userdata['user_weblog'] && !$contributor )
	{
		message_die (GENERAL_ERROR, $lang['Entry_add_not_authed']);
	}
	$title = $lang['New_entry'];
	$entry_access = $weblog_data['weblog_auth'];

	$template->assign_block_vars('switch_post_entry', array());
}
else if ( $mode == 'reply' )
{
	if ( $weblog_data['replies_auth'] > $auth_level || $entry_data['no_replies'] )
	{
		message_die(GENERAL_ERROR, $lang['Reply_no_auth']);
	}

	$title = $lang['Post_reply'];

	$template->assign_block_vars('switch_post_reply', array());
}
else if ( $mode == 'quote' )
{
	if ( $weblog_data['replies_auth'] > $auth_level || $entry_data['no_replies'] )
	{
		message_die(GENERAL_ERROR, $lang['Reply_no_auth']);
	}

	$title = $lang['Post_reply'];

	$message = $reply_data['reply_text'];

	$message = preg_replace('/\:(([a-z0-9]:)?)' . $reply_data['bbcode_uid'] . '/s', '', $message);
	$message = str_replace('<', '&lt;', $message);
	$message = str_replace('>', '&gt;', $message);
	$message = str_replace('<br />', "\n", $message);

	$sql = "SELECT username FROM " . USERS_TABLE . " WHERE user_id = " . $reply_data['poster_id'];
	if ( !($result = $db->sql_query($sql)) )
	{
		message_die(GENERAL_ERROR, "Could not obtain user information", '', __LINE__, __FILE__, $sql);
	}

	if ( $row = $db->sql_fetchrow($result) )
	{
		$quote_user = $row['username'];
	}

	$message = '[quote="' . $quote_user . '"]' . $message . '[/quote]';

	$mode = 'reply';

	$template->assign_block_vars('switch_post_reply', array());

}
else
{
	message_die(GENERAL_ERROR, $lang['No_mode_specified']);
}


$sql = "SELECT *
	FROM " . WEBLOG_MOODS_TABLE . "
	ORDER BY mood_text";
if( !$result = $db->sql_query($sql) )
{
	message_die(GENERAL_ERROR, "Couldn't obtain mood data from database", "", __LINE__, __FILE__, $sql);
}
$mood_data = $db->sql_fetchrowset($result);


$sql = "SELECT *
	FROM " . WEBLOG_ACTIONS_TABLE . "
	ORDER BY action_text";
if( !$result = $db->sql_query($sql) )
{
	message_die(GENERAL_ERROR, "Couldn't obtain action data from database", "", __LINE__, __FILE__, $sql);
}
$action_data = $db->sql_fetchrowset($result);


$sql = "SELECT * FROM " . $table_prefix . "blog_categories"; 
if ( !($result = $db->sql_query($sql)) ) 
{ 
    message_die(GENERAL_ERROR, 'Error getting category information', '', __LINE__, __FILE__, $sql); 
} 
$category_data = array(); 
while ( $row = $db->sql_fetchrow($result) ) 
{ 
      $category_data[] = $row; 
} 
//
// Signature toggle selection
//
if( !empty($userdata['user_sig']) && $userdata['user_weblog'] == $weblog_data['weblog_id'] || $contributor )
{
	$template->assign_block_vars('switch_signature_checkbox', array());
}

//
// BBCode toggle selection
//
if ( $board_config['allow_bbcode'] )
{
	$bbcode_status = $lang['BBCode_is_ON'];
	$template->assign_block_vars('switch_bbcode_checkbox', array());
}
else
{
	$bbcode_status = $lang['BBCode_is_OFF'];
}

//
// Smilies toggle selection
//
if ( $board_config['allow_smilies'] )
{
	$smilies_status = $lang['Smilies_are_ON'];
	$template->assign_block_vars('switch_smilies_checkbox', array());
}
else
{
	$smilies_status = $lang['Smilies_are_OFF'];
}

if ( !$popup )
{
	$template->assign_block_vars('switch_not_popup', array());
}
else
{
	$template->assign_block_vars('switch_is_popup', array());
}

if( !$userdata['session_logged_in'] )
{
	$template->assign_block_vars('switch_username_select', array());
}

if ( $popup )
{
	$hidden_form_fields .= '<input type="hidden" name="popup" value="1" />';
}

$hidden_form_fields .= '<input type="hidden" name="mode" value="' . $mode . '" />';

if ( $mode == 'newentry' || $mode == 'editentry' )
{
	//
	// Handle pictures that were already uploaded
	//

	$script_name = preg_replace('/^\/?(.*?)\/?$/', '\1', trim($board_config['script_path']));
	$script_name = ( $script_name != '' ) ? $script_name . '/' : '';
	$server_name = trim($board_config['server_name']);
	$server_protocol = ( $board_config['cookie_secure'] ) ? 'https://' : 'http://';
	$server_port = ( $board_config['server_port'] <> 80 ) ? ':' . trim($board_config['server_port']) . '/' : '/';

	$server_url = $server_protocol . $server_name . $server_port . $script_name;

}

switch( $mode )
{
	case 'newentry':
		$page_title = $weblog_data['weblog_name'] . ' :: ' . $lang['New_entry'];
		$hidden_form_fields .= '<input type="hidden" name="' . POST_WEBLOG_URL . '" value="' . $weblog_id . '" />';
		break;

	case 'reply':
		$page_title = $weblog_data['weblog_name'] . ' :: ' . $lang['Post_reply'];
		$hidden_form_fields .= '<input type="hidden" name="' . POST_ENTRY_URL . '" value="' . $entry_id . '" />';
		break;

	case 'editentry':
		$page_title = $weblog_data['weblog_name'] . ' :: ' . $lang['Edit_entry'];
		$hidden_form_fields .= '<input type="hidden" name="' . POST_ENTRY_URL . '" value="' . $entry_id . '" />';
		break;

	case 'editreply':
		$page_title = $weblog_data['weblog_name'] . ' :: ' . $lang['Edit_reply'];
		$hidden_form_fields .= '<input type="hidden" name="' . POST_REPLY_URL . '" value="' . $reply_id . '" />';
		break;
}

// Generate smilies listing for page output

//
// Include page header
//
include($phpbb_root_path . 'includes/page_header.'.$phpEx);

$template->set_filenames(array(
	'body' => 'blog/posting_body.tpl')
);

$mood = find_mood ($mood);
$action = find_action ($action);

//
// Output the data to the template
//
$template->assign_vars(array(
	'ENTRY_SUBJECT' => strip_tags(htmlspecialchars($entry_subject)),
	'ENTRY_TIME' => create_date($board_config['default_dateformat'], $entry_data['entry_time'], $board_config['board_timezone']),
	'ENTRY' => $entry_message,
	'USERNAME' => $username,
	'SUBJECT' => $subject,
	'MESSAGE' => $message,
	'ENTRY_AUTH_SELECT' => make_weblog_auth_select ( $entry_access, 'entry_access' ),
	'SELECT_MOOD' => make_mood_select( $mood['mood_id'], 'mood', TRUE ),
	'ACTION_SELECT' => make_action_select( $action['action_id'], 'action', TRUE ),
	'CATEGORY_SELECT' => make_category_select ($category_id, 'category_id', $category_data),
	'MOOD_IMG' => ( $mood['mood_id'] > 0 ) ? $mood['mood_url'] : 'mood_none.gif',
	'ACTION_IMG' => ( $action['action_id'] > 0 ) ? $action['action_url'] : 'action_none.gif',
	'BBCODE_STATUS' => sprintf($bbcode_status, '<a href="' . append_sid("faq.$phpEx?mode=bbcode") . '" target="_phpbbcode">', '</a>'), 
	'SMILIES_STATUS' => $smilies_status, 
	'MODE' => $title,
	'MOD_VERSION' => $mod_version,
	'WEBLOG_NAME' => strip_tags($weblog_data['weblog_name']),
	'DATE_SELECT' => make_date_select($year, $month, $day),	
	'CLOSE_WINDOW' => ( $popup ) ? ' onclick="window.close()"' : '',
	'U_WEBLOG' => append_sid("weblog.$phpEx?" . POST_WEBLOG_URL . "=" . $weblog_data['weblog_id']),
	'U_ENTRY' => append_sid("weblog_entry.$phpEx?" . POST_ENTRY_URL . "=$entry_id"),	
	'L_FILENAME' => $lang['Filename'],
	'L_BBCODE' => $lang['BBCode'],		
	'L_ACTION' => $lang['Currently'],
	'L_CATEGORY' => $lang['Category'],
	'L_MOOD' => $lang['Mood'],
	'L_DISABLE_REPLIES' => $lang['Disable_replies'],
	'L_ENTRY_ACCESS' => $lang['Entry_auth'],
	'L_SUBJECT' => $lang['Subject'],
	'L_MESSAGE_BODY' => $lang['Message_body'],
	'L_OPTIONS' => $lang['Options'],
	'L_PREVIEW' => $lang['Preview'],
	'L_SPELLCHECK' => $lang['Spellcheck'],
	'L_SUBMIT' => $lang['Submit'],
	'L_CANCEL' => $lang['Cancel'], 
	'L_DISABLE_BBCODE' => $lang['Disable_BBCode_post'], 
	'L_DISABLE_SMILIES' => $lang['Disable_Smilies_post'], 
	'L_ATTACH_SIGNATURE' => $lang['Attach_signature'], 
	'L_NOTIFY_ON_REPLY' => $lang['Notify'], 
	'L_MEMORABLE_ENTRY' => $lang['Memorable_entry'],
        'L_ENTRY_NO_REPLIES' => $lang['Entry_no_replies'],
	'L_REPLIES_DISABLED' => $lang['Replies_disabled'],
	'L_GO' => $lang['Go'],
	'L_AUTHOR' => $lang['Author'],
	'L_MESSAGE' => $lang['Message'],		 
	'L_STYLES_TIP' => $lang['Styles_tip'], 
	'S_BBCODE_CHECKED' => ( !$bbcode_on ) ? 'checked="checked"' : '',
	'S_SMILIES_CHECKED' => ( !$smilies_on ) ? 'checked="checked"' : '',
	'S_SIGNATURE_CHECKED' => ( $attach_sig ) ? 'checked="checked"' : '',
	'S_MEMORABLE_CHECKED' => ( $memorable ) ? 'checked="checked"' : '',
	'S_DISABLE_REPLIES_CHECKED' => ( $disable_replies ) ? 'checked="checked"' : '',
	'S_POST_ACTION' => append_sid("weblog_posting.$phpEx"),
	'S_HIDDEN_FORM_FIELDS' => $hidden_form_fields)
);

$template->pparse('body');

include($phpbb_root_path . 'includes/page_tail.'.$phpEx);

?>