<?php
/***************************************************************************
 *                            weblog_friends.php
 *                         ------------------------
 *   Anv@r.all 2010
 *   (C) apwa.ru
 *
 ***************************************************************************/


define('IN_PHPBB', true);
$phpbb_root_path = './';
include($phpbb_root_path . 'extension.inc');
include($phpbb_root_path . 'common.'.$phpEx);
include($phpbb_root_path . 'includes/bbcode.'.$phpEx);
include($phpbb_root_path . 'includes/weblogs_common.'.$phpEx);
include($phpbb_root_path . 'includes/functions_weblog.'.$phpEx);

//
// Start initial var setup
//
if( isset($HTTP_GET_VARS[POST_USERS_URL]) || isset($HTTP_POST_VARS[POST_USERS_URL]) )
{
	$user_id = ( isset($HTTP_GET_VARS[POST_USERS_URL]) ) ? intval($HTTP_GET_VARS[POST_USERS_URL]) : intval($HTTP_POST_VARS[POST_USERS_URL]);
}
else
{
	$user_id = '';
}

$user_exists = FALSE;

//
// Check if the user has actually sent a weblog ID with his/her request
// If not give them a nice error page.
//
if( !empty($user_id) )
{
	$sql = "SELECT u.*, w.*
		FROM " . WEBLOGS_TABLE . " w, " . USERS_TABLE . " u
		WHERE u.user_id = $user_id
			AND w.weblog_id = u.user_weblog";
	if( !$result = $db->sql_query($sql) )
	{
		message_die(GENERAL_ERROR, "Couldn't obtain weblogs information.", "", __LINE__, __FILE__, $sql);
	}
}
else
{
	message_die(GENERAL_MESSAGE, $lang['User_no_weblog']);
}

$weblog_data = array();
//
// If the query doesn't return any rows this isn't a valid weblog. Inform
// the user.
//
if( !($weblog_data = $db->sql_fetchrow($result)) )
{
	message_die(GENERAL_MESSAGE, $lang['User_no_weblog']);
}


if ( $weblog_data['deleted'] )
{
	message_die(GENERAL_ERROR, sprintf($lang['Weblog_deactivated'], $weblog_data['weblog_name']));
}

$weblog_id = $weblog_data['weblog_id'];
$username = $weblog_data['username'];

//
// Start session management
//
$userdata = session_pagestart($user_ip, 10000 + $weblog_id);
init_userprefs($userdata);
//
// End session management
//

//
// Fetch Contributor data
//
$sql = "SELECT * FROM " . WEBLOG_CONTRIBUTORS_TABLE . " WHERE weblog_id = " . $weblog_data['weblog_id'] . " AND user_id = " . $userdata['user_id'];
if ( !($result = $db->sql_query($sql)) )
{
	message_die(GENERAL_ERROR, 'Error querying to find user weblog information', '', __LINE__, __FILE__, $sql);
}

$contributor = FALSE;
if ( $row = $db->sql_fetchrow($result) || $userdata['user_level'] == ADMIN )
{
	$contributor = TRUE;
}

// Get the user's clearence levels
$auth_level = get_auth_level ( $weblog_data, $contributor );

// See if user can see this weblog
if ( $weblog_data['weblog_auth'] > $auth_level )
{
	message_die(GENERAL_ERROR, $lang['Weblog_noaccess']);
}

//
// Check to see if the owner added a friend
//
if ( $weblog_data['weblog_id'] == $userdata['user_weblog'] || $contributor )
{
	$friend = str_replace("\'", "''", ( isset($HTTP_POST_VARS['friend']) ) ? htmlspecialchars($HTTP_POST_VARS['friend']) : '');
	
	if ( isset($HTTP_POST_VARS['addgroup']) || isset($HTTP_POST_VARS['removegroup']) )
	{
		$group_id = ( isset($HTTP_POST_VARS[POST_GROUPS_URL]) ) ? intval($HTTP_POST_VARS[POST_GROUPS_URL]) : 0;
		
		$sql = "SELECT u.username
			FROM " . GROUPS_TABLE . " g, " . USER_GROUP_TABLE . " ug, " . USERS_TABLE . " u
			WHERE ug.user_id = u.user_id
				AND ug.group_id = g.group_id
				AND g.group_id = $group_id
				AND g.group_single_user <> " . TRUE . "
			ORDER BY g.group_name, ug.user_id";
		if ( !($result = $db->sql_query($sql)) )
		{
			message_die(GENERAL_ERROR, 'Error getting group information', '', __LINE__, __FILE__, $sql);
		}

		$selected_friends = array();
		while ( $row = $db->sql_fetchrow($result) )
		{
			$selected_friends[] = $row['username'];
		}
		
		if ( !count($selected_friends) )
		{
			message_die(GENERAL_MESSAGE, $lang['No_groups_exist']);
		}
	}
	else
	{
		$selected_friends = array_unique(explode(',', $friend));
	}
	
	$friend = implode('\', \'', $selected_friends);

	if ( isset($HTTP_POST_VARS['addfriend']) || isset($HTTP_POST_VARS['addgroup']) )
	{
		// Now, attempt to find a user with such a username
		$sql = "SELECT username, user_id FROM " . USERS_TABLE . " WHERE username IN ('" . $friend . "')";
		if( !$result = $db->sql_query($sql) )
		{
			message_die(GENERAL_ERROR, "Couldn't obtain username information.", "", __LINE__, __FILE__, $sql);
		}	

		$users_found = array();
		$friend_ids = array();
		while ( $row = $db->sql_fetchrow($result) )
		{
			$friend_ids[] = $row['user_id'];
			$users_found[] = $row['username'];
		}

		$users_not_found = array_diff($selected_friends, $users_found);
		if ( count($users_not_found) )
		{
			$users_not_found = implode (', ', $users_not_found);
		}
		else
		{
			$users_not_found = $lang['None'];
		}

		if ( count($friend_ids) )
		{
			// See if any users haven't already been added
			$sql = "SELECT f.*, u.username, u.user_id FROM " . WEBLOG_FRIENDS_TABLE . " f, " . USERS_TABLE . " u WHERE f.friend_id IN (" . implode(', ', $friend_ids) . ") AND u.user_id = f.friend_id AND f.owner_id = $user_id ";
			if( !$result = $db->sql_query($sql) )
			{
				message_die(GENERAL_ERROR, "Couldn't obtain friend information.", "", __LINE__, __FILE__, $sql);
			}

			$users_already_friends = array();
			while ( $row = $db->sql_fetchrow($result) )
			{
				$users_already_friends[] = $row['username'];
			}
			
			if ( !count($users_already_friends) )
			{
				$users_already_friends[] = $username;
			}
		
		
			$users_found2 = array_diff($users_found, $users_already_friends);

			$friend = implode('\', \'', $users_found2);
	
			// Now, attempt to find a user with such a username
			$sql = "SELECT username, user_id FROM " . USERS_TABLE . " WHERE username IN ('" . $friend . "')";
			if( !$result = $db->sql_query($sql) )
			{
				message_die(GENERAL_ERROR, "Couldn't obtain username information.", "", __LINE__, __FILE__, $sql);
			}

			$friend_ids = array();
			while ( $row = $db->sql_fetchrow($result) )
			{
				$friend_ids[] = $row['user_id'];
			}
	
			for ( $i = 0; $i < count($friend_ids); $i++ )
			{
				if ( $friend_ids[$i] != $user_id && $friend_ids[$i] != ANONYMOUS )
				{
					// Now insert new friend to friends table
					$sql = "INSERT INTO " . WEBLOG_FRIENDS_TABLE . " (owner_id, friend_id) VALUES ($user_id, " . $friend_ids[$i] . ")";
					if( !($result = $db->sql_query($sql)) )
					{
						message_die(GENERAL_ERROR, "Couldn't obtain insert friend information.", "", __LINE__, __FILE__, $sql);
					}
				}
			}
		}
				
		if ( count($users_already_friends) )
		{
			$users_already_friends = implode (', ', $users_already_friends);
		}
		else
		{
			$users_already_friends = $lang['None'];
		}
		
		if ( count($users_found2) )
		{
			$users_found2 = implode (', ', $users_found2);
		}
		else
		{
			$users_found2 = $lang['None'];
		}

		$template->assign_vars(array(
			'META' => '<meta http-equiv="refresh" content="3;url=' . append_sid("weblog_friends.$phpEx?" . POST_USERS_URL . "=$user_id") . '">')
		);
	
		message_die (GENERAL_MESSAGE, sprintf($lang['Friends_added'], $users_found2) . '<br />' . sprintf($lang['Friends_already_added'], $users_already_friends) . '<br />' . sprintf($lang['Users_not_exist'], $users_not_found) . '<br /><br />' . sprintf($lang['Click_return_friends'], '<a href="' . append_sid("weblog_friends.$phpEx?" . POST_USERS_URL . "=$user_id") . '">', '</a>') . '<br /><br />' . sprintf($lang['Click_return_weblog'], '<a href="' . append_sid("weblog.$phpEx?" . POST_WEBLOG_URL . "=" . $weblog_data['weblog_id']) . '">', '</a>', $weblog_data['weblog_name']));
	}
	else if ( isset($HTTP_POST_VARS['removeuser']) || isset($HTTP_POST_VARS['removegroup']) )
	{

		// Now, attempt to find a user with such a username
		$sql = "SELECT username, user_id FROM " . USERS_TABLE . " WHERE username IN ('" . $friend . "')";
		if( !$result = $db->sql_query($sql) )
		{
			message_die(GENERAL_ERROR, "Couldn't obtain username information.", "", __LINE__, __FILE__, $sql);
		}	

		$users_found = array();
		$friend_ids = array();
		while ( $row = $db->sql_fetchrow($result) )
		{
			$friend_ids[] = $row['user_id'];
			$users_found[] = $row['username'];
		}

		$users_not_found = array_diff($selected_friends, $users_found);
		if ( count($users_not_found) )
		{
			$users_not_found = implode (', ', $users_not_found);
		}
		else
		{
			$users_not_found = $lang['None'];
		}

		// See if any users haven't already been removed
		$sql = "SELECT f.*, u.username, u.user_id FROM " . WEBLOG_FRIENDS_TABLE . " f, " . USERS_TABLE . " u WHERE f.friend_id IN (" . implode(', ', $friend_ids) . ") AND u.user_id = f.friend_id AND f.owner_id = $user_id ";
		if( !$result = $db->sql_query($sql) )
		{
			message_die(GENERAL_ERROR, "Couldn't obtain friend information.", "", __LINE__, __FILE__, $sql);
		}

		$users_already_friends = array();
		while ( $row = $db->sql_fetchrow($result) )
		{
			$users_already_friends[] = $row['username'];
		}

		$users_found2 = array_diff($users_found, $users_already_friends);
		if ( count($users_found2) )
		{
			$users_found2 = implode (', ', $users_found2);
		}
		else
		{
			$users_found2 = $lang['None'];
		}

		$friend = implode('\', \'', $users_already_friends);
	
		// Now, attempt to find a user with such a username
		$sql = "SELECT username, user_id FROM " . USERS_TABLE . " WHERE username IN ('" . $friend . "')";
		if( !$result = $db->sql_query($sql) )
		{
			message_die(GENERAL_ERROR, "Couldn't obtain username information.", "", __LINE__, __FILE__, $sql);
		}

		$friend_ids = array();
		while ( $row = $db->sql_fetchrow($result) )
		{
			$friend_ids[] = $row['user_id'];
		}
	
		// Now delete the chosen "friends" from the friends table
		$sql = "DELETE FROM " . WEBLOG_FRIENDS_TABLE . " WHERE friend_id IN (" . implode(', ', $friend_ids) . ")  AND owner_id = $user_id";
		if( !($result = $db->sql_query($sql)) )
		{
			message_die(GENERAL_ERROR, "Couldn't delete friend information.", "", __LINE__, __FILE__, $sql);
		}

		if ( count($users_already_friends) )
		{
			$users_already_friends = implode (', ', $users_already_friends);
		}
		else
		{
			$users_already_friends = $lang['None'];
		}

		$template->assign_vars(array(
			'META' => '<meta http-equiv="refresh" content="3;url=' . append_sid("weblog_friends.$phpEx?" . POST_USERS_URL . "=$user_id") . '">')
		);
	
		message_die (GENERAL_MESSAGE, sprintf($lang['Friends_removed'], $users_already_friends) . '<br />' . sprintf($lang['Users_not_friends'], $users_found2) . '<br />' . sprintf($lang['Users_not_exist'], $users_not_found) . '<br /><br />' . sprintf($lang['Click_return_friends'], '<a href="' . append_sid("weblog_friends.$phpEx?" . POST_USERS_URL . "=$user_id") . '">', '</a>') . '<br /><br />' . sprintf($lang['Click_return_weblog'], '<a href="' . append_sid("weblog.$phpEx?" . POST_WEBLOG_URL . "=" . $weblog_data['weblog_id']) . '">', '</a>', $weblog_data['weblog_name']));
	}
}

$page_title = $weblog_data['weblog_name'] . ' :: ' . sprintf($lang['Friends'], $weblog_data['username']);
//
// Start output of page
include($phpbb_root_path . 'includes/page_header.'.$phpEx);

$template->set_filenames(array(
	'body' => 'blog/friends_body.tpl')
);

//
// Get the moods data
//
$sql = "SELECT *
	FROM " . WEBLOG_MOODS_TABLE . "
	ORDER BY mood_text";
if( !$result = $db->sql_query($sql) )
{
	message_die(GENERAL_ERROR, "Couldn't obtain mood data from database", "", __LINE__, __FILE__, $sql);
}
$mood_data = $db->sql_fetchrowset($result);

//
// Get the actions data
//
$sql = "SELECT *
	FROM " . WEBLOG_ACTIONS_TABLE . "
	ORDER BY action_text";
if( !$result = $db->sql_query($sql) )
{
	message_die(GENERAL_ERROR, "Couldn't obtain action data from database", "", __LINE__, __FILE__, $sql);
}
$action_data = $db->sql_fetchrowset($result);

//
// Get a list of usergroups
//
$sql = "SELECT group_id, group_name, group_type
	FROM " . GROUPS_TABLE . " g 
	WHERE group_single_user <> " . TRUE . " 
	ORDER BY g.group_name";
if ( !($result = $db->sql_query($sql)) )
{
	message_die(GENERAL_ERROR, 'Error getting group information', '', __LINE__, __FILE__, $sql);
}

$s_group_select = '<select name="' . POST_GROUPS_URL . '">';
while ( $row = $db->sql_fetchrow($result) )
{
	if  ( $row['group_type'] != GROUP_HIDDEN || $userdata['user_level'] == ADMIN )
	{
		$s_group_select .='<option value="' . $row['group_id'] . '">' . $row['group_name'] . '</option>';
	}
}
$s_group_select .= '</select>';

//
// Get this user's friends data
//
$sql = "SELECT f.friend_id, u.*, w.* 
		FROM " . WEBLOG_FRIENDS_TABLE . " f, " . USERS_TABLE . " u, " . WEBLOGS_TABLE . " w
		WHERE f.owner_id = $user_id
			AND f.friend_id = u.user_id
			AND w.weblog_id = u.user_weblog";
if( !$result = $db->sql_query($sql) )
{
	message_die(GENERAL_ERROR, "Couldn't obtain friends information.", "", __LINE__, __FILE__, $sql);
}

$friend_data = array();
while ( $row = $db->sql_fetchrow($result) )
{
	$friend_data[] = $row;
}

for ( $i = 0; $i < count($friend_data); $i++ )
{
	$auth_level2 = get_auth_level ( $friend_data[$i], FALSE, $friends_data, $blocked_data );

	$friend_entry_data = array();
	if ( $friend_data[$i]['weblog_auth'] <= $auth_level2 )
	{
		// Do a second query to find the latest entry, replies, etc.
		$sql = "SELECT * FROM " . WEBLOG_ENTRIES_TABLE . "
				WHERE weblog_id = " . $friend_data[$i]['weblog_id'] . "
					AND entry_access <= $auth_level2
				ORDER BY entry_time DESC
				LIMIT 1";
		if( !$result = $db->sql_query($sql) )
		{
			message_die(GENERAL_ERROR, "Couldn't obtain friends entry information.", "", __LINE__, __FILE__, $sql);
		}

		if ( $row = $db->sql_fetchrow($result) )
		{
			$friend_entry_data = $row;
		}

		//
		// Ok now prepare the data and output it
		//

		// Prepare Avatar Image
		$avatar_img = '';
		if ( $friend_data[$i]['user_avatar_type'] && $friend_data[$i]['user_allowavatar'] )
		{
			switch( $friend_data[$i]['user_avatar_type'] )
			{
				case USER_AVATAR_UPLOAD:
					$avatar_img = ( $board_config['allow_avatar_upload'] ) ? '<img src="' . $board_config['avatar_path'] . '/' . $friend_data[$i]['user_avatar'] . '" alt="" border="0" />' : '';
					break;
				case USER_AVATAR_REMOTE:
					$avatar_img = ( $board_config['allow_avatar_remote'] ) ? '<img src="' . $friend_data[$i]['user_avatar'] . '" alt="" border="0" />' : '';
					break;
				case USER_AVATAR_GALLERY:
					$avatar_img = ( $board_config['allow_avatar_local'] ) ? '<img src="' . $board_config['avatar_gallery_path'] . '/' . $friend_data[$i]['user_avatar'] . '" alt="" border="0" />' : '';
					break;
			}
		}

		//
		// Prepare the latest entry
		//
		$friend_entry_data['entry_text'] = htmlspecialchars($friend_entry_data['entry_text']);
		$friend_entry_data['entry_text'] = hide_cuts ($friend_entry_data['entry_text']);

		// BBCode
		if ( $friend_entry_data['enable_bbcode'] )
		{
			$friend_entry_data['entry_text'] = bbencode_second_pass($friend_entry_data['entry_text'], $friend_entry_data['bbcode_uid']);
		}
	
		// Smilies
		if ( $friend_entry_data['enable_smilies'] )
		{
			$friend_entry_data['entry_text'] = smilies_pass($friend_entry_data['entry_text']);
		}
	
		$friend_entry_data['entry_text'] = make_clickable($friend_entry_data['entry_text']);
	
		if ( $weblog_config['censor_weblog'] )
		{
			// Define censored word matches
			$orig_word = array();
			$replacement_word = array();
			obtain_word_list($orig_word, $replacement_word);
	
			// Censor text and title
			if (count($orig_word))
			{
				$friend_entry_data['entry_subject'] = preg_replace($orig_word, $replacement_word, $friend_entry_data['entry_subject']);
				$friend_entry_data['entry_text'] = preg_replace($orig_word, $replacement_word, $friend_entry_data['entry_text']);
				$friend_entry_data['currently_text'] = preg_replace($orig_word, $replacement_word, $friend_entry_data['currently_text']);
			}
		}

		$friend_entry_data['entry_text'] = nl2br($friend_entry_data['entry_text']);
		$friend_entry_data['entry_text'] = undo_htmlspecialchars($friend_entry_data['entry_text']);

		// Mood Icons
		$mood = array();
		$mood = find_mood($friend_entry_data['entry_mood']);

		if ( $mood >= 0 )
		{ 
			$mood = '[&nbsp;' . sprintf($lang['Mood:'], '<img src="images/weblogs/' . $mood['mood_url'] . '" alt="" border="0" />', $mood['mood_text']) . '&nbsp;]';
		}
		else
		{
			$mood = '';
		}

		// Currently Icons
		$currently = array();
		$currently = find_action($friend_entry_data['entry_currently']);

		if ( $currently > 0 )
		{
			$action = '[&nbsp;' . sprintf($lang['Currently:'], '<img src="images/weblogs/' . $currently['action_url'] . '" alt="" border="0"/>', $action['action_text']) . '&nbsp;]';
		}
		else
		{
			$action = '';
		}
		 
		$time = create_date($board_config['default_dateformat'], $friend_entry_data['entry_time'], $board_config['board_timezone']);

		$template->assign_block_vars('friendsrow', array(
			'ID' => 'friend' . $i,			
			'AVATAR_IMG' => $avatar_img,
			'U_WEBLOG' => append_sid("weblog.$phpEx?" . POST_WEBLOG_URL . "=" . $friend_data[$i]['weblog_id']),
			'WEBLOG_NAME' => strip_tags($friend_data[$i]['weblog_name']),
			'U_PROFILE' => append_sid("profile.$phpEx?mode=viewprofile&amp;" . POST_USERS_URL . "=" . $friend_data[$i]['user_id']),
			'FRIEND' => $friend_data[$i]['username'],
			'SUBJECT' => strip_tags(htmlspecialchars($friend_entry_data['entry_subject'])),
			'ENTRY' => ( $friend_entry_data['entry_text'] ) ? $friend_entry_data['entry_text'] : '(' . $lang['No_entries'] . ')',
			'TIME_DATE' => ( $friend_entry_data['entry_time'] ) ? $time : '',
			'MOOD' => $mood,
			'CURRENTLY' => $action,
			'POST_COMMENT' => ( !$friend_entry_data['no_replies'] && $friend_entry_data['entry_text'] ) ? sprintf(strip_tags($friend_data[$i]['post_reply_text']), $friend_entry_data['entry_replies']) : '',
			'REPLIES' => ( !$friend_entry_data['no_replies'] && $friend_entry_data['entry_text'] ) ? sprintf(strip_tags($friend_data[$i]['replies_text']), $friend_entry_data['entry_replies']) : '',
			'U_VIEW_COMMENTS' => ( !$friend_entry_data['no_replies'] ) ? append_sid('weblog_entry.' . $phpEx . '?' . POST_ENTRY_URL . '=' . $friend_entry_data['entry_id']) : '',
			'U_POST_COMMENT' => ( !$friend_entry_data['no_replies'] ) ? append_sid('weblog_posting.' . $phpEx . '?mode=reply&amp;' . POST_ENTRY_URL . '=' . $friend_entry_data['entry_id']) : '')
		);
	}
}

//
// Query the users who have this user as a friend
//
$sql = "SELECT u.username, u.user_id FROM " . WEBLOG_FRIENDS_TABLE . " f, " . USERS_TABLE . " u
	WHERE u.user_id = f.owner_id
		AND f.friend_id = $user_id";
if( !$result = $db->sql_query($sql) )
{
	message_die(GENERAL_ERROR, "Couldn't get friend of information.", "", __LINE__, __FILE__, $sql);
}
	
while ( $row = $db->sql_fetchrow($result) )
{
	$template->assign_block_vars('friendofrow', array(
		'U_PROFILE' => append_sid("profile.$phpEx?mode=viewprofile&amp;" . POST_USERS_URL . "=" . $row['user_id']),
		'FRIEND' => $row['username'])
	);
}

//
// Query the users who this user has added as a friend
//
$sql = "SELECT u.username, u.user_id FROM " . WEBLOG_FRIENDS_TABLE . " f, " . USERS_TABLE . " u
	WHERE u.user_id = f.friend_id
		AND f.owner_id = $user_id";
if( !$result = $db->sql_query($sql) )
{
	message_die(GENERAL_ERROR, "Couldn't get friend of information.", "", __LINE__, __FILE__, $sql);
}
	
while ( $row = $db->sql_fetchrow($result) )
{
	$template->assign_block_vars('friendrow', array(
		'U_PROFILE' => append_sid("profile.$phpEx?mode=viewprofile&amp;" . POST_USERS_URL . "=" . $row['user_id']),
		'FRIEND' => $row['username'])
	);
}

if ( $userdata['user_id'] == $user_id || $contributor )
{
	$template->assign_block_vars('switch_owner', array());


}
//
// Generate page
//
$template->assign_vars(array(
	'L_WEBLOG_FRIENDS' => sprintf($lang['Friends'], $weblog_data['username']),
	'L_FRIENDS' => $lang['Friends_list'],
	'L_FRIEND_OF' => $lang['Friend_of'],
	'L_REMOVE_USER' => $lang['Remove_user'],
	'L_INDEX' => sprintf($lang['Forum_Index'], $board_config['sitename']),
	'L_WEBLOGS' => $lang['Weblogs'],
	'L_ADD_FRIEND' => $lang['Add_friend'],
	'L_ADD_FRIEND_EXPLAIN' => $lang['Add_friend_explain'],
	'L_ADD_GROUP' => $lang['Add_group'],
	'L_REMOVE_GROUP' => $lang['Remove_group'],
	
	'U_INDEX' => append_sid('index.'.$phpEx),
	'U_WEBLOGS' => append_sid("weblogs.$phpEx"),
	'U_WEBLOG' => append_sid("weblog.$phpEx?" . POST_WEBLOG_URL . "=" . $weblog_data['weblog_id']),

	'S_GROUP_SELECT' => $s_group_select,
	'S_ADDFRIENDS_ACTION' => append_sid("weblog_friends.$phpEx?" . POST_USERS_URL . "=$user_id"),
	'WEBLOG_NAME' => strip_tags($weblog_data['weblog_name']))
);

//
// Output the body
//
$template->pparse('body');


$template->assign_vars(array(
	'L_POWERED_BY' => sprintf($lang['Weblog_powered_by'], WEBLOGS_MOD_VERSION))
);
//
// Output the footer
//
include($phpbb_root_path . 'includes/page_tail.'.$phpEx);

?>