<?php
/***************************************************************************
 *                          weblog_contributors.php
 *                       -----------------------------
 *   Anv@r.all 2010
 *   (C) apwa.ru
 *
 ***************************************************************************/


define('IN_PHPBB', true);
$phpbb_root_path = './';
include($phpbb_root_path . 'extension.inc');
include($phpbb_root_path . 'common.'.$phpEx);
include($phpbb_root_path . 'includes/weblogs_common.'.$phpEx);
include($phpbb_root_path . 'includes/functions_weblog.'.$phpEx);

//
// Start session management
//
$userdata = session_pagestart($user_ip, PAGE_INDEX);
init_userprefs($userdata);
//
// End session management
//

//	
// Start initial var setup
//
if( isset($HTTP_GET_VARS[POST_WEBLOG_URL]) || isset($HTTP_POST_VARS[POST_WEBLOG_URL]) )
{
	$weblog_id = ( isset($HTTP_GET_VARS[POST_WEBLOG_URL]) ) ? intval($HTTP_GET_VARS[POST_WEBLOG_URL]) : intval($HTTP_POST_VARS[POST_WEBLOG_URL]);
}
else
{
	$weblog_id = 0;
}

$user_exists = FALSE;

//
// Make sure that the weblog exists
//
if ( $weblog_id )
{
	$sql = "SELECT w.* FROM " . WEBLOGS_TABLE . " w WHERE w.weblog_id = $weblog_id";
	if( !$result = $db->sql_query($sql) )
	{
		message_die(GENERAL_ERROR, "Couldn't obtain weblogs information.", "", __LINE__, __FILE__, $sql);
	}

	if ( !($weblog_data = $db->sql_fetchrow($result)) )
	{
		message_die(GENERAL_ERROR, 'Weblog_not_exist');
	}
}
else
{
	message_die(GENERAL_MESSAGE, 'Weblog_not_exist');
}

if ( $weblog_data['deleted'] )
{
	message_die(GENERAL_ERROR, sprintf($lang['Weblog_deactivated'], $weblog_data['weblog_name']));
}

if ( $userdata['user_weblog'] == $weblog_id && isset($HTTP_POST_VARS['addcontributor']) )
{
	$contributor_user = htmlspecialchars($HTTP_POST_VARS['contributoruser']);

	// Now, attempt to find a user with such a username
	$sql = "SELECT username, user_id FROM " . USERS_TABLE . " WHERE username = '" . str_replace("\'", "''", $contributor_user) . "'";
	if( !$result = $db->sql_query($sql) )
	{
		message_die(GENERAL_ERROR, "Couldn't obtain username information.", "", __LINE__, __FILE__, $sql);
	}

	if ( $row = $db->sql_fetchrow($result) )
	{
		$user_id = $row['user_id'];
	}
	else
	{
		message_die(GENERAL_ERROR, $lang['User_not_exist'] . '<br /><br />' . sprintf($lang['Click_return_contributors'], '<a href="' . append_sid("weblog_contributors.$phpEx?" . POST_WEBLOG_URL . "=$weblog_id") . '">', '</a>'));
	}

	// See if that contributor hasn't already been added
	$sql = "SELECT * FROM " . WEBLOG_CONTRIBUTORS_TABLE . " WHERE user_id = $user_id AND weblog_id = $weblog_id";
	if( !$result = $db->sql_query($sql) )
	{
		message_die(GENERAL_ERROR, "Couldn't obtain contributor information.", "", __LINE__, __FILE__, $sql);
	}

	if ( $row = $db->sql_fetchrow($result) )
	{
		message_die (GENERAL_ERROR, $lang['Contributor_already_added'] . '<br /><br />' . sprintf($lang['Click_return_contributors'], '<a href="' . append_sid("weblog_contributors.$phpEx?" . POST_WEBLOG_URL . "=$weblog_id") . '">', '</a>'));
	}

	if ( $contributor_user == $userdata['username'] )
	{
		message_die (GENERAL_ERROR, $lang['No_contributor_owner'] . '<br /><br />' . sprintf($lang['Click_return_contributors'], '<a href="' . append_sid("weblog_contributors.$phpEx?" . POST_WEBLOG_URL . "=$weblog_id") . '">', '</a>'));
	}

	if ( $contributor_user == ANONYMOUS )
	{
		message_die (GENERAL_ERROR, $lang['No_guest_contributors'] . '<br /><br />' . sprintf($lang['Click_return_contributors'], '<a href="' . append_sid("weblog_contributors.$phpEx?" . POST_WEBLOG_URL . "=$weblog_id") . '">', '</a>'));
	}

	// Now insert new user to contributor table
	$sql = "INSERT INTO " . WEBLOG_CONTRIBUTORS_TABLE . " (user_id, weblog_id) VALUES ($user_id, $weblog_id)";
	if( !$result = $db->sql_query($sql) )
	{
		message_die(GENERAL_ERROR, "Couldn't obtain insert contributor information.", "", __LINE__, __FILE__, $sql);
	}

	message_die (GENERAL_MESSAGE, $lang['Contributor_added'] . '<br /><br />' . sprintf($lang['Click_return_contributors'], '<a href="' . append_sid("weblog_contributors.$phpEx?" . POST_WEBLOG_URL . "=$weblog_id") . '">', '</a>'));
}
else if ( $userdata['user_weblog'] == $weblog_id && isset($HTTP_POST_VARS['removecontributor']) )
{
	$contributor_user = htmlspecialchars($HTTP_POST_VARS['contributoruser']);

	// Now, attempt to find a user with such a username
	$sql = "SELECT username, user_id FROM " . USERS_TABLE . " WHERE username = '" . str_replace("\'", "''", $contributor_user) . "'";
	if( !$result = $db->sql_query($sql) )
	{
		message_die(GENERAL_ERROR, "Couldn't obtain username information.", "", __LINE__, __FILE__, $sql);
	}

	if ( $row = $db->sql_fetchrow($result) )
	{
		$user_id = $row['user_id'];
	}
	else
	{
		message_die(GENERAL_ERROR, $lang['User_not_exist'] . '<br /><br />' . sprintf($lang['Click_return_contributors'], '<a href="' . append_sid("weblog_contributors.$phpEx?" . POST_WEBLOG_URL . "=$weblog_id") . '">', '</a>'));
	}

	if ( $userdata['username'] == $contributor_user )
	{
		message_die(GENERAL_ERROR, $lang['User_no_remove_selfcontributor']);
	}

	// Now, attempt to find a user that is a friend of the owner
	$sql = "SELECT user_id FROM " . WEBLOG_CONTRIBUTORS_TABLE . " WHERE weblog_id = $weblog_id";
	if( !$result = $db->sql_query($sql) )
	{
		message_die(GENERAL_ERROR, "Couldn't obtain contributor information.", "", __LINE__, __FILE__, $sql);
	}

	if (!( $row = $db->sql_fetchrow($result) ))
	{
		message_die(GENERAL_ERROR, $lang['User_not_contributor'] . '<br /><br />' . sprintf($lang['Click_return_contributors'], '<a href="' . append_sid("weblog_contributors.$phpEx?" . POST_WEBLOG_URL . "=$weblog_id") . '">', '</a>'));
	}

	// Remove the contributor
	$sql = "DELETE FROM " . WEBLOG_CONTRIBUTORS_TABLE . " WHERE user_id = $user_id AND weblog_id = $weblog_id";
	if( !$result = $db->sql_query($sql) )
	{
		message_die(GENERAL_ERROR, "Couldn't delete contributor information.", "", __LINE__, __FILE__, $sql);
	}

	message_die (GENERAL_MESSAGE, $lang['Contributor_removed'] . '<br /><br />' . sprintf($lang['Click_return_contributors'], '<a href="' . append_sid("weblog_contributors.$phpEx?" . POST_WEBLOG_URL . "=$weblog_id") . '">', '</a>') );
}

$page_title = $weblog_data['weblog_name'] . ' :: ' . $lang['Contributors'];
//
// Start output of page
//
include($phpbb_root_path . 'includes/page_header.'.$phpEx);

$template->set_filenames(array(
	'body' => 'blog/contributors_body.tpl')
);

//
// Find the users that are contributors
//
$sql = "SELECT u.username, u.user_id, c.user_id FROM " . WEBLOG_CONTRIBUTORS_TABLE . " c, " . USERS_TABLE . " u
	WHERE c.weblog_id = $weblog_id
		AND u.user_id = c.user_id";
if( !$result = $db->sql_query($sql) )
{
	message_die(GENERAL_ERROR, "Couldn't get contributors information.", "", __LINE__, __FILE__, $sql);
}
	
while ( $row = $db->sql_fetchrow($result) )
{
	$template->assign_block_vars('contribrow', array(
		'U_PROFILE' => append_sid("profile.$phpEx?mode=viewprofile&amp;" . POST_USERS_URL . "=" . $row['user_id']),
		'CONTRIBUTOR' => $row['username'])
	);
}

//
// Generate page
//
$template->assign_vars(array(
	'L_CONTRIBUTORS' => $lang['Contributors'],
	'L_CURRENT_CONTRIBUTORS' => $lang['Current_contributors'],
	'L_REMOVE_CONTRIBUTOR' => $lang['Remove_contributor'],
	'L_INDEX' => sprintf($lang['Forum_Index'], $board_config['sitename']),
	'L_WEBLOGS' => $lang['Weblogs'],
	'L_ADD_CONTRIBUTOR' => $lang['Add_contributor'],

	'U_INDEX' => append_sid('index.'.$phpEx),
	'U_WEBLOGS' => append_sid("weblogs.$phpEx"),
	'U_WEBLOG' => append_sid("weblog.$phpEx?" . POST_WEBLOG_URL . "=" . $weblog_data['weblog_id']),

	'S_CONTRIBUTOR_ACTION' => append_sid("weblog_contributors.$phpEx?" . POST_WEBLOG_URL . "=$weblog_id"),
	'WEBLOG_NAME' => $weblog_data['weblog_name'])
);

//
// Output the body
//
$template->pparse('body');


$template->assign_vars(array(
	'L_POWERED_BY' => sprintf($lang['Weblog_powered_by'], WEBLOGS_MOD_VERSION))
);
//
// Output the footer
//
include($phpbb_root_path . 'includes/page_tail.'.$phpEx);

?>