<?php
/***************************************************************************
 *                           weblog_allentries.php
 *                        ---------------------------
 *  Anv@r.all 2010
 *   (C) apwa.ru
 *
 ***************************************************************************/


define('IN_PHPBB', true);
$phpbb_root_path = './';
include($phpbb_root_path . 'extension.inc');
include($phpbb_root_path . 'common.'.$phpEx);
include($phpbb_root_path . 'includes/weblogs_common.'.$phpEx);
include($phpbb_root_path . 'includes/functions_weblog.'.$phpEx);

//
// Start initial var setup
//
if( isset($HTTP_GET_VARS[POST_WEBLOG_URL]) || isset($HTTP_POST_VARS[POST_WEBLOG_URL]) )
{
	$weblog_id = ( isset($HTTP_GET_VARS[POST_WEBLOG_URL]) ) ? intval($HTTP_GET_VARS[POST_WEBLOG_URL]) : intval($HTTP_POST_VARS[POST_WEBLOG_URL]);
}
else
{
	$weblog_id = '';
}

if( isset($HTTP_GET_VARS['mode']) || isset($HTTP_POST_VARS['mode']) )
{
	$mode = ( isset($HTTP_GET_VARS['mode']) ) ? htmlspecialchars($HTTP_GET_VARS['mode']) : htmlspecialchars($HTTP_POST_VARS['mode']);
}
else
{
	$mode = '';
}


$start = ( isset($HTTP_GET_VARS['start']) ) ? intval($HTTP_GET_VARS['start']) : 0;

//
// End initial var setup
//
//
// Get the weblog
//
$sql = "SELECT *
	FROM " . WEBLOGS_TABLE . " w, " . USERS_TABLE . " u
	WHERE w.weblog_id = $weblog_id
		AND u.user_weblog = w.weblog_id";
if( !$result = $db->sql_query($sql) )
{
	message_die(GENERAL_ERROR, "Couldn't obtain weblog information.", "", __LINE__, __FILE__, $sql);
}

$weblog_data = array();
if( !($weblog_data = $db->sql_fetchrow($result)) )
{
	message_die(GENERAL_MESSAGE, $lang['Weblog_not_exist']);
}

//
// Immediately check to see if this weblog is flagged for deletion
//
if ( $weblog_data['deleted'] )
{
	message_die(GENERAL_ERROR, sprintf($lang['Weblog_deactivated'], $weblog_data['weblog_name']));
}


//
// Start session management
//
$userdata = session_pagestart($user_ip, 10000 + $weblog_id);
init_userprefs($userdata);
//
// End session management
//

//
// Fetch Contributor data
//
$sql = "SELECT * FROM " . WEBLOG_CONTRIBUTORS_TABLE . " WHERE weblog_id = $weblog_id AND user_id = " . $userdata['user_id'];
if ( !($result = $db->sql_query($sql)) )
{
	message_die(GENERAL_ERROR, 'Error querying to find user weblog information', '', __LINE__, __FILE__, $sql);
}

$contributor = FALSE;
if ( $row = $db->sql_fetchrow($result) || $userdata['user_level'] == ADMIN )
{
	$contributor = TRUE;
}

// Get user auth level
$auth_level = get_auth_level ($weblog_data, $contributor);

//
// Define censored word matches
//
$orig_word = array();
$replacement_word = array();
obtain_word_list($orig_word, $replacement_word);

$page_title = strip_tags($weblog_data['weblog_name']) . ' :: ' . $lang['Entries'];
//
// Dump out the page header and load weblog template
//
include($phpbb_root_path . 'includes/page_header.'.$phpEx);

//
// Prepare for the main query by figuring out what to adjust first. (Borrowed and Modified from phpBB code)
//
if( !empty($HTTP_POST_VARS['entrydays']) || !empty($HTTP_GET_VARS['entrydays']) )
{
	$entry_days = ( !empty($HTTP_POST_VARS['entrydays']) ) ? intval($HTTP_POST_VARS['entrydays']) : intval($HTTP_GET_VARS['entrydays']);
	$min_entry_time = time() - ($entry_days * 86400);

	$sql = "SELECT COUNT(e.entry_id) AS weblog_entries 
		FROM " . WEBLOG_ENTRIES_TABLE . " e, " . WEBLOG_REPLIES_TABLE . " r
		WHERE e.weblog_id = $weblog_id 
			AND r.reply_id = e.entry_last_post_id
			AND r.post_time >= $min_entry_time"; 

	if( !$result = $db->sql_query($sql) )
	{
		message_die(GENERAL_ERROR, "Couldn't obtain limited entries count information", "", __LINE__, __FILE__, $sql);
	}
	$row = $db->sql_fetchrow($result);

	$entry_count = $row['weblog_entries'];
	$limit_entries_time = "AND e.entry_time >= $min_entry_time";

	if( !empty($HTTP_POST_VARS['entrydays']) )
	{
		$start = 0;
	}
}
else
{
	$entry_count = $weblog_data['weblog_entries'];

	$limit_entries_time = '';
	$entry_days = 0;
}

//
// Generate a 'Show topics in previous x days' select box. If the topicsdays var is sent
// then get it's value, find the number of topics with dates newer than it (to properly
// handle pagination) and alter the main query (Borrowed and Modified from phpBB code)
//
$previous_days = array(0, 1, 7, 14, 30, 90, 180, 364);
$previous_days_text = array($lang['All_entries'], $lang['1_Day'], $lang['7_Days'], $lang['2_Weeks'], $lang['1_Month'], $lang['3_Months'], $lang['6_Months'], $lang['1_Year']);

$select_entry_days = '<select name="entrydays">';
for($i = 0; $i < count($previous_days); $i++)
{
	$selected = ($entry_days == $previous_days[$i]) ? ' selected="selected"' : '';
	$select_entry_days .= '<option value="' . $previous_days[$i] . '"' . $selected . '>' . $previous_days_text[$i] . '</option>';
}
$select_entry_days .= "</select>";

$template->set_filenames(array(
	'body' => 'blog/allentries_body.tpl')
);


//
// Fetch Contributor data
//
$sql = "SELECT * FROM " . WEBLOG_CONTRIBUTORS_TABLE . " WHERE weblog_id = $weblog_id AND user_id = " . $userdata['user_id'];
if ( !($result = $db->sql_query($sql)) )
{
	message_die(GENERAL_ERROR, 'Error querying to find user weblog information', '', __LINE__, __FILE__, $sql);
}

$contributor = FALSE;
if ( $row = $db->sql_fetchrow($result) || $userdata['user_level'] == ADMIN )
{
	$contributor = TRUE;
}

if ( $weblog_data['weblog_id'] == $userdata['user_weblog'] || $contributor )
{
	$template->assign_block_vars('switch_weblog_owner', array() );
}

$template->assign_vars(array(
	'S_POST_DAYS_ACTION' => append_sid("weblog_allentries.$phpEx?" . POST_WEBLOG_URL . "=" . $weblog_id . "&amp;start=$start"),
	'S_SELECT_ENTRY_DAYS' => $select_entry_days,
	'U_WEBLOG' => append_sid("weblog.$phpEx?" . POST_WEBLOG_URL . "=$weblog_id"),
	'U_WEBLOGS' => append_sid("weblogs.$phpEx"),
	'U_POST_NEW_ENTRY' => append_sid("weblog_posting.$phpEx?mode=newentry&amp;" . POST_WEBLOG_URL . "=$weblog_id"),	
	'U_VIEW_MEMORABLE' => append_sid("weblog_allentries.$phpEx?" . POST_WEBLOG_URL . "=$weblog_id&amp;mode=viewmemorable"),
	'U_VIEW_PRIVATE' => append_sid("weblog_allentries.$phpEx?" . POST_WEBLOG_URL . "=$weblog_id&amp;mode=viewprivate"),
	'WEBLOG_NAME' => strip_tags($weblog_data['weblog_name']),
	'WEBLOG_ID' => $weblog_id,
	'WEBLOG_URL' => POST_WEBLOG_URL,
	'OWNER' => $weblog_data['username'],
	'L_WEBLOGS' => $lang['Weblogs'],
	'L_WEBLOG_OWNER' => $lang['Weblog_Owner'],
	'L_INDEX' => sprintf($lang['Forum_Index'], $board_config['sitename']),
	'L_POST_NEW_ENTRY' => $lang['Post_new_entry'],
	'L_ENTRIES' => $lang['Entries'],
	'L_REPLIES' => $lang['Replies'],
	'L_VIEWS' => $lang['Views'],
	'L_LASTREPLY' => $lang['Last_reply'],
	'L_NO_ENTRIES' => $lang['Sorry_no_entries'],
	'L_DISPLAY_ENTRIES' => $lang['Display_entries'],
	'L_GO' => $lang['Go'],
	'L_VIEW_PRIVATE' => $lang['View_private_entries'],
	'L_VIEW_MEMORABLE' => $lang['View_memorable_entries'])
);
//
// End header
//

$tracking_entries = ( isset($HTTP_COOKIE_VARS[$board_config['cookie_name'] . '_e']) ) ? unserialize($HTTP_COOKIE_VARS[$board_config['cookie_name'] . '_e']) : '';
$tracking_weblogs = ( isset($HTTP_COOKIE_VARS[$board_config['cookie_name'] . '_w']) ) ? unserialize($HTTP_COOKIE_VARS[$board_config['cookie_name'] . '_w']) : '';

//
// Grab all dem entries
//

// Get all memorable entry data
$sql = "SELECT e.*, e.entry_id AS entry_id2, u.user_id, u.username, r.* FROM " . WEBLOG_ENTRIES_TABLE . " e
	LEFT OUTER JOIN " . WEBLOG_REPLIES_TABLE . " r
		ON e.entry_last_post_id = r.reply_id
	LEFT OUTER JOIN " . USERS_TABLE . " u
		ON r.poster_id = u.user_id
	WHERE e.weblog_id = " . $weblog_data['weblog_id'] . "
		AND e.entry_access " . (( $mode == 'viewprivate' ) ? '= ' . WEBLOG_AUTH_OWNER : '<= ' . $auth_level) . "
		AND e.memorable = 1
		$limit_entries_time		
	ORDER BY entry_time DESC";
if(!($result = $db->sql_query($sql)))
{
	message_die(GENERAL_ERROR, 'Could not query weblog entry information', '', __LINE__, __FILE__, $sql);
}

$entry_data = array();
while ( $row = $db->sql_fetchrow($result) )
{
	$entry_data[] = $row;
}

if ( $mode != 'viewmemorable' )
{
	// Get all entry data
	$sql = "SELECT e.entry_id AS entry_id2, e.*, u.user_id, u.username, r.* FROM " . WEBLOG_ENTRIES_TABLE . " e
		LEFT OUTER JOIN " . WEBLOG_REPLIES_TABLE . " r
			ON e.entry_last_post_id = r.reply_id
		LEFT OUTER JOIN " . USERS_TABLE . " u
			ON r.poster_id = u.user_id
		WHERE e.weblog_id = " . $weblog_data['weblog_id'] . "
			AND e.entry_access " . (( $mode == 'viewprivate' ) ? '= ' . WEBLOG_AUTH_OWNER : '<= ' . $auth_level) . "
			AND e.memorable <> 1			
			$limit_entries_time
		ORDER BY entry_time DESC
		LIMIT $start, " . $board_config['topics_per_page'];
	if(!($result = $db->sql_query($sql)))
	{
		message_die(GENERAL_ERROR, 'Could not query weblog entry information', '', __LINE__, __FILE__, $sql);
	}

	while ( $row = $db->sql_fetchrow($result) )
	{
		$entry_data[] = $row;
	}

	// Get all entry data
	$sql = "SELECT count(e.entry_id) AS total_entries FROM " . WEBLOG_ENTRIES_TABLE . " e
		WHERE e.weblog_id = " . $weblog_data['weblog_id'] . "
			AND e.entry_access " . (( $mode == 'viewprivate' ) ? '= ' . WEBLOG_AUTH_OWNER : '<= ' . $auth_level) . "
			AND e.memorable <> 1
			$limit_entries_time
		ORDER BY entry_time DESC";
	if(!($result = $db->sql_query($sql)))
	{
		message_die(GENERAL_ERROR, 'Could not query entry information', '', __LINE__, __FILE__, $sql);
	}

	$total_entries = 0;
	if ( $row = $db->sql_fetchrow($result) )
	{
		$total_entries = $row['total_entries'];
	}

}

//
// Get the moods data
//
$sql = "SELECT *
	FROM " . WEBLOG_MOODS_TABLE . "
	ORDER BY mood_text";
if( !$result = $db->sql_query($sql) )
{
	message_die(GENERAL_ERROR, "Couldn't obtain mood data from database", "", __LINE__, __FILE__, $sql);
}
$mood_data = $db->sql_fetchrowset($result);

//
// Get the actions data
//
$sql = "SELECT *
	FROM " . WEBLOG_ACTIONS_TABLE . "
	ORDER BY action_text";
if( !$result = $db->sql_query($sql) )
{
	message_die(GENERAL_ERROR, "Couldn't obtain action data from database", "", __LINE__, __FILE__, $sql);
}
$action_data = $db->sql_fetchrowset($result);

//
// Okay, lets dump out the page ...
//
if( count($entry_data) )
{
	for($i = 0; $i < count($entry_data); $i++)
	{
		$entry_id = $entry_data[$i]['entry_id2'];

		$entry_subject = ( count($orig_word) && $weblog_config['censor_weblog'] ) ? preg_replace($orig_word, $replacement_word, strip_tags(htmlspecialchars($entry_data[$i]['entry_subject']))) : strip_tags(htmlspecialchars($entry_data[$i]['entry_subject']));

		$replies = $entry_data[$i]['entry_replies'];

		// Mood Icons
		$mood = array();
		$mood = find_mood($entry_data[$i]['entry_mood']);

		if ( $mood >= 0 )
		{ 
			$mood = '<img src="images/weblog/' . $mood['mood_url'] . '" alt=""/>';
		}
		else
		{
			$mood = '';
		}

		// Currently Icons
		$currently = array();
		$currently = find_action($entry_data[$i]['entry_currently']);

		if ( $currently > 0 )
		{
			$action = '<img src="images/weblog/' . $currently['action_url'] . '" alt="' . strip_tags(htmlspecialchars($entry_data[$i]['currently_text'])) . '"/>'; 
		}
		else
		{
			$action = '';
		}
		
		$last_post_time = '';
		$last_post_url = '';
		$last_post_author = '';						

		if ( $entry_data[$i]['reply_id'] )
		{
			$last_post_time = create_date($board_config['default_dateformat'], $entry_data[$i]['post_time'], $board_config['board_timezone']);

			$last_post_author = ( $entry_data[$i]['poster_id'] == ANONYMOUS ) ? ( ($entry_data[$i]['post_username'] != '' ) ? $entry_data[$i]['post_username'] . ' ' : $lang['Guest'] . ' ' ) : '<a href="' . append_sid("profile.$phpEx?mode=viewprofile&amp;" . POST_USERS_URL . '='  . $entry_data[$i]['user_id']) . '">' . $entry_data[$i]['username'] . '</a>';
		
			if( !$entry_data[$i]['entry_last_post_id'] )
			{
				$last_post_url = $newest_post_img;
			}
			else
			{
				$last_post_url = '<a href="' . append_sid("weblog_entry.$phpEx?"  . POST_REPLY_URL . '=' . $entry_data[$i]['reply_id']) . '#' . $entry_data[$i]['reply_id'] . '">' . $lang['View_latest_post'] . '</a>';
			}
		}
		else
		{
			$last_post_time = $lang['No_replies_yet'];
			$last_post_url = '';
		}

		if( ( $replies + 1 ) > $board_config['posts_per_page'] )
		{
			$total_pages = ceil( ( $replies + 1 ) / $board_config['posts_per_page'] );
			$goto_page = '[';

			$times = 1;
			for($j = 0; $j < $replies + 1; $j += $board_config['posts_per_page'])
			{
				$goto_page .= '<a href="' . append_sid("weblog_entry.$phpEx?" . POST_ENTRY_URL . "=" . $entry_id . "&amp;start=$j") . '">' . $times . '</a>';
				if( $times == 1 && $total_pages > 4 )
				{
					$goto_page .= '...';
					$times = $total_pages - 3;
					$j += ( $total_pages - 4 ) * $board_config['posts_per_page'];
				}
				else if ( $times < $total_pages )
				{
					$goto_page .= ', ';
				}
				$times++;
			}
			$goto_page .= ']';
		}
		else
		{
			$goto_page = '';
		}
		
		$view_entry_url = append_sid("weblog_entry.$phpEx?" . POST_ENTRY_URL . "=$entry_id");

		$first_post_time = create_date($board_config['default_dateformat'], $entry_data[$i]['entry_time'], $board_config['board_timezone']);

		$views = $entry_data[$i]['entry_views'];

		$row_class = ( !($i % 2) ) ? 'row_hard' : 'row_easy';

		$template->assign_block_vars('entryrow', array(
			'ROW_CLASS' => $row_class,
			'MOOD' => $mood,
			'ACTION' => $action,			
			'MEMORABLE' => ( $entry_data[$i]['memorable'] ) ? $lang['Entry_Memorable'] : '',
			'ENTRY_SUBJECT' => $entry_subject,
			'FIRST_POST_TIME' => $first_post_time,
			'GOTO_PAGE' => $goto_page,
			'REPLIES' => $replies,
			'VIEWS' => $views,
			'LAST_POST_TIME' => $last_post_time, 
			'LAST_POST_AUTHOR' => $last_post_author, 
			'LAST_POST' => $last_post_url, 
			'U_VIEW_ENTRY' => $view_entry_url)
		);
	}

	$template->assign_vars(array(
		'PAGINATION' => generate_pagination("weblog_allentries.$phpEx?" . POST_WEBLOG_URL . "=$weblog_id&amp;entrydays=$entry_days", $total_entries, $board_config['topics_per_page'], $start),
		'PAGE_NUMBER' => sprintf($lang['Page_of'], ( floor( $start / $board_config['topics_per_page'] ) + 1 ), ceil( count($entry_data) / $board_config['topics_per_page'] )))
	);
}
else
{
	$template->assign_block_vars('switch_no_entries', array() );
}

//
// Parse the page and print
//
$template->pparse('body');

include($phpbb_root_path . 'includes/page_tail.'.$phpEx);

?>