<?php
/***************************************************************************
 *                                weblog.php
 *                            -------------------
 *    Anv@r.all, 2010
 *    (C) apwa.ru
 *
 ***************************************************************************/

define('IN_PHPBB', true);
$phpbb_root_path = './';
include($phpbb_root_path . 'extension.inc');
include($phpbb_root_path . 'common.'.$phpEx);
include($phpbb_root_path . 'includes/bbcode.'.$phpEx);
include($phpbb_root_path . 'includes/weblogs_common.'.$phpEx);
include($phpbb_root_path . 'includes/functions_weblog.'.$phpEx);

//	
// Start initial var setup
//
if( isset($HTTP_GET_VARS[POST_WEBLOG_URL]) || isset($HTTP_POST_VARS[POST_WEBLOG_URL]) )
{
	$weblog_id = ( isset($HTTP_GET_VARS[POST_WEBLOG_URL]) ) ? intval($HTTP_GET_VARS[POST_WEBLOG_URL]) : intval($HTTP_POST_VARS[POST_WEBLOG_URL]);
	$username = '';
}
else if( isset($HTTP_GET_VARS[POST_USERS_URL]) || isset($HTTP_POST_VARS[POST_USERS_URL]) )
{
	$username = ( isset($HTTP_GET_VARS[POST_USERS_URL]) ) ? htmlspecialchars($HTTP_GET_VARS[POST_USERS_URL]) : intval($HTTP_POST_VARS[POST_USERS_URL]);
	$weblog_id = 0;
}
else
{
	$username = '';
	$weblog_id = 0;
}

$cat = ( isset($HTTP_GET_VARS[POST_CAT_URL]) ) ? intval($HTTP_GET_VARS[POST_CAT_URL]) : '';
//
// Fetch weblog
//
if( !empty($weblog_id) )
{
	$sql = "SELECT w.*, u.username, u.user_id, u.user_level, u.user_avatar_type, u.user_allowavatar, u.user_avatar, u.user_allowweblog
		FROM " . WEBLOGS_TABLE . " w, " . USERS_TABLE . " u
		WHERE w.weblog_id = $weblog_id
			AND w.weblog_id = u.user_weblog";
	if( !$result = $db->sql_query($sql) )
	{
		message_die(GENERAL_ERROR, "Couldn't obtain weblogs information.", "", __LINE__, __FILE__, $sql);
	}
}
else if ( !empty($username) )
{
	$sql = "SELECT w.*, u.username, u.user_id, u.user_level, u.user_avatar_type, u.user_allowavatar, u.user_avatar, u.user_allowweblog
		FROM " . WEBLOGS_TABLE . " w, " . USERS_TABLE . " u
		WHERE w.weblog_id = u.user_weblog
			AND u.username = '" . str_replace("\'", "''", $username) . "'";
	if( !$result = $db->sql_query($sql) )
	{
		message_die(GENERAL_ERROR, "Couldn't obtain weblogs information.", "", __LINE__, __FILE__, $sql);
	}
}
else
{
	message_die(GENERAL_MESSAGE, 'Weblog_not_exist');
}

$weblog_data = array();
if( !($weblog_data = $db->sql_fetchrow($result)) )
{
	message_die(GENERAL_MESSAGE, 'Weblog_not_exist');
}
$weblog_id = $weblog_data['weblog_id'];

//
// Start session management
//
$userdata = session_pagestart($user_ip, 10000 + $weblog_id); // Mimicking a forum for the "Users browsing this blog:" feature
init_userprefs($userdata);
//
// End session management
//

if( isset($HTTP_GET_VARS['previous']) )
{
	$previous = abs(intval($HTTP_GET_VARS['previous']));
}
else
{
	$previous = 0;
}

if( isset($HTTP_GET_VARS['month']) && !empty($HTTP_GET_VARS['month']) )
{
	$month = intval($HTTP_GET_VARS['month']);

	if ( $month < 1 || $month > 12 )
	{
		$month = create_date("n", time(), $board_config['board_timezone']);
	}
}

if( isset($HTTP_GET_VARS['day']) && !empty($HTTP_GET_VARS['day']) )
{
	$day = intval($HTTP_GET_VARS['day']);

	if ( $day < 1 || $day > 31 )
	{
		$day = create_date("j", time(), $board_config['board_timezone']);
	}
}

if( isset($HTTP_GET_VARS['year']) && !empty($HTTP_GET_VARS['year']) )
{
	$year = intval($HTTP_GET_VARS['year']);

	if ( $year < 1970 || $year > 2038 )
	{
		$year = create_date("Y", time(), $board_config['board_timezone']);
	}
}


$months = array($lang['datetime']['January'],$lang['datetime']['February'],$lang['datetime']['March'],$lang['datetime']['April'],$lang['datetime']['May'],$lang['datetime']['June'], $lang['datetime']['July'], $lang['datetime']['August'], $lang['datetime']['September'], $lang['datetime']['October'], $lang['datetime']['November'], $lang['datetime']['December']);

if ( !$weblog_data['user_allowweblog'] )
{
	message_die(GENERAL_ERROR, sprintf($lang['Owner_is_banned'], $weblog_data['username']));
}
else if ( $weblog_data['deleted'] )
{
	message_die(GENERAL_ERROR, sprintf($lang['Weblog_deactivated'], $weblog_data['weblog_name']));
}


//
// Fetch Contributor data
//
$sql = "SELECT * FROM " . WEBLOG_CONTRIBUTORS_TABLE . " WHERE weblog_id = $weblog_id AND user_id = " . $userdata['user_id'];
if ( !($result = $db->sql_query($sql)) )
{
	message_die(GENERAL_ERROR, 'Error querying to find user weblog information', '', __LINE__, __FILE__, $sql);
}

$contributor = FALSE;
if ( $row = $db->sql_fetchrow($result) || $userdata['user_level'] == ADMIN )
{
	$contributor = TRUE;
}

// Get the user's clearence levels
$auth_level = get_auth_level ( $weblog_data, $contributor );

// See if user can see this weblog
if ( $weblog_data['weblog_auth'] > $auth_level )
{
	message_die(GENERAL_ERROR, $lang['Weblog_noaccess']);
}

//
// Fetch Contributor data (2)
//
$sql = "SELECT u.* FROM " . WEBLOG_CONTRIBUTORS_TABLE . " c, " . USERS_TABLE . " u WHERE c.weblog_id = $weblog_id AND c.user_id = u.user_id";
if ( !($result = $db->sql_query($sql)) )
{
	message_die(GENERAL_ERROR, 'Error querying to find user weblog information', '', __LINE__, __FILE__, $sql);
}

$contributors = '';
while ( $row = $db->sql_fetchrow($result) )
{
	if ( !empty($contributors) )
	{
		$temp_url = append_sid("profile.$phpEx?mode=viewprofile&amp;" . POST_USERS_URL . "=" . $row['user_id']);
		$contributors .= ', <a href="' . $temp_url . '">' . $row['username'] . '</a>';
	}
	else
	{
		$temp_url = append_sid("profile.$phpEx?mode=viewprofile&amp;" . POST_USERS_URL . "=" . $row['user_id']);
		$contributors = '<a href="' . $temp_url . '">' . $row['username'] . '</a>';
	}
}

if ( empty($contributors) )
{
	$contributors = $lang['(None)'];
}

if ( $weblog_data['weblog_id'] != $userdata['user_weblog'] && !$contributor )
{
	//
	// Update the number of views for this weblog
	//
	$sql = "UPDATE " . WEBLOGS_TABLE . "
		SET weblog_views = weblog_views + 1
		WHERE weblog_id = $weblog_id";
	if( !$result = $db->sql_query($sql) )
	{
		message_die(GENERAL_ERROR, "Couldn't update weblog views information.", "", __LINE__, __FILE__, $sql);
	}
}

$page_title = strip_tags($weblog_data['weblog_name']); 
//
// Start output of page
//
include($phpbb_root_path . 'includes/page_header.'.$phpEx);

	$template->set_filenames(array(		
		'body' => 'blog/index_blog_body.tpl')
	);
	
	if ( $weblog_data['show_weblog_info'] )
	{
		$template->assign_block_vars('switch_show_info', array());
	}	

if ( $weblog_data['weblog_id'] == $userdata['user_weblog'] )
{
	$template->assign_block_vars('switch_owner_only', array());
	$template->assign_block_vars('switch_contributor_only', array());
}
else if ( $contributor )
{
	$template->assign_block_vars('switch_contributor_only', array());
}

$pm_url = append_sid("privmsg.$phpEx?mode=post&amp;" . POST_USERS_URL . "=" . $weblog_data['user_id']);


// Figure out what to do when a new date is requested
if ( $year && !$month && !$day )
{
	$end_time = mktime(0,0,0,1,1,$year+1);
	$begin_time = mktime(0,0,0,1,1,$year);
}
else if ( $year && $month && !$day )
{
	$end_time = mktime(0,0,0,$month+1,1,$year); // Setting date parameter to zero means same as last day
	$begin_time = mktime(0,0,0,$month,1,$year);
}
else if ( $year && $month && $day )
{
	$end_time = mktime(0,0,0,$month,$day+1,$year);
	$begin_time = mktime(0,0,0,$month,$day,$year);
}
else
{
	$begin_time = 0;
	$end_time = time();
}

//
// Get the moods data
//
$sql = "SELECT *
	FROM " . WEBLOG_MOODS_TABLE . "
	ORDER BY mood_text";
if( !$result = $db->sql_query($sql) )
{
	message_die(GENERAL_ERROR, "Couldn't obtain mood data from database", "", __LINE__, __FILE__, $sql);
}
$mood_data = $db->sql_fetchrowset($result);

//
// Get the actions data
//
$sql = "SELECT *
	FROM " . WEBLOG_ACTIONS_TABLE . "
	ORDER BY action_text";
if( !$result = $db->sql_query($sql) )
{
	message_die(GENERAL_ERROR, "Couldn't obtain action data from database", "", __LINE__, __FILE__, $sql);
}
$action_data = $db->sql_fetchrowset($result);

// CategoryAddon courtesy by willow at TheBlogPoint.com
$category = "";
if ($cat !='') 
{
      $category = " AND e.category_id = '" . $cat . "' ";
}

$perpage = ($weblog_data['entries_perpage']) ? $weblog_data['entries_perpage'] : $weblog_config['main_blogsperpage'];
//
// Fetch Entries
//
$sql = "SELECT e.*, u.* FROM " . WEBLOG_ENTRIES_TABLE . " e, " . USERS_TABLE . " u
	WHERE e.weblog_id = $weblog_id " . $category . "
	AND e.entry_poster_id = u.user_id
	AND e.entry_access <= $auth_level
	ORDER BY e.entry_time DESC LIMIT " . $perpage;
if(!($result = $db->sql_query($sql)))
{
	message_die(GENERAL_ERROR, 'Could not query weblog entry information', '', __LINE__, __FILE__, $sql);
}

$entry_data = array();
while ( $row = $db->sql_fetchrow($result) )
{
	$entry_data[] = $row;
}

$update_sql = '';

for ($i = 0; $i < count($entry_data); $i++)
{
	if ( $entry_data[$i]['entry_time'] < $begin_time || $entry_data[$i]['entry_time'] > $end_time )
	{
		continue;
	}

	$entry_data[$i]['entry_text'] = cut_message ( $entry_data[$i]['entry_text'], $entry_data[$i]['entry_id'] );
        
        if ( (!isset($HTTP_GET_VARS[POST_ENTRY_URL]) || (($HTTP_GET_VARS[POST_ENTRY_URL] != $entry_data[$i]['entry_id']) && isset($HTTP_GET_VARS[POST_ENTRY_URL]))) && (100 > 0) && (strlen($entry_data[$i]['entry_text']) > (100*4)))
	{		
		$obrez = strpos($entry_data[$i]['entry_text'], " ", 100*2);
		$entry_data[$i]['entry_text'] = substr($entry_data[$i]['entry_text'], 0, $obrez);
		$entry_data[$i]['entry_text'] .= '...<a href="' . append_sid("weblog_entry.$phpEx?" . POST_ENTRY_URL . "=" . $entry_data[$i]['entry_id']) . '">--&gt;</a>';			   
        }
        else if ( !$update_sql )
	{
		$update_sql = "UPDATE " . WEBLOG_ENTRIES_TABLE . " SET entry_views = entry_views + 1 WHERE entry_id = " . $entry_data[$i]['entry_id'];
	}
	else
	{
		$update_sql .= " OR entry_id = " . $entry_data[$i]['entry_id'];
	}
        	
	if ( !$board_config['allow_html'] )
	{
		if ( $entry_data[$i]['enable_html'] )
		{
			preg_replace('#(<)([\/]?.*?)(>)#is', "&lt;\\2&gt;", $entry_data[$i]['entry_text']);
		}
	}

	if ( $board_config['allow_bbcode'] )
	{
		if ( $entry_data[$i]['enable_bbcode'] )
		{
			$entry_data[$i]['entry_text'] = ( $entry_data[$i]['bbcode_uid'] ) ? bbencode_second_pass($entry_data[$i]['entry_text'], $entry_data[$i]['bbcode_uid']) : preg_replace('/\:[0-9a-z\:]+\]/si', ']', $entry_data[$i]['entry_text']);
		}
	}

	$entry_data[$i]['entry_text'] = make_clickable($entry_data[$i]['entry_text']);

	if ( $board_config['allow_smilies'] )
	{
		if ( $entry_data[$i]['enable_smilies'] )
		{
			$entry_data[$i]['entry_text'] = smilies_pass($entry_data[$i]['entry_text']);
		}
	}

	if ( $weblog_config['censor_weblog'] )
	{
		$orig_word = array();
		$replacement_word = array();
		obtain_word_list($orig_word, $replacement_word);
	}

	$entry_data[$i]['entry_text'] = str_replace("\n", "\n<br />\n", $entry_data[$i]['entry_text']);	

        $mood = array();
	$mood = find_mood($entry_data[$i]['entry_mood']);

	if ( $mood >= 0 )
	{
		$mood = '[' . sprintf($lang['Mood:'], '<img src="images/weblog/' . $mood['mood_url'] . '" alt="' . $mood_data['mood_text'] . '" border="0" />', $mood['mood_text']) . ']';
	}
	else
	{
		$mood = '';
	}

	$currently = array();
	$currently = find_action($entry_data[$i]['entry_currently']);

	if ( $currently >= 0 )
	{
		$action = '[' . sprintf($lang['Currently:'], '<img src="images/weblog/' . $currently['action_url'] . '" alt="' . $currently['action_text'] . '" border="0" />',  $currently['action_text']) . ']';
	}
	else
	{
		$action = '';
	}
        
        /*$cat_id = $entry_data[$i]['category_id'];
        if ( $cat_id != '0' )
        {
	      $category = '' . $lang['Category:'] . '<a href="' . append_sid("weblog.$phpEx?" . POST_WEBLOG_URL . "=" . $weblog_data['weblog_id'] . "&amp;" . POST_CAT_URL . "=" . $cat_id) . '">' . $entry_data[$i]['blog_cat_title'] . '</a>';
        }
        else
        {
	      $category = '';
	}*/
		 
	$time = create_date($board_config['default_dateformat'], $entry_data[$i]['entry_time'], $board_config['board_timezone']);

	$day2 = create_date("j", $entry_data[$i]['entry_time'], $board_config['board_timezone']);
	$month2 = create_date("n", $entry_data[$i]['entry_time'], $board_config['board_timezone']);
	$year2 = create_date("Y", $entry_data[$i]['entry_time'], $board_config['board_timezone']);

	$entry_access = $entry_data[$i]['entry_access'];
        $row_class = ( !($i % 2) ) ? 'row_hard' : 'row_easy';
	
		$template->assign_block_vars('entryrow', array(
		'SUBJECT' => strip_tags(htmlspecialchars($entry_data[$i]['entry_subject'])),
		'ENTRY' => $entry_data[$i]['entry_text'],
		'TIME_DATE' => $time,
		'MOOD' => $mood,
		'CURRENTLY' => $action,
                'ROW_CLASS' => $row_class,
		'CATEGORY' => $category,

		'LOCKED_ICON' => ( $entry_data[$i]['entry_access'] > WEBLOG_AUTH_ALL ) ? $lang['Restricted_access'] . $weblog_auth_types[$entry_access] : '',
		'POSTED_BY' => ( !empty($entry_data[$i]['username']) ) ? sprintf($lang['Posted_by'], '<a href="' . append_sid("profile.$phpEx?mode=viewprofile&amp;" . POST_USERS_URL . "=" . $entry_data[$i]['user_id']) . '">' . $entry_data[$i]['username'] . '</a>') : '',
		'EDIT_LINK' => ( $weblog_data['weblog_id'] == $userdata['user_weblog'] || $contributor ) ? '<strong>[ <a href="' . append_sid ("weblog_posting.$phpEx?mode=editentry&amp;" . POST_ENTRY_URL . "=" . $entry_data[$i]['entry_id']) . '">' . $lang['Edit'] . '</a> ]</strong>' : '',
		'DELETE_LINK' => ( $weblog_data['weblog_id'] == $userdata['user_weblog'] || $contributor ) ? '<strong>[ <a href="' . append_sid ("weblog_posting.$phpEx?mode=delete&amp;" . POST_ENTRY_URL . "=" . $entry_data[$i]['entry_id']) . '">X</a> ]</strong>' : '',
		'POST_COMMENT' => ( !$entry_data[$i]['no_replies'] ) ? sprintf(strip_tags($lang['Reply_to_topic']), $entry_data[$i]['entry_replies']) : '',
		'REPLIES' => ( !$entry_data[$i]['no_replies'] ) ? sprintf(strip_tags($lang['Replies_to']), $entry_data[$i]['entry_replies']) : '',
		'OPEN_NEW_WINDOW' => ( $weblog_data['reply_in_popup'] ) ? ' onclick="window.open(\'' . append_sid('weblog_posting.' . $phpEx . '?mode=reply&amp;' . POST_ENTRY_URL . '=' . $entry_data[$i]['entry_id'] . '&amp;popup=1') . '\', \'_weblogcomment\', \'HEIGHT=640,resizable=no,scrollbars=yes,WIDTH=550\');return false;" target="_weblogcomment"' : '',
		'EDIT_IMG' => ( $weblog_data['weblog_id'] == $userdata['user_weblog'] || $contributor ) ? $lang['Edit'] : '',
		'DELETE_IMG' => ( $weblog_data['weblog_id'] == $userdata['user_weblog'] || $contributor ) ? $lang['Delete'] : '',
		'U_EDIT' => ( $weblog_data['weblog_id'] == $userdata['user_weblog'] || $contributor ) ? append_sid ("weblog_posting.$phpEx?mode=editentry&amp;" . POST_ENTRY_URL . "=" . $entry_data[$i]['entry_id']) : '',
		'U_DELETE' => ( $weblog_data['weblog_id'] == $userdata['user_weblog'] || $contributor ) ? append_sid ("weblog_posting.$phpEx?mode=delete&amp;" . POST_ENTRY_URL . "=" . $entry_data[$i]['entry_id']) : '',
		'U_PERMALINK' => append_sid("weblog_entry.$phpEx?" . POST_ENTRY_URL . "=" . $entry_data[$i]['entry_id']),
		'U_VIEW_COMMENTS' => ( !$entry_data[$i]['no_replies'] ) ? append_sid('weblog_entry.' . $phpEx . '?' . POST_ENTRY_URL . '=' . $entry_data[$i]['entry_id']) : '',
		'U_POST_COMMENT' => ( !$entry_data[$i]['no_replies'] ) ? append_sid('weblog_posting.' . $phpEx . '?mode=reply&amp;' . POST_ENTRY_URL . '=' . $entry_data[$i]['entry_id']) : '')
	);	
}

//
// Update the entry view counter
//
if ( !empty($update_sql) && !$db->sql_query($update_sql) )
{
	echo $update_sql;

	message_die(GENERAL_ERROR, "Could not update entry views.", '', __LINE__, __FILE__, $update_sql);
}

if ( $weblog_data['show_weblog_info'] )
{
	// Get the total number of replies for this weblog.
	$sql = "SELECT count(r.reply_id) AS total
		FROM " . WEBLOGS_TABLE . " w, " . WEBLOG_ENTRIES_TABLE . " e, " . WEBLOG_REPLIES_TABLE . " r
		WHERE r.entry_id = e.entry_id
			AND e.weblog_id = w.weblog_id
			AND w.weblog_id = $weblog_id";
	if(!($result = $db->sql_query($sql)))
	{
		message_die(GENERAL_ERROR, 'Could not get total number of replies information', '', __LINE__, __FILE__, $sql);
	}

	if ( $row = $db->sql_fetchrow($result) )
	{
		$num_replies = $row['total'];
	}
}

avatar_img($weblog_data['user_avatar_type'], $weblog_data['user_allowavatar'], $weblog_data['user_avatar'], $avatar_img, $avatar_mini);
        
if ($cat != '')
{
     $category = '&amp;' . POST_CAT_URL . '=' . $cat;
}


$template->assign_vars(array(
	'POST_ENTRY_IMG' => 'images/weblog/newentry.gif',
	'WEBLOG_ID' => $weblog_data['weblog_id'],
	'WEBLOG_NAME' => $weblog_data['weblog_name'],
	'WEBLOG_DESCRIPTION' => $weblog_data['weblog_desc'],
	'WEBLOG_OWNER' => $weblog_data['username'],
	'JOINED_DATE' => ( $weblog_data['weblog_advanced'] || $weblog_data['show_profile_info'] ) ? create_date ($board_config['default_dateformat'], $weblog_data['user_regdate'], $board_config['board_timezone']) : '',
	'LOCATION' => ( $weblog_data['weblog_advanced'] || $weblog_data['show_profile_info'] ) ? $weblog_data['user_from'] : '',
	'OCCUPATION' => ( $weblog_data['weblog_advanced'] || $weblog_data['show_profile_info'] ) ? $weblog_data['user_occ'] : '',
	'INTERESTS' => ( $weblog_data['weblog_advanced'] || $weblog_data['show_profile_info'] ) ? $weblog_data['user_interests'] : '',
	'STARTED_DATE' => ( $weblog_data['weblog_advanced'] || $weblog_data['show_weblog_info'] ) ? create_date ($board_config['default_dateformat'], $weblog_data['weblog_create_date'], $board_config['board_timezone']) : '',
	'NUMBER_OF_VISITS' => ( $weblog_data['weblog_advanced'] || $weblog_data['show_weblog_info'] ) ? $weblog_data['weblog_views'] : '',
	'NUMBER_OF_ENTRIES' => ( $weblog_data['weblog_advanced'] || $weblog_data['show_weblog_info'] ) ? $weblog_data['weblog_entries'] : '',
	'NUMBER_OF_REPLIES' =>	( $weblog_data['weblog_advanced'] || $weblog_data['show_weblog_info'] ) ? $num_replies : '',
	'WEBLOG_AGE' => ( $weblog_data['weblog_advanced'] || $weblog_data['show_weblog_info'] ) ? sprintf ( $lang['Weblog_age_days'], intval( (time() - $weblog_data['weblog_create_date'])/(60*60*24) ) ) : '',
	'CONTACT_OWNER' => sprintf ($lang['Contact_owner'], $weblog_data['username']),
	'ABOUT_OWNER' => sprintf ($lang['About_owner'], $weblog_data['username']),
	'AVATAR_IMG' => $avatar_img,
	'MONTH' => $months[$month-1],
	'YEAR' => $year,	
	'S_SHOUT_ACTION' => append_sid("weblog.$phpEx?" . POST_WEBLOG_URL . "=$weblog_id"),
	'CONTRIBUTORS' => $contributors,
	'S_FORM_ACTION' => append_sid("weblog.$phpEx?" . POST_WEBLOG_URL . "=$weblog_id"),
	'DATE_SELECT' => make_date_select ( $year, $month, $day ),
	'S_HIDDEN_FIELD' => '<input type="hidden" name="w" value="' . $weblog_id . '" />',

	'L_CONTRIBUTORS' => $lang['Contributors'],
	'L_EDIT_CONTRIBUTORS' => $lang['Edit_contributors'],
	'L_DISABLE_HTML' => $lang['Disable_HTML_post'], 
	'L_DISABLE_BBCODE' => $lang['Disable_BBCode_post'], 
	'L_DISABLE_SMILIES' => $lang['Disable_Smilies_post'], 
	'L_NO_SHOUTS' => $lang['No_shouts'],	
	'L_MOOD' => $lang['Mood'],
	'L_CURRENTLY' => $lang['Currently'],
	'L_WEBLOG_OWNER' => $lang['Weblog_Owner'],
	'L_WEBLOG' => $lang['Weblog'],
	'L_GO' => $lang['Go'],
	'L_WEBLOG_STARTED' => $lang['Start_date'],
	'L_VIEW_ALL_ENTRIES' => $lang['View_all_entries'],	
	'L_PRIVATE_MESSAGE' => $lang['Private_Message'],	
	'L_JOINED' => $lang['Joined'],
	'L_LOCATION' => $lang['Location'],
	'L_OCCUPATION' => $lang['Occupation'],
	'L_INTERESTS' => $lang['Interests'],
	'L_TOTAL_ENTRIES' => $lang['Total_entries'],
	'L_WEBLOG_AGE' => $lang['Weblog_age'],
	'L_FRIENDS_LIST' => ( $userdata['user_showfriends'] ) ? $lang['Friends_list'] : '',
	'L_BLOCKED_LIST' => $lang['Blocked_list'],
	'L_SEND_PM' => $lang['Send_private_message'],
	'L_EMAIL' => $lang['Email'],	
	'L_REPLIES' => $lang['Replies'],
	'L_TOTAL_REPLIES' => $lang['Total_replies'],
	'L_VISITS' => $lang['Visits'],
	'L_POST_NEW_ENTRY' => ( $userdata['user_id'] == $weblog_data['user_id'] || $contributor ) ? $lang['Post_new_entry'] : '',
	'L_COMMENT_ON_ENTRY' => $lang['Comment_on_entry'],
	'L_VIEW_COMMENTS' => $lang['View_comments'],
	'L_RSS' => $lang['RSS'],
	'L_WEBLOG_CP' => $lang['Weblog_CP'],
	'L_SHOUT' => $lang['Shout'],
	'L_SUBMIT' => $lang['Submit'],
	'L_RESET' => $lang['Reset'],
	'L_NAME' => $lang['Username'],
	'L_VIEW_SMILIES' => $lang['View_smilies'],
	'L_PERMALINK' => $lang['Permalink'],
        'U_CONTRIBUTORS' => append_sid("weblog_contributors.$phpEx?" . POST_WEBLOG_URL . "=" . $weblog_data['weblog_id']),
	'U_VIEW_SMILIES' => append_sid("posting.$phpEx?mode=smilies"),
	'U_FORWARD' => ( $previous != 0 ) ? '<a href="weblog.php?' . POST_WEBLOG_URL . '=' . $weblog_data['weblog_id'] . '&amp;previous=' . ($previous - $weblog_data['entries_perpage']) . $categoryLink . '" class="nav">' . $lang['Forward'] . '</a>' : $lang['Forward'],
	'U_BACK' => ( ($previous + $weblog_data['entries_perpage']) < count($entry_data) ) ? '<a href="weblog.php?' . POST_WEBLOG_URL . '=' . $weblog_data['weblog_id'] . '&amp;previous=' . ($previous + $weblog_data['entries_perpage']) . $categoryLink . '" class="nav">' . $lang['Back'] . '</a>' : $lang['Back'],
	'U_PROFILE' => append_sid("profile.$phpEx?mode=viewprofile&amp;" . POST_USERS_URL . "=" . $weblog_data['user_id']),	
	'U_SEND_PRIVATE_MESSAGE' => ( $weblog_data['show_contact_info'] && !empty($pm_url) ) ? $pm_url : '',	
	'U_WEBLOG' => append_sid("weblog.$phpEx?" . POST_WEBLOG_URL . "=" . $weblog_data['weblog_id']),
	'U_WEBLOG_CP' => append_sid("weblog_config.$phpEx"),
	'U_POST_ENTRY' => ( $userdata['user_id'] == $weblog_data['user_id'] || $contributor ) ? append_sid("weblog_posting.$phpEx?mode=newentry&amp;" . POST_WEBLOG_URL . "=" . $weblog_data['weblog_id']) : '',
	'U_ALL_ENTRIES' => append_sid("weblog_allentries.$phpEx?" . POST_WEBLOG_URL . '=' . $weblog_data['weblog_id']),
	'U_RSS_FEED' => append_sid("weblog_rss.$phpEx?" . POST_WEBLOG_URL . "=" . $weblog_data['weblog_id']),
	'U_FRIENDS_LIST' => ( $userdata['user_showfriends'] ) ? append_sid("weblog_friends.$phpEx?" . POST_USERS_URL . "=" . $weblog_data['user_id']) : '',
	'U_BLOCKED_LIST' => ( $userdata['user_id'] == $weblog_data['user_id'] || $contributors ) ? append_sid("weblog_blocked.$phpEx?" . POST_USERS_URL . "=" . $weblog_data['user_id']) : '',
	'U_PREVIOUS_MONTH' => ( $month == 1 ) ? append_sid("weblog.$phpEx?" . POST_WEBLOG_URL . "=" . $weblog_data['weblog_id'] . "&amp;previous=$previous&∓month=$lastmonth&amp;year=$lastyear") : append_sid("weblog.$phpEx?" . POST_WEBLOG_URL . "=" . $weblog_data['weblog_id'] . "&amp;previous=$previous&amp;month=$lastmonth&amp;year=$year"),
	'U_NEXT_MONTH' => ( $month == 12 ) ? append_sid("weblog.$phpEx?" . POST_WEBLOG_URL . "=" . $weblog_data['weblog_id'] . "&amp;previous=$previous&amp;month=$nextmonth&amp;year=$nextyear") : append_sid("weblog.$phpEx?" . POST_WEBLOG_URL . "=" . $weblog_data['weblog_id'] . "&amp;previous=$previous&amp;month=$nextmonth&amp;year=$year"),
	'U_PREVIOUS_YEAR' => append_sid("weblog.$phpEx?" . POST_WEBLOG_URL . "=" . $weblog_data['weblog_id'] . "&amp;previous=$previous&amp;month=$month&amp;year=$lastyear"),
	'U_NEXT_YEAR' => append_sid("weblog.$phpEx?" . POST_WEBLOG_URL . "=" . $weblog_data['weblog_id'] . "&amp;previous=$previous&amp;month=$month&amp;year=$nextyear"))
);

$template->pparse('body');

include($phpbb_root_path . 'includes/page_tail.'.$phpEx);

?>∓