<?php
/***************************************************************************
 *                           �  KaspeR
 *                            -------------------
 ***************************************************************************/

define('IN_PHPBB', true);

$phpbb_root_path = './';
include($phpbb_root_path . 'extension.inc');
include($phpbb_root_path . 'common.'.$phpEx);


$userdata = session_pagestart($user_ip, PAGE_INDEX);
init_userprefs($userdata);

if (isset($HTTP_POST_VARS['mode']) || isset($HTTP_GET_VARS['mode']))
{
	$mode = (isset($HTTP_POST_VARS['mode'])) ? $HTTP_POST_VARS['mode'] : $HTTP_GET_VARS['mode'];
}
else
{
	$mode = '';
}

$user_id = (isset($HTTP_GET_VARS[POST_USERS_URL])) ? intval($HTTP_GET_VARS[POST_USERS_URL]) : 0;

$page_title	= $lang['Points_sys'];
include($phpbb_root_path . 'includes/page_header.'.$phpEx);


$template->set_filenames(array(
	'body' => 'points_system.tpl')
);


if ($mode == 'donate')
{
	if ($userdata['user_id'] == ANONYMOUS)
	{
		$redirect = $phpbb_root_path . "pointscp.$phpEx&mode=donate";
		$redirect .= (isset($user_id)) ? '&' . POST_USERS_URL . '=' . $user_id : '';
		header('Location: ' . append_sid($phpbb_root_path . "login.$phpEx?redirect=$redirect", true));
	}
	
	if (!$board_config['points_donate'] && $userdata['user_level'] != ADMIN/* && !$userdata['admin_allow_points']*/)
	{
		message_die(GENERAL_MESSAGE, $lang['Points_user_donation_off']);
	}
	
	if (isset($HTTP_POST_VARS['submit']))
	{
		if(!empty($HTTP_POST_VARS['username']))
		{
			$to_userdata = get_userdata($HTTP_POST_VARS['username'], true);
			$user_id = $to_userdata['user_id'];

			if (!$to_userdata)
			{
				$error = true;
				$error_msg = $lang['No_such_user'];
			}
			if ($user_id == $userdata['user_id'])
			{
				$error = true;
				$error_msg .= ((!empty($error_msg)) ? '<br />' : '') . sprintf($lang['Points_cant_donate_self'], $board_config['points_name']);
			}
			/*if (!$to_userdata['admin_allow_points'])
			{
				$error = true;
				$error_msg .= ((!empty($error_msg)) ? '<br />' : '') . sprintf($lang['Points_cant_donate'], $board_config['points_name']);
			}*/

		}
		else
		{
			$error = true;
			$error_msg = $lang['Points_no_username'];
		}

		if (abs(intval($HTTP_POST_VARS['amount'])) == 0)
		{
			$error = true;
			$error_msg .= ((!empty($error_msg)) ? '<br />' : '') . sprintf($lang['Points_enter_some_donate'], $board_config['points_name']);
		}

		if (isset($error))
		{
			$template->set_filenames(array(
				'reg_header' => 'error_body.tpl')
			);
			$template->assign_vars(array(
				'ERROR_MESSAGE' => $error_msg)
			);
			$template->assign_var_from_handle('ERROR_BOX', 'reg_header');
		}
		else
		{
			$amount = abs(intval($HTTP_POST_VARS['amount']));
			$from_points = get_user_points($userdata['user_id']);
			
			if ($amount > $from_points)
			{
				message_die(GENERAL_MESSAGE, sprintf($lang['Points_cant_donate'], $board_config['points_name']));
			}

			add_points($user_id, $amount);

			subtract_points($userdata['user_id'], $amount);

			//Send donation email if the user wants it

			if ($to_userdata['user_notify_donation'])
			{
				include($phpbb_root_path . 'includes/emailer.'.$phpEx);
				$emailer = new emailer($board_config['smtp_delivery']);

				$email_headers = 'From: ' . $board_config['board_email'] . "\nReturn-Path: " . $board_config['board_email'] . "\n";

				$emailer->use_template('user_notify_donation', $to_userdata['user_lang']);
				$emailer->email_address($to_userdata['user_email']);
				$emailer->extra_headers($email_headers);

				$message = stripslashes(htmlspecialchars($HTTP_POST_VARS['message']));

				$emailer->assign_vars(array(
					'DONATOR' => stripslashes($userdata['username']),
					'USERNAME' => stripslashes($to_userdata['username']),
					'MESSAGE' => trim($message),
					'AMOUNT_DONATE' => $amount,
					'TOTAL_POINTS' => get_user_points($user_id),
					'EMAIL_SIG' => str_replace('<br />', "\n", "-- \n" . $board_config['board_email_sig']),
					'SITENAME' => $board_config['sitename'],					
					'L_POINTS' => $board_config['points_name'])
				);

				$emailer->send();
				$emailer->reset();
			}

			$loc = (!empty($HTTP_POST_VARS['location'])) ? $HTTP_POST_VARS['location'] : append_sid($phpbb_root_path . "pointscp.$phpEx?mode=donate");

			$template->assign_vars(array(
				'META' => '<meta http-equiv="refresh" content="3;url=' . $loc . '">')
			);

			$msg = $lang['Points_thanks_donation'] . '<br /><br />' . sprintf($lang['Click_return_points_donate'], '<a href="' . append_sid($phpbb_root_path . "pointscp.$phpEx?mode=donate") . '">', '</a> ') . '<br /><br />' . sprintf($lang['Click_return_index'], '<a href="' . append_sid("index.$phpEx") . '">', '</a>');
			message_die(GENERAL_MESSAGE, $msg);
		}
	}

	$s_username = (!empty($user_id)) ? get_username_from_id($user_id) : '';
	$location = (empty($HTTP_POST_VARS['location'])) ? $HTTP_SERVER_VARS['HTTP_REFERER'] : $location;
	$s_hidden_fields = '<input type="hidden" name="location" value="' . $location . '">';

	$template->assign_vars(array(
		'L_FIND_USERNAME' => $lang['Find_username'],
		'L_SUBMIT' => $lang['Submit'],
		'L_RESET' => $lang['Reset'],
		'L_POINTS_TITLE' => $lang['Points_donation'],
		'L_DONATE_TO' => sprintf($lang['Points_donate_to'], $board_config['points_name']),
		'L_AMOUNT' => $lang['Points_amount'],
		'L_AMOUNT_GIVE' => sprintf($lang['Points_give'], $board_config['points_name']),

		'USERNAME' => $s_username,
		'S_HIDDEN_FIELDS' => $s_hidden_fields,
		'S_POST_ACTION' => append_sid($phpbb_root_path . "pointscp.$phpEx?mode=donate", true),
		'U_SEARCH_USER' => append_sid($phpbb_root_path . "search.$phpEx?mode=searchuser"))
	);
	$template->assign_block_vars('switch_points_donate', array());
}
else
{
	if ($userdata['user_id'] == ANONYMOUS)
	{
		$redirect = "pointscp.$phpEx";
		$redirect .= (isset($user_id)) ? '&user_id=' . $user_id : '';
		header('Location: ' . append_sid($phpbb_root_path . "login.$phpEx?redirect=$redirect", true));
	}

	if ($userdata['user_level'] != ADMIN && user_is_authed($userdata['user_id']) == false)
	{
		message_die(GENERAL_MESSAGE, $lang['Points_not_admin']);
	}
	
	if (isset($HTTP_POST_VARS['submit']))
	{
		$points_reset = (isset($HTTP_POST_VARS['points_reset']) && $userdata['user_level'] == ADMIN) ? true : false;
		if (empty($HTTP_POST_VARS['username']) && empty($HTTP_POST_VARS['mass_username']) && $userdata['user_level'] != ADMIN)
		{
			$error = true;
			$error_msg .= $lang['Points_no_username'];
		}
		if (!$$error)
		{
			$user_id = get_userid_from_name($HTTP_POST_VARS['username']);
			
			if (empty($user_id) && empty($HTTP_POST_VARS['mass_username']) && $userdata['user_level'] != ADMIN)
			{
				$error = true;
				$error_msg = $lang['No_such_user'];
			}
			else
			{
				$user_id_list = array();

				if (!empty($user_id))
				{
					$user_id_list[] = $user_id;
				}
				else if (!empty($HTTP_POST_VARS['mass_username']))
				{
					$mass_usernames = explode("\n", $HTTP_POST_VARS['mass_username']);

					foreach ($mass_usernames as $username)
					{
						$username = trim($username);

						if (!empty($username))
						{
							$user_id = get_userid_from_name($username);
							if (!empty($user_id))
							{
								$user_id_list[] = $user_id;
							}
						}
					}
				}
				else if ($userdata['user_level'] == ADMIN)
				{
					$sql = "SELECT user_id
				                FROM " . USERS_TABLE . " WHERE user_id <> " . ANONYMOUS ;
					if( !($result = $db->sql_query($sql)) )
					{
						message_die(GENERAL_ERROR, 'Could not query users', '', __LINE__, __FILE__, $sql);
					}
					while ( $row = $db->sql_fetchrow($result) )
					{
						if (!empty($row['user_id']))
						{
							$user_id_list[] = $row['user_id'];
						}
					}
					$db->sql_freeresult($result);
				}
			}
		}

		if (isset($error))
		{
			$template->set_filenames(array(
				'reg_header' => 'error_body.tpl')
			);
			$template->assign_vars(array(
				'ERROR_MESSAGE' => $error_msg)
			);
			$template->assign_var_from_handle('ERROR_BOX', 'reg_header');
		}
		else
		{
			$amount = abs(intval($HTTP_POST_VARS['amount']));

			$amount = ($HTTP_POST_VARS['method']) ? $amount : -$amount;
			change_points($user_id_list, $amount, $points_reset);

			$loc = (isset($HTTP_POST_VARS['location']) && !empty($HTTP_POST_VARS['location'])) ? $HTTP_POST_VARS['location'] : $HTTP_SERVER_VARS['HTTP_REFERER'];
			
			$template->assign_vars(array(
				'META' => '<meta http-equiv="refresh" content="3;url=' . $loc . '">')
			);

			$msg = sprintf($lang['Points_user_updated'], $board_config['points_name']) . '<br /><br />' . sprintf($lang['Click_return_pointscp'], '<a href="' . $loc . '">', '</a> ') . '<br /><br />' . sprintf($lang['Click_return_index'], '<a href="' . append_sid("index.$phpEx") . '">', '</a>');
			message_die(GENERAL_MESSAGE, $msg);
		}
	}

	$s_username = (!empty($user_id)) ? get_username_from_id($user_id) : '';
	$location = (!isset($HTTP_POST_VARS['location'])) ? $HTTP_SERVER_VARS['HTTP_REFERER'] : $location;
	$s_hidden_fields = '<input type="hidden" name="location" value="' . $location . '">';

	$template->assign_vars(array(
		'L_FIND_USERNAME' => $lang['Find_username'],
		'L_ADD' => $lang['Add'],
		'L_SUBTRACT' => $lang['Subtract'],
		'L_SUBMIT' => $lang['Submit'],
		'L_RESET' => $lang['Reset'],
		'L_POINTS_TITLE' => $lang['Points_cp'],
		'L_AMOUNT' => $lang['Points_amount'],
		'L_AMOUNT_GIVE_TAKE' => sprintf($lang['Points_give_take'], $board_config['points_name']),
		'L_METHOD' => $lang['Points_method'],
		'L_ADD_SUBTRACT' => sprintf($lang['Points_add_subtract'], $board_config['points_name']),
		'L_MASS_EDIT' => $lang['Points_mass_edit'],
		'L_MASS_EDIT_EXPLAIN' => $lang['Points_mass_edit_explain'],
		'L_MESSAGE' => $lang['Message'],
	 
		'USERNAME' => $s_username,
		'S_AMOUNT' => $board_config['points_topic'],
		'S_HIDDEN_FIELDS' => $s_hidden_fields,
		'S_POST_ACTION' => append_sid($phpbb_root_path . "pointscp.$phpEx", true),
		'U_SEARCH_USER' => append_sid($phpbb_root_path . "search.$phpEx?mode=searchuser"))
	);
	$template->assign_block_vars('switch_points_cp', array());
}

$template->pparse('body');

include($phpbb_root_path . 'includes/page_tail.'.$phpEx);

?>