<?php
/*************************************************
 *    apwa.ru       index.php
 *                 -------------
 * Anv@r.all 2009 Модуль портала для phpbb 2.0.23
 ************************************************/
if ( !defined('IN_PHPBB') )
{
	die("Hacking attempt");
} 

function bbencode_strip($text, $uid)
{
	$text = " " . $text;
	if (! (strpos($text, "[") && strpos($text, "]")) )
	{
		$text = substr($text, 1);
		return $text;
	}
	$text = str_replace("[code:1:$uid]","", $text);
	$text = str_replace("[/code:1:$uid]", "", $text);
	$text = str_replace("[code:$uid]", "", $text);
	$text = str_replace("[/code:$uid]", "", $text);
	$text = str_replace("[quote:1:$uid]","", $text);
	$text = str_replace("[/quote:1:$uid]", "", $text);
	$text = str_replace("[quote:$uid]", "", $text);
	$text = str_replace("[/quote:$uid]", "", $text);
	$text = preg_replace("/\[quote:$uid=(?:\"?([^\"]*)\"?)\]/si", "", $text);
	$text = preg_replace("/\[quote:1:$uid=(?:\"?([^\"]*)\"?)\]/si", "", $text);	
	$text = str_replace("[list:$uid]", "", $text);
	$text = str_replace("[*:$uid]", "", $text);
	$text = str_replace("[/list:u:$uid]", "", $text);
	$text = str_replace("[/list:o:$uid]", "", $text);
	$text = preg_replace("/\[list=([a1]):$uid\]/si", "", $text);
	$text = preg_replace("/\[color=(\#[0-9A-F]{6}|[a-z]+):$uid\]/si", "", $text);
	$text = str_replace("[/color:$uid]", "", $text);
        $text = preg_replace("/\[url\]/i","", $text);
        $text = preg_replace("/\[\/url\]/i", "", $text);
        $text = preg_replace("/\[url=([a-z0-9\-\.,\?!%\*_\/:;~\\&$@\/=\+]+)\]/si", "", $text);
        $text = preg_replace("/\[\/url:$uid\]/i", "", $text); 
	$text = str_replace("[img:$uid]","", $text);
	$text = str_replace("[/img:$uid]", "", $text);
	$text = str_replace("[email:$uid]","", $text);
	$text = str_replace("[/email:$uid]", "", $text);
	$text = preg_replace("/\[size=([\-\+]?[1-2]?[0-9]):$uid\]/si", "", $text);
	$text = str_replace("[/size:$uid]", "", $text);	
	$text = str_replace("[b:$uid]","", $text);
	$text = str_replace("[/b:$uid]", "", $text);
	$text = str_replace("[u:$uid]", "", $text);
	$text = str_replace("[/u:$uid]", "", $text);
	$text = str_replace("[i:$uid]", "", $text);
	$text = str_replace("[/i:$uid]", "", $text);  	
	$text = substr($text, 1);
	return $text;
}

$sql = 'SELECT t.topic_id, t.forum_id, t.topic_title, t.topic_time, t.topic_replies, t.topic_poster,
	       u.username, pt.post_id, pt.post_text, pt.bbcode_uid, p.post_id, p.enable_smilies
	FROM ' . TOPICS_TABLE . ' AS t, ' . USERS_TABLE . ' AS u, ' . POSTS_TEXT_TABLE . ' AS pt, ' . POSTS_TABLE . ' AS p
	WHERE t.forum_id IN (' . $CFG['news_forum'] . ') 
	   AND t.topic_time <= ' . time() . ' 
	   AND t.topic_poster = u.user_id 
	   AND t.topic_first_post_id = pt.post_id 
	   AND t.topic_first_post_id = p.post_id 
	   AND t.topic_status <> 2
	ORDER BY t.topic_time DESC';
if ($CFG['number_of_news'] != 0)
{
	$sql .= ' LIMIT ' . $CFG['number_of_news'];
}
if(!($result = $db->sql_query($sql)))
{
	message_die(GENERAL_ERROR, 'Could not query announcements information', '', __LINE__, __FILE__, $sql);
}

$posts = array();
while ($row = $db->sql_fetchrow($result))
{
       $posts[] = $row;
}
$db->sql_freeresult($result);

$template->set_filenames(array(
	'news' => 'module/news_body.tpl')
);

$template->assign_block_vars('news', array(
        'U_NEWS' => append_sid("viewforum.$phpEx?f=1"))
);      
	               	       	
for ($i = 0; $i < count($posts); $i++)
{
	 $message = $posts[$i]['post_text'];
	 $message = preg_replace('#(<)([\/]?.*?)(>)#is', "&lt;\\2&gt;", $message);
	 	
	 if ((($CFG['news_length'] == 0) or (strlen($message) <= $CFG['news_length'])) || $module == 'news')
	 {				
		 $message = bbencode_second_pass($message, $posts[$i]['bbcode_uid']);
		 $read_full = '';
	 }
	 else
	 {
		 $message = bbencode_strip($message, $posts[$i]['bbcode_uid']);
		 $message = substr($message, 0, $CFG['news_length']-strlen (strrchr(substr($message, 0, $CFG['news_length']), ' '))) . '&hellip;';	
		 $read_full = $lang['Read_Full'];
	 }
	 if ($posts[$i]['enable_smilies'] == 1)
	 {
		 $message = smilies_pass($message);
	 }
	 $message = make_clickable($message);

	 $orig_word = array();
	 $replacement_word = array();
	 obtain_word_list($orig_word, $replacement_word);

	 if (count($orig_word))
	 {			      		              			     	
		 $message = str_replace($orig_word, $replacement_word, $message);
	 }	 
	 $message = str_replace("\n", "\n<br />\n", $message);
         $post_date = create_date($board_config['default_dateformat'], $posts[$i]['topic_time'], $board_config['board_timezone']);
	 
	 $template->assign_block_vars('news.fetchpost_row', array(
		 'TITLE' => $posts[$i]['topic_title'],
		 'POSTER' => $posts[$i]['username'],
		 'REPLIES' => $posts[$i]['topic_replies'],
		 'TEXT' => $message,		  
		 'TIME' => $post_date,			
		 'U_VIEW_COMMENTS' => append_sid('viewtopic.' . $phpEx . '?t=' . $posts[$i]['topic_id']),
		 'U_POST_COMMENT' => append_sid('posting.' . $phpEx . '?mode=reply&amp;t=' . $posts[$i]['topic_id']),
		 'U_READ_FULL' => append_sid('index.' . $phpEx . '?module=news'),
		 'L_READ_FULL' => $read_full)
	);
}
$template->assign_var_from_handle('MODULE_NEWS', 'news');
	
?>        