<?php
/***************************************************************************
 *                  memberlist.php
 *                            -------------------
 *      Author: phpBB Group.
 ***************************************************************************/

define('IN_PHPBB', true);
$phpbb_root_path = './';
include($phpbb_root_path . 'extension.inc');
include($phpbb_root_path . 'common.'.$phpEx);

$userdata = session_pagestart($user_ip, PAGE_VIEWMEMBERS);
init_userprefs($userdata);

if ( isset($HTTP_POST_VARS['start1']) )
{
       $start1 = intval($HTTP_POST_VARS['start1']);
       $start = (($start1 - 1) * $board_config['topics_per_page']);
} 
else 
{
       $start = ( isset($HTTP_GET_VARS['start']) ) ? intval($HTTP_GET_VARS['start']) : 0;
       $start = ($start < 0) ? 0 : $start;
}

$page_title = $lang['Viewing_member_list'];
include($phpbb_root_path . 'includes/page_header.'.$phpEx);

if (isset($HTTP_GET_VARS['ban']))
{

        $template->set_filenames(array(
	      'body' => 'banlist_body.tpl')
        );

        $sql = "SELECT username, user_id, user_posts 
	       FROM " . USERS_TABLE . "
	       WHERE user_id <> " . ANONYMOUS . " AND user_warnings > 0 
	       ORDER BY user_posts 
	       DESC LIMIT $start, " . $board_config['topics_per_page'];
        if( !($result = $db->sql_query($sql)) )
        {
	       message_die(GENERAL_ERROR, 'Could not query users', '', __LINE__, __FILE__, $sql);
        }

        if ( $row = $db->sql_fetchrow($result) )
        {
	       $i = 0;
	       do
	       {
		      $user_id = $row['user_id'];

		      $sql = "SELECT expire, modification 
			      FROM " . REPUTATION_TABLE . "
			      WHERE user_id = $user_id AND modification = 4";
		      if( !($resultat = $db->sql_query($sql)) )
		      {
			      message_die(GENERAL_ERROR, 'Could not query users', '', __LINE__, __FILE__, $sql);
		      }
		      if ( $roww = $db->sql_fetchrow($resultat) )
		      {

			      $username = $row['username'];
			      $posts = ( $row['user_posts'] ) ? $row['user_posts'] : 0;
			      $expire = create_date('d M, G:i', $roww['expire'], $board_config['board_timezone']);

			      $template->assign_block_vars('banrow', array(
				      'USERNAME' => $username,
				      'POSTS' => $posts,
				      'EXPIRE' => $expire,
				      'U_VIEWPROFILE' => append_sid("profile.$phpEx?mode=viewprofile&amp;" . POST_USERS_URL . "=$user_id"))
			      );
		      }
		      else
		      {
		              message_die(GENERAL_MESSAGE, $lang['No_banlist']);
		      }
		      $i++;
	       }
	       while ( $row = $db->sql_fetchrow($result) );
	       $db->sql_freeresult($result);
         } 
         else 
         {
                message_die(GENERAL_MESSAGE, $lang['No_banlist']);
         }

         if ( $mode != 'topten' || $board_config['topics_per_page'] < 10 )
         {
	        $sql = "SELECT count(*) AS total
		        FROM " . USERS_TABLE . "
		        WHERE user_id <> " . ANONYMOUS . " 
		        AND user_warnings > 0";
	        if ( !($result = $db->sql_query($sql)) )
	        {
		        message_die(GENERAL_ERROR, 'Error getting total users', '', __LINE__, __FILE__, $sql);
	        }

	        if ( $total = $db->sql_fetchrow($result) )
	        {
		        $total_members = $total['total'];
		        $pagination = generate_pagination("memberlist.$phpEx?ban&amp;", $total_members, $board_config['topics_per_page'], $start). '';
	        }
	        $db->sql_freeresult($result);
         }
         else
         {
	        $pagination = '';
	        $total_members = 10;
         }

         $template->assign_vars(array(
	        'PAGINATION' => $pagination)
         );
         $template->pparse('body');
} 
else if (isset($HTTP_GET_VARS['admin'])) 
{

	$exclude_users = '';
	$template->assign_block_vars('switch_list_staff', array());
	$template->set_filenames(array(
 	       'body' => 'staff_body.tpl')
 	);

	$is_auth_ary = array();
	$is_auth_ary = auth(AUTH_VIEW, AUTH_LIST_ALL, $userdata, $forums);

	$sql_forums = "SELECT ug.user_id, f.forum_id, f.forum_name
		       FROM ". AUTH_ACCESS_TABLE ." aa, ". USER_GROUP_TABLE ." ug, ". FORUMS_TABLE ." f
		       WHERE aa.auth_mod = ". TRUE ." 
		       AND ug.group_id = aa.group_id 
		       AND f.forum_id = aa.forum_id
		       ORDER BY f.forum_order";
	if( !$result_forums = $db->sql_query($sql_forums) )
	{
		message_die(GENERAL_ERROR, 'could not query forums.', '', __LINE__, __FILE__, $sql_forums);
	}
	while( $row = $db->sql_fetchrow($result_forums) )
	{
		$display_forums = ( $is_auth_ary[$row['forum_id']]['auth_view'] ) ? true : false;
		if( $display_forums )
		{
			$forum_id = $row['forum_id'];
			$staff2[$row['user_id']][$row['forum_id']] = '<a href="'. append_sid("viewforum.$phpEx?f=$forum_id") .'" class="genmed">'. $row['forum_name'] .'</a>';
		}
	}
	$db->sql_freeresult($result_forums);

	$level_cat = $lang['Staff_level'];
	for( $i = 0; $i < count($level_cat); $i++ )
	{
		$user_level = $level_cat[$i];

		$template->assign_block_vars('switch_list_staff.user_level', array(
		      'USER_LEVEL' => $user_level)
		);

		if( $level_cat['0'] )
		{
			$where = 'user_level = '. ADMIN;
		}
		else if( $level_cat['1'] )
		{
			$where = 'user_level = '. MOD;
		}
		$level_cat[$i] = '';

		$sql_exclude_users = ( !empty($exclude_users) ) ? ' AND user_id NOT IN ('. $exclude_users .')' : '';
		
		$sql_user = "SELECT * FROM ". USERS_TABLE ." 
	 	             WHERE $where $sql_exclude_users 
	 	             ORDER BY user_regdate";
		
		if( !($result_user = $db->sql_query($sql_user)) )
		{
			message_die(GENERAL_ERROR, 'could not obtain user information.', '', __LINE__, __FILE__, $sql_user);
		}
		if( $staff = $db->sql_fetchrow($result_user) )
		{
			$k = 0;
			do
			{
				$user_id = $staff['user_id'];
				$user_status = ( $staff['user_session_time'] >= (time() - 60) ) ? (( $row['user_allow_viewonline'] ) ? $lang['Staff_online'] : (( $userdata['user_level'] == ADMIN || $userdata['user_id'] == $user_id ) ? $lang['Staff_online'] : '')) : '';
		               
		                /*$avatar_img = '<img src="' . $board_config['avatar_path'] . '/noava.gif" alt="" height="60" width="60"/>'; 
                                if ( $staff['user_avatar_type'] && $staff['user_allowavatar'] ) 
                                { 
                                        switch( $staff['user_avatar_type'] ) 
                                        { 
                                               case USER_AVATAR_UPLOAD: 
                                                    $avatar_img = '<img src="' . $board_config['avatar_path'] . '/' . $staff['user_avatar'] . '" alt=""/>'; 
                                               break; 
                                               case USER_AVATAR_REMOTE: 
                                                    $avatar_img = '<img src="' . $staff['user_avatar'] . '" alt=""/>'; 
                                               break; 
                                               case USER_AVATAR_GALLERY: 
                                                    $avatar_img = '<img src="' . $board_config['avatar_gallery_path'] . '/' . $staff['user_avatar'] . '" alt=""/>'; 
                                               break; 
                                        } 
                                }*/
                                 
                                avatar_img($staff['user_avatar_type'], $staff['user_allowavatar'], $staff['user_avatar'], $avatar_img, $avatar_mini);
                                
                                $user_gender = ( $staff['user_gender'] == 1 ||  $staff['user_gender'] == 2 ) ? (($staff['user_gender'] == 1 ) ? '<img src="./images/m-off.gif" alt=""/>' : '<img src="./images/f-off.gif" alt="" />') : '';

				$forums = ($staff['user_level'] == ADMIN) ? '<span class="cattitle">' . $lang['All_available'] . '</span>' : $lang['Moderator'];
				if( !empty($staff2[$staff['user_id']]) )
				{
					asort($staff2[$staff['user_id']]);
					$forums = implode(', ',$staff2[$staff['user_id']]);
				}

				$template->assign_block_vars('switch_list_staff.user_level.staff', array(
				        'AVATAR_IMG' => $avatar_img,
				        'AVATAR_MINI' => $avatar_mini,
				        'GENDER' => $user_gender,
					'USERNAME' => $staff['username'],
					'POSTS' => $staff['user_posts'],
					'USER_STATUS' => $user_status,
					'U_PROFILE' => append_sid("profile.$phpEx?mode=viewprofile&amp;". POST_USERS_URL ."=$user_id"),
					'FORUMS' => $forums,
				));
				$k++;
			}
			while( $staff = $db->sql_fetchrow($result_user) );
			$db->sql_freeresult($result_user);
		}
	}
        $template->pparse('body');
} 
else 
{
        if ( isset($HTTP_GET_VARS['gender']) || isset($HTTP_POST_VARS['gender']) )
        {
	       $gender = ( isset($HTTP_POST_VARS['gender']) ) ? htmlspecialchars($HTTP_POST_VARS['gender']) : htmlspecialchars($HTTP_GET_VARS['gender']);
        }
        else
        {
	       $gender = '';
        }
        if ( isset($HTTP_GET_VARS['mode']) || isset($HTTP_POST_VARS['mode']) )
        {
	        $mode = ( isset($HTTP_POST_VARS['mode']) ) ? htmlspecialchars($HTTP_POST_VARS['mode']) : htmlspecialchars($HTTP_GET_VARS['mode']);
        }
        else
        {
	        $mode = 'points';
        }
        if(isset($HTTP_POST_VARS['order']))
        {
	        $sort_order = ($HTTP_POST_VARS['order'] == 'ASC') ? 'ASC' : 'DESC';
        }
        else if(isset($HTTP_GET_VARS['order']))
        {
	        $sort_order = ($HTTP_GET_VARS['order'] == 'ASC') ? 'ASC' : 'DESC';
        }
        else
        {
	        $sort_order = 'DESC';
        }
        $mode_types_text = array($lang['Sort_Joined'], $lang['Sort_Username'], $lang['Sort_Posts'], $lang['Sort_Top_Ten']);
        $mode_types = array('joined', 'username', 'posts', 'topten', 'points');

        $select_sort_mode = '<select name="mode">';
        for($i = 0; $i < count($mode_types_text); $i++)
        {
	        $selected = ( $mode == $mode_types[$i] ) ? ' selected="selected"' : '';
	        $select_sort_mode .= '<option value="' . $mode_types[$i] . '"' . $selected . '>' . $mode_types_text[$i] . '</option>';
        }
        $select_sort_mode .= '</select>';
        $select_sort_order = '<select name="order">';
        if($sort_order == 'ASC')
        {
	        $select_sort_order .= '<option value="ASC" selected="selected">' . $lang['Sort_Ascending'] . '</option><option value="DESC">' . $lang['Sort_Descending'] . '</option>';
        }
        else
        {
	        $select_sort_order .= '<option value="ASC">' . $lang['Sort_Ascending'] . '</option><option value="DESC" selected="selected">' . $lang['Sort_Descending'] . '</option>';
        }
        $select_sort_order .= '</select>';
        
        $template->set_filenames(array(
	        'body' => 'memberlist_body.tpl')
        );

        $template->assign_vars(array(
	        'L_SELECT_SORT_METHOD' => $lang['Select_sort_method'],
	        'L_EMAIL' => $lang['Email'],
	        'L_WEBSITE' => $lang['Website'],
	        'L_FROM' => $lang['Location'],
	        'L_ORDER' => $lang['Order'],
	        'L_SORT' => $lang['Sort'],
	        'L_SUBMIT' => $lang['Sort'],
	        'L_JOINED' => $lang['Joined'], 
	        'L_POSTS' => $lang['Posts'], 
	        'L_PM' => $lang['Private_Message'],
	        'L_POINTS' => $points_config['points_name'], 

	        'S_MODE_SELECT' => $select_sort_mode,
	        'S_ORDER_SELECT' => $select_sort_order,
	        'S_MODE_ACTION' => append_sid("memberlist.$phpEx"))
        );

        switch( $mode )
        {
	       case 'joined':
		$order_by = "user_regdate $sort_order LIMIT $start, " . $board_config['topics_per_page'];
		break;
	       case 'username':
		$order_by = "username $sort_order LIMIT $start, " . $board_config['topics_per_page'];
		break;
	       case 'posts':
		$order_by = "user_posts $sort_order LIMIT $start, " . $board_config['topics_per_page'];
		break;
	       case 'topten':
		$order_by = "user_posts $sort_order LIMIT 10";
		break;
	       case 'points':
		$order_by = "user_points $sort_order LIMIT $start," . $board_config['topics_per_page'];
		break;		
	       default:
		$order_by = "user_points $sort_order LIMIT $start, " . $board_config['topics_per_page'];
		break;
        }

        $gender_sql = ( $gender == 'm' || $gender == 'f' ) ? (( $gender == 'm') ? 'AND user_gender = 1' : 'AND user_gender = 2') : '';

        $sql = "SELECT username, user_id, user_level, user_posts, user_points, user_nic_color, user_gender, user_yim, user_avatar_type, user_allowavatar, user_avatar 
	        FROM " . USERS_TABLE . "
	        WHERE user_id <> " . ANONYMOUS . " 
	        $gender_sql
	        ORDER BY $order_by";
        if( !($result = $db->sql_query($sql)) )
        {
	        message_die(GENERAL_ERROR, 'Could not query users', '', __LINE__, __FILE__, $sql);
        }
       	$memberrow = array();

	while( $row = $db->sql_fetchrow($result) )
	{
		$memberrow[] = $row;
	} 
	
	$cools = ($template_name == 'web') ? '5' : '1';
	
        for ($i = 0; $i < count($memberrow); $i += $cools)
	{
		$template->assign_block_vars('members', array());
		
		for ($j = $i; $j < ($i + $cools); $j++)
		{
	                if ( $row['user_level'] == ADMIN )
	                {
		               $poster_status = '<i style="color: red">Adm</i>';
	                } 
	                elseif ( $row['user_level'] == MOD ) 
	                {
		               $poster_status = '<i style="color: green">Mod</i>';
	                } 
	                else 
	                {
		               $poster_status = '';
	                }
	                $user_gender = ( $memberrow[$j]['user_gender'] == 1 ||  $memberrow[$j]['user_gender'] == 2 ) ? (( $memberrow[$j]['user_gender'] == 1 ) ? '<img src="./images/m-off.gif" alt=""/>' : '<img src="./images/f-off.gif" alt="" />') : '';
		        /*$avatar_img = '<img src="' . $board_config['avatar_path'] . '/noava.gif" alt="" height="60" width="60"/>'; 
                        if ( $memberrow[$j]['user_avatar_type'] && $memberrow[$j]['user_allowavatar'] ) 
                        { 
                               switch( $memberrow[$j]['user_avatar_type'] ) 
                               { 
                                     case USER_AVATAR_UPLOAD: 
                                         $avatar_img = '<img src="' . $board_config['avatar_path'] . '/' . $memberrow[$j]['user_avatar'] . '" alt=""/>'; 
                                     break; 
                                     case USER_AVATAR_REMOTE: 
                                         $avatar_img = '<img src="' . $memberrow[$j]['user_avatar'] . '" alt=""/>'; 
                                     break; 
                                     case USER_AVATAR_GALLERY: 
                                         $avatar_img = '<img src="' . $board_config['avatar_gallery_path'] . '/' . $memberrow[$j]['user_avatar'] . '" alt=""/>'; 
                                     break; 
                               } 
                        }*/
                        avatar_img($memberrow[$j]['user_avatar_type'], $memberrow[$j]['user_allowavatar'], $memberrow[$j]['user_avatar'], $avatar_img, $avatar_mini);
                        $posts = $memberrow[$j]['user_posts'];
		        $username = $memberrow[$j]['username'];
		        $user_color = $memberrow[$j]['user_nic_color'];
		        $user_id = $memberrow[$j]['user_id'];
		        $yim = ( $memberrow[$j]['user_yim'] ) ? $lang['YIM'] . ': ' . $memberrow[$j]['user_yim'] : '';
		        $user_points = ( $memberrow[$j]['user_points'] ) ? $memberrow[$j]['user_points'] : '0';
		        
                        $row_class = ( !($j % 2) ) ? 'row_easy' : 'row_hard';
		        $template->assign_block_vars('members.memberrow', array(
		               'ROW_CLASS' => $row_class,
		               'AVATAR_IMG' => $avatar_img,
		               'AVATAR_MINI' => $avatar_mini,
		               'POSTER_STATUS' => $poster_status,
			       'USERNAME' => $username,
			       'GENDER' => $user_gender,
			       'YIM' => $yim, 
			       'POINTS' => $user_points,
			       'POSTS' => $posts,
			       'COLOR' => $user_color,
			       'U_VIEWPROFILE' => append_sid("profile.$phpEx?mode=viewprofile&amp;" . POST_USERS_URL . "=$user_id"))
		        );
	        }
        }

        if ( $mode != 'topten' || $board_config['topics_per_page'] < 10 )
        {
	       $sql = "SELECT count(*) AS total
		       FROM " . USERS_TABLE . "
		       WHERE user_id <> " . ANONYMOUS . "
		       $gender_sql";

	       if ( !($result = $db->sql_query($sql)) )
	       {
		       message_die(GENERAL_ERROR, 'Error getting total users', '', __LINE__, __FILE__, $sql);
	       }

	       if ( $total = $db->sql_fetchrow($result) )
	       {
		       $total_members = $total['total'];
		       $genders = ( $gender == 'f' || $gender == 'm' ) ? '&amp;gender=' . $gender . '' : ''; 
		       $pagination = generate_pagination("memberlist.$phpEx?mode=$mode$genders&amp;order=$sort_order", $total_members, $board_config['topics_per_page'], $start). '';
	       }
	       $db->sql_freeresult($result);
        }
        else
        {
	       $pagination = '';
	       $total_members = 10;
        }

        $template->assign_vars(array(
	       'PAGINATION' => $pagination)
        );
        $template->pparse('body');
}

include($phpbb_root_path . 'includes/page_tail.'.$phpEx);

?>