CREATE TABLE IF NOT EXISTS `phpbb_album` (
  `pic_id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `pic_filename` varchar(255) NOT NULL,
  `pic_thumbnail` varchar(255) DEFAULT NULL,
  `pic_title` varchar(255) NOT NULL,
  `pic_desc` text,
  `pic_user_id` mediumint(8) NOT NULL,
  `pic_username` varchar(32) DEFAULT NULL,
  `pic_user_ip` char(8) NOT NULL DEFAULT '0',
  `pic_time` int(11) unsigned NOT NULL,
  `pic_cat_id` mediumint(8) unsigned NOT NULL DEFAULT '1',
  `pic_view_count` int(11) unsigned NOT NULL DEFAULT '0',
  `pic_lock` tinyint(3) NOT NULL DEFAULT '0',
  `pic_approval` tinyint(3) NOT NULL DEFAULT '1',
  PRIMARY KEY (`pic_id`),
  KEY `pic_cat_id` (`pic_cat_id`),
  KEY `pic_user_id` (`pic_user_id`),
  KEY `pic_time` (`pic_time`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

CREATE TABLE IF NOT EXISTS `phpbb_album_cat` (
  `cat_id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `cat_title` varchar(255) NOT NULL,
  `cat_desc` text,
  `cat_order` mediumint(8) NOT NULL,
  `cat_view_level` tinyint(3) NOT NULL DEFAULT '-1',
  `cat_upload_level` tinyint(3) NOT NULL DEFAULT '0',
  `cat_rate_level` tinyint(3) NOT NULL DEFAULT '0',
  `cat_comment_level` tinyint(3) NOT NULL DEFAULT '0',
  `cat_edit_level` tinyint(3) NOT NULL DEFAULT '0',
  `cat_delete_level` tinyint(3) NOT NULL DEFAULT '2',
  `cat_view_groups` varchar(255) DEFAULT NULL,
  `cat_upload_groups` varchar(255) DEFAULT NULL,
  `cat_rate_groups` varchar(255) DEFAULT NULL,
  `cat_comment_groups` varchar(255) DEFAULT NULL,
  `cat_edit_groups` varchar(255) DEFAULT NULL,
  `cat_delete_groups` varchar(255) DEFAULT NULL,
  `cat_moderator_groups` varchar(255) DEFAULT NULL,
  `cat_approval` tinyint(3) NOT NULL DEFAULT '0',
  PRIMARY KEY (`cat_id`),
  KEY `cat_order` (`cat_order`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

CREATE TABLE IF NOT EXISTS `phpbb_album_comment` (
  `comment_id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `comment_pic_id` int(11) unsigned NOT NULL,
  `comment_user_id` mediumint(8) NOT NULL,
  `comment_username` varchar(32) DEFAULT NULL,
  `comment_user_ip` char(8) NOT NULL,
  `comment_time` int(11) unsigned NOT NULL,
  `comment_text` text,
  `comment_edit_time` int(11) unsigned DEFAULT NULL,
  `comment_edit_count` smallint(5) unsigned NOT NULL DEFAULT '0',
  `comment_edit_user_id` mediumint(8) DEFAULT NULL,
  PRIMARY KEY (`comment_id`),
  KEY `comment_pic_id` (`comment_pic_id`),
  KEY `comment_user_id` (`comment_user_id`),
  KEY `comment_user_ip` (`comment_user_ip`),
  KEY `comment_time` (`comment_time`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

CREATE TABLE IF NOT EXISTS `phpbb_album_config` (
  `config_name` varchar(255) NOT NULL,
  `config_value` varchar(255) NOT NULL,
  PRIMARY KEY (`config_name`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

CREATE TABLE IF NOT EXISTS `phpbb_album_rate` (
  `rate_pic_id` int(11) unsigned NOT NULL,
  `rate_user_id` mediumint(8) NOT NULL,
  `rate_user_ip` char(8) NOT NULL,
  `rate_point` tinyint(3) unsigned NOT NULL,
  KEY `rate_pic_id` (`rate_pic_id`),
  KEY `rate_user_id` (`rate_user_id`),
  KEY `rate_user_ip` (`rate_user_ip`),
  KEY `rate_point` (`rate_point`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

CREATE TABLE IF NOT EXISTS `phpbb_attachments` (
  `attach_id` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `post_id` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `privmsgs_id` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `user_id_1` mediumint(8) NOT NULL,
  `user_id_2` mediumint(8) NOT NULL,
  `forum_id` int(11) NOT NULL,
  `date` int(11) NOT NULL,
  KEY `attach_id_post_id` (`attach_id`,`post_id`),
  KEY `attach_id_privmsgs_id` (`attach_id`,`privmsgs_id`),
  KEY `post_id` (`post_id`),
  KEY `privmsgs_id` (`privmsgs_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

CREATE TABLE IF NOT EXISTS `phpbb_attachments_config` (
  `config_name` varchar(255) NOT NULL,
  `config_value` varchar(255) NOT NULL,
  PRIMARY KEY (`config_name`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

CREATE TABLE IF NOT EXISTS `phpbb_attachments_desc` (
  `attach_id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `physical_filename` varchar(255) NOT NULL,
  `real_filename` varchar(255) NOT NULL,
  `download_count` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `comment` varchar(255) DEFAULT NULL,
  `extension` varchar(100) DEFAULT NULL,
  `mimetype` varchar(100) DEFAULT NULL,
  `filesize` int(20) NOT NULL,
  `filetime` int(11) NOT NULL DEFAULT '0',
  `thumbnail` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`attach_id`),
  KEY `filetime` (`filetime`),
  KEY `physical_filename` (`physical_filename`(10)),
  KEY `filesize` (`filesize`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

CREATE TABLE IF NOT EXISTS `phpbb_attach_quota` (
  `user_id` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `group_id` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `quota_type` smallint(2) NOT NULL DEFAULT '0',
  `quota_limit_id` mediumint(8) unsigned NOT NULL DEFAULT '0',
  KEY `quota_type` (`quota_type`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

CREATE TABLE IF NOT EXISTS `phpbb_auth_access` (
  `group_id` mediumint(8) NOT NULL DEFAULT '0',
  `forum_id` smallint(5) unsigned NOT NULL DEFAULT '0',
  `auth_view` tinyint(1) NOT NULL DEFAULT '0',
  `auth_read` tinyint(1) NOT NULL DEFAULT '0',
  `auth_post` tinyint(1) NOT NULL DEFAULT '0',
  `auth_reply` tinyint(1) NOT NULL DEFAULT '0',
  `auth_edit` tinyint(1) NOT NULL DEFAULT '0',
  `auth_delete` tinyint(1) NOT NULL DEFAULT '0',
  `auth_sticky` tinyint(1) NOT NULL DEFAULT '0',
  `auth_announce` tinyint(1) NOT NULL DEFAULT '0',
  `auth_vote` tinyint(1) NOT NULL DEFAULT '0',
  `auth_pollcreate` tinyint(1) NOT NULL DEFAULT '0',
  `auth_attachments` tinyint(1) NOT NULL DEFAULT '0',
  `auth_mod` tinyint(1) NOT NULL DEFAULT '0',
  `auth_download` tinyint(1) NOT NULL DEFAULT '0',
  KEY `group_id` (`group_id`),
  KEY `forum_id` (`forum_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

CREATE TABLE IF NOT EXISTS `phpbb_banlist` (
  `ban_id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `ban_userid` mediumint(8) NOT NULL,
  `ban_ip` char(8) NOT NULL,
  `ban_email` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`ban_id`),
  KEY `ban_ip_user_id` (`ban_ip`,`ban_userid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

CREATE TABLE IF NOT EXISTS `phpbb_blogs` (
  `weblog_id` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `weblog_name` varchar(60) NOT NULL DEFAULT '',
  `weblog_desc` varchar(255) NOT NULL DEFAULT '',
  `weblog_auth` tinyint(4) unsigned NOT NULL DEFAULT '0',
  `replies_auth` tinyint(4) unsigned NOT NULL DEFAULT '0',
  `weblog_entries` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `entries_perpage` smallint(5) unsigned NOT NULL DEFAULT '5',
  `weblog_create_date` int(11) NOT NULL DEFAULT '0',
  `weblog_views` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `weblog_advanced` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `show_weblog_info` tinyint(1) unsigned NOT NULL DEFAULT '1',
  `weblog_last_entry_id` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `cblock_bbcode_uid` varchar(10) NOT NULL DEFAULT '',
  PRIMARY KEY (`weblog_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

CREATE TABLE IF NOT EXISTS `phpbb_blog_actions` (
  `action_id` smallint(5) unsigned NOT NULL DEFAULT '0',
  `action_text` varchar(50) DEFAULT '',
  `action_url` varchar(100) DEFAULT '',
  PRIMARY KEY (`action_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

CREATE TABLE IF NOT EXISTS `phpbb_blog_blocked` (
  `owner_id` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `blocked_id` mediumint(8) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`owner_id`,`blocked_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

CREATE TABLE IF NOT EXISTS `phpbb_blog_categories` (
  `blog_cat_id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `blog_cat_title` varchar(100) DEFAULT NULL,
  `blog_cat_order` mediumint(8) unsigned NOT NULL,
  `blog_cat_entry` smallint(5) NOT NULL,
  `blog_cat_comment` smallint(5) NOT NULL,
  PRIMARY KEY (`blog_cat_id`),
  KEY `blog_cat_order` (`blog_cat_order`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=10 ;

CREATE TABLE IF NOT EXISTS `phpbb_blog_config` (
  `config_name` varchar(255) NOT NULL DEFAULT '',
  `config_value` varchar(255) NOT NULL DEFAULT '',
  PRIMARY KEY (`config_name`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

CREATE TABLE IF NOT EXISTS `phpbb_blog_contributors` (
  `weblog_id` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `user_id` mediumint(8) NOT NULL DEFAULT '0',
  PRIMARY KEY (`weblog_id`,`user_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

CREATE TABLE IF NOT EXISTS `phpbb_blog_entries` (
  `entry_id` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `weblog_id` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `entry_access` tinyint(4) unsigned NOT NULL DEFAULT '0',
  `entry_subject` varchar(60) NOT NULL DEFAULT '',
  `entry_text` text NOT NULL,
  `bbcode_uid` varchar(10) NOT NULL DEFAULT '',
  `entry_mood` smallint(5) NOT NULL DEFAULT '0',
  `entry_currently` smallint(5) NOT NULL DEFAULT '0',
  `entry_time` int(11) NOT NULL DEFAULT '0',
  `entry_views` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `enable_bbcode` tinyint(1) unsigned NOT NULL DEFAULT '1',
  `enable_smilies` tinyint(1) unsigned NOT NULL DEFAULT '1',
  `enable_html` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `memorable` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `no_replies` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `entry_replies` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `entry_last_post_userid` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `entry_last_post_id` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `entry_poster_id` mediumint(8) NOT NULL DEFAULT '0',
  `category_id` mediumint(8) unsigned NOT NULL,
  PRIMARY KEY (`entry_id`),
  KEY `weblog_id` (`weblog_id`),
  KEY `entry_last_post_userid` (`entry_last_post_userid`),
  KEY `entry_last_post_id` (`entry_last_post_id`),
  KEY `entry_poster_id` (`entry_poster_id`),
  KEY `category_id` (`category_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

CREATE TABLE IF NOT EXISTS `phpbb_blog_friends` (
  `owner_id` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `friend_id` mediumint(8) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`owner_id`,`friend_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

CREATE TABLE IF NOT EXISTS `phpbb_blog_moods` (
  `mood_id` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `mood_text` varchar(255) NOT NULL DEFAULT '',
  `mood_url` varchar(255) NOT NULL DEFAULT '',
  `mood_set` mediumint(8) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`mood_id`),
  KEY `mood_set` (`mood_set`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

CREATE TABLE IF NOT EXISTS `phpbb_blog_replies` (
  `reply_id` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `entry_id` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `poster_id` mediumint(8) NOT NULL DEFAULT '0',
  `post_time` int(11) DEFAULT NULL,
  `post_username` varchar(25) NOT NULL DEFAULT '',
  `post_subject` varchar(60) NOT NULL DEFAULT '',
  `enable_bbcode` tinyint(1) unsigned NOT NULL DEFAULT '1',
  `enable_smilies` tinyint(1) unsigned NOT NULL DEFAULT '1',
  `enable_html` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `enable_sig` tinyint(1) unsigned NOT NULL DEFAULT '1',
  `reply_text` text NOT NULL,
  `bbcode_uid` varchar(10) NOT NULL DEFAULT '',
  PRIMARY KEY (`reply_id`),
  KEY `entry_id` (`entry_id`),
  KEY `poster_id` (`poster_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

CREATE TABLE IF NOT EXISTS `phpbb_categories` (
  `cat_id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `cat_title` varchar(100) DEFAULT NULL,
  `cat_order` mediumint(8) unsigned NOT NULL,
  PRIMARY KEY (`cat_id`),
  KEY `cat_order` (`cat_order`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;


CREATE TABLE IF NOT EXISTS `phpbb_forums` (
  `forum_id` smallint(5) unsigned NOT NULL,
  `cat_id` mediumint(8) unsigned NOT NULL,
  `forum_name` varchar(150) DEFAULT NULL,
  `forum_desc` text,
  `forum_status` tinyint(4) NOT NULL DEFAULT '0',
  `forum_order` mediumint(8) unsigned NOT NULL DEFAULT '1',
  `forum_posts` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `forum_postcount` tinyint(1) NOT NULL DEFAULT '1',
  `forum_topics` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `forum_last_post_id` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `prune_next` int(11) DEFAULT NULL,
  `prune_enable` tinyint(1) NOT NULL DEFAULT '0',
  `points_disabled` tinyint(1) NOT NULL,
  `auth_view` tinyint(2) NOT NULL DEFAULT '0',
  `auth_read` tinyint(2) NOT NULL DEFAULT '0',
  `auth_post` tinyint(2) NOT NULL DEFAULT '0',
  `auth_reply` tinyint(2) NOT NULL DEFAULT '0',
  `auth_edit` tinyint(2) NOT NULL DEFAULT '0',
  `auth_delete` tinyint(2) NOT NULL DEFAULT '0',
  `auth_sticky` tinyint(2) NOT NULL DEFAULT '0',
  `auth_announce` tinyint(2) NOT NULL DEFAULT '0',
  `auth_vote` tinyint(2) NOT NULL DEFAULT '0',
  `auth_pollcreate` tinyint(2) NOT NULL DEFAULT '0',
  `auth_attachments` tinyint(2) NOT NULL DEFAULT '0',
  `auth_download` tinyint(2) NOT NULL DEFAULT '0',
  `forum_thank` tinyint(1) NOT NULL DEFAULT '0',
  `attached_forum_id` mediumint(8) NOT NULL DEFAULT '-1',
  PRIMARY KEY (`forum_id`),
  KEY `forums_order` (`forum_order`),
  KEY `cat_id` (`cat_id`),
  KEY `forum_last_post_id` (`forum_last_post_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

CREATE TABLE IF NOT EXISTS `phpbb_config` (
  `config_name` varchar(255) NOT NULL,
  `config_value` varchar(255) NOT NULL,
  PRIMARY KEY (`config_name`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

CREATE TABLE IF NOT EXISTS `phpbb_config_points` (
  `config_name` varchar(255) NOT NULL,
  `config_value` varchar(255) NOT NULL,
  PRIMARY KEY (`config_name`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

CREATE TABLE IF NOT EXISTS `phpbb_confirm` (
  `confirm_id` char(32) NOT NULL DEFAULT '',
  `session_id` char(32) NOT NULL DEFAULT '',
  `code` char(6) NOT NULL DEFAULT '',
  PRIMARY KEY (`session_id`,`confirm_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

CREATE TABLE IF NOT EXISTS `phpbb_css_style` (
  `style_id` smallint(5) unsigned NOT NULL AUTO_INCREMENT,
  `style_name` varchar(40) NOT NULL,
  `user_id` mediumint(8) NOT NULL DEFAULT '0',
  `body_background` varchar(40) NOT NULL,
  `body_color` varchar(40) NOT NULL,
  `body_border` varchar(40) NOT NULL,
  `body_width` varchar(40) NOT NULL,
  `body_max` varchar(40) NOT NULL,
  `a_link` varchar(40) NOT NULL,
  `a_hower` varchar(40) NOT NULL,
  `top_background` varchar(40) NOT NULL,
  `top_color` varchar(40) NOT NULL,
  `top_border` varchar(40) NOT NULL,
  `tab_background` varchar(40) NOT NULL,
  `tab_color` varchar(40) NOT NULL,
  `tab_border` varchar(40) NOT NULL,
  `tab_border_radius` varchar(40) NOT NULL,
  `row1_background` varchar(40) NOT NULL,
  `row1_color` varchar(40) NOT NULL,
  `row1_border` varchar(40) NOT NULL,
  `row1_border_radius` varchar(40) NOT NULL,
  `row_hard_background` varchar(40) NOT NULL,
  `row_hard_color` varchar(40) NOT NULL,
  `row_hard_border` varchar(40) NOT NULL,
  `row_easy_background` varchar(40) NOT NULL,
  `row_easy_color` varchar(40) NOT NULL,
  `row_easy_border` varchar(40) NOT NULL,
  `buttom_background` varchar(40) NOT NULL,
  `buttom_color` varchar(40) NOT NULL,
  `buttom_border` varchar(40) NOT NULL,
  KEY `style_id` (`style_id`),
  KEY `user_id` (`user_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=15 ;

CREATE TABLE IF NOT EXISTS `phpbb_disallow` (
  `disallow_id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `disallow_username` varchar(25) NOT NULL DEFAULT '',
  PRIMARY KEY (`disallow_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=19 ;

CREATE TABLE IF NOT EXISTS `phpbb_extensions` (
  `ext_id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `group_id` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `extension` varchar(100) NOT NULL,
  `comment` varchar(100) DEFAULT NULL,
  PRIMARY KEY (`ext_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=29 ;

CREATE TABLE IF NOT EXISTS `phpbb_extension_groups` (
  `group_id` mediumint(8) NOT NULL AUTO_INCREMENT,
  `group_name` char(20) NOT NULL,
  `cat_id` tinyint(2) NOT NULL DEFAULT '0',
  `allow_group` tinyint(1) NOT NULL DEFAULT '0',
  `download_mode` tinyint(1) unsigned NOT NULL DEFAULT '1',
  `upload_icon` varchar(100) DEFAULT '',
  `max_filesize` int(20) NOT NULL DEFAULT '0',
  `forum_permissions` varchar(255) NOT NULL DEFAULT '',
  PRIMARY KEY (`group_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=9 ;

CREATE TABLE IF NOT EXISTS `phpbb_forbidden_extensions` (
  `ext_id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `extension` varchar(100) NOT NULL,
  PRIMARY KEY (`ext_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=17 ;

CREATE TABLE IF NOT EXISTS `phpbb_forum_prune` (
  `prune_id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `forum_id` smallint(5) unsigned NOT NULL,
  `prune_days` smallint(5) unsigned NOT NULL,
  `prune_freq` smallint(5) unsigned NOT NULL,
  PRIMARY KEY (`prune_id`),
  KEY `forum_id` (`forum_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=2 ;

CREATE TABLE IF NOT EXISTS `phpbb_groups` (
  `group_id` mediumint(8) NOT NULL AUTO_INCREMENT,
  `group_type` tinyint(4) NOT NULL DEFAULT '1',
  `group_name` varchar(40) NOT NULL,
  `group_description` varchar(255) NOT NULL,
  `group_moderator` mediumint(8) NOT NULL DEFAULT '0',
  `group_single_user` tinyint(1) NOT NULL DEFAULT '1',
  `group_allow_weblogs` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `group_created_by_user` tinyint(1) NOT NULL DEFAULT '0',
  `group_logo` varchar(100) NOT NULL,
  PRIMARY KEY (`group_id`),
  KEY `group_single_user` (`group_single_user`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=422 ;

CREATE TABLE IF NOT EXISTS `phpbb_groups_shout` (
  `shout_id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `group_id` int(11) NOT NULL,
  `shout_username` varchar(25) NOT NULL,
  `shout_user_id` mediumint(8) NOT NULL,
  `shout_session_time` int(11) NOT NULL,
  `shout_ip` char(8) NOT NULL,
  `shout_text` text NOT NULL,
  `enable_bbcode` tinyint(1) NOT NULL,
  `enable_html` tinyint(1) NOT NULL,
  `enable_smilies` tinyint(1) NOT NULL,
  `shout_bbcode_uid` varchar(10) NOT NULL,
  KEY `shout_id` (`shout_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

CREATE TABLE IF NOT EXISTS `phpbb_guestbook` (
  `nick` varchar(25) NOT NULL DEFAULT '',
  `data_ora` int(11) NOT NULL DEFAULT '0',
  `email` varchar(255) DEFAULT NULL,
  `comento` text,
  `bbcode_uid` varchar(10) DEFAULT NULL,
  `ipi` varchar(8) NOT NULL DEFAULT '',
  `agent` varchar(255) NOT NULL DEFAULT '',
  `user_id` mediumint(8) NOT NULL DEFAULT '0',
  `hide` tinyint(1) DEFAULT '0',
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

CREATE TABLE IF NOT EXISTS `phpbb_guest_config` (
  `config_name` varchar(255) NOT NULL DEFAULT '',
  `config_value` varchar(255) NOT NULL DEFAULT '',
  PRIMARY KEY (`config_name`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

CREATE TABLE IF NOT EXISTS `phpbb_links` (
  `link_id` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `link_text` varchar(255) NOT NULL DEFAULT '',
  `link_url` varchar(255) NOT NULL DEFAULT '',
  `link_set` mediumint(8) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`link_id`),
  KEY `link_set` (`link_set`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

CREATE TABLE IF NOT EXISTS `phpbb_links_sets` (
  `set_id` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `set_name` varchar(255) NOT NULL DEFAULT '',
  PRIMARY KEY (`set_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

CREATE TABLE IF NOT EXISTS `phpbb_portal_config` (
  `config_name` varchar(255) NOT NULL,
  `config_value` varchar(255) NOT NULL,
  PRIMARY KEY (`config_name`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

CREATE TABLE IF NOT EXISTS `phpbb_posts` (
  `post_id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `topic_id` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `forum_id` smallint(5) unsigned NOT NULL DEFAULT '0',
  `poster_id` mediumint(8) NOT NULL DEFAULT '0',
  `post_time` int(11) NOT NULL DEFAULT '0',
  `poster_ip` char(8) NOT NULL,
  `post_username` varchar(25) DEFAULT NULL,
  `enable_bbcode` tinyint(1) NOT NULL DEFAULT '1',
  `enable_html` tinyint(1) NOT NULL DEFAULT '0',
  `enable_smilies` tinyint(1) NOT NULL DEFAULT '1',
  `enable_sig` tinyint(1) NOT NULL DEFAULT '1',
  `post_edit_time` int(11) DEFAULT NULL,
  `post_edit_count` smallint(5) unsigned NOT NULL DEFAULT '0',
  `post_reviews` smallint(8) unsigned NOT NULL DEFAULT '0',
  `post_locked` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `post_attachment` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`post_id`),
  KEY `forum_id` (`forum_id`),
  KEY `topic_id` (`topic_id`),
  KEY `poster_id` (`poster_id`),
  KEY `post_time` (`post_time`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

CREATE TABLE IF NOT EXISTS `phpbb_posts_text` (
  `post_id` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `bbcode_uid` char(10) NOT NULL DEFAULT '',
  `post_subject` char(60) DEFAULT NULL,
  `post_text` text,
  PRIMARY KEY (`post_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

CREATE TABLE IF NOT EXISTS `phpbb_post_reports` (
  `report_id` mediumint(8) NOT NULL AUTO_INCREMENT,
  `post_id` mediumint(8) NOT NULL DEFAULT '-1',
  `review_id` mediumint(8) NOT NULL DEFAULT '-1',
  `forum_id` mediumint(9) NOT NULL DEFAULT '-1',
  `user_id` mediumint(8) NOT NULL DEFAULT '0',
  `report_time` int(11) NOT NULL DEFAULT '0',
  `reports_num` mediumint(8) NOT NULL DEFAULT '0',
  PRIMARY KEY (`report_id`),
  KEY `post_id` (`post_id`),
  KEY `review_id` (`review_id`),
  KEY `forum_id` (`forum_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

CREATE TABLE IF NOT EXISTS `phpbb_present` (
  `present_id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `present_img` varchar(100) DEFAULT NULL,
  `present_user_id` mediumint(8) unsigned NOT NULL,
  `donate_user_id` mediumint(8) unsigned NOT NULL,
  `donate_username` varchar(25) DEFAULT NULL,
  `donate_time` int(11) NOT NULL DEFAULT '0',
  `message` text NOT NULL,
  `nodel` tinyint(1) DEFAULT '0',
  PRIMARY KEY (`present_id`),
  KEY `present_user_id` (`present_user_id`),
  KEY `donate_time` (`donate_time`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

CREATE TABLE IF NOT EXISTS `phpbb_privmsgs` (
  `privmsgs_id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `privmsgs_type` tinyint(4) NOT NULL DEFAULT '0',
  `privmsgs_subject` varchar(255) NOT NULL DEFAULT '0',
  `privmsgs_from_userid` mediumint(8) NOT NULL DEFAULT '0',
  `privmsgs_to_userid` mediumint(8) NOT NULL DEFAULT '0',
  `privmsgs_date` int(11) NOT NULL DEFAULT '0',
  `privmsgs_ip` char(8) NOT NULL,
  `privmsgs_enable_bbcode` tinyint(1) NOT NULL DEFAULT '1',
  `privmsgs_enable_html` tinyint(1) NOT NULL DEFAULT '0',
  `privmsgs_enable_smilies` tinyint(1) NOT NULL DEFAULT '1',
  `privmsgs_attach_sig` tinyint(1) NOT NULL DEFAULT '1',
  `privmsgs_attachment` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`privmsgs_id`),
  KEY `privmsgs_from_userid` (`privmsgs_from_userid`),
  KEY `privmsgs_to_userid` (`privmsgs_to_userid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

CREATE TABLE IF NOT EXISTS `phpbb_privmsgs_text` (
  `privmsgs_text_id` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `privmsgs_bbcode_uid` char(10) NOT NULL DEFAULT '0',
  `privmsgs_text` text,
  PRIMARY KEY (`privmsgs_text_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

CREATE TABLE IF NOT EXISTS `phpbb_profile_guestbook` (
  `gb_id` int(10) NOT NULL AUTO_INCREMENT,
  `user_id` int(10) NOT NULL DEFAULT '0',
  `poster_id` int(10) NOT NULL DEFAULT '0',
  `bbcode` varchar(64) NOT NULL DEFAULT '',
  `gb_time` int(10) NOT NULL DEFAULT '0',
  `title` varchar(255) NOT NULL DEFAULT '',
  `message` text NOT NULL,
  `user_guest_name` varchar(64) NOT NULL DEFAULT '',
  PRIMARY KEY (`gb_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

CREATE TABLE IF NOT EXISTS `phpbb_profile_view` (
  `user_id` mediumint(8) NOT NULL,
  `viewername` varchar(25) NOT NULL,
  `viewer_id` mediumint(8) NOT NULL,
  `view_stamp` int(11) NOT NULL,
  `counter` mediumint(8) NOT NULL
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

CREATE TABLE IF NOT EXISTS `phpbb_question` (
  `id` int(5) NOT NULL AUTO_INCREMENT,
  `question` text NOT NULL,
  `otvet_1` text NOT NULL,
  `otvet_2` text NOT NULL,
  `otvet_3` text NOT NULL,
  `otvet_4` text NOT NULL,
  `otvet_verno` tinyint(1) NOT NULL DEFAULT '0',
  `moder` tinyint(1) NOT NULL DEFAULT '1',
  `bonus` tinyint(1) NOT NULL DEFAULT '0',
  `author` varchar(32) DEFAULT 'unknown',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

CREATE TABLE IF NOT EXISTS `phpbb_questions_active` (
  `user_id` int(6) NOT NULL,
  `on_off_user` tinyint(1) NOT NULL DEFAULT '0',
  `vop_id` int(5) NOT NULL,
  `real_otvet` tinyint(1) NOT NULL,
  `bonus` tinyint(1) NOT NULL DEFAULT '0',
  `progr` int(3) NOT NULL DEFAULT '0',
  `start_time` int(11) NOT NULL DEFAULT '0',
  `zad_vop` int(6) NOT NULL DEFAULT '0',
  `right_otv` int(6) NOT NULL DEFAULT '0',
  `pris_vop` int(6) NOT NULL DEFAULT '0',
  `prin_vop` int(6) NOT NULL DEFAULT '0',
  `u1` int(5) NOT NULL DEFAULT '0',
  PRIMARY KEY (`user_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

CREATE TABLE IF NOT EXISTS `phpbb_questions_config` (
  `config_name` varchar(32) NOT NULL DEFAULT '',
  `config_value` varchar(16) NOT NULL DEFAULT '',
  PRIMARY KEY (`config_name`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

CREATE TABLE IF NOT EXISTS `phpbb_questions_temp` (
  `id` int(4) NOT NULL AUTO_INCREMENT,
  `question` text NOT NULL,
  `otvet_1` text NOT NULL,
  `otvet_2` text NOT NULL,
  `otvet_3` text NOT NULL,
  `otvet_4` text NOT NULL,
  `otvet_verno` tinyint(1) NOT NULL,
  `author` int(6) NOT NULL,
  `isto` text NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

CREATE TABLE IF NOT EXISTS `phpbb_quota_limits` (
  `quota_limit_id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `quota_desc` varchar(20) NOT NULL DEFAULT '',
  `quota_limit` bigint(20) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`quota_limit_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=4 ;

CREATE TABLE IF NOT EXISTS `phpbb_ranks` (
  `rank_id` smallint(5) unsigned NOT NULL AUTO_INCREMENT,
  `rank_title` varchar(50) NOT NULL,
  `rank_min` mediumint(8) NOT NULL DEFAULT '0',
  `rank_special` tinyint(1) DEFAULT '0',
  `rank_image` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`rank_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=37 ;

CREATE TABLE IF NOT EXISTS `phpbb_reputation` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `modification` tinyint(1) NOT NULL DEFAULT '0',
  `user_id` mediumint(8) NOT NULL DEFAULT '0',
  `voter_id` mediumint(8) NOT NULL DEFAULT '0',
  `post_id` mediumint(8) NOT NULL DEFAULT '-1',
  `forum_id` smallint(5) NOT NULL DEFAULT '-1',
  `poster_ip` char(8) NOT NULL DEFAULT '',
  `date` int(11) DEFAULT NULL,
  `expire` int(11) DEFAULT NULL,
  `edit_time` int(11) DEFAULT NULL,
  `edit_count` smallint(5) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `voter_id` (`voter_id`),
  KEY `post_id` (`post_id`),
  KEY `date` (`date`),
  KEY `expire` (`expire`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

CREATE TABLE IF NOT EXISTS `phpbb_reputation_text` (
  `id` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `text` text,
  `bbcode_uid` varchar(10) NOT NULL DEFAULT '',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

CREATE TABLE IF NOT EXISTS `phpbb_search_results` (
  `search_id` int(11) unsigned NOT NULL DEFAULT '0',
  `session_id` char(32) NOT NULL DEFAULT '',
  `search_time` int(11) NOT NULL DEFAULT '0',
  `search_array` text NOT NULL,
  PRIMARY KEY (`search_id`),
  KEY `session_id` (`session_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

CREATE TABLE IF NOT EXISTS `phpbb_search_wordlist` (
  `word_text` varchar(50) CHARACTER SET utf8 COLLATE utf8_bin NOT NULL DEFAULT '',
  `word_id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `word_common` tinyint(1) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`word_text`),
  KEY `word_id` (`word_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

CREATE TABLE IF NOT EXISTS `phpbb_search_wordmatch` (
  `post_id` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `word_id` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `title_match` tinyint(1) NOT NULL DEFAULT '0',
  KEY `post_id` (`post_id`),
  KEY `word_id` (`word_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

CREATE TABLE IF NOT EXISTS `phpbb_sessions` (
  `session_id` char(32) NOT NULL DEFAULT '',
  `session_user_id` mediumint(8) NOT NULL DEFAULT '0',
  `session_start` int(11) NOT NULL DEFAULT '0',
  `session_time` int(11) NOT NULL DEFAULT '0',
  `session_ip` char(8) NOT NULL DEFAULT '0',
  `session_page` int(11) NOT NULL DEFAULT '0',
  `session_topic` int(11) NOT NULL,
  `session_logged_in` tinyint(1) NOT NULL DEFAULT '0',
  `session_admin` tinyint(2) NOT NULL DEFAULT '0',
  `is_robot` varchar(255) NOT NULL DEFAULT '0',
  PRIMARY KEY (`session_id`),
  KEY `session_user_id` (`session_user_id`),
  KEY `session_id_ip_user_id` (`session_id`,`session_ip`,`session_user_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

CREATE TABLE IF NOT EXISTS `phpbb_sessions_keys` (
  `key_id` varchar(32) NOT NULL DEFAULT '0',
  `user_id` mediumint(8) NOT NULL DEFAULT '0',
  `last_ip` varchar(8) NOT NULL DEFAULT '0',
  `last_login` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`key_id`,`user_id`),
  KEY `last_login` (`last_login`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

CREATE TABLE IF NOT EXISTS `phpbb_shop_icq` (
  `id` mediumint(10) NOT NULL AUTO_INCREMENT,
  `icq_number` int(15) DEFAULT '0',
  `icq_password` varchar(255) DEFAULT NULL,
  `icq_cost` mediumint(20) DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

CREATE TABLE IF NOT EXISTS `phpbb_smilies` (
  `smilies_id` int(11) NOT NULL AUTO_INCREMENT,
  `smile_url` text,
  `smile_cat` int(11) DEFAULT NULL,
  `code` text,
  `emoticon` varchar(75) DEFAULT NULL,
  PRIMARY KEY (`smilies_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=360 ;

CREATE TABLE IF NOT EXISTS `phpbb_smilies_cat` (
  `id` mediumint(11) NOT NULL AUTO_INCREMENT,
  `cat_title` varchar(50) CHARACTER SET cp1251 NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=37 ;

CREATE TABLE IF NOT EXISTS `phpbb_sobytie` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `link_id` mediumint(8) unsigned NOT NULL,
  `link_type` varchar(25) NOT NULL,
  `count` mediumint(8) unsigned NOT NULL,
  `to_user_id` mediumint(8) unsigned NOT NULL,
  `to_username` varchar(25) DEFAULT NULL,
  `user_id` mediumint(8) NOT NULL,
  `username` varchar(25) DEFAULT NULL,
  `subject` char(60) DEFAULT NULL,
  `text` text,
  `time` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `time` (`time`),
  KEY `user_id` (`user_id`),
  KEY `to_user_id` (`to_user_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

CREATE TABLE IF NOT EXISTS `phpbb_styles_css` (
  `style_id` mediumint(8) NOT NULL AUTO_INCREMENT,
  `style_name` varchar(50) DEFAULT NULL,
  `style_text` text,
  PRIMARY KEY (`style_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=74 ;

CREATE TABLE IF NOT EXISTS `phpbb_thanks` (
  `topic_id` mediumint(8) NOT NULL,
  `user_id` mediumint(8) NOT NULL,
  `thanks_time` int(11) NOT NULL
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

CREATE TABLE IF NOT EXISTS `phpbb_topics` (
  `topic_id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `forum_id` smallint(8) unsigned NOT NULL DEFAULT '0',
  `topic_title` char(60) NOT NULL,
  `topic_desc` varchar(255) DEFAULT '',
  `topic_poster` mediumint(8) NOT NULL DEFAULT '0',
  `topic_time` int(11) NOT NULL DEFAULT '0',
  `topic_views` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `topic_replies` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `topic_status` tinyint(3) NOT NULL DEFAULT '0',
  `topic_vote` tinyint(1) NOT NULL DEFAULT '0',
  `topic_type` tinyint(3) NOT NULL DEFAULT '0',
  `topic_first_post_id` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `topic_last_post_id` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `topic_moved_id` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `topic_attachment` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`topic_id`),
  KEY `forum_id` (`forum_id`),
  KEY `topic_moved_id` (`topic_moved_id`),
  KEY `topic_status` (`topic_status`),
  KEY `topic_type` (`topic_type`),
  KEY `topic_last_post_id` (`topic_last_post_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

CREATE TABLE IF NOT EXISTS `phpbb_topics_watch` (
  `topic_id` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `user_id` mediumint(8) NOT NULL DEFAULT '0',
  `notify_status` tinyint(1) NOT NULL DEFAULT '0',
  KEY `topic_id` (`topic_id`),
  KEY `user_id` (`user_id`),
  KEY `notify_status` (`notify_status`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

CREATE TABLE IF NOT EXISTS `phpbb_users` (
  `user_id` mediumint(8) NOT NULL,
  `user_active` tinyint(1) DEFAULT '1',
  `username` varchar(25) NOT NULL,
  `user_password` varchar(32) NOT NULL,
  `user_session_time` int(11) NOT NULL DEFAULT '0',
  `user_session_page` smallint(5) NOT NULL DEFAULT '0',
  `user_session_topic` int(11) NOT NULL,
  `user_lastvisit` int(11) NOT NULL DEFAULT '0',
  `user_regdate` int(11) NOT NULL DEFAULT '0',
  `user_level` tinyint(4) DEFAULT '0',
  `user_posts` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `user_topics` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `user_timezone` decimal(5,2) NOT NULL DEFAULT '0.00',
  `user_lang` varchar(255) DEFAULT NULL,
  `user_datephpbbmat` varchar(14) NOT NULL DEFAULT 'd M Y H:i',
  `user_new_privmsg` smallint(5) unsigned NOT NULL DEFAULT '0',
  `user_unread_privmsg` smallint(5) unsigned NOT NULL DEFAULT '0',
  `user_last_privmsg` int(11) NOT NULL DEFAULT '0',
  `user_login_tries` smallint(5) unsigned NOT NULL DEFAULT '0',
  `user_last_login_try` int(11) NOT NULL DEFAULT '0',
  `user_emailtime` int(11) DEFAULT NULL,
  `user_viewemail` tinyint(1) DEFAULT NULL,
  `user_profile_view_popup` tinyint(1) DEFAULT '1',
  `user_attachsig` tinyint(1) DEFAULT NULL,
  `user_allowhtml` tinyint(1) DEFAULT '1',
  `user_allowbbcode` tinyint(1) DEFAULT '1',
  `user_allowsmile` tinyint(1) DEFAULT '1',
  `user_allowavatar` tinyint(1) NOT NULL DEFAULT '1',
  `user_allow_pm` tinyint(1) NOT NULL DEFAULT '1',
  `user_allow_viewonline` tinyint(1) NOT NULL DEFAULT '1',
  `user_allow_showprofile` tinyint(1) NOT NULL DEFAULT '1',
  `user_notify` tinyint(1) NOT NULL DEFAULT '1',
  `user_notify_pm` tinyint(1) NOT NULL DEFAULT '0',
  `user_notify_donation` tinyint(1) NOT NULL,
  `user_popup_pm` tinyint(1) NOT NULL DEFAULT '0',
  `user_rank` int(11) DEFAULT '0',
  `user_avatar` varchar(100) DEFAULT NULL,
  `user_avatar_type` tinyint(4) NOT NULL DEFAULT '0',
  `user_email` varchar(255) DEFAULT NULL,
  `user_icq` varchar(15) DEFAULT NULL,
  `user_number` varchar(15) DEFAULT NULL,
  `user_website` varchar(100) DEFAULT NULL,
  `user_from` varchar(100) DEFAULT NULL,
  `user_sig` text,
  `user_sig_bbcode_uid` char(10) DEFAULT NULL,
  `user_aim` varchar(255) DEFAULT NULL,
  `user_yim` varchar(17) DEFAULT NULL,
  `user_msnm` varchar(255) DEFAULT NULL,
  `user_occ` varchar(100) DEFAULT NULL,
  `user_interests` varchar(255) DEFAULT NULL,
  `user_actkey` varchar(32) DEFAULT NULL,
  `user_newpasswd` varchar(32) DEFAULT NULL,
  `user_reputation` smallint(8) NOT NULL DEFAULT '0',
  `user_reputation_plus` smallint(8) NOT NULL DEFAULT '0',
  `user_warnings` tinyint(4) unsigned NOT NULL DEFAULT '0',
  `user_topics_per_page` tinyint(2) NOT NULL DEFAULT '15',
  `user_posts_per_page` tinyint(2) NOT NULL DEFAULT '15',
  `user_birthday` int(11) NOT NULL DEFAULT '999999',
  `user_next_birthday_greeting` int(11) NOT NULL DEFAULT '0',
  `user_gender` tinyint(4) NOT NULL DEFAULT '0',
  `style_text` text,
  `user_on_off` tinyint(4) NOT NULL DEFAULT '1',
  `user_attach_mod` tinyint(4) NOT NULL DEFAULT '1',
  `user_nic_color` varchar(100) NOT NULL DEFAULT '#3B678D',
  `user_quick_answer` tinyint(4) NOT NULL DEFAULT '0',
  `user_icq_send` tinyint(4) NOT NULL DEFAULT '1',
  `user_index_spisok` tinyint(4) NOT NULL DEFAULT '0',
  `user_style` tinyint(4) DEFAULT NULL,
  `user_points` int(11) NOT NULL,
  `admin_allow_points` tinyint(1) NOT NULL DEFAULT '1',
  `user_post_leng` int(8) NOT NULL DEFAULT '0',
  `user_allowweblog` tinyint(1) unsigned NOT NULL DEFAULT '1',
  `user_showfriends` tinyint(1) unsigned NOT NULL DEFAULT '1',
  `user_weblog` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `user_thanks` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `user_thanked` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `user_status` varchar(100) DEFAULT NULL,
  `user_email_new_gb` tinyint(1) NOT NULL DEFAULT '0',
  `user_can_gb` tinyint(1) NOT NULL DEFAULT '1',
  `user_profile_view` smallint(5) NOT NULL DEFAULT '0',
  `user_last_profile_view` int(11) NOT NULL DEFAULT '0',
  `gorod_life` smallint(6) NOT NULL,
  `gorod_eda_time` bigint(20) NOT NULL,
  `gorod_money` bigint(20) NOT NULL,
  `gorod_ohota_time` bigint(20) NOT NULL,
  `gorod_brak` varchar(32) NOT NULL,
  `gorod_tamag` varchar(32) NOT NULL,
  `gorod_tamag_life` smallint(6) NOT NULL,
  `gorod_tamag_time` bigint(20) NOT NULL,
  `gorod_voodoo` int(11) NOT NULL,
  `gorod_voodoo_name` varchar(32) NOT NULL,
  `gorod_kopi` bigint(20) NOT NULL,
  `gorod_kriminal` int(11) NOT NULL,
  `gorod_kriminal_time` bigint(20) NOT NULL,
  `gorod_security` varchar(32) NOT NULL,
  `gorod_security_uron` int(11) NOT NULL,
  `gorod_para` varchar(50) NOT NULL,
  `gorod_tur` varchar(50) NOT NULL,
  `gorod_firm` varchar(50) NOT NULL,
  `gorod_band` varchar(50) NOT NULL,
  `gorod_band_time` bigint(20) NOT NULL,
  `theme` varchar(3) NOT NULL,
  PRIMARY KEY (`user_id`),
  KEY `user_session_time` (`user_session_time`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

CREATE TABLE IF NOT EXISTS `phpbb_users_bots` (
  `id` mediumint(8) NOT NULL DEFAULT '0',
  `name` varchar(25) NOT NULL DEFAULT '',
  `view` varchar(25) NOT NULL DEFAULT '',
  `lastvisit` int(11) NOT NULL DEFAULT '0',
  `was` varchar(15) DEFAULT NULL,
  `ip` varchar(100) DEFAULT NULL,
  `show` int(1) NOT NULL DEFAULT '1',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

CREATE TABLE IF NOT EXISTS `phpbb_users_friends` (
  `owner_user_id` int(11) NOT NULL AUTO_INCREMENT,
  `friend_user_id` varchar(32) NOT NULL,
  `friend_yes` text NOT NULL,
  `friend_no` text NOT NULL,
  PRIMARY KEY (`owner_user_id`,`friend_user_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=17 ;

CREATE TABLE IF NOT EXISTS `phpbb_user_group` (
  `group_id` mediumint(8) NOT NULL DEFAULT '0',
  `user_id` mediumint(8) NOT NULL DEFAULT '0',
  `user_pending` tinyint(1) DEFAULT NULL,
  KEY `group_id` (`group_id`),
  KEY `user_id` (`user_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

CREATE TABLE IF NOT EXISTS `phpbb_vote_desc` (
  `vote_id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `topic_id` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `vote_text` text NOT NULL,
  `vote_start` int(11) NOT NULL DEFAULT '0',
  `vote_length` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`vote_id`),
  KEY `topic_id` (`topic_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

CREATE TABLE IF NOT EXISTS `phpbb_vote_results` (
  `vote_id` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `vote_option_id` tinyint(4) unsigned NOT NULL DEFAULT '0',
  `vote_option_text` varchar(255) NOT NULL,
  `vote_result` int(11) NOT NULL DEFAULT '0',
  KEY `vote_option_id` (`vote_option_id`),
  KEY `vote_id` (`vote_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

CREATE TABLE IF NOT EXISTS `phpbb_vote_voters` (
  `vote_id` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `vote_user_id` mediumint(8) NOT NULL DEFAULT '0',
  `vote_user_ip` char(8) NOT NULL,
  KEY `vote_id` (`vote_id`),
  KEY `vote_user_id` (`vote_user_id`),
  KEY `vote_user_ip` (`vote_user_ip`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

CREATE TABLE IF NOT EXISTS `phpbb_words` (
  `word_id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `word` char(100) NOT NULL,
  `replacement` char(100) NOT NULL,
  PRIMARY KEY (`word_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=24 ;
