<?php

if (!defined('IN_PHPBB'))
{
	die("Hacking attempt");
}

class guestbook
{
	var $userdata;
	var $uid;
	var $url;
	var $url_intern;
	function guestbook(&$uid, $mode = false, $url = false)
	{
		global $phpEx;
		if(is_array($uid)) 
		{
			$this->userdata = $uid;
		}
		else
		{
			$this->userdata = get_userdata($uid);
		}
		$this->uid = $this->userdata['user_id'];
		$this->version = '1.0.8';

		if($url !== false)
		{
			$tmp = explode("?", $url);
			if(!count($tmp))
			{
				//No valid url, missing ?.
				$url = false;
			}
			else
			{
				if(!file_exists($tmp[0]))
				{
					//File doesn't exists
					$url = false;
				}
			}
		}

		if($url === false )
		{
			$this->url_intern = "profile." . $phpEx . "?mode=viewprofile&amp;" . POST_USERS_URL . "=" . $this->uid;
		}
		else
		{
			$this->url_intern = $url;
		}

		if(!$mode)
		{
			return true;
		}
		else
		{
			return $this->mode($mode);
		}
	}
	function mode($mode)
	{
		global $userdata,$board_config,$lang;
		global $HTTP_GET_VARS, $template, $HTTP_POST_VARS, $phpbb_root_path, $phpEx, $db;
		if(!$this->userdata['user_can_gb'] || !$userdata['user_can_gb'] || (!$board_config['allow_guests_gb'] && !$userdata['session_logged_in']))
		{
		      switch($mode)
		      {
			    case "view": $this->view();					 
			    break;							  				 
			    default: return false;
		      }
			return true;
		}
		else
		{
		       if ( isset($HTTP_POST_VARS['cancel']) )
		       {
				$redirect = "profile.php?mode=viewprofile&amp;" . POST_USERS_URL . "=" . $this->uid;
				redirect(append_sid($redirect, true));
		       }
		       $confirm = ( $HTTP_POST_VARS['confirm'] ) ? TRUE : 0;
		       if(($mode == 'delete' || $mode == 'deleteall') && !$confirm)
		       {
				$hidden_fields = '<input type="hidden" name="sid" value="' . $userdata['session_id'] . '" /><input type="hidden" name="mode" value="' . $mode . '" /><input type="hidden" name="gb_id" value="' . intval($HTTP_GET_VARS['gb_id']) . '" />';
				

				//
				// Set template files
				//
				$template->set_filenames(array(
					'confirm' => 'confirm_body.tpl')
				);

				$template->assign_vars(array(
					'MESSAGE_TITLE' => $lang['Confirm'],
					'MESSAGE_TEXT' => $lang['Confirm_delete_gbpost'],

					'L_YES' => $lang['Yes'],
					'L_NO' => $lang['No'],

					'S_CONFIRM_ACTION' => $this->append_sid("gb=" . $mode),
					'S_HIDDEN_FIELDS' => $hidden_fields)
				);

				$template->pparse('confirm');

				include($phpbb_root_path . 'includes/page_tail.'.$phpEx);
		       }
		       switch($mode)
		       {
				case "view":
					$this->view();					 
				break;
							  	
				case "quote":
				case "post":
				case "edit":
						$this->post($mode);
				break;
				case "delete":
					if($userdata['user_level'] == ADMIN || $userdata['user_id'] == $this->uid)
					{
						$this->delete();
					}
					else
					{
						message_die(GENERAL_MESSAGE,sprintf($lang['gb_no_per'], $lang['Delete_post']));
					}
				break;
				case "deleteall":
					if($userdata['user_level'] == ADMIN || $userdata['user_id'] == $this->uid)
					{
						$this->deleteall();
					}
					else
					{
						message_die(GENERAL_MESSAGE,sprintf($lang['gb_no_per'], $lang['delete_all_pro']));
					}
				break;			 
				default:
					return false;
		        }		         
		}
		return true;
	}
	
	function view()
	{
		global $db,$HTTP_GET_VARS;
		$start = (isset($HTTP_GET_VARS['start'])) ? intval($HTTP_GET_VARS['start']) : 0;
		$start = ($start < 0) ? 0 : $start; 
		$sql = "SELECT * FROM ".PROFILE_GUESTBOOK_TABLE." g, ".USERS_TABLE." u 
		        WHERE g.user_id = ".$this->uid." 
		        AND g.poster_id = u.user_id
			ORDER BY g.gb_time DESC
			LIMIT $start, 5";
		if( !$result = $db->sql_query($sql) )
		{
			message_die(GENERAL_ERROR,"Could not query guestbook","",__LINE__,__FILE__,$sql);
		}
		if( !$db->sql_numrows($result) )
		{
			if($start == 0)
			{
				$this->maak_view($result,'nores',0);
			}
			else
			{
				$this->maak_view($result,'nopag',0);
			}
		}
		else
		{
			$this->maak_view($result,'',0);
		}
	}
	function maak_view($result, $fout = '', $tot)
	{
		global $phpbb_root_path, $phpEx, $template, $lang, $profiledata, $userdata, $images, $board_config;
		global $db, $theme, $HTTP_GET_VARS;
		
		include_once($phpbb_root_path . "/includes/bbcode." . $phpEx);
		
		$template->set_filenames(array(
			'gb_body' => 'profile_gb_view.tpl')
		);
				
		if($userdata['user_level'] == ADMIN)
		{
			$delete_all_else_txt = sprintf($lang['gb_text2'],$this->append_sid("gb=deleteall"));
		}
		else if($userdata['user_id'] == $this->uid || $userdata['user_level'] == MOD)
		{
			$delete_all_else_txt = sprintf($lang['gb_text2'], $this->append_sid("gb=deleteall"));
		}
		else
		{
		        $delete_all_else_txt = sprintf($lang['gb_text'],$profiledata['username']); 
		}
	
		$reply = $this->append_sid('gb=post');
		
		$template->assign_vars(array(
			"L_GUESTBOOK" => $lang['Guestbook'],
			"DELETE_ALL_ELSE_TXT" => $delete_all_else_txt,
			"REPLY" => $reply)
		);
		
		if($fout != '')
		{
			switch($fout)
			{
				case "nores":
					$template->assign_block_vars("error",array(
						"ERROR" => $lang['Guest_empty']
					));
				break;
				case "nopag":
					$template->assign_block_vars("error",array(
						"L_GUESTBOOK_ERROR" => $lang['gb_error'],
						"ERROR" => $lang['gb_nopag']
					));
				break;
			}
		}
		else
		{
			$postrow = array();
			$postrow = $db->sql_fetchrowset($result);
			$total_posts = count($postrow);

			global $ranksrow;
			$orig_word = array();
			$replacement_word = array();
			obtain_word_list($orig_word, $replacement_word);			

			$sql2 = "SELECT * FROM " . PROFILE_GUESTBOOK_TABLE . " 
			         WHERE user_id = " . $this->uid;
			$result2 = $db->sql_query($sql2);
			if(!$result2)
			{
				message_die(GENERAL_ERROR,"Could not get total of guestbook posts!","",__LINE__,__FILE__,$sql2);
			}
			$total_replies = $db->sql_numrows($result2);
			
			$start = (isset($HTTP_GET_VARS['start'])) ? intval($HTTP_GET_VARS['start']) : 0;
			
			$pagination = generate_pagination('profile . ' . $phpEx . '?mode=viewprofile&amp;gb=view&amp;' . POST_USERS_URL . '=' . $this->uid, $total_replies, 5, $start);
	
			$template->assign_block_vars('main',array(
				'PAGINATION' => $pagination,
				'PAGE_NUMBER' => sprintf($lang['Page_of'], ( floor( $start / intval(5) ) + 1 ), ceil( $total_replies / intval(5) )),
				'L_AUTHOR' => $lang['Author'],
				'L_MESSAGE' => $lang['Message'])
			);
			
			$post_nr = 0;
			if($start != 0)
			{
				$post_nr += (int)$start;
			}
			for($i = 0; $i < $total_posts; $i++)
			{
				$post_nr++;

				$poster_id = $postrow[$i]['poster_id'];
				$post_date = create_date($board_config['default_dateformat'], $postrow[$i]['gb_time'], $board_config['board_timezone']);

				$poster_posts = ( $postrow[$i]['user_id'] != ANONYMOUS ) ? '[' . $postrow[$i]['user_posts'].']' : '';

				$poster_from = ( $postrow[$i]['user_from'] && $postrow[$i]['user_id'] != ANONYMOUS ) ? $lang['Location'] . ': ' . $postrow[$i]['user_from'] : '';
				$poster = ( $poster_id == ANONYMOUS ) ? (!empty($postrow[$i]['user_guest_name'])) ? $postrow[$i]['user_guest_name']."(".$lang['Guest'].")":  $lang['Guest'] : '<a href="' . append_sid("profile.$phpEx?mode=viewprofile&amp;" . POST_USERS_URL . '='  . $postrow[$i]['user_id']) . '">' . $postrow[$i]['username'] . '</a>';

	                        /*$avatar_img = ''; 
                                if ( $postrow[$i]['user_avatar_type'] && $postrow[$i]['user_allowavatar'] ) 
                                { 
                                      switch( $postrow[$i]['user_avatar_type'] ) 
                                      { 
                                       case USER_AVATAR_UPLOAD: 
                                             $avatar_img = '<img src="' . $board_config['avatar_path'] . '/' . $postrow[$i]['user_avatar'] . '" border="0" height="80" width="80"/>'; 
                                       break; 
                                       case USER_AVATAR_REMOTE: 
                                             $avatar_img = '<img src="' . $postrow[$i]['user_avatar'] . '" alt="" border="0" height="80" width="80"/>'; 
                                       break; 
                                       case USER_AVATAR_GALLERY: 
                                             $avatar_img = '<img src="' . $board_config['avatar_gallery_path'] . '/' . $postrow[$i]['user_avatar'] . '" alt="" border="0" height="80" width="80"/>'; 
                                       break; 
                                      } 
                                }*/
                                avatar_img($postrow[$i]['user_avatar_type'], $postrow[$i]['user_allowavatar'], $postrow[$i]['user_avatar'], $avatar_img, $avatar_mini);
                        
				$temp_url = $this->append_sid("gb=quote&amp;gb_id=" . $postrow[$i]['gb_id']);
				$quote = '<a href="' . $temp_url . '">' . $lang['Reply_with_quote'] . '</a>|';

			        if (($poster_id != ANONYMOUS && $userdata['user_id'] == $poster_id) || $userdata['user_level'] == ADMIN || $userdata['user_level'] == MOD || $userdata['user_id'] == $this->uid)
		                {
		                    $temp_url = $this->append_sid("gb=edit&amp;gb_id=".$postrow[$i]['gb_id']);
		                    $edit = '<a href="' . $temp_url . '">' . $lang['Edit_delete_post'] . '</a>|';
		                }
		                else
		                {
		                    $edit = '';
		                }

		                if ( $userdata['user_id'] == $postrow['poster_id'] || $userdata['user_level'] == ADMIN || $userdata['user_level'] == MOD || $userdata['user_id'] == $this->uid)
		                {
		                    $temp_url = $this->append_sid("gb=delete&amp;gb_id=" . $postrow[$i]['gb_id']);
		                    $delpost = '<a href="' . $temp_url . '">' . $lang['Delete_post'] . '</a>';
		                }
		                else
		                {
		                    $delpost = '';
		                }

				$post_title = ( $postrow[$i]['title'] != '' ) ? $postrow[$i]['title'] : '';

				$message = stripslashes($postrow[$i]['message']);
				$bbcode_uid = $postrow[$i]['bbcode'];

				if ( $bbcode_uid != '' )
				{
					$message = ( $board_config['allow_bbcode'] ) ? bbencode_second_pass($message, $bbcode_uid) : preg_replace('/\:[0-9a-z\:]+\]/si', ']', $message);
				}

				$message = make_clickable($message);

				$message = smilies_pass($message);

				$message = str_replace("\n", "\n<br />\n", $message);
				$row_class = ( !($i % 2) ) ? 'row_easy' : 'row_hard';
				
				$template->assign_block_vars('main.postrow', array(
					'U_POST_ID' => $postrow[$i]['gb_id'],					
					'ROW_CLASS' => $row_class,
					'POSTER_NAME' => $poster,
					'POSTER_RANK' => $poster_rank,
					'RANK_IMAGE' => $rank_image,
					'POSTER_JOINED' => $poster_joined,
					'POSTER_POSTS' => $poster_posts,
					'POSTER_FROM' => $poster_from,
					'POSTER_AVATAR' => $avatar_img,
					'AVATAR_MINI' => $avatar_mini,
					'POST_DATE' => $post_date,
					'POST_SUBJECT' => $post_title,
					'MESSAGE' => $message,
					'EDIT' => $edit,
					'QUOTE' => $quote,
					'DELETE' => $delpost,
					'NUMBER' => $post_nr
				));
			}
		}
	
		include_once($phpbb_root_path."/includes/functions_post.".$phpEx);

		$quick_valid = true;

	        if($board_config['gb_posts'] > 0 && $userdata['user_posts'] <= $board_config['gb_posts'])
		{
			$quick_valid = false;
		}

		if($board_config['gb_quick'] && $quick_valid)
		{
			$template->assign_block_vars('quick',array());
		}
		      
		if(!$userdata['session_logged_in'])
		{
			$template->assign_block_vars('quick.username',array());
		}
		
		$action = $this->append_sid("gb=post");
		
		$template->assign_vars(array(
			'L_POST_QUICK' => $lang['gb_quick_reply'],
			'L_GB_POST' => $lang['gb_post2'],
			'L_TITLE' => $lang['gb_title'],
			'L_MESSAGE_BODY' => $lang['Message_body'],
			'L_SUBMIT' => $lang['Submit'],
			'L_USERNAME' => $lang['Username'],
			'U_PROFILE' => append_sid('profile.'.$phpEx.'?mode=viewprofile&amp;'.POST_USERS_URL.'='.$this->uid),

			'S_POST_ACTION' => $action
			)
		);
		$template->assign_var_from_handle('GUESTBOOK', 'gb_body');
	}
	
	function post($mode)
	{
		global $board_config,$userdata,$lang,$HTTP_POST_VARS,$phpbb_root_path,$phpEx,$db,$HTTP_GET_VARS,$unhtml_specialchars_replace,$unhtml_specialchars_match,$html_entities_match,$html_entities_replace;
		if($board_config['allow_guests_gb'] == 0 && !$userdata['session_logged_in'])
		{
			message_die(GENERAL_MESSAGE,sprintf($lang['gb_no_per'],$lang['post_pro']));
		}
		elseif($board_config['gb_posts'] > 0 && $userdata['user_posts'] <= $board_config['gb_posts'] && $userdata['user_id'] != ANONYMOUS)
		{
			message_die(GENERAL_MESSAGE,sprintf($lang['gb_posts_not'],$board_config['gb_posts']));
		}
		if(isset($HTTP_POST_VARS['message']))
		{
			$me = $HTTP_POST_VARS['message'];
			$ti = $HTTP_POST_VARS['subject'];
			include_once($phpbb_root_path."/includes/bbcode.".$phpEx);
			include_once($phpbb_root_path."/includes/functions_post.".$phpEx);

			$bbcode = make_bbcode_uid();
			$me = prepare_message($me,$board_config['allow_html'],true,true,$bbcode);
			$ti = prepare_message($ti,false,true,true,$bbcode);//No HTML in titles. BBcode and smilies are allowed.
			$err = false;
			$errmsg = array();
			if(empty($me))
			{
				$errmsg[] = $lang['Fields_empty'];
				$err = true;
			}
			if(!$userdata['session_logged_in'])
			{
				if(!empty($HTTP_POST_VARS['username']))
				{
					$username = phpbb_clean_username($HTTP_POST_VARS['username']);
				}
				else
				{
					$username = '';
				}
			}
			else
			{
				$username = '';
			}
			if($err)
			{
				$id = intval($HTTP_GET_VARS['gb_id']);

				$action = $this->append_sid("gb=$mode&amp;id=$id");
				$this->post_table($me,$ti,$action,$username,$errmsg);
				return;
			}

			$pid = $userdata['user_id'];
			if($mode != 'edit')
			{

				$sql = "INSERT INTO ".PROFILE_GUESTBOOK_TABLE." (user_id,poster_id,bbcode,title,message,gb_time,user_guest_name) VALUES
				(".$this->uid.",$pid,'$bbcode','$ti','$me','".time()."','$username');";
			}
			else
			{
				$id = intval($HTTP_GET_VARS['gb_id']);
				if(empty($id))
				{
					message_die(GENERAL_ERROR,$lang['gb_no_id'],"",__LINE__,__FILE__);
				}
				$sql = "UPDATE ".PROFILE_GUESTBOOK_TABLE." SET
				bbcode = '$bbcode', title = '$ti', message = '$me' WHERE gb_id = $id";
			}
			$result = $db->sql_query($sql);
			if(!$result)
			{
				message_die(GENERAL_ERROR,"Could not insert or update user guestbook!","",__LINE__,__FILE__,$sql);
			}

			$id = $db->sql_nextid();
			$msg = '<br /><a href="' . $this->append_sid("gb=view") . '#' . $id . '">' . $lang['back_pro'] . '</a>';	

			if($mode == 'edit')
			{
				message_die(GENERAL_MESSAGE, $lang['gb_edit'].$msg);
			}
			else
			{
				message_die(GENERAL_MESSAGE, $lang['gb_post'].$msg);
			}
		}
		else
		{
			if($mode == 'edit')
			{
				$id = intval($HTTP_GET_VARS['gb_id']);
				if(empty($id))
				{
					message_die(GENERAL_ERROR,$lang['gb_no_id'],"",__LINE__,__FILE__);
				}
				$action = $this->append_sid("gb=edit&amp;gb_id=" . $id);
				$sql = "SELECT * FROM ".PROFILE_GUESTBOOK_TABLE." 
				        WHERE gb_id = $id";;
				$r = $db->sql_query($sql);
				if(!$r)
				{
					message_die(GENERAL_ERROR,"Could not select edit information!",__LINE__,__FILE__,$sql);
				}
				$row = $db->sql_fetchrow($r);
				if($userdata['user_level'] != ADMIN && $userdata['user_level'] != MOD && $userdata['user_id'] != $this->uid && $row['poster_id'] != $userdata['user_id'])
				{
					message_die(GENERAL_MESSAGE,sprintf($lang['gb_no_per'],$lang['Edit_delete_post']));
				}
				$me = str_replace(':'.$row['bbcode'],'',$row['message']);
				$ti = str_replace(':'.$row['bbcode'],'',$row['title']);

			}
			elseif($mode == 'quote')
			{
				$action = $this->append_sid("gb=post");
				$id = intval($HTTP_GET_VARS['gb_id']);
				if(empty($id)){
					message_die(GENERAL_ERROR,$lang['gb_no_id'],"",__LINE__,__FILE__);
				}
				$sql = "SELECT * FROM ".PROFILE_GUESTBOOK_TABLE." g, ".USERS_TABLE." u 
			      	        WHERE g.gb_id = $id 
			      	        AND u.user_id = g.poster_id";
				$result = $db->sql_query($sql);
				if(!$result)
				{
					message_die(GENERAL_ERROR,"Could not select edit information!",__LINE__,__FILE__,$sql);
				}
				$row = $db->sql_fetchrow($result);
				$me = str_replace(':'.$row['bbcode'],'',$row['message']);
				$ti = str_replace(':'.$row['bbcode'],'',$row['title']);
				if($row['user_id'] != ANONYMOUS)
				{
					$me = '[quote="' . $row['username'] . '"]' . $me . '[/quote]';
				}
				else
				{
					if(!empty($row['user_guest_name']))
					{
						$me = '[quote="' . $row['user_guest_name'] . '"]' . $me . '[/quote]';
					}
					else
					{
						$me = '[quote]' . $me . '[/quote]';
					}
				}
				$ti = $lang['re'] . ":".$ti;
			}
			else
			{
				$action = $this->append_sid("gb=post");
				$me = '';
				$ti = '';
			}
			$this->post_table($me,$ti,$action);
			return;
		}
	}
	function post_table($me,$ti,$action,$username = '',$errmsg = array())
	{
		global $phpbb_root_path,$phpEx,$template,$mode,$userdata,$lang,$db,$unhtml_specialchars_replace,$unhtml_specialchars_match,$html_entities_match,$html_entities_replace;


		include_once($phpbb_root_path."/includes/bbcode.".$phpEx);
		include_once($phpbb_root_path."/includes/functions_post.".$phpEx);
		$template->set_filenames(array(
			'body' => 'profile_gb_post.tpl')
		);
		if(count($errmsg) > 0)
		{
			$template->set_filenames(array(
				'reg_header' => 'error_body.tpl')
			);
			$error_msg = $lang['gb_error'];
			for($i = 0;$i<count($errmsg);$i++)
			{
				$error_msg .= '<br />'.$errmsg[$i];
			}
			$template->assign_vars(array(
				'ERROR_MESSAGE' => $error_msg)
			);
			$template->assign_var_from_handle('ERROR_BOX', 'reg_header');
		}
		if(!$userdata['session_logged_in'] && $mode != 'edit')
		{
			$template->assign_block_vars('username',array(
				'USERNAME' => $username
			));
		}
		$me = unprepare_message($me);
		$ti = unprepare_message($ti);
		$template->assign_vars(array(
			'TITLE' => stripslashes($ti),
			'MESSAGE' => stripslashes($me),

			'L_GB_POST' => $lang['gb_post2'],
			'L_TITLE' => $lang['gb_title'],
			'L_MESSAGE_BODY' => $lang['Message_body'],
			'L_SUBMIT' => $lang['Submit'],
			'L_USERNAME' => $lang['Username'],
			'L_EMPTY_MESSAGE' => $lang['Empty_message'],
			'U_PROFILE' => append_sid('profile.'.$phpEx.'?mode=viewprofile&amp;'.POST_USERS_URL.'='.$this->uid),

			'S_POST_ACTION' => $action)
		);
		$template->pparse('body');
		include_once($phpbb_root_path."/includes/page_tail.".$phpEx);
	}
	function deleteall()
	{
		global $db,$lang,$phpEx;
		$sql = "DELETE FROM " . PROFILE_GUESTBOOK_TABLE . " WHERE user_id = ".$this->uid."";
		if(!$db->sql_query($sql))
		{
			message_die(GENERAL_ERROR,"Could not delete guestbook posts!","",__LINE__,__FILE__,$sql);
		}
		$msg = '<br /><a href="' . $this->append_sid("gb=view") . '">'.$lang['back_pro'].'</a>';
		message_die(GENERAL_MESSAGE, $lang['gb_all_del'] . $msg);
	}
	function delete()
	{
		global $lang,$HTTP_POST_VARS,$db,$phpEx;
		$id = intval($HTTP_POST_VARS['gb_id']);
		if(empty($id))
		{
			message_die(GENERAL_ERROR, $lang['gb_no_id'],"",__LINE__,__FILE__);
		}
		$sql = "DELETE FROM " . PROFILE_GUESTBOOK_TABLE . " WHERE user_id = ".$this->uid." AND gb_id = $id";
		if(!$db->sql_query($sql))
		{
			message_die(GENERAL_ERROR,"Could not delete guestbook posts!","",__LINE__,__FILE__,$sql);
		}
		$msg = '<br /><a href="' . $this->append_sid("gb=view") . '">'.$lang['back_pro'].'</a>';
		message_die(GENERAL_MESSAGE, $lang['gb_del'] . $msg);
	}
	function append_sid($url)
	{		
		$url = $this->url_intern . '&amp;' . $url;
		$url = append_sid($url);				
		return $url;
	}
	
}

?>