<?php
/***************************************************************************
 *                           functions_weblog.php
 *                        --------------------------
 *   Anv@r.all 2010
 *   (C) apwa.ru  
 * 
 ***************************************************************************/

function make_weblog_auth_select ( $selected, $select_name )
{
	global $lang;

	$weblog_auth_types = array($lang['Weblog_auth_all'], $lang['Weblog_auth_reg'], $lang['Weblog_auth_friends'], $lang['Weblog_auth_owner']);

	$weblog_auth_select = '<select id="' . $select_name . '" name="' . $select_name . '">';
	for ($i = 0; $i < count($weblog_auth_types); $i++)
	{
		$select = ( $selected == $i ) ? ' selected="selected"' : '';
		$weblog_auth_select .= '<option value="' . $i . '"' . $select . '>' . $weblog_auth_types[$i] . '</option>';
	}
	$weblog_auth_select .= '</select>';

	return $weblog_auth_select;
}

function make_mood_select ( $selected, $select_name, $auto_change_img = FALSE )
{
	global $lang, $mood_data;

	$mood_select = '<select id="' . $select_name . '" name="' . $select_name . '"' . ( ( $auto_change_img ) ? ' onchange="update_mood(this.options[selectedIndex].id);"' : '') . ' tabindex="4"><option value="-1" id="mood_none.gif"' . (( $selected == -1 ) ? " selected=\"selected\"" : "") . '>' . $lang['None'] . '</option>';
	for ($i = 0; $i < count($mood_data); $i++)
	{
		$select = ( $selected == $mood_data[$i]['mood_id'] ) ? ' selected="selected"' : '';
		$mood_select .= '<option value="' . $mood_data[$i]['mood_id'] . '" id="' . $mood_data[$i]['mood_url'] . '"' . $select . '>' . $mood_data[$i]['mood_text'] . '</option>';
	}
	$mood_select .= '</select>';

	return $mood_select;
}

function make_action_select ( $selected, $select_name, $auto_change_img = FALSE )
{
	global $lang, $action_data;

	$action_select = '<select id="' . $select_name . '" name="' . $select_name . '"' . ( ( $auto_change_img ) ? ' onchange="update_currently(this.options[selectedIndex].id);"' : '') . ' tabindex="5"><option value="-1" id="action_none.gif"' . (( $selected == -1 ) ? " selected=\"selected\"" : "") . '>' . $lang['None'] . '</option>';
	for ($i = 0; $i < count($action_data); $i++)
	{
		$select = ( $selected == $action_data[$i]['action_id'] ) ? ' selected="selected"' : '';
		$action_select .= '<option value="' . $action_data[$i]['action_id'] . '" id="' . $action_data[$i]['action_url'] . '"' . $select . '>' . $action_data[$i]['action_text'] . '</option>';
	}
	$action_select .= '</select>';

	return $action_select;
}

/********************************
* ADD ON for Category by willow *
*********************************/
function make_category_select ( $selected, $select_name, $category_data, $auto_change = TRUE)
{
	global $lang;

	$category_select = '<select name="' . $select_name . '"'  . '>';
	for ($i = 0; $i < count($category_data); $i++)
	{
		$select = ( $selected == $category_data[$i]['blog_cat_id'] ) ? ' selected="selected"' : '';
		$category_select .= '<option value="' . $category_data[$i]['blog_cat_id'] . '"' . $select . '>' . $category_data[$i]['blog_cat_title'] . '</option>';
	}
	$category_select .= '</select>';

	return $category_select;
}

function get_auth_level ( $weblog_data, $is_contributor = FALSE, $friends_data = array(), $blocked_data = array() )
{
	global $userdata, $db;

	$owner_id = $weblog_data['user_id'];

	if ( !count($friends_data) )
	{
		//
		// Friends
		//
		$sql = "SELECT * FROM " . WEBLOG_FRIENDS_TABLE . " WHERE friend_id = " . $userdata['user_id'];
		if ( !($result = $db->sql_query($sql)) )
		{
			weblog_message_die(GENERAL_ERROR, 'Error querying to find user weblog friends information', '', __LINE__, __FILE__, $sql);
		}

		$friends_data = array();
		while ( $row = $db->sql_fetchrow($result) )
		{
			$friends_data[] = $row;
		}
	}

	if ( !count($blocked_data) )
	{
		//
		// Blocked Users
		//
		$sql = "SELECT * FROM " . WEBLOG_BLOCKED_TABLE . " WHERE blocked_id = " . $userdata['user_id'];
		if ( !($result = $db->sql_query($sql)) )
		{
			weblog_message_die(GENERAL_ERROR, 'Error querying to find user weblog blocked information', '', __LINE__, __FILE__, $sql);
		}

		$blocked_data = array();
		while ( $row = $db->sql_fetchrow($result) )
		{
			$blocked_data[] = $row;
		}
	}

	//
	// Get the authorization level of this user versus this weblog
	//
	$weblog_id = $weblog_data['weblog_id'];

	$auth_level = 0;	// The user should at least belong to the 'all' category!

	if ( $userdata['session_logged_in'] )
	{
		$auth_level = 1;

		for ( $i = 0; $i < count($friends_data); $i++ )
		{
			if ( $friends_data[$i]['owner_id'] == $owner_id && $userdata['user_id'] == $friends_data[$i]['friend_id'] )
			{
				$auth_level = 2;
				break;
			}
		}

		for ( $i = 0; $i < count($blocked_data); $i++ )
		{
			if ( $blocked_data[$i]['owner_id'] == $owner_id && $userdata['user_id'] == $blocked_data[$i]['blocked_id'] )
			{
				$auth_level = -1;
				break;
			}
		}

		if ( $userdata['user_level'] == ADMIN || $is_contributor )
		{
			$auth_level = 2;
		}

		if ( $weblog_data['weblog_id'] == $userdata['user_weblog']  )
		{
			// Means full access. Can be any number higher than 2.
			$auth_level = 3;
		}
	}

	return $auth_level;
}

function get_weblog_body ($weblog_id)
{
	global $lang;

	$filename = 'templates/blog_' . $weblog_id . '.tpl';

	// CHMOD the template's files
	@chmod ($filename, 0755);
	if ( file_exists($filename) )
	{
		$body = file($filename);
	}
	else
	{
		$body[] = sprintf($lang['Weblog_no_body'], $filename);
	}

	$file_body = '';
	for ( $i = 0; $i < count($body); $i++) { $file_body .= $body[$i]; }

	return $file_body;
}

function find_mood ( $mood_id )
{
	global $mood_data;

	if ( $mood_id == -2 )
	{
		return -2;
	}

	for ( $i = 0; $i < count($mood_data); $i++ )
	{
		if ( $mood_data[$i]['mood_id'] == $mood_id )
		{
			return $mood_data[$i];
		}
	}

	return -1;
}

function find_action ( $action_id )
{
	global $action_data;

	if ( $action_id == -2 )
	{
		return -2;
	}

	for ( $i = 0; $i < count($action_data); $i++ )
	{
		if ( $action_data[$i]['action_id'] == $action_id )
		{
			return $action_data[$i];
		}
	}

	return -1;
}

function make_date_select ( $select_year, $select_month, $select_day )
{
	global $lang, $board_config;

	$months = array($lang['datetime']['January'],$lang['datetime']['February'],$lang['datetime']['March'],$lang['datetime']['April'],$lang['datetime']['May'],$lang['datetime']['June'], $lang['datetime']['July'], $lang['datetime']['August'], $lang['datetime']['September'], $lang['datetime']['October'], $lang['datetime']['November'], $lang['datetime']['December']);

	$date_select = '<select id="month" name="month">';
	$date_select .= '<option value="">---</option>';
	for ($i = 1; $i <= 12 ; $i++)
	{
		$select = ( $select_month == $i ) ? ' selected="selected"' : '';
		$date_select .= '<option value="' . $i . '"' . $select . '>' . $months[$i-1] . '</option>';
	}
	$date_select .= '</select>';


	$date_select .= '<select id="day" name="day">';
	$date_select .= '<option value="">---</option>';
	for ($i = 1; $i <= 31 ; $i++)
	{
		$select = ( $select_day == $i ) ? ' selected="selected"' : '';
		$date_select .= '<option value="' . $i . '"' . $select . '>' . $i . '</option>';
	}
	$date_select .= '</select>';


	$date_select .= '<select id="year" name="year">';
	for ($i = 1970; $i <= 2037; $i++)
	{
		$select = ( $select_year == $i ) ? ' selected="selected"' : '';
		$date_select .= '<option value="' . $i . '"' . $select . '>' . $i . '</option>';
	}
	$date_select .= '</select>';

	return $date_select;

}

function search_array ( $needle, $haystack )
{
	for ( $i = 0; $i < count($haystack); $i++)
	{
		if ( $haystack[$i]['weblog_id'] == $needle )
		{
			return true;
		}
	}

	return false;
}

function fetch_visible_weblogs($sort, $order)
{
	global $db, $userdata;

	//
	// Friends
	//
	$sql = "SELECT * FROM " . WEBLOG_FRIENDS_TABLE . " WHERE friend_id = " . $userdata['user_id'];
	if ( !($result = $db->sql_query($sql)) )
	{
		message_die(GENERAL_ERROR, 'Error querying to find user weblog friends information', '', __LINE__, __FILE__, $sql);
	}

	$friends_data = array();
	while ( $row = $db->sql_fetchrow($result) )
	{
		$friends_data[] = $row;
	}

	//
	// Blocked Users
	//
	$sql = "SELECT * FROM " . WEBLOG_BLOCKED_TABLE . " WHERE blocked_id = " . $userdata['user_id'];
	if ( !($result = $db->sql_query($sql)) )
	{
		message_die(GENERAL_ERROR, 'Error querying to find user weblog blocked information', '', __LINE__, __FILE__, $sql);
	}

	$blocked_data = array();
	while ( $row = $db->sql_fetchrow($result) )
	{
		$blocked_data[] = $row;
	}

	//
	// Fetch Contributor data
	//
	$sql = "SELECT * FROM " . WEBLOG_CONTRIBUTORS_TABLE . " WHERE user_id = " . $userdata['user_id'];
	if ( !($result = $db->sql_query($sql)) )
	{
		message_die(GENERAL_ERROR, 'Error querying to find user weblog information', '', __LINE__, __FILE__, $sql);
	}

	$contributor_data = array();
	while ( $row = $db->sql_fetchrow($result) )
	{
		$contributor_data[] = $row;
	}

	//
	// Get Weblog Data from Weblogs with at least one valid entry
	//
	$sql = "SELECT w.*, u.*, e.entry_id, e.entry_subject, e.entry_access, e.entry_mood, e.entry_currently, e.entry_time, e.bbcode_uid, e.entry_text
		FROM " . USERS_TABLE . " u, " . WEBLOGS_TABLE . " w
		LEFT JOIN " . WEBLOG_ENTRIES_TABLE . " e
		ON e.weblog_id = w.weblog_id
		AND e.entry_time <= " . time() . "
		WHERE w.weblog_id = u.user_weblog
		ORDER BY $sort $order LIMIT 0, 300";	
	if ( !($result = $db->sql_query($sql)) )
	{
		message_die(GENERAL_ERROR, 'Could not query weblogs information', '', __LINE__, __FILE__, $sql);
	}
	//
	// Build a new array, discarding weblogs with outdated entries or entries that cannot be viewed.
	//
	$weblog_data = array();
	while( $row = $db->sql_fetchrow($result) )
	{
		if ( !search_array( $row['weblog_id'], $weblog_data ) )
		{
			$contributor = FALSE;
			for ( $i = 0; $i < count($contributor_data); $i++)
			{
				if ( $contributor_data[$i]['weblog_id'] == $row['weblog_id'] )
				{
					$contributor = TRUE;
					break;
				}
			}
			$auth_level = get_auth_level( $row, $contributor, $friends_data, $blocked_data );

			if ( $auth_level >= $row['weblog_auth'] && $auth_level >= $row['entry_access'] )
			{
				$weblog_data[] = $row;
			}
		}
	}


	return $weblog_data;
}

function cut_message ( $message, $entry_id )
{
	global $lang, $phpEx;

	// Limit if [cut] is found
	$msg = '';
	if ( $pos = strpos($message, '[cut]') )
	{
		if ( $pos2 = strpos($message, '[/cut]') )
		{
			$msg = substr($message, $pos + 5, $pos2 - $pos - 5);
		}
		else
		{
			$msg = $lang['More'];
		}
		

		$message = substr($message, 0, $pos);
		$message .= "\n" . sprintf($lang['More_entry'], '<a href="' . append_sid("weblog_entry.$phpEx?" . POST_ENTRY_URL . "=" . $entry_id) . '">', substr($msg, 0, 20), '</a>'); 
	}

	return $message;
}

function hide_cuts ( $message )
{
	if ( ($pos = strpos($message, '[cut]')) && ($pos2 = strpos($message, '[/cut]')) )
	{
		$msg = substr($message, $pos, ($pos2 + 6)-$pos);

		$message = str_replace ($msg, '', $message);
	}
	return $message;
}

?>