<?php
/***************************************************************************
 *                            functions_antispam.php
 *                            -------------------
 *   Anv@r.all 2010
 *   (C) apwa.ru
 *
 ***************************************************************************/

if ( !defined('IN_PHPBB') )
{
	die("Hacking attempt");
}

function spam_no_apwa_ru ($str) 
{
	return FALSE === strpos($str, 'apwa.ru');
}
function spam_not_self_reference ($str) 
{
	global $board_config;
	if (! (FALSE === strpos($str, '@'))) 
	{
		return TRUE;
	}
	$sname = $board_config['server_name'];
	$range = "[-_A-Za-z0-9]";
	if (! preg_match("/$range+\\.$range+$/", $sname, $matches)) 
	{
		return TRUE;
	}
	$sname = $matches[0];
	$sname = preg_quote($sname, '#');
	$re = "#^(?:\\w+://)?(?:$range+\\.)*$sname#";
	if (! preg_match($re, $str, $matches)) 
	{
		return TRUE;
	}
	$tail = substr($str, strlen($matches[0]));
	if ('' == $tail) 
	{
		return FALSE;
	}
	return preg_match("/^($range|\\.)/", $tail);
}
function spam_hook($preview, &$error_msg, $username, $subject, $message) 
{
	global $userdata;
	global $phpbb_root_path;
	global $board_config;
	global $phpEx;
	global $lang; 
	global $phpbb_root_path;
	if ($error_msg != '') 
	{
		return;
	}
	if (ADMIN == $userdata['user_level']) 
	{
		return;
	}
	if ($userdata['user_id'] != ANONYMOUS) 
	{
		$username = $userdata['username'] . '[' . $userdata['user_id'] . ']';
	}
	$div = " {{{|\":}}}\n";
	$str = $username. $div . $subject . $div . $message;
	$orig_word        = array(); 
	$replacement_word = array(); 
	obtain_word_list(&$orig_word, &$replacement_word);
	
	if ($userdata['user_id'] != ANONYMOUS) 
	{
		if (spam_no_apwa_ru ($str)) 
		{
			return;
		}
	}

	$str = bbencode_second_pass($str, 0);
	$str = make_clickable($str);
	$contacts = spam_find_contact_info($str);

	$contacts = array_filter($contacts, 'spam_not_self_reference');
	if (function_exists('spam_filter_contacts')) 
	{
		$contacts = spam_filter_contacts($contacts);
	}
	if (! count($contacts)) 
	{
		return;
	}

	if ($userdata['user_id'] == ANONYMOUS) 
	{
		$c2 = array_filter($contacts, 'spam_no_apwa_ru');
		if (count ($c2)) 
		{
			$contacts = $c2;
		}
	}

	$error_msg = $lang['Rupoisk_Spam'];
	$error_msg .= "<u>\n";
	foreach ($contacts as $item) 
	{
		$error_msg .= '<b>' . htmlspecialchars($item) . "</b>\n";
	}
	$error_msg .= "</u>\n";

	if ($preview) 
	{
		return;
	}

	$lic_key  = 'x';
	$key      = '';
	if (file_exists (@phpbb_realpath ($lic_file))) 
	{		
		$s1 = strtr(strtolower($board_config['server_name']), array(' ' => '', '.' => '', 'w' => ''));
		$s2 = strtr(strtolower($lic_server), array(' ' => '', '.' => '', 'w' => ''));
		if ($s1 == $s2) 
		{
			$key = md5($s1);
			if ($key == $lic_key) 
			{
				if (! (isset($spam_notify) and $spam_notify)) 
				{
					return;
				}
			}
		}
	}

	$message     = stripslashes($message);
	$trans_table = array_flip(get_html_translation_table(HTML_ENTITIES));
	$message     = strtr($message, $trans_table);

	$links = '';
	foreach ($contacts as $item) 
	{
		$links .= "* $item\n";
	}
	$server = '';
	foreach (array('REMOTE_ADDR','HTTP_USER_AGENT','HTTP_VIA','HTTP_X_FORWARDED_FOR') as $k) 
	{
		if (isset($_SERVER[$k])) 
		{
			$server .= $k . '=' . $_SERVER[$k] . "\n";
		}
	}
	$server .= 'ENCODING=' . $lang['ENCODING'] . "\n";
	$subst = array(
		'LINKS'  => $links,
		'NAME'   => $username,
		'SUBJ'   => $subject,
		'TEXT'   => $message,
		'SERVER' => $server
	);
	if ($key == $lic_key) {
		$subst['UNREG'] = '';
	}
	
}

function spam_is_top_level_domain($dm) 
{
	if (! $dm) 
	{
		return 1;
	}
	$dlist = array(
		'ac', 'ad', 'ae', 'aero', 'af', 'ag', 'ai', 'al',
		'am', 'an', 'ao', 'aq', 'ar', 'arpa', 'arts', 'as',
		'at', 'au', 'aw', 'az', 'ba', 'bb', 'bd', 'be',
		'bf', 'bg', 'bh', 'bi', 'biz', 'bj', 'bm', 'bn',
		'bo', 'br', 'bs', 'bt', 'bv', 'bw', 'by', 'bz',
		'ca', 'cc', 'cd', 'cf', 'cg', 'ch', 'ci', 'ck',
		'cl', 'cm', 'cn', 'co', 'com', 'coop', 'cr', 'cu',
		'cv', 'cx', 'cy', 'cz', 'de', 'dj', 'dk', 'dm',
		'do', 'dz', 'ec', 'edu', 'ee', 'eg', 'eh', 'er',
		'es', 'et', 'fi', 'firm', 'fj', 'fk', 'fm', 'fo',
		'fr', 'fx', 'ga', 'gd', 'ge', 'gf', 'gg', 'gh',
		'gi', 'gl', 'gm', 'gn', 'gov', 'gp', 'gq', 'gr',
		'gs', 'gt', 'gu', 'gw', 'gy', 'hk', 'hm', 'hn',
		'hr', 'ht', 'hu', 'id', 'ie', 'il', 'im', 'in',
		'info', 'int', 'io', 'iq', 'ir', 'is', 'it', 'je',
		'jm', 'jo', 'jp', 'ke', 'kg', 'kh', 'ki', 'km',
		'kn', 'kp', 'kr', 'kw', 'ky', 'kz', 'la', 'lb',
		'lc', 'li', 'lk', 'lr', 'ls', 'lt', 'lu', 'lv',
		'ly', 'ma', 'mc', 'md', 'mg', 'mh', 'mil', 'mk',
		'ml', 'mm', 'mn', 'mo', 'mp', 'mq', 'mr', 'ms',
		'mt', 'mu', 'museum', 'mv', 'mw', 'mx', 'my', 'mz',
		'na', 'name', 'nato', 'nc', 'ne', 'net', 'nf', 'ng',
		'ni', 'nl', 'no', 'np', 'nom', 'np', 'nr', 'nu',
		'nz', 'om', 'org', 'pa', 'pe', 'pf', 'pg', 'ph',
		'pk', 'pl', 'pn', 'pr', 'pro', 'pt', 'pw', 'py',
		'qa', 're', 'rec', 'ro', 'ru', 'rw', 'sa', 'sb',
		'sc', 'sd', 'se', 'sg', 'sh', 'shop', 'si', 'sj',
		'sk', 'sl', 'sm', 'sn', 'so', 'sr', 'st', 'su',
		'sv', 'sy', 'sz', 'tc', 'td', 'tf', 'tg', 'th',
		'tj', 'tk', 'tm', 'tn', 'to', 'tp', 'tr', 'tt',
		'tv', 'tw', 'tz', 'ua', 'ug', 'uk', 'um', 'us',
		'uy', 'uz', 'va', 'vc', 've', 'vg', 'vi', 'vn',
		'vu', 'web', 'wf', 'ws', 'ye', 'yt', 'yu', 'za',
		'zm', 'zr', 'zw'
	);
	return in_array($dm, $dlist);
}

function spam_find_contact_info($text) 
{	
	$check_for_icq_wmid = 1;
	$check_for_phone    = 1;
	$min_digits_number  = 8;	
	$text = strtolower($text);
	$ret  = array();
	$encsym   = "(?:%[A-Fa-f0-9]{2})";
	$protocol = "(?:(?:ftp|http|https|gopher|mailto|news|nntp|telnet|wais|file|prospero|ms-help|$encsym{3,})(?::|$encsym)(?:\/|$encsym){2})";
	$username = $password="(?:[-a-z0-9\.\?;&=_]*|$encsym*)";
	$host     = "(?:\.?(?:[-_a-z0-9]|$encsym)+\.)+((?:[a-z]|$encsym)+)\.?";	
	$host     = "(?:(?:".$host.")|(?:[0-9]{1,3}\.[0-9]{1,3}\.[0-9]{1,3}\.([0-9]{1,3})))";
	$port     = "(?:[0-9]{1,5})";
	$urlpath  = "(?:[-a-z0-9_\.\/%;:&=])*";
	$urlpath  = "(?:".$urlpath.")";	
	$params   = "(?:[-a-z0-9_\.\/%;:&=\$+@#'\"`~^])*";
	$params   = "(?:(?:\?|#)".$params.")";	
	preg_match_all("/$protocol?(?:$username?(?:(?::|$encsym)$password?)?@)?$host(?:(?::|$encsym)$port)?$urlpath$params?/", $text, $url1);
	
	for ($i = 0; $i < count($url1[0]); $i++) 
	{
		// Decoding hex-encoded symbols (%20, %5F, etc.)
		$url1[0][$i] = urldecode($url1[0][$i]); 
		$url1[1][$i] = urldecode($url1[1][$i]);
		if (spam_is_top_level_domain($url1[1][$i])) {
			$ret[] = $url1[0][$i];
		}
	}
	
	preg_match_all('/href\s*=\s*["\']([^"\']+)["\']/', $text, $explicit_links);
	if (count ($explicit_links[1])) 
	{
		$ret = array_merge ($ret, $explicit_links[1]);
	}
	
	if ($check_for_icq_wmid) 
	{
		preg_match_all("/(?:icq){0,1}(?:wm){0,1}(?:z|r|u|e|id){0,1}\s*(?:[0-9]\s*(-|\.){0,1}\s*){".$min_digits_number.",}/", $text, $wmids);
		foreach ($wmids[0] as $wmid) 
		{
			$ret[] = trim(trim($wmid), ".,()");
		}
	}
	
	if ($check_for_phone) 
	{
		preg_match_all("/(\d\d\d-\d\d-?\d\d)/", $text, $phones);
		foreach ($phones[0] as $phone) 
		{
			$ret[] = trim(trim($phone), ".,()");
		}
	}
	
	return array_unique($ret);
}

?>