<?php

define('IN_PHPBB', true);
$phpbb_root_path = './';

include($phpbb_root_path . 'extension.inc');
include($phpbb_root_path . 'common.'.$phpEx);
include($phpbb_root_path . 'includes/bbcode.'.$phpEx);
include($phpbb_root_path . 'includes/functions_gb.'.$phpEx);
include($phpbb_root_path . 'includes/functions_antispam.'.$phpEx);

function refresh_page($message = '') 
{
     global $template, $lang, $phpEx, $view;
 
               $template->assign_vars(array(
			'META' => '<meta http-equiv="refresh" content="3;url=' . append_sid("index.$phpEx") . '">')
		    );

     $msg = $message . '<br />' . sprintf($lang['Guest_return'], '<a href="' . append_sid("gb.$phpEx") . '">', '</a> ') . '<br />' . sprintf($lang['Click_return_index'], '<a href="' . append_sid("index.$phpEx") . '">', '</a>');

     message_die(GENERAL_MESSAGE, $msg);
} 

$userdata = session_pagestart($user_ip, PAGE_GUESTBOOK);
init_userprefs($userdata);

$guest_config = array();
$guest_book = new guestbook();
$guest_config = $guest_book->guest_config();
$time = date('d.m - H:i');

$ban_information = session_userban($user_ip, $userdata['user_id']);
if ($ban_information)
{
	message_die(CRITICAL_MESSAGE, 'Вы не можете создавать новые темы и отвечать на старые, т.к. ваш '.$ban_information);
}

if ( $userdata['session_logged_in'] )
{
      switch ($userdata['user_level'])	
      { 
         case ADMIN: define('STAFF', true); break;
         case MOD: 
		if ( $guest_config['permit_mod'] )
		{
		       define('STAFF', true);  
		}
	break;
      }
}
$hide = ( isset($HTTP_POST_VARS['hide']) ) ? ( ($HTTP_POST_VARS['hide']) ? TRUE : 0 ) : 0;
$unhide = ( isset($HTTP_POST_VARS['unhide']) ) ? ( ($HTTP_POST_VARS['unhide']) ? TRUE : 0 ) : 0;
$cancel = ( isset($HTTP_POST_VARS['cancel']) ) ? TRUE : FALSE;
$confirm = ( isset($HTTP_POST_VARS['confirm']) ) ? TRUE : FALSE;
$delete = ( isset($HTTP_POST_VARS['delete']) ) ? TRUE : FALSE;
$start = ( isset($HTTP_GET_VARS['start']) ) ? intval($HTTP_GET_VARS['start']) : 0;

if ( isset($HTTP_POST_VARS['idmsg']) || isset($HTTP_GET_VARS['idmsg']) )
{
	$idmsg = ( isset($HTTP_POST_VARS['idmsg']) ) ? $HTTP_POST_VARS['idmsg'] : $HTTP_GET_VARS['idmsg'];
	$idmsg = intval($idmsg);	
}
else
{
	$idmsg = '';
}

if ( isset($HTTP_POST_VARS['view']) || isset($HTTP_GET_VARS['view']) )
{
	$view = ( isset($HTTP_POST_VARS['view']) ) ? $HTTP_POST_VARS['view'] : $HTTP_GET_VARS['view'];
	$view = htmlspecialchars($view);	
}
else
{
	$view = '';
}

if ( isset($HTTP_POST_VARS['mode']) || isset($HTTP_GET_VARS['mode']) )
{
	$mode = ( isset($HTTP_POST_VARS['mode']) ) ? $HTTP_POST_VARS['mode'] : $HTTP_GET_VARS['mode'];
	$mode = htmlspecialchars($mode);
}
else
{
	if ( $delete )
	{
		$mode = 'delete';
	}
	else
	{
		$mode = '';
	}
}

if ( $cancel )
{
	redirect(append_sid("gb.$phpEx", TRUE));
}

$error_msg = '';
$strip_var_list = array('email' => 'email', 'confirm_code' => 'confirm_code');

function get_crypted_name($name)
{
	global $board_config;

	$code_start = $board_config['board_startdate'] % 2 ? 65: 97;
	$first = chr($code_start + $board_config['board_startdate'] % 26);
	$var = $first . md5($name . $board_config['board_startdate']);

	return $var;
}

if (isset($HTTP_POST_VARS['submit']))
{

	$html_entities_match = array('#&(?!(\#[0-9]+;))#', '#<#', '#>#', '#"#');
	$html_entities_replace = array('&amp;', '&lt;', '&gt;', '&quot;');	
	$username = ( !empty($HTTP_POST_VARS['nick']) ) ? phpbb_clean_username($HTTP_POST_VARS['nick']) : $userdata['username'];
	$email = ( !empty($HTTP_POST_VARS['email']) ) ? trim(htmlspecialchars($HTTP_POST_VARS['email'])) : '';
	$message = ( !empty($HTTP_POST_VARS['message']) ) ? trim($HTTP_POST_VARS['message']) : '';
	$maxlenght = intval($guest_config['maxlenght_posts']);
	$strip_var_list = array('email' => 'email', 'confirm_code' => 'confirm_code');
	spam_hook('', $error_msg, $username, '', $message);
	while( list($var, $param) = @each($strip_var_list) )
	{
		$param = get_crypted_name($param);
		if ( !empty($HTTP_POST_VARS[$param]) )
		{
			$$var = trim(htmlspecialchars($HTTP_POST_VARS[$param]));
		}
	}
	
	if (!$userdata['session_logged_in'] || ($userdata['session_logged_in'] && $username != $userdata['username']))
	{
		include($phpbb_root_path . 'includes/functions_validate.'.$phpEx);
		
		$result = validate_username($username);
		if ($result['error'])
		{
			$error_msg .= (!empty($error_msg)) ? '<br />' . $result['error_msg'] : $result['error_msg'];
		}
	}
	else
	{
		$username = $userdata['username'];
	}	
                        
        if ( strlen( $message ) > $maxlenght )
        {
              $error_msg .= (!empty($error_msg)) ? '<br />' . sprintf($lang['Long_message'], $maxlenght)  : sprintf($lang['Long_message'], $maxlenght) ;
        }
        else if ( $message != '' )
        {   
              $check = $guest_book->check_post_error($message);
      
              if ( $check['error'] )
	      {
                     $error_msg .= (!empty($error_msg)) ? '<br />' . $check['error_msg'] : $check['error_msg'];

              }
	      else
	      {
                     $message = $guest_book->word_wrap($message, $guest_config['word_wrap_length']);
		     $bbcode_uid = make_bbcode_uid();
		     $message = preg_replace($html_entities_match, $html_entities_replace, $message);
		     $message = bbencode_first_pass($message, $bbcode_uid);
	      }
	}
	else
	{
		$error_msg .= (!empty($error_msg)) ? '<br />' . $lang['Empty_message'] : $lang['Empty_message'];
	}
		
        $data_ora = time();
        $agent = trim(htmlspecialchars($HTTP_SERVER_VARS['HTTP_USER_AGENT'])); // ??? :(
        $hide = $guest_config['hide_posts'];
        $flood_interval = intval($guest_config['flood_interval']);
   
        if ( $flood_interval > 0 )
        {      
                $time_request = time() - $flood_interval;
                $last_posting = intval($HTTP_COOKIE_VARS[$board_config['cookie_name'] . '_flood']);
      
	        if(!isset($HTTP_COOKIE_VARS[$board_config['cookie_name'] . '_flood']) OR $last_posting < $time_request)
	        {  
	                setcookie($board_config['cookie_name'] . '_flood',time(), time()+3600, $board_config['cookie_path'], $board_config['cookie_domain'], $board_config['cookie_secure']);
                }
                if($last_posting > $time_request)
                {
                        $error_msg .= (!empty($error_msg)) ? '<br />' . $lang['Flood_Error'] : $lang['Flood_Error'];
                }     
        }
        
        if (!$userdata['session_logged_in'])
        {
		if (empty($HTTP_POST_VARS['confirm_id']))
		{
			$error = TRUE;
			$error_msg .= ( ( isset($error_msg) ) ? '' : '' ) . $lang['Confirm_code_wrong'];
		}
		else
		{
			$confirm_id = htmlspecialchars($HTTP_POST_VARS['confirm_id']);
			if (!preg_match('/^[A-Za-z0-9]+$/', $confirm_id))
			{
				$confirm_id = '';
			}
			
			$sql = 'SELECT code 
				FROM ' . CONFIRM_TABLE . " 
				WHERE confirm_id = '$confirm_id' 
				AND session_id = '" . $userdata['session_id'] . "'";
			if (!($result = $db->sql_query($sql)))
			{
				message_die(GENERAL_ERROR, 'Could not obtain confirmation code', '', __LINE__, __FILE__, $sql);
			}
			
			if ($row = $db->sql_fetchrow($result))
			{
				if ($row['code'] != $confirm_code)
				{
					$error = TRUE;
					$error_msg .= ( ( isset($error_msg) ) ? '' : '' ) . $lang['Confirm_code_wrong'];
				}
				else
				{
					$sql = 'DELETE FROM ' . CONFIRM_TABLE . " 
						WHERE confirm_id = '$confirm_id' 
							AND session_id = '" . $userdata['session_id'] . "'";
					if (!$db->sql_query($sql))
					{
						message_die(GENERAL_ERROR, 'Could not delete confirmation code', '', __LINE__, __FILE__, $sql);
					}
				}
			}
			else
			{		
				$error = TRUE;
				$error_msg .= ( ( isset($error_msg) ) ? '' : '' ) . $lang['Confirm_code_wrong'];
			}
			$db->sql_freeresult($result);
		}
       }     
       if (!$error_msg)
       {    
	       if (defined('STAFF') and $idmsg != '') 
	       {
	                $sql = "UPDATE " . GUESTBOOK . " SET nick = '$username', email = '".str_replace("\'", "''", $email)."', comento = '".str_replace("\'", "''", $message)."', bbcode_uid = '$bbcode_uid' 
			        WHERE id = '$idmsg' LIMIT 1";
		        
		        $message_sing = $lang['Message_edited'];
	       } 
	       else 
	       {
	                $sql = "INSERT INTO " . GUESTBOOK . " (nick, data_ora, email, comento, bbcode_uid, ipi, agent, user_id, hide)
	                        VALUES ('$username', '$data_ora', '".str_replace("\'", "''", $email)."', '".str_replace("\'", "''", $message)."', '$bbcode_uid', '$user_ip', '$agent', '".$userdata['user_id']."', '$hide')";
	                
	                $message_sing = $lang['Message_sing'];
	                // Sobytie
	                add_sobytie('', 'gb_post', '', '', '', $userdata['user_id'], $username, '', $message, $data_ora);	
	                // Sobytie
	       } 
    
               if( !($result = $db->sql_query($sql)) )
               {
   	                 message_die(GENERAL_ERROR, 'Could not query guestbook', '', __LINE__, __FILE__, $sql);
               }
               refresh_page($message_sing); 
       }
       else 
       {
               $field_nick = ( !empty($HTTP_POST_VARS['nick']) ) ? stripslashes($username) : '';
               $field_email = ( !empty($HTTP_POST_VARS['email']) ) ? stripslashes($email) : '';
               $field_comento = ( !empty($HTTP_POST_VARS['message']) ) ? stripslashes($message) : '';
               $field_comento = preg_replace('/\:(([a-z0-9]:)?)' . $bbcode_uid . '/s', '', $field_comento);
       }
}

$confirm_image = '';
$strip_var_list = array('confirm_code' => 'confirm_code'); 
if (!$userdata['session_logged_in'] )
{
	$sql = 'SELECT session_id FROM ' . SESSIONS_TABLE; 
	if (!($result = $db->sql_query($sql)))
	{
		message_die(GENERAL_ERROR, 'Could not select session data', '', __LINE__, __FILE__, $sql);
	}

	if ($row = $db->sql_fetchrow($result))
	{
		$confirm_sql = '';
		do
		{
			$confirm_sql .= (($confirm_sql != '') ? ', ' : '') . "'" . $row['session_id'] . "'";
		}
		while ($row = $db->sql_fetchrow($result));
		
		$sql = 'DELETE FROM ' .  CONFIRM_TABLE . " 
	  	        WHERE session_id NOT IN ($confirm_sql)";		
		if (!$db->sql_query($sql))
		{
			message_die(GENERAL_ERROR, 'Could not delete stale confirm data', '', __LINE__, __FILE__, $sql);
		}
	}
	$db->sql_freeresult($result);

	$sql = 'SELECT COUNT(session_id) AS attempts 
		FROM ' . CONFIRM_TABLE . " 
		WHERE session_id = '" . $userdata['session_id'] . "'";
	if (!($result = $db->sql_query($sql)))
	{
		message_die(GENERAL_ERROR, 'Could not obtain confirm code count', '', __LINE__, __FILE__, $sql);
	}

	if ($row = $db->sql_fetchrow($result))
	{
		if ($row['attempts'] > 20)
		{
			message_die(GENERAL_MESSAGE, $lang['Too_many_']);
		}
	}
	$db->sql_freeresult($result);

	$allowed_symbols = "0123456789";
	$length = 5;
	while(true)
	{
		$code='';
		for($i=0; $i<$length; $i++)
		{
			$code.=$allowed_symbols{mt_rand(0,strlen($allowed_symbols)-1)};
		}
		if(!preg_match('/cp|cb|ck|c6|c9|rn|rm|mm|co|do|cl|db|qp|qb|dp/', $code)) break;
	}

	$confirm_id = md5(uniqid($user_ip));

	$sql = 'INSERT INTO ' . CONFIRM_TABLE . " (confirm_id, session_id, code) 
		VALUES ('$confirm_id', '". $userdata['session_id'] . "', '$code')";
	
	if (!$db->sql_query($sql))
	{
		message_die(GENERAL_ERROR, 'Could not insert new confirm code information', '', __LINE__, __FILE__, $sql);
	}

	unset($code);
		
	$confirm_image = '<img src="' . append_sid("profile.$phpEx?mode=confirm&amp;id=$confirm_id") . '" alt="" title="" />';
	$s_hidden_fields .= '<input type="hidden" name="confirm_id" value="' . $confirm_id . '" />';

	$template->assign_block_vars('switch_confirm', array());
}
		
foreach ( $strip_var_list as $var => $param )
{
	$template->assign_vars(array(
		'VAR_' . strtoupper($param) => get_crypted_name($param))
	);
}
	
if ( (defined('STAFF') and $mode == 'edit') or $mode == 'quote') 
{
  
        if ($mode == 'edit')
        {
                 $sql = "SELECT * FROM " . GUESTBOOK . " 
                         WHERE id = '$idmsg' LIMIT 1";
        }
        else
        { 
                 $sql = "SELECT nick, comento, bbcode_uid 
                         FROM " . GUESTBOOK . " 
                         WHERE id = '$idmsg' LIMIT 1";
        }                               
	if ( $result = $db->sql_query($sql) ) 
	{
		$row = $db->sql_fetchrow($result);
         	if (!$row)  message_die(GENERAL_MESSAGE, $lang['Guest_none_selected']);
			 
		if ($mode == 'edit') 
		{
	 		$field_email = ( !empty($row['email']) ) ? trim(stripslashes($row['email'])) : '';
	         	$field_nick = ( !empty($row['nick']) ) ? trim(stripslashes($row['nick'])) : ANONYMOUS;
	         	$bbcodes = $row['bbcode_uid'];
	         	$editid = $idmsg;
		}
               
		$quote_nick = ( !empty($row['nick']) ) ? trim(stripslashes($row['nick'])) : ANONYMOUS;
		$field_comento = ( !empty($row['comento']) ) ? stripslashes($row['comento']) : '';
	        $field_comento = preg_replace('/\:(([a-z0-9]:)?)' . $row['bbcode_uid'] . '/s', '', $field_comento);
	         
	        $field_comento = str_replace('<', '&lt;', $field_comento);
		$field_comento = str_replace('>', '&gt;', $field_comento);
		$field_comento = str_replace('<br />', "\n", $field_comento);
				
	        if ( $mode == 'quote' ) 
	        {
			$field_comento = $quote_nick . ',';
		}				
	}
}
 
switch( $view )
{
        default: 
	{
	     $title_msg = $lang['Guestbook'];
	     $sql =  "SELECT COUNT(*) as total FROM " . GUESTBOOK . " WHERE hide = 0";
	     $hidepost =  'WHERE hide = 0';
	}
        break;
} 
$result = $db->sql_query($sql);
if( $result )
{
	$row = $db->sql_fetchrow($result);
	$num = $row['total'];	       
}
      $db->sql_freeresult($result);
      
        $guest_config['posts_per_page'] = intval($guest_config['posts_per_page']);
        $link_view_all = (defined('STAFF')) ? '<a href="' . append_sid("gb.$phpEx?view=view_all") . '">'.$lang['Guest_view_all'].'</a>' : '';
	$link_view_hidden = (defined('STAFF')) ? '<a href="' . append_sid("gb.$phpEx?view=hidden") . '">'.$lang['Guest_view_hidden'].'</a>' : '';
	$link_view_visible = (defined('STAFF')) ? '<a href="' . append_sid("gb.$phpEx") . '">'.$lang['Guest_view_visible'].'</a>' : '';
	$pagination = (defined('STAFF')) ? generate_pagination("gb.$phpEx?mode=leggi&amp;view=$view", $num, $guest_config['posts_per_page'], $start). ' ': generate_pagination("gb.$phpEx?mode=leggi", $num, $guest_config['posts_per_page'], $start). ' ';
        $field_view = (defined('STAFF')) ?  '<input type="hidden" name="view" value="'.$view.'" />' : '';
	$field_hide = (defined('STAFF')) ? '<input type="submit" name="hide" value="'.$lang['Guest_hide_selected'].'" class="subbutton" />' : '';
	$field_unhide = (defined('STAFF')) ? '<input type="submit" name="unhide" value="'.$lang['Guest_show_selected'].'" class="subbutton" />' : '';
	$field_delete = (defined('STAFF')) ? '<input type="submit" name="delete" value="'.$lang['Del2'].'" class="subbutton" />' : '';
        $s_hidden_fields = '<input type="hidden" name="submit" value="'.$lang['Submit'].'" />';
        $s_hidden_fields .= ($mode =='edit') ? '<input type="hidden" name="idmsg" value="'.$editid.'" />' : $s_hidden_fields;
	$s_hidden_fields .= '<input type="hidden" name="mode" value="'. $guest_book->encrypt(time()) . '" />';
	$s_hidden_fields .= '<input type="hidden" name="confirm_id" value="' . $confirm_id . '" />';

$page_title = 'Написать';
include($phpbb_root_path . 'includes/page_header.'.$phpEx); 

if ( $error_msg != '' )
{
	$template->set_filenames(array(
		'reg_header' => 'error_body.tpl')
	);
	$template->assign_vars(array(
		'ERROR_MESSAGE' => $error_msg)
	);
	
	$template->assign_var_from_handle('ERROR_BOX', 'reg_header');
}

$template->set_filenames(array( 
        'body' => 'gbcomm.tpl') 
); 

	$template->assign_vars(array(
		'L_MESSAGE' => $lang['Message'], 
		'TIME' => $time,
		'L_GUESTBOOK' => $title_msg,
		'CONFIRM_IMG' => $confirm_image, 
		'L_USERNAME' => $lang['Username'],
                'FIELD_HIDE' => $field_hide,
                'FIELD_VIEW' => $field_view,
                'FIELD_NICK' => $field_nick,
                'FIELD_COMENTO' => $field_comento,
		'U_GUESTBOOK' => append_sid("gb.$phpEx?"), 
		'L_SUBJECT' => $lang['Subject'],
		'L_POSTED' => $lang['Posted'], 
		'L_DATE' => $lang['Date'],
		'L_FROM' => $lang['From'],
		'L_SUBMIT' => $lang['Submit'],
		'L_DELETE' => $lang['Delete'],
		'L_SELECT' => $lang['Select'],
		'L_CAVEAT' => $lang['caveat'],
		'L_MESSAGGIO' => $lang['Post'],
	        'L_EMPTY_MESSAGE' => $lang['Empty_message'],
		'S_GUESTBOOK_ACTION' => append_sid("gbcomm.$phpEx?mode=scrivi"),
		'S_HIDDEN_FIELDS' => $s_hidden_fields)
	);

if (defined('STAFF'))
{
      $template->assign_block_vars('switch_user_staff', array());
}

$template->pparse('body'); 
include($phpbb_root_path . 'includes/page_tail.'.$phpEx); 

?>