<?php

define('IN_PHPBB', true);
$phpbb_root_path = './';
include($phpbb_root_path . 'extension.inc');
include($phpbb_root_path . 'common.'.$phpEx);

if (!empty($board_config['index_announcement']))
{
	include($phpbb_root_path . 'includes/bbcode.'.$phpEx);
}

$userdata = session_pagestart($user_ip, PAGE_INDEX);
init_userprefs($userdata);

$viewcat = ( !empty($HTTP_GET_VARS[POST_CAT_URL]) ) ? $HTTP_GET_VARS[POST_CAT_URL] : -1;

if( (!$board_config['index_spisok'] && !$userdata['session_logged_in']) || ($userdata['session_logged_in'] && !$userdata['user_index_spisok']) )
{
	if ( $viewcat < 0 && $template_name != 'web')
	{
	     $viewcat = -2 ;
	}
}

$tracking_topics = ( isset($HTTP_COOKIE_VARS[$board_config['cookie_name'] . '_t']) ) ? unserialize($HTTP_COOKIE_VARS[$board_config['cookie_name'] . "_t"]) : array();
$tracking_forums = ( isset($HTTP_COOKIE_VARS[$board_config['cookie_name'] . '_f']) ) ? unserialize($HTTP_COOKIE_VARS[$board_config['cookie_name'] . "_f"]) : array();

$total_posts = get_db_stat('postcount');
$total_topics = get_db_stat('topiccount');
$total_users = get_db_stat('usercount');
$total_attach = get_db_stat('attachcount');
$newest_userdata = get_db_stat('newestuser');
$newest_user = $newest_userdata['username'];
$newest_uid = $newest_userdata['user_id'];

$statistika = sprintf($lang['total_topics'], $total_topics)." &#8226; ".sprintf($lang['Posted_articles_total'], $total_posts)." &#8226; ".sprintf($lang['Attach_total'], $total_attach)." &#8226; ".sprintf($lang['Registered_users_total'], $total_users)." &#8226; ".sprintf($lang['Newest_user'], '<a href="' . append_sid("profile.$phpEx?mode=viewprofile&amp;" . POST_USERS_URL . "=$newest_uid") . '">', $newest_user, '</a>');

$ban_information = session_userban($user_ip, $userdata['user_id']);
if ($ban_information)
{
	$ban = '<div class="text" style="color: red; font-weight: bold;">Внимание!<br/></div><div style="border: 1px solid #d4d6d4; background: #ffffa0;">Ваш '.$ban_information.'</div>';
} 
else 
{
	$ban = '';
}

$sql = "SELECT c.cat_id, c.cat_title, c.cat_order
	FROM " . CATEGORIES_TABLE . " c 
	ORDER BY c.cat_order";
if( !($result = $db->sql_query($sql)) )
{
	message_die(GENERAL_ERROR, 'Could not query categories list', '', __LINE__, __FILE__, $sql);
}

$category_rows = array();
while ($row = $db->sql_fetchrow($result))
{
	$category_rows[] = $row;
}
$db->sql_freeresult($result);

$total_categories = count($category_rows);

$sql = "SELECT f.*, p.post_time, p.post_username,  u.username, u.user_id, t.topic_id, t.topic_title
        FROM ((( " . FORUMS_TABLE . " f
	LEFT JOIN " . POSTS_TABLE . " p ON p.post_id = f.forum_last_post_id )
	LEFT JOIN " . USERS_TABLE . " u ON u.user_id = p.poster_id )
	LEFT JOIN " . TOPICS_TABLE . " t ON t.topic_last_post_id = f.forum_last_post_id)
	GROUP BY f.forum_id ORDER BY f.cat_id, f.forum_order";
if ( !($result = $db->sql_query($sql)) )
{
	message_die(GENERAL_ERROR, 'Could not query forums information', '', __LINE__, __FILE__, $sql);
}

$forum_data = array();
while( $row = $db->sql_fetchrow($result) )
{
	$forum_data[] = $row;
}
$attach = $forum_data;

$db->sql_freeresult($result);

$total_forums = count($forum_data);

if ($userdata['session_logged_in'])
{
	if ($userdata['user_lastvisit'] < (time() - 5184000))
	{
		$userdata['user_lastvisit'] = time() - 5184000;
	}

	$sql = "SELECT t.forum_id, t.topic_id, p.post_time 
		FROM " . TOPICS_TABLE . " t, " . POSTS_TABLE . " p 
		WHERE p.post_id = t.topic_last_post_id 
			AND p.post_time > " . $userdata['user_lastvisit'] . " 
			AND t.topic_moved_id = 0"; 
	if ( !($result = $db->sql_query($sql)) )
	{
		message_die(GENERAL_ERROR, 'Could not query new topic information', '', __LINE__, __FILE__, $sql);
	}

	$new_topic_data = array();
	while( $topic_data = $db->sql_fetchrow($result) )
	{
		$new_topic_data[$topic_data['forum_id']][$topic_data['topic_id']] = $topic_data['post_time'];
	}
	$db->sql_freeresult($result);
}

$is_auth_ary = array();
$is_auth_ary = auth(AUTH_VIEW, AUTH_LIST_ALL, $userdata, $forum_data);

if( $userdata['session_logged_in'] )
{
	$sql = "SELECT COUNT(post_id) as total
			FROM " . POSTS_TABLE . "
			WHERE post_time >= " . $userdata['user_lastvisit'];
	$result = $db->sql_query($sql);
	if( $result )
	{
		$row = $db->sql_fetchrow($result);
		$lang['Search_new'] = $lang['Search_new'] . "&nbsp;(" . $row['total'] . ")";
	}
}
define('SHOW_ONLINE', true);
$page_title = sprintf($lang['Forum_Index'], $board_config['sitename']);
include($phpbb_root_path . 'includes/page_header.'.$phpEx);
 
$template->set_filenames(array(
	'body' => 'index_body.tpl')
);
	
$template->assign_vars(array( 
        'RSS' => '<a href="rss.'. $phpEx .'">RSS Feed</a>',
	'STATISTIKA' => $statistika,
	'L_TOPICS' => $lang['Topics'],
	'L_POSTS' => $lang['Replies'],
	'L_LAST_POST' => $lang['Last_Post'],			
	'BAN_INFO' => $ban)
);

if (!empty($board_config['index_announcement']))
{
	$announcement = smilies_pass($board_config['index_announcement']);
	$announcement = str_replace("\n", "\n<br/>\n", $announcement);

	$template->assign_block_vars('announcement', array(
		'ANNOUNCEMENT' => $announcement)
	);
}
if ($board_config['birthday_check_day'])
{
        include($phpbb_root_path . 'module/birthday.'.$phpEx);
}

$display_categories = array();		
for ($i = 0; $i < $total_forums; $i++ )
{
	if ($is_auth_ary[$forum_data[$i]['forum_id']]['auth_view'])
	{
		$display_categories[$forum_data[$i]['cat_id']] = true;
	}
}
  
for($i = 0; $i < $total_categories; $i++)
{	 
        $cat_id = $category_rows[$i]['cat_id'];                     	
	if (isset($display_categories[$cat_id]) && $display_categories[$cat_id])
	{	
	        $row_class = ( !($i % 2) ) ? 'row_hard' : 'row_easy';
	        $template->assign_block_vars('catrow', array(			        		        
			'CAT_DESC' => $category_rows[$i]['cat_title'],
			'ROW_CLASS' => $row_class,			
			'U_VIEWCAT' => append_sid("forum.$phpEx?" . POST_CAT_URL . "=$cat_id"))
		);
                if ( $viewcat == $cat_id || $viewcat == -1 )
		{																			                                               									        
		        if( $viewcat == $cat_id )
		        {
			        $template->set_filenames(array(
			                'body' => 'cat_body.tpl')
			        );
		        }
		        for($j = 0; $j < $total_forums; $j++)
		        {
			        if ( $forum_data[$j]['cat_id'] == $cat_id )
			        {
					$forum_id = $forum_data[$j]['forum_id']; 
					$attached_id = $forum_data[$j]['attached_forum_id'];
				        if ( $is_auth_ary[$forum_id]['auth_view'] && $attached_id == -1 )
				        {
						$attached_forums = array();
					        foreach ($attach as $key => $value)
					        {
							$sub_forum_id = $value['forum_id'];
							if ($value['attached_forum_id'] == $forum_id && $is_auth_ary[$sub_forum_id]['auth_view'])
							{									
								$unread_topics = false;								

								$attached_forums[] = array(
									'sub_name' => $value['forum_name'],
									'sub_url' => append_sid ('viewforum.php?f=' . $value['forum_id'])
								);
							}
					        }                                      
					        if ( $is_auth_ary[$forum_id]['auth_view'] )
					        {
						        if ( $forum_data[$j]['forum_status'] == FORUM_LOCKED )
							{
								$folder_image = "images/locked.gif"; 								
							}
							else
							{
							        $unread_topics = false;
								if ( $userdata['session_logged_in'] )
								{
									if ( !empty($new_topic_data[$forum_id]) )
									{
										$forum_last_post_time = 0;

										while( list($check_topic_id, $check_post_time) = @each($new_topic_data[$forum_id]) )
										{
											if ( empty($tracking_topics[$check_topic_id]) )
											{
												$unread_topics = true;
												$forum_last_post_time = max($check_post_time, $forum_last_post_time);

											}
											else
											{
												if ( $tracking_topics[$check_topic_id] < $check_post_time )
												{
													$unread_topics = true;
													$forum_last_post_time = max($check_post_time, $forum_last_post_time);
												}
											}
										}
										
										if ( !empty($tracking_forums[$forum_id]) )
										{
											if ( $tracking_forums[$forum_id] > $forum_last_post_time )
											{
												$unread_topics = false;
											}
										}

										if ( isset($HTTP_COOKIE_VARS[$board_config['cookie_name'] . '_f_all']) )
										{
											if ( $HTTP_COOKIE_VARS[$board_config['cookie_name'] . '_f_all'] > $forum_last_post_time )
											{
												$unread_topics = false;
											}
										}

									}
								}
								$folder_image = ( $unread_topics ) ? "images/new.gif" : "images/nonew.gif"; 								
							}
						        $posts = $forum_data[$j]['forum_posts'];
						        $topics = $forum_data[$j]['forum_topics'];
					                  		                                         
                                                        $template->assign_block_vars('catrow.forumrow', array(
						                'FORUM_FOLDER_IMG' => $folder_image,						             				        					        						        						         						             							
						                'FORUM_NAME' => $forum_data[$j]['forum_name'],
						                'FORUM_DESC' => $forum_data[$j]['forum_desc'],
							        'POSTS' => $forum_data[$j]['forum_posts'],
							        'TOPICS' => $forum_data[$j]['forum_topics'],							
							        'U_VIEWFORUM' => append_sid("viewforum.$phpEx?" . POST_FORUM_URL . "=$forum_id"))
						        );					        
					                 
					                if(count($attached_forums))
                                                        {                     
					                         $template->assign_block_vars('catrow.forumrow.switch', array(
                                                                        'L_ATTACHED_FORUMS' => ($attached_forum_count ==1)? $lang['Attached_forum']: $lang['Attached_forums'])
						                 );
						             						
                                                                 for($k = 0; $k < count($attached_forums); $k++)
                                                                 {                                                                                                                                    
                                                                        $template->assign_block_vars('catrow.forumrow.switch.forums', array(                                                                      
                                                                               'FORUM_NAME' => $attached_forums[$k]['sub_name'],                                                                   
                                                                               'U_VIEWFORUM' => $attached_forums[$k]['sub_url'])
                                                                        );
                                                                 }
                                                        }
                                                }					   
				        }
			        }
			}
		}
	}
}
 
$template->pparse('body');

include($phpbb_root_path . 'includes/page_tail.'.$phpEx);

?>