<?php
/***************************************************************************
 *                               album_pic.php
 *                            -------------------
 *   MODED PIC IMAGE ALBUM: (C) 2012 Anvar
 *   Site: apwa.ru
 ***************************************************************************/

define('IN_PHPBB', true);
$phpbb_root_path = './';
$album_root_path = $phpbb_root_path . 'album_mod/';
include($phpbb_root_path . 'extension.inc');
include($phpbb_root_path . 'common.'.$phpEx);

$userdata = session_pagestart($user_ip, PAGE_ALBUM);
init_userprefs($userdata);

include($album_root_path . 'album_common.'.$phpEx);

if( isset($HTTP_GET_VARS['pic_id']) )
{
	$pic_id = intval($HTTP_GET_VARS['pic_id']);
}
else if( isset($HTTP_POST_VARS['pic_id']) )
{
	$pic_id = intval($HTTP_POST_VARS['pic_id']);
}
else
{
	die('No pics specified');
}

$thumb = ( isset($HTTP_GET_VARS['thumb']) ) ? intval($HTTP_GET_VARS['thumb']) : '';

$sql = "SELECT * FROM ". ALBUM_TABLE ."
	WHERE pic_id = '$pic_id'";
if( !($result = $db->sql_query($sql)) )
{
	message_die(GENERAL_ERROR, 'Could not query pic information', '', __LINE__, __FILE__, $sql);
}
$thispic = $db->sql_fetchrow($result);

$cat_id = $thispic['pic_cat_id'];
$user_id = $thispic['pic_user_id'];

$pic_filetype = substr($thispic['pic_filename'], strlen($thispic['pic_filename']) - 4, 4);
$pic_filename = $thispic['pic_filename'];
$pic_thumbnail = $thispic['pic_thumbnail'];
$pic_thumbmini = $thispic['pic_thumbmini'];

if( empty($thispic) or !file_exists(ALBUM_UPLOAD_PATH . $pic_filename) )
{
	die($lang['Pic_not_exist']);
}

if ($cat_id != PERSONAL_GALLERY)
{
	$sql = "SELECT * FROM ". ALBUM_CAT_TABLE ."
		WHERE cat_id = '$cat_id'";
	if( !($result = $db->sql_query($sql)) )
	{
		message_die(GENERAL_ERROR, 'Could not query category information', '', __LINE__, __FILE__, $sql);
	}

	$thiscat = $db->sql_fetchrow($result);
}
else
{
	$thiscat = init_personal_gallery_cat($user_id);
}

if (empty($thiscat))
{
	die($lang['Category_not_exist']);
}

$album_user_access = album_user_access($cat_id, $thiscat, 1, 0, 0, 0, 0, 0); // VIEW

if ($album_user_access['view'] == 0 && $thumb != '1' && $thumb != '2')
{
	die($lang['Not_Authorised']);
}

if ($userdata['user_level'] != ADMIN)
{
	if( ($thiscat['cat_approval'] == ADMIN) or (($thiscat['cat_approval'] == MOD) and !$album_user_access['moderator']) )
	{
		if ($thispic['pic_approval'] != 1)
		{
			die($lang['Not_Authorised']);
		}
	}
}

if( ($album_config['hotlink_prevent'] == 1) and (isset($HTTP_SERVER_VARS['HTTP_REFERER'])) )
{
	$check_referer = explode('?', $HTTP_SERVER_VARS['HTTP_REFERER']);
	$check_referer = trim($check_referer[0]);

	$good_referers = array();

	if ($album_config['hotlink_allowed'] != '')
	{
		$good_referers = explode(',', $album_config['hotlink_allowed']);
	}

	$good_referers[] = $board_config['server_name'] . $board_config['script_path'];

	$errored = TRUE;

	for ($i = 0; $i < count($good_referers); $i++)
	{
		$good_referers[$i] = trim($good_referers[$i]);

		if( (strstr($check_referer, $good_referers[$i])) and ($good_referers[$i] != '') )
		{
			$errored = FALSE;
		}
	}

	if ($errored)
	{
		die($lang['Not_Authorised']);
	}
}

if ($thumb == '1' || $thumb == '2')
{

        $album_cache_path = ($thumb == '2') ? ALBUM_MINI_PATH : ALBUM_CACHE_PATH;
        $thumbnail_size = ($thumb == '2') ? 40 : $album_config['thumbnail_size'];

        if( ($pic_filetype != '.jpg') and ($pic_filetype != '.png') and ($pic_filetype != '.gif') )
        {
	        header('Content-type: image/jpeg');
	        readfile('images/nothumbnail.jpg');
	        exit;
        }
        else
        {
	        if( ($album_config['thumbnail_cache'] == 1) and ($pic_thumbnail != '') and file_exists($album_cache_path . $pic_thumbnail) )
	        {
		        switch ($pic_filetype)
		        {
		             case '.gif':
			     case '.jpg':
				header('Content-type: image/jpeg');
				break;
			     case '.png':
				header('Content-type: image/png');
				break;
		        }

		        readfile($album_cache_path . $pic_thumbnail);
		        exit;
	        }

	        $pic_size = @getimagesize(ALBUM_UPLOAD_PATH . $pic_filename);
	        $pic_width = $pic_size[0];
	        $pic_height = $pic_size[1];

	        $gd_errored = FALSE;
	        switch ($pic_filetype)
	        {
	              case '.gif':
                        $read_function = 'imagecreatefromgif';
                        $pic_filetype = '.jpg';
                        break;
		      case '.jpg':
			$read_function = 'imagecreatefromjpeg';
			break;
		      case '.png':
			$read_function = 'imagecreatefrompng';
			break;
	        }

	        $src = @$read_function(ALBUM_UPLOAD_PATH  . $pic_filename);

	        if (!$src)
	        {
		       $gd_errored = TRUE;
		       $pic_thumbnail = '';
	        }
	        else if( ($pic_width > $thumbnail_size) or ($pic_height > $thumbnail_size) )
	        {
                        $thumb_width = $thumb_height = $thumbnail_size;    		        
			$thumbnail_width = $thumb_width;
                        $thumbnail_height = floor( $pic_height * ( $thumbnail_width / $pic_width ) );	        
		        $new_left = '0';
                        $new_top  = floor(($thumbnail_height - $thumb_height) / 2);
                        if ($thumbnail_height < $thumb_height) 
                        {
                               $thumbnail_height = $thumb_height;
                               $thumbnail_width = floor($pic_width * ($thumbnail_height / $pic_height) );
                               $new_left = floor(($thumbnail_width - $thumb_width) / 2);
                               $new_top = '0';
                        }
                        		        		        
			$thumbnail2 = ($album_config['gd_version'] == 1) ? @imagecreate($thumbnail_width, $thumbnail_height) : @imagecreatetruecolor($thumbnail_width, $thumbnail_height);
			$resize_function = ($album_config['gd_version'] == 1) ? 'imagecopyresized' : 'imagecopyresampled';                                           
			@$resize_function($thumbnail2, $src, 0, 0, 0, 0, $thumbnail_width, $thumbnail_height, $pic_width, $pic_height);		        
      
			$thumbnail = ($album_config['gd_version'] == 1) ? @imagecreate($thumb_width, $thumb_height) : @imagecreatetruecolor($thumb_width, $thumb_height);
		        @imagecopy($thumbnail, $thumbnail2, 0, 0, $new_left, $new_top, $thumb_width, $thumb_height);
	        }
	        else
	        {
		        $thumbnail = $src;
	        }

	        if (!$gd_errored)
	        {
		        if ($album_config['thumbnail_cache'] == 1)
		        {
			       $pic_thumbnail = $pic_filename;

			       switch ($pic_filetype)
			       {
				     case '.jpg':
					@imagejpeg($thumbnail, $album_cache_path . $pic_thumbnail, $album_config['thumbnail_quality']);
					break;
				     case '.png':
					@imagepng($thumbnail, $album_cache_path . $pic_thumbnail);
					break;
			       }

			       @chmod($album_cache_path . $pic_thumbnail, 0777);
		         }

		         switch ($pic_filetype)
		         {
			     case '.jpg':
				@imagejpeg($thumbnail, '', $album_config['thumbnail_quality']);
				break;
			     case '.png':
				@imagepng($thumbnail);
				break;
		         }
		         exit;
	        }
	        else
	        {
		         header('Content-type: image/jpeg');
		         readfile('images/nothumbnail.jpg');
		         exit;
	        }
        }
}
else
{
        $sql = "UPDATE ". ALBUM_TABLE ."
		SET pic_view_count = pic_view_count + 1
		WHERE pic_id = '$pic_id'";
        if( !($result = $db->sql_query($sql)) )
        {
	        message_die(GENERAL_ERROR, 'Could not update pic information', '', __LINE__, __FILE__, $sql);
        }

        switch ( $pic_filetype )
        {
	    case '.png':
		header('Content-type: image/png');
		break;
	    case '.gif':
		header('Content-type: image/gif');
		break;
	    case '.jpg':
		header('Content-type: image/jpeg');
		break;
	    default:
		die('The filename data in the DB was corrupted');
        }

        //
        //readfile(ALBUM_UPLOAD_PATH  . $thispic['pic_filename']);
        //
        // logo to img
        //
        $img = ALBUM_UPLOAD_PATH  . $thispic['pic_filename'];
        list($width_img, $height_img) = getimagesize($img);

        $image_main = imagecreatetruecolor($width_img, $height_img) or die ("&#1054;&#1096;&#1080;&#1073;&#1082;&#1072; &#1087;&#1088;&#1080; &#1089;&#1086;&#1079;&#1076;&#1072;&#1085;&#1080;&#1080; &#1080;&#1079;&#1086;&#1073;&#1088;&#1072;&#1078;&#1077;&#1085;&#1080;&#1103;");
        imagesavealpha($image_main,TRUE);
        $couleur_fond = imagecolorallocatealpha($image_main, 0, 0, 0, 125 );
        imagefill($image_main,0,0,$couleur_fond);
        ImageColorTransparent($image_main,$couleur_fond);

        switch($pic_filetype)
        {
              case '.jpg':
              case '.jpeg': $image = imagecreatefromjpeg($img);      
                   break;
              case '.gif': $image = imagecreatefromgif($img);       
                   break;
              case '.png': $image = imagecreatefrompng($img);
                   break;
        }

        imagecopy($image_main, $image, 0, 0, 0, 0, $width_img, $height_img);

        $logo = './images/logo_copy.png';
        list($width_logo, $height_logo) = getimagesize($logo);
        $new_width_logo = '80%';
        $new_height_logo = $height_logo*($new_width_logo/$width_logo);

        $logo_temp = imagecreatefrompng($logo);
        imagecopyresampled($image_main,$logo_temp, $width_img-$new_width_logo, $height_img-$new_height_logo, 0, 0, $new_width_logo, $new_height_logo, $width_logo, $height_logo);

        switch($pic_filetype)
        {
              case '.jpg':
              case '.jpeg': imagejpeg($image_main, null, 75);    
                 break;
              case '.gif': imagegif($image_main);       
                 break;
              case '.png': imagepng($image_main);       
                 break;
        }
        ImageDestroy($image_main);
        exit;
}

?>