<?php
/***************************************************************************
 *                           ©  KaspeR
 *                            -------------------
 ***************************************************************************/
 
define('IN_PHPBB', 1);

$points_config['points_name'] = isset($points_config['points_name']) ? $points_config['points_name'] : 'Points';

//
// First we do the setmodules stuff for the admin cp.
//
if( !empty($setmodules) )
{
	$filename = basename(__FILE__);
	$menu_name = sprintf($lang['Points_update_user'], $points_config['points_name']);
	$module['Points_sys_settings'][$menu_name] = $filename;
	return;
}

//
// Load default header
//
$phpbb_root_path = './../';
require($phpbb_root_path . 'extension.inc');
require('./pagestart.' . $phpEx);

$confirm = (isset($HTTP_POST_VARS['confirm'])) ? TRUE : FALSE;

if (!$confirm)
{
	$template->set_filenames(array(
		'confirm' => 'confirm_body.tpl')
	);

	$template->assign_vars(array(
		'MESSAGE_TITLE'	=> sprintf($lang['Points_update_user'], $points_config['points_name']),
		'MESSAGE_TEXT'	=> sprintf($lang['Confirm_points_update'], $points_config['points_name']),
		'L_YES'			=> $lang['Yes'],
		'L_NO'			=> $lang['No'],
		'S_CONFIRM_ACTION'	=> append_sid('module_update_user_points.' . $phpEx),
		'S_HIDDEN_FIELDS'	=> '')
	);

	$template->pparse('confirm');
	
	include('./page_footer_admin.'.$phpEx);
	exit;
}

$sql = "SELECT user_id 
	FROM " . USERS_TABLE . " 
	WHERE user_id <> " . ANONYMOUS;
if (!$result = $db->sql_query($sql))
{
	message_die(GENERAL_ERROR, 'Could not obtain the user information!', '', __LINE__, __FILE__, $sql);
}

$users = $db->sql_fetchrowset($result);
$db->sql_freeresult($result);

$total_users = count($users);

for($i = 0; $i < $total_users; $i++)
{
	$user_id = $users[$i]['user_id'];

	$sql = 'SELECT COUNT(u.user_id) as all_posts 
		FROM ' . POSTS_TABLE . ' p, ' . TOPICS_TABLE . ' t, ' . FORUMS_TABLE . ' f, ' . USERS_TABLE . ' u
		WHERE p.topic_id = t.topic_id AND t.forum_id = f.forum_id
		AND f.points_disabled = 0
		AND p.poster_id = ' . $user_id . '
		AND u.user_id = p.poster_id
		GROUP BY u.user_id';
	if (!$result = $db->sql_query($sql))
	{
		message_die(GENERAL_ERROR, 'Could not obtain the posts information!', '', __LINE__, __FILE__, $sql);
	}

	$all_posts = $db->sql_fetchrow($result);
	$db->sql_freeresult($result);
	
	$sql = 'SELECT COUNT(u.user_id) as total_topics 
		FROM ' . TOPICS_TABLE . ' t, ' . FORUMS_TABLE . ' f, ' . USERS_TABLE . ' u
		WHERE t.forum_id = f.forum_id
		AND f.points_disabled = 0
		AND u.user_id = t.topic_poster
		AND t.topic_poster = ' . $user_id . '
		GROUP BY u.user_id';
	if (!$result = $db->sql_query($sql))
	{
		message_die(GENERAL_ERROR, 'Could not obtain the topics information!', '', __LINE__, __FILE__, $sql);
	}

	$total_topics = $db->sql_fetchrow($result);
	$db->sql_freeresult($result);

	$total_posts = $all_posts['all_posts'] - $total_topics['total_topics'];
	$total_topics = $total_topics['total_topics'];

	$points = 0;
	$points = $points + ($total_posts * $points_config['points_reply']);
	$points = $points + ($total_topics * $points_config['points_topic']);
	$points = $points + $points_config['points_register'];

	$sql = "UPDATE " . USERS_TABLE . " 
		SET user_points = $points 
		WHERE user_id = $user_id";
	if (!$db->sql_query($sql))
	{
		message_die(GENERAL_ERROR, 'Could not update the user points!', '', __LINE__, __FILE__, $sql);
	}
}

message_die(GENERAL_MESSAGE, '<br /><br />' . sprintf($lang['Points_user_updated'], $points_config['points_name']). '<br /><br />');

?>