<?php
/***************************************************************************
 *                             weblog_entry.php
 *                          ----------------------
 *   Anv@r.all 2010
 *   (C) apwa.ru
 *
 ***************************************************************************/


define('IN_PHPBB', true);
$phpbb_root_path = './';
include($phpbb_root_path . 'extension.inc');
include($phpbb_root_path . 'common.'.$phpEx);
include($phpbb_root_path . 'includes/bbcode.'.$phpEx);
include($phpbb_root_path . 'includes/weblogs_common.'.$phpEx);
include($phpbb_root_path . 'includes/functions_weblog.'.$phpEx);

if ( isset($HTTP_GET_VARS['start']) || isset($HTTP_POST_VARS['start']) )
{
	$start = (isset($HTTP_POST_VARS['start'])) ? intval($HTTP_POST_VARS['start']) : intval($HTTP_GET_VARS['start']);
	$start = abs($start);
}
else
{
	$start = 0;
}

$entry_id = $post_id = 0;

if ( isset($HTTP_GET_VARS[POST_ENTRY_URL]) )
{
	$entry_id = intval($HTTP_GET_VARS[POST_ENTRY_URL]);
}
else
{
	$entry_id = 0;
}

if ( isset($HTTP_GET_VARS[POST_REPLY_URL]))
{
	$reply_id = intval($HTTP_GET_VARS[POST_REPLY_URL]);
}
else
{
	$reply_id = 0;
}

if ( !isset($entry_id) && !isset($post_id) )
{
	message_die(GENERAL_MESSAGE, $lang['Entry_post_not_exist']);
}

$join_sql_table = ( empty($reply_id) ) ? '' : ", " . WEBLOG_REPLIES_TABLE . " r, " . WEBLOG_REPLIES_TABLE . " r2 ";
$join_sql = ( empty($reply_id) ) ? "e.entry_id = $entry_id" : "r.reply_id = $reply_id AND e.entry_id = r.entry_id AND r2.entry_id = r.entry_id AND r2.reply_id <= $reply_id";
$count_sql = ( empty($reply_id) ) ? '' : ", COUNT(r2.reply_id) AS prev_posts";

$order_sql = ( empty($reply_id) ) ? '' : "GROUP BY r.reply_id, e.entry_id, e.entry_subject, e.entry_replies, e.entry_time, e.entry_last_post_id, e.no_replies, w.weblog_name, w.weblog_id, w.weblog_auth, w.replies_auth ORDER BY r.reply_id ASC";

$sql = "SELECT e.entry_id, e.entry_subject, e.entry_replies, e.entry_time, e.entry_last_post_id, e.entry_access, e.no_replies, u.user_id, u.username, u.user_avatar, u.user_avatar_type, u.user_allowavatar, w.*" . $count_sql . "
	FROM " . WEBLOG_ENTRIES_TABLE . " e, " . WEBLOGS_TABLE . " w, " . USERS_TABLE . " u" . $join_sql_table . "
	WHERE $join_sql
	AND w.weblog_id = e.weblog_id
	AND u.user_weblog = w.weblog_id
	$order_sql";
if ( !($result = $db->sql_query($sql)) )
{
	message_die(GENERAL_ERROR, "Could not obtain entry information", '', __LINE__, __FILE__, $sql);
}

if ( !($weblog_entry_data = $db->sql_fetchrow($result)) )
{
	message_die(GENERAL_MESSAGE, $lang['Entry_post_not_exist']);
}

if ( $weblog_entry_data['deleted'] )
{
	message_die(GENERAL_ERROR, sprintf($lang['Weblog_deactivated'], $weblog_entry_data['weblog_name']));
}

$weblog_id = intval($weblog_entry_data['weblog_id']);
$weblog_name = strip_tags($weblog_entry_data['weblog_name']);
$entry_subject = strip_tags(htmlspecialchars($weblog_entry_data['entry_subject']));
$entry_id = intval($weblog_entry_data['entry_id']);
$entry_time = $weblog_entry_data['entry_time'];

$userdata = session_pagestart($user_ip, 10000 + $weblog_id);
init_userprefs($userdata);

/* ( !empty($reply_id) )
{
	$start = floor(($weblog_entry_data['prev_posts'] - 1) / $weblog_entry_data['entries_perpage'] ) * $weblog_entry_data['entries_perpage'];
}*/

$page_title = strip_tags(htmlspecialchars($weblog_entry_data['entry_subject']));

$template->set_filenames(array(
	'body' => 'blog/entry_body.tpl')
);

$sql = "SELECT * FROM " . WEBLOG_CONTRIBUTORS_TABLE . " WHERE weblog_id = $weblog_id AND user_id = " . $userdata['user_id'];
if ( !($result = $db->sql_query($sql)) )
{
	message_die(GENERAL_ERROR, 'Error querying to find user weblog information', '', __LINE__, __FILE__, $sql);
}

$contributor = FALSE;
if ( $row = $db->sql_fetchrow($result) || $userdata['user_level'] == ADMIN )
{
	$contributor = TRUE;
}


if ( $userdata['user_weblog'] == $weblog_entry_data['weblog_id'] )
{
	$template->assign_block_vars('switch_weblog_owner', array() );
	$template->assign_block_vars('switch_contributor_only', array());
}
else if ( $contributor )
{
	$template->assign_block_vars('switch_contributor_only', array());
}

$previous_days = array(0, 1, 7, 14, 30, 90, 180, 364);
$previous_days_text = array($lang['All_replies'], $lang['1_Day'], $lang['7_Days'], $lang['2_Weeks'], $lang['1_Month'], $lang['3_Months'], $lang['6_Months'], $lang['1_Year']);

if( !empty($HTTP_POST_VARS['postdays']) || !empty($HTTP_GET_VARS['postdays']) )
{
	$post_days = ( !empty($HTTP_POST_VARS['postdays']) ) ? $HTTP_POST_VARS['postdays'] : $HTTP_GET_VARS['postdays'];
	$min_post_time = time() - (intval($post_days) * 86400);

	$sql = "SELECT COUNT(r.reply_id) AS num_posts
		FROM " . WEBLOG_ENTRIES_TABLE . " e, " . WEBLOG_REPLIES_TABLE . " r
		WHERE e.entry_id = $entry_id
		AND r.entry_id = e.entry_id
		AND r.post_time >= $min_post_time";
	if ( !($result = $db->sql_query($sql)) )
	{
		message_die(GENERAL_ERROR, "Could not obtain limited topics count information", '', __LINE__, __FILE__, $sql);
	}

	$total_replies = ( $row = $db->sql_fetchrow($result) ) ? intval($row['num_posts']) : 0;

	$limit_posts_time = "AND r.post_time >= $min_post_time ";

	if ( !empty($HTTP_POST_VARS['postdays']))
	{
		$start = 0;
	}
}
else
{
	$total_replies = intval($weblog_entry_data['topic_replies']) + 1;
	$limit_posts_time = '';
	$post_days = 0;
}

$select_post_days = '<select name="postdays">';
for($i = 0; $i < count($previous_days); $i++)
{
	$selected = ($post_days == $previous_days[$i]) ? ' selected="selected"' : '';
	$select_post_days .= '<option value="' . $previous_days[$i] . '"' . $selected . '>' . $previous_days_text[$i] . '</option>';
}
$select_post_days .= '</select>';

if ( !empty($HTTP_POST_VARS['postorder']) || !empty($HTTP_GET_VARS['postorder']) )
{
	$post_order = (!empty($HTTP_POST_VARS['postorder'])) ? $HTTP_POST_VARS['postorder'] : $HTTP_GET_VARS['postorder'];
	$post_time_order = ($post_order == "asc") ? "ASC" : "DESC";
}
else
{
	$post_order = 'asc';
	$post_time_order = 'ASC';
}

$select_post_order = '<select name="postorder">';
if ( $post_time_order == 'ASC' )
{
	$select_post_order .= '<option value="asc" selected="selected">' . $lang['Oldest_First'] . '</option><option value="desc">' . $lang['Newest_First'] . '</option>';
}
else
{
	$select_post_order .= '<option value="asc">' . $lang['Oldest_First'] . '</option><option value="desc" selected="selected">' . $lang['Newest_First'] . '</option>';
}
$select_post_order .= '</select>';


// Get user auth level
$auth_level = get_auth_level($weblog_entry_data, $contributor);

if ( $weblog_entry_data['entry_access'] > $auth_level )
{
	message_die (GENERAL_ERROR, $lang['Entry_noaccess']);
}

if ( (($auth_level >= $weblog_entry_data['replies_auth']) || ($userdata['user_weblog'] == $weblog_entry_data['weblog_id'])) && !$weblog_entry_data['no_replies'] )
{
	$template->assign_block_vars('switch_reply_authed', array() );
}

//
// Get the original entry data
//
$sql = "SELECT * FROM " . WEBLOG_ENTRIES_TABLE . " WHERE entry_id = $entry_id";
if ( !($result = $db->sql_query($sql)) )
{
	message_die(GENERAL_ERROR, "Could not obtain entry information", '', __LINE__, __FILE__, $sql);
}

if ( !($entry_data = $db->sql_fetchrow($result)) )
{
	message_die(GENERAL_MESSAGE, $lang['Entry_not_exist']);
}

$reply_data = array();
//
// Get the entry's replies data
//
$sql = "SELECT r.*, u.* FROM " . WEBLOG_REPLIES_TABLE . " r, " . USERS_TABLE . " u
	WHERE r.entry_id = $entry_id
	$limit_posts_time
	AND u.user_id = r.poster_id
	ORDER BY r.post_time $post_time_order
	LIMIT $start, " . $weblog_config['latest_entry_max'];
if ( !($result = $db->sql_query($sql)) )
{
	message_die(GENERAL_ERROR, "Could not obtain entry information", '', __LINE__, __FILE__, $sql);
}

$reply_data = array();
while ( $row = $db->sql_fetchrow($result) )
{
	$reply_data[] = $row;
}

$sql = "SELECT * FROM " . RANKS_TABLE . "
	ORDER BY rank_special, rank_min";
if ( !($result = $db->sql_query($sql)) )
{
	message_die(GENERAL_ERROR, "Could not obtain ranks information.", '', __LINE__, __FILE__, $sql);
}

$ranksrow = array();
while ( $row = $db->sql_fetchrow($result) )
{
	$ranksrow[] = $row;
}
$db->sql_freeresult($result);


if ( $weblog_config['censor_weblog'] )
{
	$orig_word = array();
	$replacement_word = array();
	obtain_word_list($orig_word, $replacement_word);

	if ( count($orig_word) )
	{
		$entry_data['entry_subject'] = preg_replace($orig_word, $replacement_word, $entry_data['entry_subject']);
		$entry_data['entry_text'] = preg_replace($orig_word, $replacement_word, $entry_data['entry_text']);
		$entry_data['currently_text'] = preg_replace($orig_word, $replacement_word, $entry_data['currently_text']);
	}
}

$entry_data['entry_text'] = hide_cuts ($entry_data['entry_text']);

if ( $userdata['session_logged_in'] )
{
	$tracking_entries = ( isset($HTTP_COOKIE_VARS[$board_config['cookie_name'] . '_e']) ) ? unserialize($HTTP_COOKIE_VARS[$board_config['cookie_name'] . '_e']) : array();
	$tracking_weblogs = ( isset($HTTP_COOKIE_VARS[$board_config['cookie_name'] . '_w']) ) ? unserialize($HTTP_COOKIE_VARS[$board_config['cookie_name'] . '_w']) : array();

	if ( !empty($tracking_entries[$entry_id]) && !empty($tracking_weblogs[$weblog_id]) )
	{
		$entry_last_read = ( $tracking_entries[$entry_id] > $tracking_weblogs[$weblog_id] ) ? $tracking_entries[$entry_id] : $tracking_weblogs[$weblog_id];
	}
	else if ( !empty($tracking_entries[$entry_id]) || !empty($tracking_weblogs[$weblog_id]) )
	{
		$entry_last_read = ( !empty($tracking_entries[$entry_id]) ) ? $tracking_entries[$entry_id] : $tracking_weblogs[$weblog_id];
	}
	else
	{
		$entry_last_read = $userdata['user_lastvisit'];
	}

	if ( count($tracking_entries) >= 150 && empty($tracking_entries[$entry_id]) )
	{
		asort($tracking_entries);
		unset($tracking_entries[key($tracking_entries)]);
	}

	$tracking_entries[$entry_id] = time();

	setcookie($board_config['cookie_name'] . '_e', serialize($tracking_entries), 0, $board_config['cookie_path'], $board_config['cookie_domain'], $board_config['cookie_secure']);
}

$message = $entry_data['entry_text'];

if ( !$board_config['allow_html'] )
{
	if ( $entry_data['enable_html'] )
	{
		$message = preg_replace('#(<)([\/]?.*?)(>)#is', "&lt;\\2&gt;", $message);
	}
}

if ( $board_config['allow_bbcode'] )
{
	if ( $entry_data['bbcode_uid'] != '' )
	{
		$message = ( $board_config['allow_bbcode'] ) ? bbencode_second_pass($message, $entry_data['bbcode_uid']) : preg_replace('/\:[0-9a-z\:]+\]/si', ']', $message);
	}
}

$message = make_clickable($message);

if ( $board_config['allow_smilies'] )
{
	if ( $entry_data['enable_smilies'] )
	{
		$message = smilies_pass($message);
	}
}

$sql = "SELECT *
	FROM " . WEBLOG_MOODS_TABLE . "
	ORDER BY mood_text";
if( !$result = $db->sql_query($sql) )
{
	message_die(GENERAL_ERROR, "Couldn't obtain mood data from database", "", __LINE__, __FILE__, $sql);
}
$mood_data = $db->sql_fetchrowset($result);

$sql = "SELECT *
	FROM " . WEBLOG_ACTIONS_TABLE . "
	ORDER BY action_text";
if( !$result = $db->sql_query($sql) )
{
	message_die(GENERAL_ERROR, "Couldn't obtain action data from database", "", __LINE__, __FILE__, $sql);
}
$action_data = $db->sql_fetchrowset($result);

// Mood Icons
$mood = array();
$mood = find_mood($entry_data['entry_mood']);

if ( $mood >= 0 )
{ 
	$mood = '[' . sprintf($lang['Mood:'], '<img src="images/weblog/' . $mood['mood_url'] . '" alt=""/>', $mood['mood_text']) . ']';
}
else
{
	$mood = '';
}

// Currently Icons
$currently = array();
$currently = find_action($entry_data['entry_currently']);

if ( $currently > 0 )
{
	$action = '[' . sprintf($lang['Currently:'], '<img src="images/weblog/' . $currently['action_url'] . '" alt=""/>',  $currently['action_text']) . ']';
}
else
{
	$action = '';
}

$server_name = preg_replace('#^\/?(.*?)\/?$#', '\1', trim($board_config['server_name']));
$server_port = ($board_config['server_port'] <> 80) ? ':' . trim($board_config['server_port']) : '';
$script_name = preg_replace('#^\/?(.*?)\/?$#', '\1', trim($board_config['script_path']));
$script_name = ($script_name == '') ? $script_name : '/' . $script_name;

$message = str_replace("\n", "\n<br />\n", $message);

include($phpbb_root_path . 'includes/page_header.'.$phpEx);

avatar_img($weblog_entry_data['user_avatar_type'], $weblog_entry_data['user_allowavatar'], $weblog_entry_data['user_avatar'], $avatar_img, $avatar_mini);
        
$entry_access = $entry_data['entry_access'];
$category = $entry_data['category'];

$template->assign_vars(array(
	'WEBLOG_NAME' => $weblog_name,
	'ENTRY_SUBJECT' => $entry_subject,
	'POSTER_NAME' =>  ( !empty($weblog_entry_data['username']) ) ? sprintf($lang['Posted_by'], '<a href="' . append_sid("profile.php?mode=viewprofile&amp;" . POST_USERS_URL . "=" . $weblog_entry_data['user_id']) . '">' . $weblog_entry_data['username'] . '</a>') : '',
	'ENTRY_TIME' => create_date($board_config['default_dateformat'], $entry_data['entry_time'], $board_config['board_timezone']),
	'ENTRY' => $message,
	'MOOD' => $mood,
	'ACTION' => $action,
	'AVATAR' => $avatar_img,
	'ENTRY_LOCKED_ICON' => ( $entry_data['entry_access'] > WEBLOG_AUTH_ALL ) ? '' . $lang['Restricted_access'] . '' . $weblog_auth_types[$entry_access] : '',
	'EDIT_LINK' => ( $userdata['user_weblog'] == $weblog_entry_data['weblog_id'] || $userdata['user_level'] == ADMIN ) ? '[<a href="' . append_sid ("weblog_posting.$phpEx?mode=editentry&amp;" . POST_ENTRY_URL . "=" . $entry_data['entry_id']) . '">' . $lang['Edit'] . '</a>]' : '',
	'DELETE_LINK' => ( $userdata['user_weblog'] == $weblog_entry_data['weblog_id'] || $userdata['user_level'] == ADMIN ) ? '[<a href="' . append_sid ("weblog_posting.$phpEx?mode=delete&amp;" . POST_ENTRY_URL . "=" . $entry_data['entry_id']) . '">' . $lang['Delete'] . '</a>]' : '',			
	'CATEGORY_URL' => ( $category !='' ) ? '<a href="' . append_sid("weblog.$phpEx?" . POST_WEBLOG_URL . "=" . $weblog_id . "&amp;category=" . urlencode($category)) . '">' . $lang['More posts from this category:'] .$category . '</a>' : "",	
	'U_WEBLOG' => append_sid("weblog.$phpEx?" . POST_WEBLOG_URL . "=$weblog_id"),
	'U_WEBLOGS' => append_sid("weblogs.$phpEx"),
	'U_VIEW_ENTRY' => append_sid("weblog_entry.$phpEx?" . POST_ENTRY_URL . "=$entry_id"),
	'U_POST_NEW_ENTRY' => append_sid("weblog_posting.$phpEx?mode=newentry&amp;" . POST_WEBLOG_URL . "=$weblog_id"),
	'U_POST_NEW_REPLY' => append_sid("weblog_posting.$phpEx?mode=reply&amp;" . POST_ENTRY_URL . "=$entry_id"),
	'L_AUTHOR' => $lang['Author'],
	'L_BACK_TO_TOP' => $lang['Back_to_top'],
	'L_DISPLAY_POSTS' => $lang['Display_posts'],
	'L_GOTO_PAGE' => $lang['Goto_page'],
	'L_POST_REPLY' => $lang['Post_reply'],
	'L_POST_NEW_ENTRY' => $lang['Post_new_entry'],
	'S_SELECT_POST_DAYS' => $select_post_days,
	'S_SELECT_POST_ORDER' => $select_post_order,
	'S_POST_DAYS_ACTION' => append_sid("weblog_entry.$phpEx?" . POST_ENTRY_URL . '=' . $entry_id . "&amp;start=$start"),
	'S_AUTH_LIST' => $s_auth_can)
);

//
// Update the topic view counter
//
$sql = "UPDATE " . WEBLOG_ENTRIES_TABLE . "
	SET entry_views = entry_views + 1
	WHERE entry_id = $entry_id";
if ( !$db->sql_query($sql) )
{
	message_die(GENERAL_ERROR, "Could not update entry views.", '', __LINE__, __FILE__, $sql);
}

if( count($reply_data) )
{
    for ($i = 0; $i < count($reply_data); $i++)
    {
	$poster_id = $reply_data[$i]['user_id'];
	$poster = ( $poster_id == ANONYMOUS ) ? $lang['Guest'] : '<a href="' . append_sid("profile.$phpEx?mode=viewprofile&amp;" . POST_USERS_URL . "=$poster_id") . '">' . $reply_data[$i]['username'] . '</a>';
	$post_date = create_date($board_config['default_dateformat'], $reply_data[$i]['post_time'], $board_config['board_timezone']);
	avatar_img($reply_data[$i]['user_avatar_type'], $reply_data[$i]['user_allowavatar'], $reply_data[$i]['user_avatar'], $avatar_img, $avatar_mini);
        
        $poster_rank = '';
	$rank_image = '';
	if ( $reply_data[$i]['user_id'] == ANONYMOUS )
	{
		 $poster_rank = $lang['Guest'];		
	}
	else if ( $reply_data[$i]['user_rank'] )
	{
		for($j2 = 0; $j2 < count($ranksrow); $j2++)
		{
			if ( $reply_data[$i]['user_rank'] == $ranksrow[$j2]['rank_id'] && $ranksrow[$j2]['rank_special'] )
			{
				$poster_rank = $ranksrow[$j2]['rank_title'];
				$rank_image = ( $ranksrow[$j2]['rank_image'] ) ? '<img src="' . $ranksrow[$j2]['rank_image'] . '" alt="' . $poster_rank . '" title="' . $poster_rank . '" border="0" /><br />' : '';
			}
		}
	}
	else
	{
		for($j2 = 0; $j2 < count($ranksrow); $j2++)
		{
			if ( $reply_data[$i]['user_posts'] >= $ranksrow[$j2]['rank_min'] && !$ranksrow[$j2]['rank_special'] )
			{
				$poster_rank = $ranksrow[$j2]['rank_title'];
				$rank_image = ( $ranksrow[$j2]['rank_image'] ) ? '<img src="' . $ranksrow[$j2]['rank_image'] . '" alt="' . $poster_rank . '" title="' . $poster_rank . '" border="0" /><br />' : '';
			}
		}
	}

	$temp_url = append_sid("weblog_posting.$phpEx?mode=quote&amp;" . POST_REPLY_URL . "=" . $reply_data[$i]['reply_id'] . "&amp;" . POST_WEBLOG_URL . "=" . $weblog_id);		
	$quote = '<a href="' . $temp_url . '">' . $lang['Reply_with_quote'] . '</a>';

	if ( ($userdata['user_id'] == $poster_id || $userdata['user_weblog'] == $weblog_entry_data['weblog_id']) && $userdata['session_logged_in'] )
	{
		$temp_url = append_sid("weblog_posting.$phpEx?mode=editreply&amp;" . POST_REPLY_URL . "=" . $reply_data[$i]['reply_id']);			
		$edit = '|<a href="' . $temp_url . '">' . $lang['Edit_delete_post'] . '</a>';
	}
	else
	{
			
		$edit = '';
	}

	if ( $userdata['user_weblog'] == $weblog_entry_data['weblog_id'] || $userdata['user_level'] == ADMIN )
	{
		$temp_url = "weblog_posting.$phpEx?mode=delete&amp;" . POST_REPLY_URL . "=" . $reply_data[$i]['reply_id'] . "&amp;sid=" . $userdata['session_id'];			
		$delpost = '|<a href="' . $temp_url . '">' . $lang['Delete_post'] . '</a>';
	}
	else
	{
			
		$ip = '';			
		$delpost = '';
	}

	$message = $reply_data[$i]['reply_text'];
	$bbcode_uid = $reply_data[$i]['bbcode_uid'];

	$user_sig = ( $reply_data[$i]['enable_sig'] && $reply_data[$i]['user_sig'] != '' && $board_config['allow_sig'] ) ? $reply_data[$i]['user_sig'] : '';
	$user_sig_bbcode_uid = $reply_data[$i]['user_sig_bbcode_uid'];

	if ( !$board_config['allow_html'] || !$userdata['user_allowhtml'])
	{
		if ( $user_sig != '' )
		{
			$user_sig = preg_replace('#(<)([\/]?.*?)(>)#is', "&lt;\\2&gt;", $user_sig);
		}

		if ( $reply_data[$i]['enable_html'] )
		{
			$message = preg_replace('#(<)([\/]?.*?)(>)#is', "&lt;\\2&gt;", $message);
		}
	}

	if ( $board_config['allow_bbcode'] )
	{
		if ( $user_sig != '' && $user_sig_bbcode_uid != '' )
		{
			$user_sig = ( $board_config['allow_bbcode'] ) ? bbencode_second_pass($user_sig, $user_sig_bbcode_uid) : preg_replace('/\:[0-9a-z\:]+\]/si', ']', $user_sig);
		}

		if ( $bbcode_uid != '' )
		{
			$message = ( $board_config['allow_bbcode'] ) ? bbencode_second_pass($message, $bbcode_uid) : preg_replace('/\:[0-9a-z\:]+\]/si', ']', $message);
		}
	}
                
	if ( $user_sig != '' )
	{
		$user_sig = make_clickable($user_sig);
	}
	$message = make_clickable($message);

	if ( $board_config['allow_smilies'] )
	{
		if ( $reply_data[$i]['user_allowsmile'] && $user_sig != '' )
		{
			$user_sig = smilies_pass($user_sig);
		}

		if ( $reply_data[$i]['enable_smilies'] )
		{
			$message = smilies_pass($message);
		}
	}

	if ( $weblog_config['censor_weblog'] )
	{
		if (count($orig_word))
		{
			if ($user_sig != '')
			{
				$user_sig = str_replace('\"', '"', substr(@preg_replace('#(\>(((?>([^><]+|(?R)))*)\<))#se', "@preg_replace(\$orig_word, \$replacement_word, '\\0')", '>' . $user_sig . '<'), 1, -1));
			}

			$message = str_replace('\"', '"', substr(@preg_replace('#(\>(((?>([^><]+|(?R)))*)\<))#se', "@preg_replace(\$orig_word, \$replacement_word, '\\0')", '>' . $message . '<'), 1, -1));
		}
	}

	if ( $user_sig != '' )
	{
		$user_sig = '<br />_________________<br />' . str_replace("\n", "\n<br />\n", $user_sig);
	}

	$message = str_replace("\n", "\n<br />\n", $message);

	$row_class = ( !($i % 2) ) ? 'row_hard' : 'row_easy';

	$template->assign_block_vars('postrow', array(
		'ROW_CLASS' => $row_class,
		'POSTER_NAME' => $poster,
		'POSTER_RANK' => $poster_rank,
		'RANK_IMAGE' => $rank_image,
		'AVATAR_IMG' => $avatar_img,
		'POST_DATE' => $post_date,
		'MESSAGE' => $message,
		'SIGNATURE' => $user_sig,
                'NUMBER' => $nomer_posta = $i + $start + 1,													
		'EDIT' => $edit,			
		'QUOTE' => $quote,			
		'IP' => $ip,			
		'DELETE' => $delpost)
	);
	$template->assign_vars(array(
		'PAGINATION' => generate_pagination("weblog_entry.$phpEx?" . POST_ENTRY_URL . "=$entry_id&amp;postdays=$post_days&amp;postorder=$post_order", $weblog_entry_data['entry_replies'], $weblog_config['latest_entry_max'], $start),	
		'PAGE_NUMBER' => sprintf($lang['Page_of'], ( floor( $start / intval($weblog_config['latest_entry_max']) ) + 1 ), ceil( $weblog_entry_data['entry_replies'] / intval($weblog_config['latest_entry_max']) )))
	);
    }
}
else
{
	$replies_no_disabled = ($weblog_entry_data['no_replies']) ? $lang['Replies_disabled'] : $lang['Entry_no_replies'];
	$template->assign_vars(array(
	       	'L_ENTRY_REPLIES_NO' => $replies_no_disabled)
	);
}

$template->pparse('body');

include($phpbb_root_path . 'includes/page_tail.'.$phpEx);

?>assign_vars(array(
	       	