<?php
/***************************************************************************
 *                            weblog_config.php
 *                         -----------------------
 *   Anv@r.all 2008
 *   (C) apwa.ru
 *
 ***************************************************************************/

define('IN_PHPBB', true);
$phpbb_root_path = './';
include($phpbb_root_path . 'extension.inc');
include($phpbb_root_path . 'common.'.$phpEx);
include($phpbb_root_path . 'includes/functions_post.'.$phpEx);
include($phpbb_root_path . 'includes/bbcode.'.$phpEx);
include($phpbb_root_path . 'includes/weblogs_common.'.$phpEx);
include($phpbb_root_path . 'includes/functions_weblog.'.$phpEx);


$userdata = session_pagestart($user_ip, PAGE_INDEX);
init_userprefs($userdata);


$page_title = $lang['Weblog_CP'];
include($phpbb_root_path . 'includes/page_header.'.$phpEx);


if ( !$userdata['session_logged_in'] )
{
	message_die (GENERAL_MESSAGE, $lang['No_weblog_guests']);
}

if ( !$userdata['user_allowweblog'] )
{
	message_die (GENERAL_MESSAGE, $lang['Weblog_banned']);
}


if ( !$userdata['user_weblog'] && $weblog_config['require_auth'] )
{
	$sql = "SELECT g.* FROM " . GROUPS_TABLE . " g, " . USER_GROUP_TABLE . " ug
		WHERE ug.user_id = " . $userdata['user_id'] . "
		AND ug.group_id = g.group_id
		AND g.group_allow_weblogs = " . TRUE . "
		AND ug.user_pending <> " . TRUE;
	if ( !($result = $db->sql_query($sql)) )
	{
		message_die(GENERAL_ERROR, 'Error querying to find user group information', '', __LINE__, __FILE__, $sql);
	}

	if ( !$row = $db->sql_fetchrow($result) )
	{
		message_die (GENERAL_MESSAGE, $lang['Weblog_require_auth']);
	}
}


$sql = "SELECT * FROM " . WEBLOGS_TABLE . " w, " . USERS_TABLE . " u 
        WHERE w.weblog_id = u.user_weblog 
        AND u.user_id = " . $userdata['user_id'];
if ( !($result = $db->sql_query($sql)) )
{
	message_die(GENERAL_ERROR, 'Error querying to find user weblog information', '', __LINE__, __FILE__, $sql);
}

if ( $row = $db->sql_fetchrow($result) )
{
	$weblog_exists = TRUE;
	$weblog_data = $row;

	if ( $weblog_data['weblog_advanced'] )
	{
		$template->assign_block_vars('switch_edit_adv_weblog', array());
	}
	else
	{
		$template->assign_block_vars('switch_edit_easy_weblog', array());
	}

	$template->assign_block_vars('switch_edit_weblog', array());

	if ( $weblog_data['deleted'] )
	{
		$template->assign_block_vars('switch_marked_deletion', array());
	}
}
else if ( $weblog_id )
{
	message_die(GENERAL_MESSAGE, 'Weblog_not_exist');
}
else
{
	$template->assign_block_vars('switch_create_weblog', array());
}

if ( !($weblog_data['weblog_id'] == $userdata['user_weblog']) && $weblog_id )
{
	message_die(GENERAL_ERROR, $lang['Weblog_noaccess']);
}
//
// See if there is a template available for weblog users

$template->set_filenames(array(
	"body" => "blog/cp_body.tpl")
);

// Set initial vars
$weblog_id = $weblog_data['weblog_id'];
$weblog_advanced = $weblog_data['weblog_advanced'];

if ( isset($HTTP_POST_VARS['create']) || isset ($HTTP_POST_VARS['edit']) )
{
		$weblog_name = ( isset($HTTP_POST_VARS['weblog_name']) ) ? trim(htmlspecialchars($HTTP_POST_VARS['weblog_name'])) : '';
		$weblog_desc = ( isset($HTTP_POST_VARS['weblog_desc']) ) ? trim(htmlspecialchars($HTTP_POST_VARS['weblog_desc'])) : $weblog_data['weblog_desc'];
		$weblog_auth = ( isset($HTTP_POST_VARS['weblog_auth_select']) ) ? intval($HTTP_POST_VARS['weblog_auth_select']) : $weblog_config['default_auth'];
		$reply_auth = ( isset($HTTP_POST_VARS['replies_auth_select']) ) ? intval($HTTP_POST_VARS['replies_auth_select']): $weblog_config['default_reply_auth'];
		$num_entries = ( isset($HTTP_POST_VARS['num_entries']) ) ? intval($HTTP_POST_VARS['num_entries']) : $weblog_config['default_entries_perpage'];
		$show_weblog_info = ( isset($HTTP_POST_VARS['show_weblog_info']) ) ? intval($HTTP_POST_VARS['show_weblog_info']) : 1;
		$reset_counter = ( isset($HTTP_POST_VARS['reset_counter']) && !empty($HTTP_POST_VARS['reset_counter']) ) ? 1 : 0;

		$weblog_page = stripslashes ($weblog_page);

		if ( isset($HTTP_POST_VARS['create']) )
		{
			if ( $weblog_exists )
			{
				message_die(GENERAL_ERROR, $lang['No_second_weblog']);
			}
		}
		
		if ( empty($weblog_name) )
		{
			$error_msg = '<br />' . $lang['No_weblog_name'];
		}

		if ( empty($weblog_desc) )
		{
			$error_msg .= '<br />' . $lang['No_weblog_desc'];
		}

		if ( !empty($error_msg) )
		{
			message_die (GENERAL_ERROR, $lang['Errors_occured'] . $error_msg);
		}

		if ( isset($HTTP_POST_VARS['create']) )
		{
			$sql = "SELECT MAX(weblog_id) AS max_id FROM " . WEBLOGS_TABLE;
			if ( !($result = $db->sql_query($sql)) )
			{
				message_die(GENERAL_ERROR, 'Error selecting max weblog id.', '', __LINE__, __FILE__, $sql);
			}

			$maximum = 0;
			if ( $row = $db->sql_fetchrow($result) )
			{
				$maximum = $row['max_id'];
			}

			$sql = "INSERT INTO " . WEBLOGS_TABLE . " (
				weblog_id,				
				weblog_name,
				weblog_desc,
				weblog_auth,
				replies_auth,
				entries_perpage,
				weblog_create_date,
				show_weblog_info)

				VALUES (
				($maximum+1),				
				'" . str_replace("\'", "''", $weblog_name) . "',
				'" . str_replace("\'", "''", $weblog_desc) . "',
				$weblog_auth,
				$reply_auth,
				$num_entries,
				" . time() . ",
				$show_weblog_info)";
				
			if ( !($result = $db->sql_query($sql, BEGIN_TRANSACTION)) )
			{
				message_die(GENERAL_ERROR, 'Error creating a weblog.', '', __LINE__, __FILE__, $sql);
			}

			// Update the user's data
			$sql = "UPDATE " . USERS_TABLE . " SET user_weblog = " . ($maximum+1) . " WHERE user_id = " . $userdata['user_id'];
			if ( !($result = $db->sql_query($sql, END_TRANSACTION)) )
			{
				message_die(GENERAL_ERROR, 'Error creating a weblog.', '', __LINE__, __FILE__, $sql);
			}

			$template->assign_vars(array(
				'META' => '<meta http-equiv="refresh" content="3;url=' . append_sid("weblog.$phpEx?" . POST_WEBLOG_URL . "=" . ($maximum+1)) . '">')
			);

			$message = sprintf($lang['Weblog_created'], '<a href="' . append_sid("weblog.$phpEx?" . POST_WEBLOG_URL . "=" . ($maximum+1)) . '">', '</a>', '<a href="' . append_sid("weblog_config.$phpEx") . '">', '</a>');
		}
		else
		{			
		        if ( $weblog_action == ACTION_SWITCH_MODE && !$weblog_data['weblog_advanced'] && !$userdata['user_allowadvweblog'] )
			{
				message_die(GENERAL_ERROR, $lang['Weblog_no_adv_weblog']);
			}


			// Check all fields
			
			if ( $reset_counter )
			{
				$reset_counter = 'weblog_views = 0,';
			}
			else
			{
				$reset_counter = '';
			}

			$sql = "UPDATE " . WEBLOGS_TABLE . " SET					
					weblog_name = '" . str_replace("\'", "''", $weblog_name) . "', 
					weblog_desc = '" . str_replace("\'", "''", $weblog_desc) . "',
					weblog_auth = $weblog_auth,
					replies_auth = $reply_auth,
					entries_perpage = $num_entries,
					weblog_advanced = $weblog_advanced,
					show_weblog_info = $show_weblog_info
				WHERE weblog_id = $weblog_id";
			if ( !($result = $db->sql_query($sql)) )
			{
				message_die(GENERAL_ERROR, 'Could not update weblog.', '', __LINE__, __FILE__, $sql);
			}

			$template->assign_vars(array(
				'META' => '<meta http-equiv="refresh" content="3;url=' . append_sid("weblog.$phpEx?" . POST_ENTRY_URL . "=$weblog_id") . '">')
			);

			$message = sprintf($lang['Weblog_edited'], '<a href="' . append_sid("weblog.$phpEx?" . POST_WEBLOG_URL . "=$weblog_id") . '">', '</a>', '<a href="' . append_sid("weblog_config.$phpEx") . '">', '</a>');
		}
	message_die(GENERAL_MESSAGE, $message);
}

//
// Preparations
//

if ( $weblog_advanced )
{
	$weblog_body = get_weblog_body ( $weblog_data['weblog_id'] );
}

//
// HTML toggle selection
//
if ( $board_config['allow_html'] )
{
	$html_status = $lang['HTML_is_ON'];
}
else
{
	$html_status = $lang['HTML_is_OFF'];
}

//
// Smilies toggle selection
//
if ( $board_config['allow_smilies'] )
{
	$smilies_status = $lang['Smilies_are_ON'];
}
else
{
	$smilies_status = $lang['Smilies_are_OFF'];
}

//
// Start Page if no form submissions
//
$template->assign_vars(array(
	'L_WEBLOG_CP' => $lang['Weblog_CP'],
	'L_WEBLOG_NAME' => $lang['Weblog_name'],
	'L_WEBLOG_DESC' => $lang['Weblog_desc'],
	'L_WEBLOG_AUTH' => $lang['Weblog_auth'],
	'L_WEBLOG_AUTH_EXPLAIN' => $lang['Weblog_auth_explain'],
	'L_REPLY_AUTH' => $lang['Reply_auth'],
	'L_REPLY_AUTH_EXPLAIN' => $lang['Reply_auth_explain'],
	'L_NUMBER_OF_ENTRIES' => $lang['Number_of_entries'],
	'L_REPLIES_LABEL' => $lang['Replies_label'],
	'L_REPLIES_LABEL_EXPLAIN' => $lang['Replies_label_explain'],
	'L_POST_REPLY_LABEL' => $lang['Post_reply_label'],
	'L_SHOW_WEBLOG_INFO' => $lang['Show_blog_info'],
	'L_WEBLOG_BODY' => $lang['Weblog_body'],
	'L_WEBLOG_BODY_EXPLAIN' => $lang['Weblog_body_explain'],
	'L_WEBLOG_AUTH_ALL' => $lang['Weblog_auth_all'],
	'L_WEBLOG_AUTH_RED' => $lang['Weblog_auth_reg'],
	'L_WEBLOG_AUTH_FRIENDS' => $lang['Weblog_auth_friends'],
	'L_WEBLOG_AUTH_OWNER' => $lang['Weblog_auth_owner'],
	'L_CREATE_WEBLOG' => $lang['Weblog_create'],
	'L_EDIT_WEBLOG' => $lang['Weblog_edit'],
	'L_MARKED_FOR_DELETION' => $lang['Marked_for_deletion'],
	'L_PREVIEW' => $lang['Preview'],
	'L_YES' => $lang['Yes'],
	'L_NO' => $lang['No'],
	'L_DO_NOTHING' => $lang['Do_nothing'],
	'L_SWITCH_MODE' => ( $userdata['user_allowadvweblog'] ) ? (( $weblog_data['weblog_advanced'] ) ? $lang['Switch_easy'] : $lang['Switch_advanced']) : '',
	'L_MOOD_SET' => $lang['Mood_set'],
	'L_LOOK_AND_FEEL' => $lang['Look_and_feel'],
	'L_GENERAL_PAGE_SETTINGS' => $lang['General_page_settings'],	
	'L_URL' => $lang['URL'],
	'L_FIXED_BG' => $lang['Fixed_bg'],
	'L_TILE_BG' => $lang['Tile_bg'],
	'L_TILE' => $lang['Tile'],
	'L_LEFT' => $lang['Left'],
	'L_RIGHT' => $lang['Right'],

	'L_WEBLOG_TITLE' => $lang['Weblog_title'],
	'L_ENTRY_TITLE' => $lang['Entry_title'],
	'L_COLOR' => $lang['Color'],
	'L_DATE_AND_TIME' => $lang['Date_and_time'],
	'L_BLOCK_TITLE' => $lang['Block_title'],
	'L_BLOCK_SETTINGS' => $lang['Block_settings'],
	'L_TITLE' => $lang['Title'],
	'L_SHOW_ENABLE_SHOUTBOX' => $lang['Show_enable_shoutbox'],
	'L_ASCENDING' => $lang['Sort_Ascending'],
	'L_DESCENDING' => $lang['Sort_Descending'],
	'L_RESET_VISIT_COUNTER' => $lang['Reset_visit_counter'],
	'L_RESET_VISITS_EXPLAIN' => $lang['Reset_visits_explain'],
	'L_RESET' => $lang['Reset'], 			
	'WEBLOG_NAME' => ( $weblog_exists ) ? $weblog_data['weblog_name'] : sprintf($weblog_config['default_name'], $userdata['username']),
	'WEBLOG_DESC' => ( $weblog_exists ) ? $weblog_data['weblog_desc'] : sprintf($weblog_config['default_desc'], $userdata['username']),
	'ENTRIES_PERPAGE' => ( $weblog_exists ) ? intval($weblog_data['entries_perpage']) : intval($weblog_config['default_entries_perpage']),
        'WEBLOG_ADVANCED_ON' => ( $weblog_data['weblog_advanced'] ) ? ' checked="checked"' : '',
	'WEBLOG_ADVANCED_OFF' => ( !$weblog_data['weblog_advanced'] ) ? ' checked="checked"' : '',
	'SHOW_WEBLOG_INFO_YES' => ( $weblog_data['show_weblog_info'] ) ? ' checked="checked"' : '',
	'SHOW_WEBLOG_INFO_NO' => ( !$weblog_data['show_weblog_info'] ) ? ' checked="checked"' : '',
	'DELETE_NAME' => ( $weblog_data['deleted'] ) ? 'undelete' : 'delete',
	'L_DELETE_WEBLOG' => ( $weblog_data['deleted'] ) ? $lang['Weblog_undelete'] : $lang['Weblog_delete'],

	'SWITCH_RADIO' => ( $userdata['user_allowadvweblog'] ) ? '<input type="radio" id="action_switch_mode" name="weblog_action" value="2" />' : '',
	'WEBLOG_AUTH_SELECT' => ( $weblog_exists ) ? make_weblog_auth_select ( $weblog_data['weblog_auth'], 'weblog_auth_select') : make_weblog_auth_select ( $weblog_config['default_auth'], 'weblog_auth_select'),
	'REPLIES_AUTH_SELECT' => ( $weblog_exists ) ? make_weblog_auth_select ( $weblog_data['replies_auth'], 'replies_auth_select') : make_weblog_auth_select ( $weblog_config['default_reply_auth'], 'replies_auth_select'),
	'S_WEBLOG_BODY' => htmlentities($weblog_body),
	'S_FORM_ACTION' => append_sid($HTTP_SERVER_VARS['PHP_SELF']))
);

$template->pparse("body");

include($phpbb_root_path . 'includes/page_tail.'.$phpEx);

?>