<?php
/***************************************************************************
 *                            weblog_blocked.php
 *                         ------------------------
 *   Anv@r.all 2010
 *   (C) apwa.ru
 *
 ***************************************************************************/


define('IN_PHPBB', true);
$phpbb_root_path = './';
include($phpbb_root_path . 'extension.inc');
include($phpbb_root_path . 'common.'.$phpEx);
include($phpbb_root_path . 'includes/weblogs_common.'.$phpEx);
include($phpbb_root_path . 'includes/functions_weblog.'.$phpEx);

//
// Start initial var setup
//
if( isset($HTTP_GET_VARS[POST_USERS_URL]) || isset($HTTP_POST_VARS[POST_USERS_URL]) )
{
	$user_id = ( isset($HTTP_GET_VARS[POST_USERS_URL]) ) ? intval($HTTP_GET_VARS[POST_USERS_URL]) : intval($HTTP_POST_VARS[POST_USERS_URL]);
}
else
{
	$user_id = 0;
}

$user_exists = FALSE;

//
// Start session management
//
$userdata = session_pagestart($user_ip, PAGE_INDEX);
init_userprefs($userdata);
//
// End session management
//

$weblog_id = -1;

//
// Make sure that the user requested exists, has a weblog, and is not a guest
//
if ( $user_id != ANONYMOUS )
{
	$sql = "SELECT w.*, u.* FROM " . WEBLOGS_TABLE . " w, " . USERS_TABLE . " u WHERE w.weblog_id = u.user_weblog AND u.user_id = $user_id";
	if( !$result = $db->sql_query($sql) )
	{
		message_die(GENERAL_ERROR, "Couldn't obtain weblogs information.", "", __LINE__, __FILE__, $sql);
	}

	if ( $weblog_data = $db->sql_fetchrow($result) )
	{
		$user_exists = TRUE;
		$weblog_id = $weblog_data['weblog_id'];
		$username = $weblog_data['username'];
	}
	else
	{
		message_die(GENERAL_ERROR, $lang['User_no_weblog']);
	}
}
else
{
	message_die(GENERAL_MESSAGE, $lang['User_not_exist']);
}

//
// Fetch Contributor data
//
$sql = "SELECT * FROM " . WEBLOG_CONTRIBUTORS_TABLE . " WHERE weblog_id = $weblog_id AND user_id = " . $userdata['user_id'];
if ( !($result = $db->sql_query($sql)) )
{
	message_die(GENERAL_ERROR, 'Error querying to find user weblog information', '', __LINE__, __FILE__, $sql);
}

$contributor = FALSE;
if ( $row = $db->sql_fetchrow($result) || $userdata['user_level'] == ADMIN )
{
	$contributor = TRUE;
}

// See if user can see this blocked list
if ( $user_id != $userdata['user_id'] && !$contributor )
{
	message_die(GENERAL_ERROR, $lang['Weblog_noaccess_blocked']);
}


if ( $weblog_data['deleted'] )
{
	message_die(GENERAL_ERROR, sprintf($lang['Weblog_deactivated'], $weblog_data['weblog_name']));
}

//
// Check to see if the owner added a user to the blocked list
//
if ( $weblog_data['weblog_id'] == $userdata['user_weblog'] || $contributor )
{
	$blocked_user = str_replace("\'", "''", ( isset($HTTP_POST_VARS['blockeduser']) ) ? htmlspecialchars($HTTP_POST_VARS['blockeduser']) : '');
	$selected_users = array_unique(explode(',', $blocked_user));
	
	if ( isset($HTTP_POST_VARS['blockgroup']) || isset($HTTP_POST_VARS['removegroup']) )
	{
		$group_id = ( isset($HTTP_POST_VARS[POST_GROUPS_URL]) ) ? intval($HTTP_POST_VARS[POST_GROUPS_URL]) : 0;
		
		$sql = "SELECT u.username
			FROM " . GROUPS_TABLE . " g, " . USER_GROUP_TABLE . " ug, " . USERS_TABLE . " u
			WHERE ug.user_id = u.user_id
				AND ug.group_id = g.group_id
				AND g.group_id = $group_id
				AND g.group_single_user <> " . TRUE . "
			ORDER BY g.group_name, ug.user_id";
		if ( !($result = $db->sql_query($sql)) )
		{
			message_die(GENERAL_ERROR, 'Error getting group information', '', __LINE__, __FILE__, $sql);
		}

		$selected_users = array();
		while ( $row = $db->sql_fetchrow($result) )
		{
			$selected_users[] = $row['username'];
		}
		
		if ( !count($selected_users) )
		{
			message_die(GENERAL_MESSAGE, $lang['No_groups_exist']);
		}
	}
	
	$blocked_user = implode('\', \'', $selected_users);

	if ( isset($HTTP_POST_VARS['blockuser']) || isset($HTTP_POST_VARS['blockgroup']) )
	{
		// Now, attempt to find a user with such a username
		$sql = "SELECT username, user_id FROM " . USERS_TABLE . " WHERE username IN ('" . $blocked_user . "')";
		if( !$result = $db->sql_query($sql) )
		{
			message_die(GENERAL_ERROR, "Couldn't obtain username information.", "", __LINE__, __FILE__, $sql);
		}	

		$users_found = array();
		$blocked_ids = array();
		while ( $row = $db->sql_fetchrow($result) )
		{
			$blocked_ids[] = $row['user_id'];
			$users_found[] = $row['username'];
		}

		$users_not_found = array_diff($selected_users, $users_found);
		if ( count($users_not_found) )
		{
			$users_not_found = implode (', ', $users_not_found);
		}
		else
		{
			$users_not_found = $lang['None'];
		}

		// See if any users haven't already been added
		$sql = "SELECT b.*, u.username, u.user_id FROM " . WEBLOG_BLOCKED_TABLE . " b, " . USERS_TABLE . " u WHERE b.blocked_id IN (" . implode(', ', $blocked_ids) . ") AND u.user_id = b.blocked_id AND b.owner_id = $user_id ";
		if( !$result = $db->sql_query($sql) )
		{
			message_die(GENERAL_ERROR, "Couldn't obtain blocked user information.", "", __LINE__, __FILE__, $sql);
		}

		$users_already_blocked = array();
		while ( $row = $db->sql_fetchrow($result) )
		{
			$users_already_blocked[] = $row['username'];
		}
		
		$users_found2 = array_diff($users_found, $users_already_blocked);
		if ( count($users_already_blocked) )
		{
			$users_already_blocked = implode (', ', $users_already_blocked);
		}
		else
		{
			$users_already_blocked = $lang['None'];
		}

		$blocked_user = str_replace("', '" . $username, "", implode('\', \'', $users_found2));
	
		// Now, attempt to find a user with such a username
		$sql = "SELECT username, user_id FROM " . USERS_TABLE . " WHERE username IN ('" . $blocked_user . "')";
		if( !$result = $db->sql_query($sql) )
		{
			message_die(GENERAL_ERROR, "Couldn't obtain username information.", "", __LINE__, __FILE__, $sql);
		}

		$blocked_ids = array();
		while ( $row = $db->sql_fetchrow($result) )
		{
			$blocked_ids[] = $row['user_id'];
		}
	
		for ( $i = 0; $i < count($blocked_ids); $i++ )
		{
			if ( $blocked_ids[$i] != $user_id && $blocked_ids[$i] != ANONYMOUS )
			{
				// Now insert new blocked user to blocked user table
				$sql = "INSERT INTO " . WEBLOG_BLOCKED_TABLE . " (owner_id, blocked_id) VALUES ($user_id, " . $blocked_ids[$i] . ")";
				if( !($result = $db->sql_query($sql)) )
				{
					message_die(GENERAL_ERROR, "Couldn't obtain insert blocked users information.", "", __LINE__, __FILE__, $sql);
				}
			}
		}

		if ( count($users_found2) )
		{
			$users_found2 = implode (', ', $users_found2);
		}
		else
		{
			$users_found2 = $lang['None'];
		}

		$template->assign_vars(array(
			'META' => '<meta http-equiv="refresh" content="3;url=' . append_sid("weblog_blocked.$phpEx?" . POST_USERS_URL . "=$user_id") . '">')
		);
	
		message_die (GENERAL_MESSAGE, sprintf($lang['Users_blocked'], $users_found2) . '<br />' . sprintf($lang['Users_already_blocked'], $users_already_blocked) . '<br />' . sprintf($lang['Users_not_exist'], $users_not_found) . '<br /><br />' . sprintf($lang['Click_return_blocked'], '<a href="' . append_sid("weblog_blocked.$phpEx?" . POST_USERS_URL . "=$user_id") . '">', '</a>') . '<br /><br />' . sprintf($lang['Click_return_weblog'], '<a href="' . append_sid("weblog.$phpEx?" . POST_WEBLOG_URL . "=" . $weblog_data['weblog_id']) . '">', '</a>', $weblog_data['weblog_name']));
	}
	else if ( isset($HTTP_POST_VARS['removeuser']) || isset($HTTP_POST_VARS['removegroup']) )
	{

		// Now, attempt to find a user with such a username
		$sql = "SELECT username, user_id FROM " . USERS_TABLE . " WHERE username IN ('" . $blocked_user . "')";
		if( !$result = $db->sql_query($sql) )
		{
			message_die(GENERAL_ERROR, "Couldn't obtain username information.", "", __LINE__, __FILE__, $sql);
		}	

		$users_found = array();
		$blocked_ids = array();
		while ( $row = $db->sql_fetchrow($result) )
		{
			$blocked_ids[] = $row['user_id'];
			$users_found[] = $row['username'];
		}

		$users_not_found = array_diff($selected_users, $users_found);
		if ( count($users_not_found) )
		{
			$users_not_found = implode (', ', $users_not_found);
		}
		else
		{
			$users_not_found = $lang['None'];
		}

		// See if any users haven't already been removed
		$sql = "SELECT b.*, u.username, u.user_id FROM " . WEBLOG_BLOCKED_TABLE . " b, " . USERS_TABLE . " u WHERE b.blocked_id IN (" . implode(', ', $blocked_ids) . ") AND u.user_id = b.blocked_id AND b.owner_id = $user_id ";
		if( !$result = $db->sql_query($sql) )
		{
			message_die(GENERAL_ERROR, "Couldn't obtain blocked user information.", "", __LINE__, __FILE__, $sql);
		}

		$users_already_blocked = array();
		while ( $row = $db->sql_fetchrow($result) )
		{
			$users_already_blocked[] = $row['username'];
		}

		$users_found2 = array_diff($users_found, $users_already_blocked);
		if ( count($users_found2) )
		{
			$users_found2 = implode (', ', $users_found2);
		}
		else
		{
			$users_found2 = $lang['None'];
		}

		$blocked_user = implode('\', \'', $users_already_blocked);
	
		// Now, attempt to find a user with such a username
		$sql = "SELECT username, user_id FROM " . USERS_TABLE . " WHERE username IN ('" . $blocked_user . "')";
		if( !$result = $db->sql_query($sql) )
		{
			message_die(GENERAL_ERROR, "Couldn't obtain username information.", "", __LINE__, __FILE__, $sql);
		}

		$blocked_ids = array();
		while ( $row = $db->sql_fetchrow($result) )
		{
			$blocked_ids[] = $row['user_id'];
		}
	
		// Now delete the chosen blocked users from the block users table
		$sql = "DELETE FROM " . WEBLOG_BLOCKED_TABLE . " WHERE blocked_id IN (" . implode(', ', $blocked_ids) . ")  AND owner_id = $user_id";
		if( !($result = $db->sql_query($sql)) )
		{
			message_die(GENERAL_ERROR, "Couldn't delete blocked user information.", "", __LINE__, __FILE__, $sql);
		}

		if ( count($users_already_blocked) )
		{
			$users_already_blocked = implode (', ', $users_already_blocked);
		}
		else
		{
			$users_already_blocked = $lang['None'];
		}

		$template->assign_vars(array(
			'META' => '<meta http-equiv="refresh" content="3;url=' . append_sid("weblog_blocked.$phpEx?" . POST_USERS_URL . "=$user_id") . '">')
		);
	
		message_die (GENERAL_MESSAGE, sprintf($lang['Users_unblocked'], $users_already_blocked) . '<br />' . sprintf($lang['Users_not_blocked'], $users_found2) . '<br />' . sprintf($lang['Users_not_exist'], $users_not_found) . '<br /><br />' . sprintf($lang['Click_return_blocked'], '<a href="' . append_sid("weblog_blocked.$phpEx?" . POST_USERS_URL . "=$user_id") . '">', '</a>') . '<br /><br />' . sprintf($lang['Click_return_weblog'], '<a href="' . append_sid("weblog.$phpEx?" . POST_WEBLOG_URL . "=" . $weblog_data['weblog_id']) . '">', '</a>', $weblog_data['weblog_name']));
	}
}

$page_title = $lang['Blocked_users'];
include($phpbb_root_path . 'includes/page_header.'.$phpEx);

$template->set_filenames(array(
	'body' => 'blog/blocked_body.tpl')
);

//
// Get a list of usergroups
//
$sql = "SELECT group_id, group_name, group_type
	FROM " . GROUPS_TABLE . " g 
	WHERE group_single_user <> " . TRUE . " 
	ORDER BY g.group_name";
if ( !($result = $db->sql_query($sql)) )
{
	message_die(GENERAL_ERROR, 'Error getting group information', '', __LINE__, __FILE__, $sql);
}

$s_group_select = '<select name="' . POST_GROUPS_URL . '">';
while ( $row = $db->sql_fetchrow($result) )
{
	if  ( $row['group_type'] != GROUP_HIDDEN || $userdata['user_level'] == ADMIN )
	{
		$s_group_select .='<option value="' . $row['group_id'] . '">' . $row['group_name'] . '</option>';
	}
}
$s_group_select .= '</select>';

//
// Find the users that have been blocked
//
$sql = "SELECT u.username, u.user_id, b.blocked_id FROM " . WEBLOG_BLOCKED_TABLE . " b, " . USERS_TABLE . " u
	WHERE b.owner_id = $user_id
		AND u.user_id = b.blocked_id";
if( !$result = $db->sql_query($sql) )
{
	message_die(GENERAL_ERROR, "Couldn't get blocked user information.", "", __LINE__, __FILE__, $sql);
}
	
while ( $row = $db->sql_fetchrow($result) )
{
	$template->assign_block_vars('blockedrow', array(
		'U_PROFILE' => append_sid("profile.$phpEx?mode=viewprofile&amp;" . POST_USERS_URL . "=" . $row['user_id']),
		'BLOCKED_USER' => $row['username'])
	);
}

//
// Generate page
//
$template->assign_vars(array(
	'L_BLOCKED_USERS' => $lang['Blocked_users'],
	'L_REMOVE_USER' => $lang['Remove_user'],
	'L_INDEX' => sprintf($lang['Forum_Index'], $board_config['sitename']),
	'L_WEBLOGS' => $lang['Weblogs'],
	'L_BLOCK_USER' => $lang['Block_user'],
	'L_BLOCK_USERS_EXPLAIN' => $lang['Add_friend_explain'],
	'L_BLOCK_GROUP' => $lang['Block_group'],
	'L_REMOVE_GROUP' => $lang['Remove_group'],

	'U_INDEX' => append_sid('index.'.$phpEx),
	'U_WEBLOGS' => append_sid("weblogs.$phpEx"),
	'U_WEBLOG' => append_sid("weblog.$phpEx?" . POST_WEBLOG_URL . "=" . $weblog_data['weblog_id']),

	'S_GROUP_SELECT' => $s_group_select,
	'S_BLOCK_ACTION' => append_sid("weblog_blocked.$phpEx?" . POST_USERS_URL . "=$user_id"),
	'WEBLOG_NAME' => $weblog_data['weblog_name'])
);

//
// Output the body
//
$template->pparse('body');


$template->assign_vars(array(
	'L_POWERED_BY' => sprintf($lang['Weblog_powered_by'], WEBLOGS_MOD_VERSION))
);

//
// Output the footer
//
include($phpbb_root_path . 'includes/page_tail.'.$phpEx);

?>