<?php

/********************************************************************************
 * FILE UTF-8                  images.php
 *                            -------------------
 * Anv@r.all (c) apwa.ru 2012
 * Изменяет размер изображения. GIF, JPEG, PNG
 * http://apwa.ru/images.php?w=ширина&h=высота&file=фаил_изображения
 ********************************************************************************/
 
if ( !empty($_GET['file']) )
{
      $file = htmlspecialchars($_GET['file']);

      if ((isset($_GET['w']) && isset($_GET['h']) ) && (intval($_GET['w']) >= 20 && intval($_GET['h']) >= 20 ) && (intval($_GET['h']) <= 150 && intval($_GET['w']) <= 150) )
      {
            $max_width = intval($_GET['w']);
            $max_height = intval($_GET['h']);
      }
      else if ((isset($_POST['w']) && isset($_POST['h']) ) && (intval($_POST['w']) >= 20 && intval($_POST['h']) >= 20 ) && (intval($_POST['h']) <= 150 && intval($_POST['w']) <= 150) )
      {
            $max_width = intval($_POST['w']);
            $max_height = intval($_POST['h']);
      } 
      else
      {
            $max_width = 40; // MAX Ширина по умолчанию
            $max_height = 40; // MAX Высота по умолчанию
      }
}    

$pic_info = @getimagesize($file); // Получаем информацию о изображении
$pic_width = $pic_info[0]; // Определяем ширину
$pic_height = $pic_info[1]; // Определяем высоту
$type = $pic_info[2]; // Определяем тип файла

switch ($type)            
{
	case '1':
	     $read_function = 'imagecreatefromgif';
             $content_type = 'image/gif';
        break;
	case '2':
	     $read_function = 'imagecreatefromjpeg';
	     $content_type = 'image/jpeg';
	break;
	case '3':
	     $read_function = 'imagecreatefrompng';
	     $content_type = 'image/png';
	break;
}
$src = @$read_function($file);

if($pic_width >= $pic_height) 
{  
      $thumbnail_width = $max_width; 
      $thumbnail_height = $max_width * ($pic_height/$pic_width); 
} 
else 
{  
      $thumbnail_height = $max_height; 
      $thumbnail_width =  $max_height * ($pic_width/$pic_height); 
} 

$thumbnail = @imagecreatetruecolor($thumbnail_width, $thumbnail_height); 
@imagecopyresampled($thumbnail, $src, 0, 0, 0, 0, $thumbnail_width, $thumbnail_height, $pic_width, $pic_height); 

header("Content-type: $content_type"); 

switch ($type)
{
	case '1':
	     @imagegif($thumbnail);
	break;
	case '2':
	     @imagejpeg($thumbnail, '', 70); // 70 - качество jpeg
	break;
	case '3':
	     @imagepng($thumbnail);
	break;
}

@ImageDestroy($src ); 
@ImageDestroy($thumbnail ); 

?>