<?php

define('IN_PHPBB', true);
$phpbb_root_path = './';
include($phpbb_root_path . 'extension.inc');
include($phpbb_root_path . 'common.'.$phpEx);
include($phpbb_root_path . 'includes/bbcode.'.$phpEx);

$userdata = session_pagestart($user_ip, PAGE_INDEX);
init_userprefs($userdata);

if ( isset($HTTP_GET_VARS['mode']) || isset($HTTP_POST_VARS['mode']) )
{
	$mode = ( isset($HTTP_POST_VARS['mode']) ) ? htmlspecialchars($HTTP_POST_VARS['mode']) : htmlspecialchars($HTTP_GET_VARS['mode']);
}
else
{
	$mode = '';
}

if ( isset($HTTP_GET_VARS['ext']) || isset($HTTP_POST_VARS['ext']) )
{
	$ext = ( isset($HTTP_POST_VARS['ext']) ) ? htmlspecialchars($HTTP_POST_VARS['ext']) : htmlspecialchars($HTTP_GET_VARS['ext']);
}
else
{
	$ext = '';
}

if ( $mode == 'file' )
{
       if( isset($HTTP_POST_VARS[POST_GROUPS_URL]) )
       {
	       $group_id = intval($HTTP_POST_VARS[POST_GROUPS_URL]);
       }
       else if( isset($HTTP_GET_VARS[POST_GROUPS_URL]) )
       {
	       $group_id = intval($HTTP_GET_VARS[POST_GROUPS_URL]);
       }
       else
       {
	        message_die(GENERAL_ERROR, 'No categories specified');
       }
       if( isset($HTTP_GET_VARS['start']) )
       {
	       $start = intval($HTTP_GET_VARS['start']);
       }
       else if( isset($HTTP_POST_VARS['start']) )
       {
	       $start = intval($HTTP_POST_VARS['start']);
       }
       else
       {
	       $start = 0;
       }
       
       $start = ($start < 0) ? 0 : $start; 
       $ext_file = ( $ext != '' ) ? '&amp;ext=' . $ext . '' : '';
       $extension = ( $ext != '' ) ? "AND ad.extension = '" . $ext . "'" : '';  
       
       $sql = "SELECT e.group_id, ad.extension FROM ". EXTENSIONS_TABLE ." e, ". ATTACHMENTS_DESC_TABLE ." ad
	       WHERE e.group_id = " . $group_id . "
	       AND e.extension = ad.extension
	       $extension
	       ORDER BY ad.filetime DESC";
       if( !($result = $db->sql_query($sql)) )
       {
	       message_die(GENERAL_ERROR, 'Could not query categories list', '', __LINE__, __FILE__, $sql);
       }
       $filenum = array();
       while( $row = $db->sql_fetchrow($result) )
       {
	     $filenum[] = $row;
       } 
       $db->sql_freeresult($result);
               		     
       $sql = "SELECT e.group_id, e.extension, a.attach_id, ad.physical_filename, ad.real_filename, ad.download_count, ad.comment, ad.extension, ad.mimetype, ad.filesize, ad.filetime, f.forum_id, t.topic_title, p.post_id, u.username
	       FROM ". EXTENSIONS_TABLE ." e, " . ATTACHMENTS_TABLE . " a, " . ATTACHMENTS_DESC_TABLE . " ad, " . FORUMS_TABLE . " f , " . TOPICS_TABLE . " t, " . POSTS_TABLE . " p, " . USERS_TABLE . " u
	       WHERE e.group_id = " . $group_id . "	       
	       AND a.attach_id = ad.attach_id
	       AND ad.extension = e.extension	       	        	       	       	       	         	        
	       AND f.forum_id = t.forum_id
	       AND t.topic_id = p.topic_id	       
	       AND p.post_id = a.post_id
	       AND f.forum_id = p.forum_id       	       	       	       	       	       	        
	       AND u.user_id = p.poster_id 
	       AND a.privmsgs_id = 0
	       	$extension        	       	       
	       ORDER BY ad.filetime DESC LIMIT " . $start . ", 5";
       if( !($result = $db->sql_query($sql)) )
       {
	       message_die(GENERAL_ERROR, 'Could not query categories list', '', __LINE__, __FILE__, $sql);
       }
       $filecat = array();
       while( $row = $db->sql_fetchrow($result) )
       {
	     $filecat[] = $row;	     
       } 
       if ( count($filecat) == '' )
       {
	     message_die(GENERAL_MESSAGE, sprintf($lang['Directory_does_not_exist'], 'files.php?mode=file&amp;g=' . $group_id . '' . $ext_file . ''));
       }   
       for ($i = 0; $i < count($filecat); $i++)
       {	                       
	        $forum_id = $filecat[$i]['forum_id'];	        
	        $is_auth = array();
         	$is_auth = auth(AUTH_ALL, $forum_id, $userdata); 
              
	        $size = $filecat[$i]['filesize'];	        
                if (intval($size/1024/1024)>0)
                {
                        $size = intval($size/1024/1024).''.$lang['MB'];
                }
                elseif(intval($size/1024)>0)
                {
                        $size = intval($size/1024).''.$lang['KB'];
                }
                else
                {
                       $size = intval($size).''.$lang['Bytes'];
                }              

         	if ($is_auth['auth_download'])
         	{
                      $down = '<a href="'.append_sid("download.$phpEx?id=". $filecat[$i]['attach_id']) . '">' . $filecat[$i]['real_filename'] . '</a>';
                }
                else
                {
                      $down = $lang['Sorry_auth_view_attach'];
                }
                $comment = ($filecat[$i]['comment'] != '') ? $filecat[$i]['comment'] . '<br/>' : '';
                $topic = '<a href="'.append_sid("viewtopic.$phpEx?" . POST_POST_URL . "=". $filecat[$i]['post_id']) . '">' . $filecat[$i]['topic_title'] . '</a>';
                $poster = $filecat[$i]['username'];    
                $time = create_date($board_config['default_dateformat'], $filecat[$i]['filetime'], $board_config['board_timezone']);               
                if ($filecat[$i]['mimetype'] == 'image/png' or $filecat[$i]['mimetype'] == 'image/jpeg' or $filecat[$i]['mimetype'] == 'image/gif')
                {
                       if (!file_exists('files/' . $filecat[$i]['physical_filename']))
                       {
                              $screen = '';
                       }
                       else
                       {
                              $screen = '<img src="img.php?img=' . $filecat[$i]['attach_id'] . '" alt="' . $filecat[$i]['real_filename'] . '" /><br/>';
                       }
                }
                else
                {
                       $screen = '';
                }                
	        $row_class = ( !($i % 2) ) ? 'row_easy' : 'row_hard';
	        $template->assign_block_vars('files', array(
		         'ROW_CLASS' => $row_class,
		         'FILE_DOWN' => $down,
		         'FILE_COMMENT' => $comment,
		         'TOPIC' => $topic,	         
		         'INFO' => '['.$size.'|'.$time.'|'.$poster.']',
		         'DOWN_COUNT' => sprintf($lang['Download_number'], $filecat[$i]['download_count']),
		         'SCREEN' => $screen)
	        ); 
	       	if ($filecat[$i]['mimetype'] == 'audio/mpeg')
                {
                        $template->assign_block_vars('files.audio', array(
                                'FILE' => 'files/' . $filecat[$i]['physical_filename'])
                        ); 
                } 
       } 
      $pagination = generate_pagination("files.$phpEx?mode=file&amp;" . POST_GROUPS_URL . "=$group_id$ext_file", count($filenum), 5, $start). '';  
}            
else 
{	
       $sql = "SELECT group_id, group_name, upload_icon
	       FROM ". EXTENSION_GROUPS_TABLE ."
	       WHERE allow_group = 1
	       ORDER BY group_id ASC";
       if( !($result = $db->sql_query($sql)) )
       {
	        message_die(GENERAL_ERROR, 'Could not query categories list', '', __LINE__, __FILE__, $sql);
       }
       $catrows = array();
       while( $row = $db->sql_fetchrow($result) )
       {
	       $catrows[] = $row;
       }
       $db->sql_freeresult($result);
        
       $sql = "SELECT group_id, extension, comment
	       FROM ". EXTENSIONS_TABLE ."
	       GROUP BY ext_id ORDER BY group_id";
       if( !($result = $db->sql_query($sql)) )
       {
	      message_die(GENERAL_ERROR, 'Could not query categories list', '', __LINE__, __FILE__, $sql);
       }
       $viewcat = array();
       while( $row = $db->sql_fetchrow($result) )
       {
	      $viewcat[] = $row;
       } 
       $db->sql_freeresult($result);                
      
       for ($i = 0; $i < count($catrows); $i++)
       {
	      $group_id = $catrows[$i]['group_id'];
	      $upload_icon = ( $catrows[$i]['upload_icon'] != '' ) ? '<img src="' . $catrows[$i]['upload_icon'] . '" alt="" />' : '';
	      $row_class = ( !($i % 2) ) ? 'row_easy' : 'row_hard';
	      $template->assign_block_vars('catrow', array(
	             'ROW_CLASS' => $row_class,
	             'UPLOAD_ICON' => $upload_icon,
		     'U_VIEW_CAT' => append_sid("files.$phpEx?mode=file&amp;" . POST_GROUPS_URL . "=". $catrows[$i]['group_id']),
		     'GROUP_NAME' => $catrows[$i]['group_name'])
	      );

	      for ($j = 0; $j < count($viewcat); $j++)
              {	          	           
	             if ( $viewcat[$j]['group_id'] == $group_id )
		     { 
	                    $result = mysql_query("SELECT count(extension) AS total FROM " . ATTACHMENTS_DESC_TABLE . " WHERE extension = '" . $viewcat[$j]['extension'] . "'"); 
                            $total = mysql_fetch_array($result); 
                            if ( $total['total'] != 0 )
                            {
	                          $template->assign_block_vars('catrow.extension', array(
		                        'U_FILE_EXT' => append_sid("files.$phpEx?mode=file&amp;" . POST_GROUPS_URL . "=". $viewcat[$j]['group_id'] . "&amp;ext=". $viewcat[$j]['extension']),
		                        'EXT_NAME' => $viewcat[$j]['extension'],
		                        'TOTAL' => $total['total'])
	                          );	                         
	                    }                    
	             } 
	      }              	      
       }  
       $result = mysql_query("SELECT count(attach_id) AS total FROM " . ATTACHMENTS_TABLE);
       $total = mysql_fetch_array($result);
       $total_files = $lang['Posted_attachments'] . ': ' . sprintf($total['total']);   
}

$page_title = $lang['Files'];
include($phpbb_root_path . 'includes/page_header.'.$phpEx);

$template->set_filenames(array(
	'body' => 'files_body.tpl')
);

$template->assign_vars(array(       
         'L_TOPIC' => $lang['Topic'],
         'L_DOWNLOAD' => $lang['Download'],
         'L_DOWNLOADED' => $lang['Downloaded'],
         'TOTAL_FILES' => $total_files,       
         'PAGINATION' => $pagination)
);

$template->pparse('body');

include($phpbb_root_path . 'includes/page_tail.'.$phpEx);

?>