<?php
class vkapi {
    private $api_secret;
    private $app_id;
    private $user_id;
    private $api_url = 'http://api.vk.com/api.php';
    private $format;
    private $test_mode = false;
    
    public function __construct($user_id, $app_id, $api_secret, $test_mode = 1, $format = '') {
        $this->user_id = $user_id;
        $this->app_id = $app_id;
        $this->api_secret = $api_secret;
        $this->format = ($format == 'json' && function_exists('json_decode')) ? 'json' : 'xml';
        if($test_mode) $this->test_mode = 1;
    }
    
    public function query( $method, $params = false ) {
        if(!$params) $params = array();
        $params['api_id'] = $this->app_id;
        $params['v'] = '2.0';
        $params['method'] = $method;
        $params['timestamp'] = time();
        $params['format'] = $this->format;
        $params['random'] = rand(0,10000);
        $params['test_mode'] = $this->test_mode;
        ksort($params);
 
        $sig = $this->user_id;
        foreach($params as $k=>$v){ $sig .= $k.'='.$v; }
        $sig .= $this->api_secret; 
        $params['sig'] = md5($sig); 
        return $this->request( $this->api_url.'?'.$this->params($params) );
    }
 
    private function params($params) {
        $pice = array();
        foreach($params as $k=>$v){ $pice[] = $k.'='.urlencode($v); }
        return implode('&', $pice);
    }

    private function request($query){
        if(function_exists('curl_init')){
            $ch = curl_init($query);
            curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
            $res = curl_exec($ch);
            curl_close($ch);
        } else {
            $res = file_get_contents($query);
        }
        return $this->process($res);
    }
 
    private function process($result){
        return $this->format == 'json' ? @json_decode($result) : @simplexml_load_string($result);
    }
}
?>