<?php
// Original idea by: Dmitry Boykov (http://forum.dklab.ru/users/DmitryBoykov/)

$size = 2; // какого уровня домен считать корневым
$domains = array();
$file = file('vhosts.conf');
foreach ($file as $line) {
    $port = '';
    if (preg_match('/^[^#]* <VirtualHost \s+ [^:>]+ (?::(\d+))?/six', $line, $p)) {
        $port = @$p[1];
    }
    if (preg_match('/^[^#]* ServerName \s+ "?([^"]*)"?/six', $line, $p)) {
        if ($port == 443) continue;

        $dom = preg_replace('/^www\./si', '', $p[1]);
        $dom .= $port && $port != 80 ? ":$port" : '';
        $domains[] = $dom;
    }
}
$domains = array_unique($domains);

$out = array();
foreach ($domains as $v) {
    $tmp = explode('.', $v);
    if (sizeof($tmp) > $size) {
        $out[implode('.', array_slice($tmp, -$size))][] = $v;
    } else {
        $out[$v] = isset($out[$v]) ? $out[$v] : array();
    }
}



header('Content-Type: text/plain; charset=utf-8');
print_r($out);
exit;


$prev = false;

///////////////////////////////////
header('Content-Type: text/html; charset=utf-8');
echo '<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Strict//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd">
<html xmlns="http://www.w3.org/1999/xhtml" dir="ltr" lang="ru-ru" xml:lang="ru-ru">
<head>
<meta http-equiv="Content-Type" content="text/html; charset=utf-8"/>
<link rel="icon" href="style/favicon.ico" type="image/x-icon"/>
<link rel="stylesheet" href="1style/1style.css" type="text/css" />
<title>Список сайтов</title>

</head>
<body>

<div id="box">

<div id="title">Список сайтов:</div>
<div id="list">';   

foreach ($domains as $dom => $parts) {
    if (!$prev || !preg_match('/' . preg_quote($prev, '/') . '$/si', $dom)) {
        echo '
        <span id ="sites">
        <a id="sit" target="_blank" href="http://'.$dom.'"><img alt="*" src="1style/img/ico_site.gif"/>&#160;&#160;'.$dom.'</a>
        <a id="www" target="_blank" href="http://www.'.$dom.'"></a></span>';

        $prev = $dom;
    } else {
        echo '<li id="dom">&bull; <a id="sit1" target="_blank" href="http://'.$dom.'">'.$dom.'</a></li>';
    }
}
//А мне нужно, чтобы субдомены выводились в таком виде:
echo '<ul id="sub">
    <li id="dom">&bull; <a id="sit1" target="_blank" href="">sub1.site1</a></li>
    <li id="dom">&bull; <a id="sit1" target="_blank" href="">sub2.site1</a></li>
    <li id="dom">&bull; <a id="sit1" target="_blank" href="">sub3.site1</a></li>
    </ul>

    <p><b>&#8657;&#8657; А мне нужно, чтобы субдомены выводились в таком виде &#8657;&#8657;</b></p>';
////////////////////////////////////////////////////////
echo '</div>

</div></div>
</body></html>';
?>
