<?php

class Acl {
private $__rights = array();
private $__groups = array();
private $__right = 'user';
private $__group = array('users');

public function __construct()
{
$this->__rights = array(
'Анонимус' => 'anonymous',
'Пользователь' => 'user',
'Модератор' => 'moder',
'Администратор' => 'admin',
'Гл. Администратор' => 'super_admin'
);
}

// Проверка доступа по группе
public function isGroupAllowed($__right, $__access)
{
	if (empty($__right) || empty($__access)) return false;
	if (in_array($__access, $this->getGroup($__right))) { $this->__group = array(); return true; }

return false;
}

// Проверка доступа по правам
public function isRightAllowed($__right, $__access)
{
	if (empty($__right) || !is_string($__right)) return false;
	if (empty($__access) || !is_string($__access)) return false;

if ($__access == $__right) return true;

return false;
}

// Получение Группы
public function getGroup($__right)
{
	if (empty($__right)) return false;

	for ($i=0;$i < count($this->__groups);$i++)
	{
		if (in_array($__right, $this->__groups[$i]['rights']))
		{
		if (in_array($this->__groups[$i]['name'], $this->__group)) continue;
		$this->__group[] = $this->__groups[$i]['name']; break;
		}
	}

return array_unique($this->__group);
}

// Установка Группы
public function setGroup($__name, $ru_name, $__rights = array())
{
	if (empty($__name) || !preg_match('#[a-z_0-9]+#', $__name)) return false;
	if (empty($ru_name) || !preg_match('#[a-zа-я_\-0-9]+#iu', $ru_name)) return false;
	if (empty($__rights) || !is_array($__rights)) return false;

$this->__groups[] = array('name' => $__name, 'ru_name' => $ru_name, 'rights' => $__rights);
return true;
}

public function test($text)
{
debug($this->getGroup($text));
}

}
