<?php
/**
 * Copyright (c) 2012, Gemorroj
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 *     * Redistributions of source code must retain the above copyright notice,
 *       this list of conditions and the following disclaimer.
 *     * Redistributions in binary form must reproduce the above copyright
 *       notice, this list of conditions and the following disclaimer in the
 *       documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
 * CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 *
 * @author Gemorroj
 * @version 1.7
 */
/**
 * Накрутчик
 *
 * @author Gemorroj
 * @version 1.7
 * @license http://www.opensource.org/licenses/bsd-license.php New BSD License
 */
class Cheaters
{
    /**
     * Доступные типы проксей
     */
    const PROXY_TYPE_SOCKS5 = 'socks5';
    const PROXY_TYPE_SOCKS4 = 'socks4';
    const PROXY_TYPE_HTTP = 'http';

    /**
     * Доступные типы соединения
     */
    const CONNECTION_TYPE_CLOSE = 'Close';
    const CONNECTION_TYPE_KEEPALIVE = 'Keep-Alive';

    /**
     * Доступные версии HTTP протокола
     */
    const HTTP_VERSION_1_0 = CURL_HTTP_VERSION_1_0;
    const HTTP_VERSION_1_1 = CURL_HTTP_VERSION_1_1;


    private $_link;
    private $_linkParse = array();

    private $_timeout = 5;
    private $_sleep = null;

    private $_proxy = array();
    private $_proxyType;
    private $_referer;
    private $_xForwardedFor;
    private $_xRealIp;
    private $_via;
    private $_connect = self::CONNECTION_TYPE_CLOSE;
    private $_maxRedirect;
    private $_curl;
    protected $_debug = false;
    protected $_browsers = array();
    private $_headers = array();
    private $_headersTmp = array();
    private $_httpVersion = self::HTTP_VERSION_1_1;

    private $_response;
    private $_result = array('success' => 0, 'fail' => 0);


    /**
     * Конструктор
     *
     * @param bool $debug Отладочный режим
     */
    public function __construct ($debug = false)
    {
        $this->_browsers = file('browsers.dat');
        $this->_debug = $debug;
        $this->_curl = curl_init();
    }


    /**
     * Здаем ссылку
     *
     * @param string $link
     * @return Cheaters
     */
    public function setLink($link)
    {
        $this->_link = $link;
        $this->_setLinkParse();
        return $this;
    }


    /**
     * Получаем результатирующую статистику
     *
     * @return array
     */
    protected function getResult()
    {
        return $this->_result;
    }


    /**
     * Задаем распаршеную ссылку
     *
     * @return Cheaters
     */
    protected function _setLinkParse()
    {
        $this->_linkParse = parse_url($this->_link);
        return $this;
    }


    /**
     * Задаем максимальное время ожидания ответа в секундах
     *
     * @param int $timeout
     * @return Cheaters
     */
    public function setTimeout($timeout)
    {
        $this->_timeout = $timeout;
        return $this;
    }


    /**
     * Задаем таймаут между запросами в секундах
     *
     * @param int $sleep
     * @return Cheaters
     */
    public function setSleep($sleep)
    {
        $this->_sleep = $sleep;
        return $this;
    }


    /**
     * Задаем тип используемых прокси
     *
     * @param string $proxyType
     * @return Cheaters
     */
    public function setProxyType($proxyType = Cheaters::PROXY_TYPE_HTTP)
    {
        $this->_proxyType = $proxyType;
        $this->_setProxy();
        return $this;
    }


    /**
     * Задаем список прокси
     *
     * @return Cheaters
     */
    protected function _setProxy()
    {
        $this->_proxy = file($this->_proxyType . '_proxy.dat');
        return $this;
    }


    /**
     * Задаем реферер
     *
     * @param string $referer
     * @return Cheaters
     */
    public function setReferer($referer)
    {
        $this->_referer = $referer;
        return $this;
    }


    /**
     * Задаем HTTP заголовок X-Forwarded-For
     *
     * @param string $xForwardedFor
     * @return Cheaters
     */
    public function setXForwardedFor($xForwardedFor)
    {
        $this->_xForwardedFor = $xForwardedFor;
        return $this;
    }


    /**
     * Задаем HTTP заголовок X-Real-Ip
     *
     * @param string $xRealIp
     * @return Cheaters
     */
    public function setXRealIp($xRealIp)
    {
        $this->_xRealIp = $xRealIp;
        return $this;
    }


    /**
     * Задаем HTTP заголовок VIA
     *
     * @param string $via
     * @return Cheaters
     */
    public function setVia($via)
    {
        $this->_via = $via;
        return $this;
    }


    /**
     * Задаем тип соединения
     *
     * @param string $connect
     * @return Cheaters
     */
    public function setConnect($connect = Cheaters::CONNECTION_TYPE_CLOSE)
    {
        $this->_connect = $connect;
        return $this;
    }


    /**
     * Задаем максимальное количество редиректов
     *
     * @param int $maxRedirect
     * @return Cheaters
     */
    public function setMaxRedirect($maxRedirect = 10)
    {
        $this->_maxRedirect = $maxRedirect;
        return $this;
    }


    /**
     * Задаем версию HTTP протокола
     *
     * @param int $httpVersion
     * @return Cheaters
     */
    public function setHttpVersion($httpVersion = Cheaters::HTTP_VERSION_1_1)
    {
        $this->_httpVersion = $httpVersion;
        return $this;
    }


    /**
     * Задаем произвольный HTTP заголовок
     *
     * @param string $header
     * @param array $headers
     * @return array
     */
    private function _addHeader($header, $headers)
    {
        $replaced = false;

        list($setKey, $setValue) = explode(':', $header, 2);

        foreach ($headers as $k => $v) {
            list($key, $value) = explode(':', $v, 2);
            if ($key == $setKey) {
                $replaced = true;
                $headers[$k] = $header;
            }
        }

        if ($replaced !== true) {
            $headers[] = $header;
        }

        return $headers;
    }


    /**
     * Задаем произвольный HTTP заголовок
     *
     * @param string $header
     * @return Cheaters
     */
    public function setHeader($header)
    {
        $this->_addHeader($header, $this->_headers);
        return $this;
    }


    /**
     * Задаем произвольный HTTP заголовок
     *
     * @param string $header
     * @return Cheaters
     */
    private function _setHeaderTmp($header)
    {
        $this->_addHeader($header, $this->_headersTmp);
        return $this;
    }


    /**
     * Подготавливаем все заголовки
     *
     * @return Cheaters
     */
    protected function _initHeaders()
    {
        $this->_headers = array(
            'Accept: text/xml,application/xml,application/xhtml+xml,text/html;q=0.9,text/plain;q=0.8,image/png,*/*;q=0.5',
            'Connection: ' . $this->_connect,
            'Host: ' . $this->_linkParse['host'],
            'Accept-Charset: iso-8859-1, utf-8, utf-16, *;q=0.1',
            'Accept-Language: ru-RU,ru;q=0.9,en;q=0.8'
        );

        if ($this->_xForwardedFor !== null) {
            $this->setHeader('X-Forwarded-For: ' . $this->_xForwardedFor);
        }
        if ($this->_xRealIp !== null) {
            $this->setHeader('X-Real-Ip: ' . $this->_xRealIp);
        }
        if ($this->_via !== null) {
            $this->setHeader('Via: ' . $this->_via);
        }
        if ($this->_referer !== null) {
            $this->setHeader('Referer: ' . $this->_referer);
        }

        return $this;
    }


    /**
     * Выполняем запросы
     *
     * @param int $go количество переходов
     */
    public function exec ($go = 500)
    {
        $this->_initHeaders();

        for ($i = 0; $i < $go; ++$i) {
            curl_setopt($this->_curl, CURLOPT_URL, $this->_link);
            curl_setopt($this->_curl, CURLOPT_HTTPHEADER, $this->_headers);
            curl_setopt($this->_curl, CURLOPT_AUTOREFERER, false);
            curl_setopt($this->_curl, CURLOPT_RETURNTRANSFER, true);
            curl_setopt($this->_curl, CURLOPT_FOLLOWLOCATION, true);
            curl_setopt($this->_curl, CURLOPT_SSL_VERIFYPEER, false);
            curl_setopt($this->_curl, CURLOPT_SSL_VERIFYHOST, false);
            curl_setopt($this->_curl, CURLOPT_TIMEOUT, $this->_timeout);
            curl_setopt($this->_curl, CURLOPT_HEADER, true);
            curl_setopt($this->_curl, CURLOPT_NOBODY, false);
            curl_setopt($this->_curl, CURLOPT_HTTP_VERSION, $this->_httpVersion);
            curl_setopt($this->_curl, CURLOPT_USERAGENT, $this->_getRandomBrowser());

            if ($this->_proxy) {
                $this->_setCurlProxy();
            }

    
            $this->_response = curl_exec($this->_curl);
            if ($this->_debug === true) {
                var_dump(curl_getinfo($this->_curl), $this->_response);
            }
    
            if (!$this->_response) {
                $this->_result['fail']++;
                continue;
            }
    
            $this->_result['success']++;
    
    
            $h = $this->_parseHttpHeaders();
            if (isset($h['Location']) && substr($h['Location'], 0, 4) != 'http') {
                $this->_response .= '<a href="' . dirname($this->_link) . '/' . $h['Location'] . '">x</a>';
                $this->_redirect();
            }

            if ($this->_maxRedirect !== null) {
                for ($ii = 1; $ii <= $this->_maxRedirect; ++$ii) {
                    $this->_redirect();
                }
            }

            if ($this->_sleep !== null) {
                sleep($this->_sleep);
            }
        }
    }


    /**
     * Перехватываем редиректы
     */
    protected function _redirect()
    {
        $this->_response = preg_replace('/<\s*link.*>/isU', '', $this->_response);
        $this->_response = preg_replace('/<\s*a\s*href\s*=\s*("|\').*("|\')>\s*<\s*\/\s*a\s*>/isU', '', $this->_response);

        preg_match("#ontimer[\s]*=[\s]*['\"]+(.*?)['\"]+.*>#is", $this->_response, $next);
        if (!$next) {
            preg_match("#url[\s]*=[\s]*\\\?(.*?)\\\?[\"'\s>]#is", $this->_response, $next);
        }
        if (!$next) {
            preg_match("#href[\s]*=[\s]*\\\?\"?'?(.*?)\\\?[\"'\s>]#is", $this->_response, $next);
        }
    
        if (strpos($next[1], '://') === false) {
            $link = htmlspecialchars_decode(trim(
                $this->_linkParse['scheme'] .
                '://' .
                $this->_linkParse['host'] .
                str_replace(
                    array('//', '\\'),
                    array('/', '/'),
                    dirname($this->_linkParse['path'])
                ) .
                str_replace('&amp;', '&', $next[1])
            ));
        } else {
            $link = htmlspecialchars_decode(trim($next[1]));
        }

        preg_match_all('/Set-Cookie:(.*);/ixU', $this->_response, $cookie);

        $c = '';
        for ($i = 0, $s = sizeof($cookie[1]); $i < $s; ++$i) {
            $c .= trim($cookie[1][$i]) . ';';
        }


        $this->_headersTmp = $this->_headers;

        $this->_setHeaderTmp('Referer: ' . $this->_link);
        $this->_setHeaderTmp('Host: ' . parse_url($link, PHP_URL_HOST));
        if ($c) {
            $this->_setHeaderTmp('Cookie: ' . $c);
        }

        curl_setopt($this->_curl, CURLOPT_URL, $link);
        curl_setopt($this->_curl, CURLOPT_HTTPHEADER, $this->_headersTmp);

        $this->_response = curl_exec($this->_curl);
        if ($this->_debug === true) {
            var_dump(curl_getinfo($this->_curl), $this->_response);
        }
    }


    /**
     * Задаем прокси в CURL
     *
     * @return Cheaters
     */
    protected function _setCurlProxy()
    {
        if ($this->_proxyType == self::PROXY_TYPE_HTTP) {
            curl_setopt($this->_curl, CURLOPT_PROXYTYPE, CURLPROXY_HTTP);
            curl_setopt($this->_curl, CURLOPT_PROXY, $this->_getRandomProxy());
        } else if ($this->_proxyType == self::PROXY_TYPE_SOCKS5) {
            curl_setopt($this->_curl, CURLOPT_PROXYTYPE, CURLPROXY_SOCKS5);
            curl_setopt($this->_curl, CURLOPT_PROXY, $this->_getRandomProxy());
        } else if ($this->_proxyType == self::PROXY_TYPE_SOCKS4) {
            curl_setopt($this->_curl, CURLOPT_PROXYTYPE, CURLPROXY_SOCKS4);
            curl_setopt($this->_curl, CURLOPT_PROXY, $this->_getRandomProxy());
        }

        return $this;
    }


    /**
     * Получаем рандомную проксю
     *
     * @return string
     */
    protected function _getRandomProxy()
    {
        return trim($this->_proxy[mt_rand(0, sizeof($this->_proxy) - 1)]);
    }


    /**
     * Получаем рандомный браузер
     *
     * @return string
     */
    protected function _getRandomBrowser()
    {
        return trim($this->_browsers[mt_rand(0, sizeof($this->_browsers) - 1)]);
    }


    /**
     * Парсим HTTP заголовки
     *
     * @return array
     */
    protected function _parseHttpHeaders()
    {
        $headers = array();
        $lines = explode("\n", trim($this->_response));

        if (substr($lines[0], 0, 5) == 'HTTP/') {
            array_shift($lines);
        }

        foreach ($lines as $line) {
            preg_match('/^(.+?):\s+(.+)$/', trim($line), $matches);
            $headers[$matches[1]] = $matches[2];
            unset($matches);
        }

        return $headers;
    }
}

?>
